/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestCaseFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestSuiteFileServiceManager;
import com.kms.katalon.entity.dal.exception.DuplicatedFileNameException;
import com.kms.katalon.entity.dal.exception.NoEntityException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.DataFilePropertyInputEntity;
import com.kms.katalon.entity.testdata.InternalDataColumnEntity;
import com.kms.katalon.entity.testdata.InternalDataFilePropertyEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.io.File;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class DataFileFileServiceManager {
    public static DataFileEntity saveNewTestData(DataFileEntity newTestData) throws Exception {
        if (newTestData == null || newTestData.getProject() == null || newTestData.getParentFolder() == null) {
            return null;
        }
        EntityService.getInstance().saveEntity((FileEntity)newTestData);
        FolderFileServiceManager.refreshFolder(newTestData.getParentFolder());
        return newTestData;
    }

    public static Map<String, List<TestSuiteTestCaseLink>> getTestDataReferences(DataFileEntity dataFileEntity) throws Exception {
        if (dataFileEntity == null) {
            throw new NoEntityException("Test data not found.");
        }
        HashMap<String, List<TestSuiteTestCaseLink>> testDataReferences = new HashMap<String, List<TestSuiteTestCaseLink>>();
        List<TestSuiteEntity> allTestSuites = FolderFileServiceManager.getDescendantTestSuitesOfFolder(FolderFileServiceManager.getTestSuiteRoot(dataFileEntity.getProject()));
        String dataFileId = dataFileEntity.getRelativePathForUI().replace(File.separator, "/");
        for (TestSuiteEntity testSuiteEntity : allTestSuites) {
            ArrayList<TestSuiteTestCaseLink> testCaseLinkReferences = new ArrayList<TestSuiteTestCaseLink>();
            block1: for (TestSuiteTestCaseLink testCaseLink : testSuiteEntity.getTestSuiteTestCaseLinks()) {
                for (TestCaseTestDataLink testDataLink : testCaseLink.getTestDataLinks()) {
                    if (!dataFileId.equals(testDataLink.getTestDataId())) continue;
                    testCaseLinkReferences.add(testCaseLink);
                    continue block1;
                }
            }
            if (testCaseLinkReferences.isEmpty()) continue;
            String testSuiteId = testSuiteEntity.getRelativePathForUI().replace(File.separator, "/");
            testDataReferences.put(testSuiteId, testCaseLinkReferences);
        }
        return testDataReferences;
    }

    public static List<TestCaseEntity> getTestDataReferencesInTestCaseBinding(DataFileEntity dataFileEntity) throws Exception {
        ArrayList<TestCaseEntity> affectedTestCases = new ArrayList<TestCaseEntity>();
        if (dataFileEntity == null) {
            throw new NoEntityException("Test data not found.");
        }
        String dataFileId = dataFileEntity.getRelativePathForUI().replace(File.separator, "/");
        List<TestCaseEntity> allTestCases = FolderFileServiceManager.getDescendantTestCasesOfFolder(FolderFileServiceManager.getTestCaseRoot(dataFileEntity.getProject()));
        block0: for (TestCaseEntity testCaseEntity : allTestCases) {
            for (TestCaseTestDataLink testDataLink : testCaseEntity.getTestDataLinks()) {
                if (!dataFileId.equals(testDataLink.getTestDataId())) continue;
                affectedTestCases.add(testCaseEntity);
                continue block0;
            }
        }
        return affectedTestCases;
    }

    public static void deleteDataFile(DataFileEntity dataFile) throws Exception {
        if (dataFile == null) {
            return;
        }
        EntityFileServiceManager.delete((FileEntity)dataFile);
        FolderFileServiceManager.refreshFolder(dataFile.getParentFolder());
    }

    public static void deteleDataFileFolder(FolderEntity folder) throws Exception {
        if (folder == null) {
            return;
        }
        EntityFileServiceManager.deleteFolder(folder);
        FolderFileServiceManager.refreshFolder(folder.getParentFolder());
    }

    public static DataFileEntity getDataFile(String dataFilePk) throws Exception {
        FileEntity entity = EntityFileServiceManager.get(new File(dataFilePk));
        if (entity instanceof DataFileEntity) {
            return (DataFileEntity)entity;
        }
        return null;
    }

    public static void initTestData(DataFileEntity dataFile) {
        if (dataFile != null) {
            if (dataFile.getDataFileGUID() == null) {
                dataFile.setDataFileGUID(Util.generateGuid());
            }
            if (dataFile.getEncriptData() != null) {
                ArrayList arrays = new ArrayList();
                for (List list : dataFile.getEncriptData()) {
                    if (list == null) continue;
                    ArrayList<String> values = new ArrayList<String>();
                    for (Object val : list) {
                        try {
                            String decodedValue = URLDecoder.decode((String)val, "UTF-8");
                            if (!decodedValue.equals("null")) {
                                values.add(decodedValue);
                                continue;
                            }
                            values.add("");
                        }
                        catch (Exception exception) {
                            values.add((String)val);
                        }
                    }
                    arrays.add(values);
                }
                dataFile.setData(arrays);
            }
        }
    }

    public static DataFileEntity updateTestData(DataFileEntity newDataFile) throws Exception {
        String oldTestDataLocation;
        DataFileFileServiceManager.validateDataFile(newDataFile);
        if (EntityService.getInstance().getEntityCache().contains((FileEntity)newDataFile) && (oldTestDataLocation = EntityService.getInstance().getEntityCache().getKey((FileEntity)newDataFile)) != null && !oldTestDataLocation.equals(newDataFile.getLocation())) {
            EntityService.getInstance().getEntityCache().remove((FileEntity)newDataFile, true);
            DataFileFileServiceManager.updateReferencesAfterDataFileRenamed(oldTestDataLocation, newDataFile, newDataFile.getProject());
        }
        EntityService.getInstance().saveEntity((FileEntity)newDataFile);
        FolderFileServiceManager.refreshFolder(newDataFile.getParentFolder());
        return newDataFile;
    }

    public static void validateDataFile(DataFileEntity dataFile) throws Exception {
        EntityService.getInstance().validateName(dataFile.getName());
    }

    public static DataFileEntity copyDataFile(DataFileEntity dataFile, FolderEntity destinationFolder) throws Exception {
        return EntityFileServiceManager.copy(dataFile, destinationFolder);
    }

    public static DataFileEntity moveDataFile(DataFileEntity dataFile, FolderEntity destinationFolder) throws Exception {
        return EntityFileServiceManager.move(dataFile, destinationFolder);
    }

    public static List<DataFileEntity> getDataFileByDataFileEntity(String dataFileEntityPk) throws Exception {
        DataFileEntity entity = DataFileFileServiceManager.getDataFile(dataFileEntityPk);
        return new ArrayList<DataFileEntity>(Arrays.asList(entity));
    }

    public static String getAvailableDataFileName(FolderEntity parentFolder, String name) throws Exception {
        if (parentFolder != null) {
            return EntityService.getInstance().getAvailableName(parentFolder.getLocation(), name, true);
        }
        return null;
    }

    public static DataFileEntity updateDataFileProperty(DataFilePropertyInputEntity dataFilePropertyInput, ProjectEntity project) throws Exception {
        DataFileEntity testDataEntity = DataFileFileServiceManager.getDataFile(dataFilePropertyInput.getPk());
        String oldLocation = testDataEntity.getLocation();
        EntityService.getInstance().validateName(dataFilePropertyInput.getName());
        if (!testDataEntity.getName().equals(dataFilePropertyInput.getName())) {
            String availableName;
            if (!testDataEntity.getName().equalsIgnoreCase(dataFilePropertyInput.getName()) && !(availableName = DataFileFileServiceManager.getAvailableDataFileName(testDataEntity.getParentFolder(), dataFilePropertyInput.getName())).equalsIgnoreCase(dataFilePropertyInput.getName())) {
                throw new DuplicatedFileNameException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_DATA_FILE_NAME, dataFilePropertyInput.getName()));
            }
            EntityService.getInstance().getEntityCache().remove((FileEntity)testDataEntity, true);
        }
        testDataEntity.setName(dataFilePropertyInput.getName());
        testDataEntity.setDescription(dataFilePropertyInput.getDescription());
        testDataEntity.setDriver(DataFileEntity.DataFileDriverType.fromValue((String)dataFilePropertyInput.getDataFileDriver()));
        testDataEntity.setDataSourceUrl(dataFilePropertyInput.getDataSourceURL());
        testDataEntity.setSheetName(dataFilePropertyInput.getSheetName());
        testDataEntity.setIsInternalPath(dataFilePropertyInput.getIsInternalPath());
        testDataEntity.setContainsHeaders(dataFilePropertyInput.isEnableHeaders());
        testDataEntity.setCsvSeperator(dataFilePropertyInput.getCsvSeperator());
        DataFileFileServiceManager.updateReferencesAfterDataFileRenamed(oldLocation, testDataEntity, project);
        EntityService.getInstance().saveEntity((FileEntity)testDataEntity);
        FolderFileServiceManager.refreshFolder(testDataEntity.getParentFolder());
        return testDataEntity;
    }

    private static void updateReferencesAfterDataFileRenamed(String oldTestDataLocation, DataFileEntity newEntity, ProjectEntity project) throws Exception {
        if (!oldTestDataLocation.equals(newEntity.getLocation())) {
            String testDataId;
            FolderEntity testSuiteRoot = FolderFileServiceManager.getTestSuiteRoot(project);
            List<TestSuiteEntity> lstTestSuite = FolderFileServiceManager.getDescendantTestSuitesOfFolder(testSuiteRoot);
            File projectFile = new File(project.getLocation());
            String oldRelativeTdLocation = oldTestDataLocation.substring(projectFile.getParent().length() + 1);
            String oldTestDataId = FilenameUtils.removeExtension((String)oldRelativeTdLocation).replace(File.separator, "/");
            String newTestDataId = newEntity.getIdForDisplay();
            for (TestSuiteEntity testSuiteEntity : lstTestSuite) {
                boolean save = false;
                for (TestSuiteTestCaseLink testCaseLink : testSuiteEntity.getTestSuiteTestCaseLinks()) {
                    for (TestCaseTestDataLink testDataLink : testCaseLink.getTestDataLinks()) {
                        testDataId = testDataLink.getTestDataId();
                        if (testDataId == null || !oldTestDataId.equals(testDataId)) continue;
                        testDataLink.setTestDataId(newTestDataId);
                        save = true;
                    }
                }
                if (!save) continue;
                TestSuiteFileServiceManager.updateTestSuite(testSuiteEntity);
            }
            FolderEntity testCaseRoot = FolderFileServiceManager.getTestCaseRoot(project);
            List<TestCaseEntity> lstTestCase = FolderFileServiceManager.getDescendantTestCasesOfFolder(testCaseRoot);
            for (TestCaseEntity testCaseEntity : lstTestCase) {
                boolean needToUpdateTestCase = false;
                for (TestCaseTestDataLink testDataLink : testCaseEntity.getTestDataLinks()) {
                    testDataId = testDataLink.getTestDataId();
                    if (testDataId == null || !oldTestDataId.equals(testDataId)) continue;
                    testDataLink.setTestDataId(newTestDataId);
                    needToUpdateTestCase = true;
                }
                if (!needToUpdateTestCase) continue;
                TestCaseFileServiceManager.updateTestCase(testCaseEntity);
            }
            TestArtifactScriptRefactor.createForTestDataEntity((String)oldTestDataId).updateReferenceForProject(newTestDataId, project);
        }
    }

    public static Integer getInternalDataRowCount(DataFileEntity dataFile, String columnName) throws Exception {
        List lstInternalColumns = dataFile.getInternalDataColumns();
        int i = 0;
        while (i < lstInternalColumns.size()) {
            if (((InternalDataColumnEntity)lstInternalColumns.get(i)).getName().equals(columnName)) {
                return ((List)dataFile.getData().get(i)).size();
            }
            ++i;
        }
        return 0;
    }

    public static DataFileEntity updateInternalDataFileProperty(InternalDataFilePropertyEntity internalData, ProjectEntity project) throws Exception {
        DataFileEntity testDataEntity = DataFileFileServiceManager.getDataFile(internalData.getPk());
        String oldLocation = testDataEntity.getLocation();
        EntityService.getInstance().validateName(internalData.getName());
        EntityService.getInstance().getEntityCache().remove((FileEntity)testDataEntity, true);
        testDataEntity.setName(internalData.getName());
        testDataEntity.setDescription(internalData.getDescription());
        testDataEntity.setDriver(DataFileEntity.DataFileDriverType.valueOf((String)internalData.getDataFileDriverName()));
        testDataEntity.setDataSourceUrl(internalData.getDataSourceURL());
        testDataEntity.setSheetName(internalData.getSheetName());
        if (testDataEntity.getDriver() == DataFileEntity.DataFileDriverType.InternalData) {
            ArrayList<InternalDataColumnEntity> lstInternalDataColumnEntities = new ArrayList<InternalDataColumnEntity>();
            for (Object o : internalData.getHeaderColumn()) {
                lstInternalDataColumnEntities.add((InternalDataColumnEntity)o);
            }
            testDataEntity.setInternalDataColumns(lstInternalDataColumnEntities);
            testDataEntity.setData(internalData.getData());
            if (testDataEntity.getData() != null) {
                ArrayList arrays = new ArrayList();
                for (List list : testDataEntity.getData()) {
                    if (list == null) continue;
                    ArrayList<String> values = new ArrayList<String>();
                    for (Object val : list) {
                        try {
                            if (!val.equals("")) {
                                values.add(URLEncoder.encode((String)val, "UTF-8"));
                                continue;
                            }
                            values.add("null");
                        }
                        catch (Exception exception) {
                            if (val == null) {
                                values.add("null");
                                continue;
                            }
                            values.add((String)val);
                        }
                    }
                    arrays.add(values);
                }
                testDataEntity.setEncriptData(arrays);
            }
        }
        if (!oldLocation.equals(testDataEntity.getLocation())) {
            DataFileFileServiceManager.updateReferencesAfterDataFileRenamed(oldLocation, testDataEntity, project);
        }
        EntityService.getInstance().saveEntity((FileEntity)testDataEntity);
        FolderFileServiceManager.refreshFolder(testDataEntity.getParentFolder());
        return testDataEntity;
    }

    public static DataFileEntity getDuplicatedDataFile(FolderEntity parentFolder, String dataFileName) throws Exception {
        List<DataFileEntity> dataFiles = FolderFileServiceManager.getChildDataFilesOfFolder(parentFolder);
        for (DataFileEntity dataFile : dataFiles) {
            if (!dataFile.getName().equals(dataFileName)) continue;
            return dataFile;
        }
        return null;
    }

    public static DataFileEntity getByGUID(String guid, ProjectEntity project) throws Exception {
        File dataFileFolder;
        File projectFolder = new File(project.getFolderLocation());
        if (projectFolder.exists() && projectFolder.isDirectory() && (dataFileFolder = new File(FileServiceConstant.getDataFileRootFolderLocation(projectFolder.getAbsolutePath()))).exists() && dataFileFolder.isDirectory()) {
            return DataFileFileServiceManager.getByGUID(dataFileFolder.getAbsolutePath(), guid);
        }
        return null;
    }

    private static DataFileEntity getByGUID(String dataFileFolder, String guid) throws Exception {
        File folder = new File(dataFileFolder);
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFileEntity result;
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(DataFileEntity.getTestDataFileExtension().toLowerCase())) {
                    DataFileEntity dataFile = DataFileFileServiceManager.getDataFile(file.getAbsolutePath());
                    if (dataFile.getDataFileGUID().equals(guid)) {
                        return dataFile;
                    }
                } else if (file.isDirectory() && (result = DataFileFileServiceManager.getByGUID(file.getAbsolutePath(), guid)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void saveAllReferencesToDataFileAfterFolderRenamed(String oldFolderLocation, FolderEntity folderEntity, List<TestSuiteEntity> lstTestSuites) throws Exception {
        String oldFolderDisplayId = String.valueOf(oldFolderLocation.replace(File.separator, "/")) + "/";
        String newFolderDisplayId = String.valueOf(folderEntity.getIdForDisplay()) + "/";
        HashSet<TestSuiteEntity> lstTestSuitesWillSave = new HashSet<TestSuiteEntity>();
        for (TestSuiteEntity testSuiteEntity : lstTestSuites) {
            for (TestSuiteTestCaseLink testCaseLink : testSuiteEntity.getTestSuiteTestCaseLinks()) {
                for (TestCaseTestDataLink testDataLink : testCaseLink.getTestDataLinks()) {
                    String testDataId = testDataLink.getTestDataId();
                    if (testDataId == null || !testDataId.contains(oldFolderDisplayId)) continue;
                    testDataLink.setTestDataId(testDataId.replace(oldFolderDisplayId, newFolderDisplayId));
                    lstTestSuitesWillSave.add(testSuiteEntity);
                }
            }
        }
        for (TestSuiteEntity testSuiteEntity : lstTestSuitesWillSave) {
            TestSuiteFileServiceManager.updateTestSuite(testSuiteEntity);
        }
        FolderFileServiceManager.refreshFolderScriptReferences(oldFolderDisplayId, folderEntity);
    }
}

