/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.BinaryExpressionFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.MethodCallFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.PropertyExpressionFragment;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindAllOccurrencesVisitor;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.core.extract.StaticFragmentChecker;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.groovy.eclipse.refactoring.core.utils.StatusHelper;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractConstantDescriptor;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractGroovyConstantRefactoring
extends ExtractConstantRefactoring {
    private IASTFragment selectedFragment;
    private GroovyCompilationUnit unit;
    private int start;
    private int length;
    private String constantName;
    private boolean insertFirst;
    private FieldNode toInsertAfter;
    private String constantText;
    private String[] fExcludedVariableNames;
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "set", "is", "to"};

    public ExtractGroovyConstantRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        super(arguments, status);
        this.length = -1;
        this.start = -1;
    }

    public ExtractGroovyConstantRefactoring(GroovyCompilationUnit unit, int offset, int length) {
        super((ICompilationUnit)unit, offset, length);
        this.unit = unit;
        this.start = offset;
        this.length = this.expandSelection(this.start, length);
        this.setSelectionLength(this.length);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus status;
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.ExtractConstantRefactoring_checking_preconditions, (int)7);
        try {
            try {
                status = (RefactoringStatus)Checks.class.getDeclaredMethod("validateEdit", ICompilationUnit.class, Object.class, IProgressMonitor.class).invoke(Checks.class, this.unit, this.getValidationContext(), submon.split(4));
            }
            catch (NoSuchMethodException e) {
                status = (RefactoringStatus)Checks.class.getDeclaredMethod("validateEdit", ICompilationUnit.class, Object.class).invoke(Checks.class, this.unit, this.getValidationContext());
                submon.worked(4);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        if (status.hasFatalError()) {
            return status;
        }
        IASTFragment astFragment = this.getSelectedFragment();
        if (astFragment == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_select_expression, (RefactoringStatusContext)this.createContext()));
            return status;
        }
        submon.worked(1);
        status.merge(this.checkFragment());
        if (status.hasFatalError()) {
            return status;
        }
        submon.worked(1);
        ClassNode targetType = this.getContainingClassNode();
        if (targetType == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot find enclosing Class declaration."));
        }
        if (targetType.isScript()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)"Cannot extract a constant to a Script."));
        }
        if (targetType.isAnnotationDefinition() || targetType.isInterface()) {
            this.setVisibility("public");
            this.setTargetIsInterface(true);
        }
        submon.worked(1);
        return status;
    }

    private int expandSelection(int s, int l) {
        int end = s + l;
        char[] contents = this.unit.getContents();
        while (end < contents.length && (contents[end] == ' ' || contents[end] == '\t')) {
            ++end;
        }
        return end - s;
    }

    private CompilationUnitChange getChange() {
        return (CompilationUnitChange)ReflectionUtils.getPrivateField(ExtractConstantRefactoring.class, (String)"fChange", (Object)((Object)this));
    }

    private void setChange(CompilationUnitChange change) {
        ReflectionUtils.setPrivateField(ExtractConstantRefactoring.class, (String)"fChange", (Object)((Object)this), (Object)change);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        try {
            TextEdit edit;
            RefactoringStatus status = new RefactoringStatus();
            CompilationUnitChange change = new CompilationUnitChange("Extract Groovy Constant", (ICompilationUnit)this.getCu());
            change.setEdit((TextEdit)new MultiTextEdit());
            TextEditGroup group = this.createConstantDeclaration();
            change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, group));
            TextEdit[] textEditArray = group.getTextEdits();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                edit = textEditArray[n2];
                change.addEdit(edit);
                ++n2;
            }
            group = this.replaceExpressionsWithConstant();
            change.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)change, group));
            textEditArray = group.getTextEdits();
            n = textEditArray.length;
            n2 = 0;
            while (n2 < n) {
                edit = textEditArray[n2];
                change.addEdit(edit);
                ++n2;
            }
            this.setChange(change);
            return status;
        }
        catch (MalformedTreeException e) {
            throw new CoreException((IStatus)new Status(4, "org.codehaus.groovy.eclipse.refactoring", e.getMessage(), (Throwable)e));
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.codehaus.groovy.eclipse.refactoring", e.getMessage(), (Throwable)e));
        }
    }

    private TextEditGroup replaceExpressionsWithConstant() throws JavaModelException {
        List occurrences;
        IASTFragment origExpr = this.getSelectedFragment();
        if (this.getReplaceAllOccurrences()) {
            FindAllOccurrencesVisitor v = new FindAllOccurrencesVisitor(this.getCu().getModuleNode());
            occurrences = v.findOccurrences(origExpr);
        } else {
            occurrences = Collections.singletonList(origExpr);
        }
        TextEditGroup msg = new TextEditGroup(RefactoringCoreMessages.ExtractConstantRefactoring_replace);
        for (IASTFragment fragment : occurrences) {
            String replaceText = this.getQualifyReferencesWithDeclaringClassName() ? String.valueOf(this.getContainingClassNode().getNameWithoutPackage()) + "." + this.getConstantName() : this.getConstantName();
            msg.addTextEdit((TextEdit)new ReplaceEdit(fragment.getStart(), fragment.getLength(), replaceText));
        }
        return msg;
    }

    private TextEditGroup createConstantDeclaration() throws MalformedTreeException, BadLocationException {
        String constant = this.getConstantText();
        TextEditGroup msg = new TextEditGroup(RefactoringCoreMessages.ExtractConstantRefactoring_declare_constant);
        int insertLocation = this.findInsertLocation();
        msg.addTextEdit((TextEdit)new InsertEdit(insertLocation, constant));
        return msg;
    }

    private int findInsertLocation() {
        if (this.insertFirst()) {
            ClassNode node = this.getContainingClassNode();
            if (node.isScript()) {
                int statementStart = node.getModule().getStatementBlock().getStart();
                int methodStart = !node.getModule().getMethods().isEmpty() ? ((MethodNode)node.getModule().getMethods().get(0)).getStart() : Integer.MAX_VALUE;
                return Math.min(methodStart, statementStart);
            }
            return CharOperation.indexOf((char)'{', (char[])this.getCu().getContents(), (int)node.getNameEnd()) + 1;
        }
        return this.toInsertAfter.getEnd();
    }

    private String getConstantText() throws MalformedTreeException, BadLocationException {
        if (this.constantText == null) {
            this.constantText = this.createConstantText();
        }
        return this.constantText;
    }

    private String createConstantText() throws MalformedTreeException, BadLocationException {
        StringBuilder sb = new StringBuilder();
        JavaProject javaProject = this.getCu().getJavaProject();
        sb.append(CodeFormatterUtil.createIndentString((int)this.getIndentLevel(), (IJavaProject)javaProject));
        if (this.getVisibility().length() > 0) {
            sb.append(this.getVisibility()).append(" ");
        }
        sb.append("static final ").append(this.getConstantTypeName()).append(this.constantName).append(" = ").append(this.createExpressionText());
        Document doc = new Document(sb.toString());
        DefaultGroovyFormatter formatter = new DefaultGroovyFormatter((IDocument)doc, new FormatterPreferences((ICompilationUnit)this.unit), this.getIndentLevel());
        TextEdit edit = formatter.format();
        edit.apply((IDocument)doc);
        return String.valueOf(this.getDefaultNewlineCharacterTwice()) + doc.get();
    }

    private String getDefaultNewlineCharacterTwice() {
        String newline = ASTTools.getLineDelimeter((CompilationUnit)this.unit);
        return String.valueOf(newline) + newline;
    }

    private int getIndentLevel() {
        ClassNode node;
        ClassNode containing = node = this.getContainingClassNode();
        int indentLevel = 0;
        while (containing != null) {
            ++indentLevel;
            if (containing.getEnclosingMethod() != null) {
                ++indentLevel;
                containing = containing.getEnclosingMethod().getDeclaringClass();
                continue;
            }
            containing = containing.getOuterClass();
        }
        return indentLevel;
    }

    private String createExpressionText() {
        IASTFragment fragment = this.getSelectedFragment();
        return String.valueOf(this.unit.getContents()).substring(fragment.getStart(), fragment.getEnd());
    }

    private boolean insertFirst() {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.insertFirst;
    }

    private boolean isDeclarationLocationComputed() {
        return this.insertFirst || this.toInsertAfter != null;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        ExtractConstantDescriptor descriptor = this.createRefactoringDescriptor();
        this.getChange().setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
        return this.getChange();
    }

    private ExtractConstantDescriptor createRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        JavaProject javaProject = this.getCu().getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 786434;
        String expression = this.createExpressionText();
        String description = RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractConstantRefactoring_descriptor_description_short, (Object)BasicElementLabels.getJavaElementName((String)this.constantName));
        String header = RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractConstantRefactoring_descriptor_description, (Object)BasicElementLabels.getJavaElementName((String)this.constantName), (Object)BasicElementLabels.getJavaCodeString((String)expression));
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractConstantRefactoring_constant_name_pattern, (Object)BasicElementLabels.getJavaElementName((String)this.constantName)));
        comment.addSetting(RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractConstantRefactoring_constant_expression_pattern, (Object)BasicElementLabels.getJavaCodeString((String)expression)));
        comment.addSetting(RefactoringCoreMessages.bind((String)RefactoringCoreMessages.ExtractConstantRefactoring_visibility_pattern, (Object)RefactoringCoreMessages.ExtractConstantRefactoring_default_visibility));
        if (this.getReplaceAllOccurrences()) {
            comment.addSetting(RefactoringCoreMessages.ExtractConstantRefactoring_replace_occurrences);
        }
        if (this.getQualifyReferencesWithDeclaringClassName()) {
            comment.addSetting(RefactoringCoreMessages.ExtractConstantRefactoring_qualify_references);
        }
        arguments.put("name", this.constantName);
        arguments.put("selection", String.valueOf(String.valueOf(this.start)) + " " + String.valueOf(this.length));
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle((String)project, (IJavaElement)this.getCu()));
        arguments.put("replace", Boolean.toString(this.getReplaceAllOccurrences()));
        arguments.put("qualify", Boolean.toString(this.getQualifyReferencesWithDeclaringClassName()));
        arguments.put("visibility", Integer.toString(JdtFlags.getVisibilityCode((String)this.getVisibility())));
        ExtractConstantDescriptor descriptor = RefactoringSignatureDescriptorFactory.createExtractConstantDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        return descriptor;
    }

    private boolean getReplaceAllOccurrences() {
        return (Boolean)ReflectionUtils.getPrivateField(ExtractConstantRefactoring.class, (String)"fReplaceAllOccurrences", (Object)((Object)this));
    }

    private boolean getQualifyReferencesWithDeclaringClassName() {
        return (Boolean)ReflectionUtils.getPrivateField(ExtractConstantRefactoring.class, (String)"fQualifyReferencesWithDeclaringClassName", (Object)((Object)this));
    }

    public String getName() {
        return "Extract to constant" + (this.getReplaceAllOccurrences() ? " (replace all occurrences)" : "");
    }

    private void computeConstantDeclarationLocation() {
        if (this.isDeclarationLocationComputed()) {
            return;
        }
        FieldNode lastStaticDependency = null;
        for (FieldNode decl : this.getContainingClassNode().getFields()) {
            if (!decl.isStatic() || decl.getEnd() <= 0) continue;
            lastStaticDependency = decl;
        }
        if (lastStaticDependency == null) {
            this.insertFirst = true;
        } else {
            this.toInsertAfter = lastStaticDependency;
        }
    }

    private ClassNode getContainingClassNode() {
        return ASTTools.getContainingClassNode(this.getCu().getModuleNode(), this.getSelectionStart());
    }

    private void setTargetIsInterface(boolean b) {
        ReflectionUtils.setPrivateField(ExtractConstantRefactoring.class, (String)"fTargetIsInterface", (Object)((Object)this), (Object)true);
    }

    private RefactoringStatus checkFragment() throws JavaModelException {
        Expression expression;
        RefactoringStatus status = new RefactoringStatus();
        IASTFragment astFragment = this.getSelectedFragment();
        status.merge(this.checkExpressionFragmentIsRValue(astFragment));
        if (status.hasFatalError()) {
            return status;
        }
        this.checkAllStaticFinal();
        if (!this.selectionAllStaticFinal()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_not_load_time_constant));
        }
        if ((expression = astFragment.getAssociatedExpression()) instanceof ConstantExpression && ((ConstantExpression)expression).isNullExpression()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractConstantRefactoring_null_literals));
        }
        return status;
    }

    private void checkAllStaticFinal() throws JavaModelException {
        StaticFragmentChecker checker = new StaticFragmentChecker();
        boolean maybeStatic = checker.mayNotBeStatic(this.getSelectedFragment());
        ReflectionUtils.setPrivateField(ExtractConstantRefactoring.class, (String)"fSelectionAllStaticFinal", (Object)((Object)this), (Object)maybeStatic);
        ReflectionUtils.setPrivateField(ExtractConstantRefactoring.class, (String)"fAllStaticFinalCheckPerformed", (Object)((Object)this), (Object)true);
    }

    private RefactoringStatus checkExpressionFragmentIsRValue(IASTFragment fragment) throws JavaModelException {
        VariableExpression var;
        Expression expr;
        if (fragment.kind() == ASTFragmentKind.SIMPLE_EXPRESSION && (expr = fragment.getAssociatedExpression()) instanceof VariableExpression && (var = (VariableExpression)expr).getAccessedVariable() == var) {
            return RefactoringStatus.createFatalErrorStatus((String)"Target expression is a variable declaration.  Cannot extract a constant.");
        }
        return new RefactoringStatus();
    }

    private RefactoringStatusContext createContext() {
        try {
            IJavaElement elt = this.getCu().getElementAt(this.getSelectionStart());
            if (elt instanceof IMember) {
                return StatusHelper.createContext((IMember)elt);
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)"Error finding refactoring context", (Throwable)e);
        }
        return null;
    }

    private IASTFragment getSelectedFragment() {
        if (this.selectedFragment == null) {
            this.selectedFragment = ASTTools.getSelectionFragment(this.getCu().getModuleNode(), this.getSelectionStart(), this.getSelectionLength());
        }
        return this.selectedFragment;
    }

    private String getConstantTypeName() {
        String name;
        Expression e = this.getSelectedFragment().getAssociatedExpression();
        if (e != null && !"Object".equals(name = e.getType().getNameWithoutPackage())) {
            return String.valueOf(name) + " ";
        }
        return "";
    }

    public String getConstantSignaturePreview() throws JavaModelException {
        return String.valueOf(this.getVisibility()) + " static final " + this.getConstantTypeName() + ' ' + this.constantName;
    }

    public RefactoringStatus checkConstantNameOnChange() throws JavaModelException {
        return Checks.checkConstantName((String)this.getConstantName(), (IJavaElement)this.getCu());
    }

    public String[] guessConstantNames() {
        String text = ExtractGroovyConstantRefactoring.getBaseNameFromExpression((IJavaProject)this.getCu().getJavaProject(), this.getSelectedFragment(), 3);
        if (text == null) {
            return CharOperation.NO_STRINGS;
        }
        try {
            Integer.parseInt(text);
            text = "_" + text;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NamingConventions.suggestVariableNames((int)3, (int)1, (String)text, (IJavaProject)this.getCu().getJavaProject(), (int)(this.getContainingClassNode().isArray() ? 1 : 0), (String[])this.getExcludedVariableNames(), (boolean)true);
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            HashSet<String> usedNames = new HashSet<String>();
            for (ClassNode classNode : this.unit.getModuleNode().getClasses()) {
                for (FieldNode fieldNode : classNode.getFields()) {
                    usedNames.add(fieldNode.getName());
                }
            }
            this.fExcludedVariableNames = usedNames.toArray(new String[usedNames.size()]);
        }
        return this.fExcludedVariableNames;
    }

    private static String getBaseNameFromExpression(IJavaProject project, IASTFragment assignedFragment, int variableKind) {
        IASTFragment next;
        if (assignedFragment == null) {
            return null;
        }
        String name = null;
        Expression assignedExpression = assignedFragment.getAssociatedExpression();
        if (assignedExpression instanceof CastExpression) {
            assignedExpression = ((CastExpression)assignedExpression).getExpression();
        }
        String candidate = null;
        if (assignedExpression instanceof ConstantExpression) {
            candidate = ((ConstantExpression)assignedExpression).getText();
        } else if (assignedExpression instanceof VariableExpression) {
            candidate = ((VariableExpression)assignedExpression).getName();
        } else if (assignedExpression instanceof ClassExpression) {
            candidate = ((ClassExpression)assignedExpression).getType().getNameWithoutPackage();
        } else if (assignedExpression instanceof MethodCallExpression) {
            candidate = ((MethodCallExpression)assignedExpression).getMethodAsString();
        } else if (assignedExpression instanceof StaticMethodCallExpression) {
            candidate = ((StaticMethodCallExpression)assignedExpression).getMethod();
        }
        if (candidate != null) {
            StringBuffer res = new StringBuffer();
            boolean needsUnderscore = false;
            int i = 0;
            while (i < candidate.length()) {
                char ch = candidate.charAt(i);
                if (Character.isJavaIdentifierPart(ch)) {
                    if (res.length() == 0 && !Character.isJavaIdentifierStart(ch) || needsUnderscore) {
                        res.append('_');
                    }
                    res.append(ch);
                    needsUnderscore = false;
                } else {
                    needsUnderscore = res.length() > 0;
                }
                ++i;
            }
            if (res.length() > 0) {
                name = res.toString();
            }
        }
        switch (assignedFragment.kind()) {
            case PROPERTY: 
            case SAFE_PROPERTY: 
            case SPREAD_SAFE_PROPERTY: 
            case METHOD_POINTER: {
                next = ((PropertyExpressionFragment)assignedFragment).getNext();
                break;
            }
            case METHOD_CALL: {
                next = ((MethodCallFragment)assignedFragment).getNext();
                break;
            }
            case BINARY: {
                next = ((BinaryExpressionFragment)assignedFragment).getNext();
                break;
            }
            default: {
                next = null;
            }
        }
        if (next != null) {
            name = String.valueOf(name) + "_" + ExtractGroovyConstantRefactoring.getBaseNameFromExpression(project, next, variableKind);
        }
        if (name != null) {
            int i = 0;
            int n = KNOWN_METHOD_NAME_PREFIXES.length;
            while (i < n) {
                String curr = KNOWN_METHOD_NAME_PREFIXES[i];
                if (name.startsWith(curr)) {
                    if (name.equals(curr)) {
                        return null;
                    }
                    if (Character.isUpperCase(name.charAt(curr.length()))) {
                        return name.substring(curr.length());
                    }
                }
                ++i;
            }
        } else {
            name = "CONSTANT";
        }
        return name;
    }

    public void setConstantName(String newName) {
        super.setConstantName(newName);
        Assert.isNotNull((Object)newName);
        this.constantName = newName;
    }

    public String getConstantName() {
        return this.constantName;
    }

    private GroovyCompilationUnit getCu() {
        if (this.unit == null) {
            this.unit = (GroovyCompilationUnit)ReflectionUtils.getPrivateField(ExtractConstantRefactoring.class, (String)"fCu", (Object)((Object)this));
        }
        return this.unit;
    }

    private int getSelectionStart() {
        if (this.start == -1) {
            this.start = (Integer)ReflectionUtils.getPrivateField(ExtractConstantRefactoring.class, (String)"fSelectionStart", (Object)((Object)this));
        }
        return this.start;
    }

    private int getSelectionLength() {
        if (this.length == -1) {
            this.length = (Integer)ReflectionUtils.getPrivateField(ExtractConstantRefactoring.class, (String)"fSelectionLength", (Object)((Object)this));
        }
        return this.length;
    }

    private void setSelectionLength(int newLength) {
        ReflectionUtils.setPrivateField(ExtractConstantRefactoring.class, (String)"fSelectionLength", (Object)((Object)this), (Object)newLength);
    }
}

