/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rename.renameLocal;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.util.Util;

public class LocalVariableNameCheckerRequestor
implements ITypeRequestor {
    private final Variable variable;
    private final int start;
    private final int end;
    private final String newName;
    private boolean shadowing;
    private boolean variableFound;
    private IJavaElement foundEnclosingElement;

    public LocalVariableNameCheckerRequestor(Variable variable, String newName) {
        this.variable = variable;
        this.newName = newName;
        if (variable instanceof ASTNode) {
            ASTNode v = (ASTNode)variable;
            this.start = v.getStart();
            this.end = v.getEnd();
        } else {
            this.end = -1;
            this.start = -1;
        }
    }

    public boolean isShadowing() {
        return this.shadowing;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        ConstantExpression expr;
        if (!this.interestingElement(enclosingElement)) {
            return ITypeRequestor.VisitStatus.CANCEL_MEMBER;
        }
        if (!this.variableFound) {
            if (node == this.variable) {
                this.variableFound = true;
                this.foundEnclosingElement = enclosingElement;
            }
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        if (enclosingElement != this.foundEnclosingElement) {
            return ITypeRequestor.VisitStatus.STOP_VISIT;
        }
        if (node instanceof Variable) {
            Variable other = (Variable)node;
            if (other.getName().equals(this.newName) && (!(other instanceof VariableExpression) || ((VariableExpression)other).getAccessedVariable() != this.variable)) {
                this.shadowing = true;
                return ITypeRequestor.VisitStatus.STOP_VISIT;
            }
        } else if (node instanceof ConstantExpression && (expr = (ConstantExpression)node).getText().equals(this.variable.getName()) && result.declaration != this.variable) {
            this.shadowing = true;
            return ITypeRequestor.VisitStatus.STOP_VISIT;
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean interestingElement(IJavaElement enclosingElement) {
        if (enclosingElement.getElementName().equals("<clinit>")) {
            return true;
        }
        if (this.start >= 0 && this.end >= 0 && enclosingElement instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)enclosingElement).getSourceRange();
                return range.getOffset() <= this.start && range.getOffset() + range.getLength() >= this.end;
            }
            catch (JavaModelException e) {
                Util.log((Throwable)e);
            }
        }
        return false;
    }
}

