/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.processors;

import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.callbacks.Callback;
import io.swagger.oas.models.examples.Example;
import io.swagger.oas.models.headers.Header;
import io.swagger.oas.models.links.Link;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.security.SecurityScheme;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.processors.CallbackProcessor;
import io.swagger.parser.v3.processors.ExampleProcessor;
import io.swagger.parser.v3.processors.HeaderProcessor;
import io.swagger.parser.v3.processors.LinkProcessor;
import io.swagger.parser.v3.processors.ParameterProcessor;
import io.swagger.parser.v3.processors.RequestBodyProcessor;
import io.swagger.parser.v3.processors.ResponseProcessor;
import io.swagger.parser.v3.processors.SchemaProcessor;
import io.swagger.parser.v3.processors.SecuritySchemeProcessor;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ComponentsProcessor {
    private final ResolverCache cache;
    private final OpenAPI openApi;
    private final SchemaProcessor schemaProcessor;
    private final ResponseProcessor responseProcessor;
    private final RequestBodyProcessor requestBodyProcessor;
    private final ParameterProcessor parameterProcessor;
    private final HeaderProcessor headerProcessor;
    private final ExampleProcessor exampleProcessor;
    private final LinkProcessor linkProcessor;
    private final CallbackProcessor callbackProcessor;
    private final SecuritySchemeProcessor securitySchemeProcessor;

    public ComponentsProcessor(OpenAPI openApi, ResolverCache cache) {
        this.cache = cache;
        this.openApi = openApi;
        this.schemaProcessor = new SchemaProcessor(cache, openApi);
        this.responseProcessor = new ResponseProcessor(cache, openApi);
        this.requestBodyProcessor = new RequestBodyProcessor(cache, openApi);
        this.parameterProcessor = new ParameterProcessor(cache, openApi);
        this.headerProcessor = new HeaderProcessor(cache, openApi);
        this.exampleProcessor = new ExampleProcessor(cache, openApi);
        this.linkProcessor = new LinkProcessor(cache, openApi);
        this.callbackProcessor = new CallbackProcessor(cache, openApi);
        this.securitySchemeProcessor = new SecuritySchemeProcessor(cache, openApi);
    }

    public void processComponents() {
        LinkedHashSet<String> keySet;
        if (this.openApi.getComponents() == null) {
            return;
        }
        Map schemas = this.openApi.getComponents().getSchemas();
        Map responses = this.openApi.getComponents().getResponses();
        Map requestBodies = this.openApi.getComponents().getRequestBodies();
        Map parameters = this.openApi.getComponents().getParameters();
        Map headers = this.openApi.getComponents().getHeaders();
        Map examples = this.openApi.getComponents().getExamples();
        Map links = this.openApi.getComponents().getLinks();
        Map callbacks = this.openApi.getComponents().getCallbacks();
        Map securitySchemes = this.openApi.getComponents().getSecuritySchemes();
        if (schemas != null) {
            keySet = new LinkedHashSet<String>();
            while (schemas.keySet().size() > keySet.size()) {
                this.processSchemas(keySet, schemas);
            }
        }
        if (responses != null) {
            keySet = new LinkedHashSet();
            while (responses.keySet().size() > keySet.size()) {
                this.processResponses(keySet, responses);
            }
        }
        if (requestBodies != null) {
            keySet = new LinkedHashSet();
            while (requestBodies.keySet().size() > keySet.size()) {
                this.processRequestBodies(keySet, requestBodies);
            }
        }
        if (parameters != null) {
            keySet = new LinkedHashSet();
            while (parameters.keySet().size() > keySet.size()) {
                this.processParameters(keySet, parameters);
            }
        }
        if (headers != null) {
            keySet = new LinkedHashSet();
            while (headers.keySet().size() > keySet.size()) {
                this.processHeaders(keySet, headers);
            }
        }
        if (examples != null) {
            keySet = new LinkedHashSet();
            while (examples.keySet().size() > keySet.size()) {
                this.processExamples(keySet, examples);
            }
        }
        if (links != null) {
            keySet = new LinkedHashSet();
            while (links.keySet().size() > keySet.size()) {
                this.processLinks(keySet, links);
            }
        }
        if (callbacks != null) {
            keySet = new LinkedHashSet();
            while (callbacks.keySet().size() > keySet.size()) {
                this.processCallbacks(keySet, callbacks);
            }
        }
        if (securitySchemes != null) {
            keySet = new LinkedHashSet();
            while (securitySchemes.keySet().size() > keySet.size()) {
                this.processSecuritySchemes(keySet, securitySchemes);
            }
        }
    }

    private void processSecuritySchemes(Set<String> securitySchemeKey, Map<String, SecurityScheme> securitySchemes) {
        securitySchemeKey.addAll(securitySchemes.keySet());
        for (String securitySchemeName : securitySchemeKey) {
            SecurityScheme securityScheme = securitySchemes.get(securitySchemeName);
            SecurityScheme resolvedSecurityScheme = this.securitySchemeProcessor.processSecurityScheme(securityScheme);
            securitySchemes.replace(securitySchemeName, securityScheme, resolvedSecurityScheme);
        }
    }

    private void processCallbacks(Set<String> callbackKey, Map<String, Callback> callbacks) {
        callbackKey.addAll(callbacks.keySet());
        for (String callbackName : callbackKey) {
            Callback callback = callbacks.get(callbackName);
            this.callbackProcessor.processCallback(callback);
        }
    }

    private void processLinks(Set<String> linkKey, Map<String, Link> links) {
        linkKey.addAll(links.keySet());
        for (String linkName : linkKey) {
            Link link = links.get(linkName);
            this.linkProcessor.processLink(link);
        }
    }

    private void processExamples(Set<String> exampleKey, Map<String, Example> examples) {
        exampleKey.addAll(examples.keySet());
        for (String exampleName : exampleKey) {
            Example example = examples.get(exampleName);
            this.exampleProcessor.processExample(example);
        }
    }

    private void processHeaders(Set<String> HeaderKey, Map<String, Header> headers) {
        HeaderKey.addAll(headers.keySet());
        for (String headersName : HeaderKey) {
            Header header = headers.get(headersName);
            this.headerProcessor.processHeader(header);
        }
    }

    private void processParameters(Set<String> ParametersKey, Map<String, Parameter> parameters) {
        ParametersKey.addAll(parameters.keySet());
        for (String parametersName : ParametersKey) {
            Parameter parameter = parameters.get(parametersName);
            this.parameterProcessor.processParameter(parameter);
        }
    }

    private void processRequestBodies(Set<String> requestBodyKey, Map<String, RequestBody> requestBodies) {
        requestBodyKey.addAll(requestBodies.keySet());
        for (String requestBodyName : requestBodyKey) {
            RequestBody requestBody = requestBodies.get(requestBodyName);
            this.requestBodyProcessor.processRequestBody(requestBody);
        }
    }

    private void processResponses(Set<String> responseKey, Map<String, ApiResponse> responses) {
        responseKey.addAll(responses.keySet());
        for (String responseName : responseKey) {
            ApiResponse response = responses.get(responseName);
            this.responseProcessor.processResponse(response);
        }
    }

    public void processSchemas(Set<String> schemaKeys, Map<String, Schema> schemas) {
        schemaKeys.addAll(schemas.keySet());
        for (String schemaName : schemaKeys) {
            Schema schema = schemas.get(schemaName);
            this.schemaProcessor.processSchema(schema);
        }
    }
}

