/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class SimpleTypeLookup
implements ITypeLookupExtension {
    protected GroovyCompilationUnit unit;
    private static final List<ClassNode> UNKNOWN_TYPES = new ArrayList<ClassNode>();
    protected static final AccessorSupport[] READER = new AccessorSupport[]{AccessorSupport.ISSER, AccessorSupport.GETTER};
    protected static final AccessorSupport[] WRITER = new AccessorSupport[]{AccessorSupport.SETTER};

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
        this.unit = unit;
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType, boolean isStaticObjectExpression) {
        ClassNode declaringType = Optional.ofNullable(GroovyUtils.getWrapperTypeIfPrimitive(objectExpressionType)).orElseGet(() -> SimpleTypeLookup.findDeclaringType(node, scope));
        boolean isPrimary = objectExpressionType == null;
        boolean isStatic = isStaticObjectExpression || isPrimary && scope.isStatic();
        return this.findType(node, declaringType, scope, isPrimary, isStatic);
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return new TypeLookupResult(node.getType(), node.getDeclaringClass(), (ASTNode)node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return new TypeLookupResult(node.getReturnType(), node.getDeclaringClass(), (ASTNode)node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        ClassNode type = node;
        if (node.getOuterClass() != null) {
            if (!node.isRedirectNode() && GroovyUtils.isAnonymous(node)) {
                type = node.getUnresolvedSuperClass(false);
                if (type == VariableScope.OBJECT_CLASS_NODE) {
                    type = node.getInterfaces()[0];
                }
            } else if (SimpleTypeLookup.isTraitHelper(node)) {
                type = node.getOuterClass();
            }
        }
        return new TypeLookupResult(type, type, (ASTNode)node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        ClassNode type = Optional.ofNullable(scope.lookupNameInCurrentScope(node.getName())).map(info -> info.type).orElse(node.getType());
        return new TypeLookupResult(type, scope.getEnclosingTypeDeclaration(), (ASTNode)node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    protected static ClassNode findDeclaringType(Expression node, VariableScope scope) {
        Variable var;
        if (node instanceof ClassExpression || node instanceof ConstructorCallExpression) {
            return node.getType();
        }
        if (node instanceof FieldExpression) {
            return ((FieldExpression)node).getField().getDeclaringClass();
        }
        if (node instanceof StaticMethodCallExpression) {
            return null;
        }
        if (node instanceof ConstantExpression && scope.isMethodCall()) {
            ClassNode ownerType = scope.getEnclosingClosure() != null ? SimpleTypeLookup.getBaseDeclaringType(scope.getOwner()) : scope.getEnclosingTypeDeclaration();
            return ownerType;
        }
        if (node instanceof VariableExpression && (var = ((VariableExpression)node).getAccessedVariable()) != null && !(var instanceof Parameter) && !(var instanceof VariableExpression)) {
            ClassNode ownerType = scope.getEnclosingClosure() != null ? SimpleTypeLookup.getBaseDeclaringType(scope.getOwner()) : scope.getEnclosingTypeDeclaration();
            return ownerType;
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    protected TypeLookupResult findType(Expression node, ClassNode declaringType, VariableScope scope, boolean isPrimaryExpression, boolean isStaticObjectExpression) {
        MethodNode target;
        ClassNode nodeType = node.getType();
        TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.EXACT;
        if (scope.isMethodCall() && (target = SimpleTypeLookup.getMethodTarget(node)) != null) {
            return new TypeLookupResult(target.getReturnType(), target.getDeclaringClass(), (ASTNode)target, confidence, scope);
        }
        if (node instanceof VariableExpression) {
            return this.findTypeForVariable((VariableExpression)node, scope, declaringType);
        }
        if (node instanceof ConstantExpression) {
            if (isPrimaryExpression) {
                if (scope.isMethodCall()) {
                    VariableExpression call = new VariableExpression((Variable)new DynamicVariable(node.getText(), false));
                    TypeLookupResult result = this.findTypeForVariable(call, scope, declaringType);
                    if (SimpleTypeLookup.isCompatible((AnnotatedNode)result.declaration, isStaticObjectExpression)) {
                        return result;
                    }
                    if (isStaticObjectExpression) {
                        return this.findTypeForVariable(call, scope, VariableScope.newClassClassNode(declaringType));
                    }
                }
            } else {
                VariableScope outer = (VariableScope)declaringType.getNodeMetaData((Object)"outer.scope");
                if (outer != null) {
                    try {
                        outer.setMethodCallArgumentTypes(scope.getMethodCallArgumentTypes());
                        TypeLookupResult typeLookupResult = this.findTypeForVariable(new VariableExpression((Variable)new DynamicVariable(node.getText(), false)), outer, declaringType);
                        return typeLookupResult;
                    }
                    finally {
                        outer.setMethodCallArgumentTypes(null);
                    }
                }
                if (scope.getEnclosingNode() instanceof AttributeExpression) {
                    ClassNode clazz = !isStaticObjectExpression ? declaringType : declaringType.getGenericsTypes()[0].getType();
                    FieldNode field = null;
                    if (!SimpleTypeLookup.isSuperObjectExpression(scope)) {
                        field = clazz.getDeclaredField(node.getText());
                        clazz = clazz.getSuperClass();
                    }
                    while (field == null && clazz != null) {
                        field = clazz.getDeclaredField(node.getText());
                        if (field != null && (field.isPrivate() || !field.isPublic() && !field.isProtected() && !Objects.equals(clazz.getPackage(), scope.getEnclosingTypeDeclaration().getPackage()))) {
                            field = null;
                        }
                        clazz = clazz.getSuperClass();
                    }
                    if (SimpleTypeLookup.isCompatible((AnnotatedNode)field, isStaticObjectExpression)) {
                        return new TypeLookupResult(field.getType(), field.getDeclaringClass(), (ASTNode)field, confidence, scope);
                    }
                    return new TypeLookupResult(VariableScope.VOID_CLASS_NODE, null, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
                }
                if ("new".equals(node.getText()) && isStaticObjectExpression && SimpleTypeLookup.isStaticReferenceToInstanceMethod(scope)) {
                    return new TypeLookupResult(declaringType.getGenericsTypes()[0].getType(), null, (ASTNode)node, confidence, scope);
                }
                boolean isLhsExpression = scope.getWormhole().remove("lhs") == node;
                return this.findTypeForNameWithKnownObjectExpression(node.getText(), nodeType, declaringType, scope, isLhsExpression, isStaticObjectExpression);
            }
            ConstantExpression cexp = (ConstantExpression)node;
            if (cexp.isNullExpression()) {
                return new TypeLookupResult(VariableScope.NULL_TYPE, null, null, confidence, scope);
            }
            if (cexp.isTrueExpression() || cexp.isFalseExpression()) {
                return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
            }
            if (cexp.isEmptyStringExpression() || VariableScope.STRING_CLASS_NODE.equals((Object)nodeType)) {
                return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, (ASTNode)node, confidence, scope);
            }
            if (ClassHelper.isNumberType((ClassNode)nodeType) || VariableScope.BIG_DECIMAL_CLASS.equals((Object)nodeType) || VariableScope.BIG_INTEGER_CLASS.equals((Object)nodeType)) {
                return new TypeLookupResult(GroovyUtils.getWrapperTypeIfPrimitive(nodeType), null, null, confidence, scope);
            }
            return new TypeLookupResult(nodeType, null, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
        }
        if (node instanceof ConstructorCallExpression) {
            ClassNode declaration;
            List declaredConstructors;
            ConstructorCallExpression call = (ConstructorCallExpression)node;
            ClassNode resolvedDeclaringType = declaringType;
            if (call.isSpecialCall()) {
                nodeType = VariableScope.VOID_CLASS_NODE;
                resolvedDeclaringType = scope.getEnclosingMethodDeclaration().getDeclaringClass();
                if (call.isSuperCall()) {
                    resolvedDeclaringType = resolvedDeclaringType.getUnresolvedSuperClass(false);
                }
            } else if (call.isUsingAnonymousInnerClass()) {
                nodeType = this.lookupType((ClassNode)call.getType(), (VariableScope)scope).type;
                resolvedDeclaringType = resolvedDeclaringType.getUnresolvedSuperClass(false);
            }
            if ((declaredConstructors = resolvedDeclaringType.getDeclaredConstructors()).size() > 1) {
                List<ClassNode> callTypes = scope.getMethodCallArgumentTypes();
                if (callTypes != null && !callTypes.isEmpty() && callTypes.get(0).equals((Object)declaringType.getOuterClass()) && (call.isUsingAnonymousInnerClass() ? !scope.isStatic() : !Flags.isStatic((int)declaringType.getModifiers()))) {
                    callTypes.remove(0);
                }
                declaration = SimpleTypeLookup.findMethodDeclaration0(declaredConstructors, callTypes, false);
            } else {
                declaration = !declaredConstructors.isEmpty() ? (ASTNode)declaredConstructors.get(0) : resolvedDeclaringType;
            }
            return new TypeLookupResult(nodeType, resolvedDeclaringType, (ASTNode)declaration, confidence, scope);
        }
        if (node instanceof StaticMethodCallExpression) {
            ArrayList<MethodNode> candidates = new ArrayList<MethodNode>(12);
            String methodName = ((StaticMethodCallExpression)node).getMethod();
            ClassNode theType = ((StaticMethodCallExpression)node).getOwnerType();
            if (theType.isAbstract() || theType.isInterface() || GroovyUtils.implementsTrait(theType)) {
                LinkedHashSet<ClassNode> hierarchy = new LinkedHashSet<ClassNode>();
                VariableScope.createTypeHierarchy(theType, hierarchy, false);
                for (ClassNode type : hierarchy) {
                    for (MethodNode candidate : type.getDeclaredMethods(methodName)) {
                        if (!candidate.isStatic()) continue;
                        candidates.add(candidate);
                    }
                }
            } else {
                ClassNode type = theType;
                while (type != null && type != VariableScope.OBJECT_CLASS_NODE) {
                    for (MethodNode candidate : type.getDeclaredMethods(methodName)) {
                        if (!candidate.isStatic()) continue;
                        candidates.add(candidate);
                    }
                    type = type.getSuperClass();
                }
            }
            MethodNode closestMatch = SimpleTypeLookup.findMethodDeclaration0(candidates, scope.getMethodCallArgumentTypes(), true);
            return new TypeLookupResult(closestMatch.getReturnType(), closestMatch.getDeclaringClass(), (ASTNode)closestMatch, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        if (node instanceof ClosureExpression) {
            ClassNode returnType;
            if (VariableScope.isPlainClosure(nodeType) && (returnType = (ClassNode)node.getNodeMetaData((Object)"returnType")) != null && !VariableScope.isVoidOrObject(returnType)) {
                GroovyUtils.updateClosureWithInferredTypes(nodeType, returnType, ((ClosureExpression)node).getParameters());
            }
            return new TypeLookupResult(nodeType, null, (ASTNode)node, confidence, scope);
        }
        if (node instanceof BooleanExpression) {
            return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof GStringExpression) {
            return new TypeLookupResult(VariableScope.GSTRING_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof ArrayExpression || node instanceof CastExpression) {
            return new TypeLookupResult(nodeType, null, null, confidence, scope);
        }
        if (node instanceof ClassExpression) {
            ClassNode classType = VariableScope.newClassClassNode(nodeType);
            return new TypeLookupResult(classType, null, (ASTNode)nodeType, confidence, scope);
        }
        if (node instanceof EmptyExpression) {
            return new TypeLookupResult(null, null, null, confidence, scope);
        }
        if (node instanceof BitwiseNegationExpression) {
            ClassNode type = ((BitwiseNegationExpression)node).getExpression().getType();
            if (VariableScope.STRING_CLASS_NODE.equals((Object)type)) {
                type = VariableScope.PATTERN_CLASS_NODE;
            }
            return new TypeLookupResult(type, null, null, confidence, scope);
        }
        if (VariableScope.OBJECT_CLASS_NODE.equals((Object)nodeType)) {
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        return new TypeLookupResult(nodeType, declaringType, null, confidence, scope);
    }

    protected TypeLookupResult findTypeForNameWithKnownObjectExpression(String name, ClassNode type, ClassNode declaringType, VariableScope scope, boolean isLhsExpression, boolean isStaticObjectExpression) {
        ClassNode resolvedDeclaringType;
        ClassNode resolvedType;
        int fieldAccessPolicy;
        TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.EXACT;
        ClassNode declaring = isStaticObjectExpression && (!Traits.isTrait((ClassNode)SimpleTypeLookup.getBaseDeclaringType(declaringType)) || "$static$self".equals(SimpleTypeLookup.getObjectExpression(scope).getText())) ? SimpleTypeLookup.getBaseDeclaringType(declaringType) : declaringType;
        ASTNode declaration = this.findDeclaration(name, declaring, isLhsExpression, isStaticObjectExpression, fieldAccessPolicy = !scope.isFieldAccessDirect() || !SimpleTypeLookup.isThisObjectExpression(scope) && !SimpleTypeLookup.isSuperObjectExpression(scope) ? 0 : (SimpleTypeLookup.isThisObjectExpression(scope) ? 1 : 2), scope.getEnclosingNode() instanceof MethodPointerExpression ? UNKNOWN_TYPES : scope.getMethodCallArgumentTypes());
        if (declaration instanceof MethodNode && scope.getEnclosingNode() instanceof PropertyExpression && !scope.isMethodCall() && (!AccessorSupport.isGetter((MethodNode)declaration) || name.equals(((MethodNode)declaration).getName()))) {
            declaration = null;
        }
        if (!(declaration != null || declaring == declaringType || VariableScope.CLASS_CLASS_NODE.equals((Object)declaringType) && scope.getEnclosingNode() instanceof MethodPointerExpression && GroovyUtils.getGroovyVersion().getMajor() < 4)) {
            return this.findTypeForNameWithKnownObjectExpression(name, type, declaringType, scope, isLhsExpression, false);
        }
        if (declaration != null) {
            resolvedType = SimpleTypeLookup.getTypeFromDeclaration(declaration);
            resolvedDeclaringType = SimpleTypeLookup.getDeclaringTypeFromDeclaration(declaration, declaringType);
        } else if ("call".equals(name)) {
            resolvedType = VariableScope.OBJECT_CLASS_NODE;
            resolvedDeclaringType = VariableScope.CLOSURE_CLASS_NODE;
            declaration = (ASTNode)resolvedDeclaringType.getMethods("call").get(0);
        } else if ("this".equals(name) && declaringType.equals((Object)VariableScope.CLASS_CLASS_NODE)) {
            resolvedType = resolvedDeclaringType = declaringType.getGenericsTypes()[0].getType();
            declaration = resolvedDeclaringType;
        } else {
            resolvedType = VariableScope.OBJECT_CLASS_NODE;
            resolvedDeclaringType = declaringType;
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        if (declaration != null) {
            if (!resolvedDeclaringType.equals((Object)VariableScope.CLASS_CLASS_NODE) && !resolvedDeclaringType.equals((Object)VariableScope.OBJECT_CLASS_NODE)) {
                if (declaration instanceof FieldNode) {
                    FieldNode field = (FieldNode)declaration;
                    if (isStaticObjectExpression && !field.isStatic()) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    } else if (field.isPrivate()) {
                        if (SimpleTypeLookup.isSuperObjectExpression(scope)) {
                            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                        } else if (SimpleTypeLookup.isThisObjectExpression(scope) && SimpleTypeLookup.isNotThisOrOuterClass(declaring, resolvedDeclaringType)) {
                            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                        }
                    }
                } else if (declaration instanceof PropertyNode) {
                    PropertyNode property = (PropertyNode)declaration;
                    FieldNode underlyingField = property.getField();
                    if (isStaticObjectExpression && (underlyingField != null ? !underlyingField.isStatic() : !property.isStatic())) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    } else if (property.isSynthetic()) {
                        confidence = isLhsExpression || !scope.isMethodCall() && !(scope.getEnclosingNode() instanceof MethodPointerExpression) ? TypeLookupResult.TypeConfidence.INFERRED : TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                } else if (declaration instanceof MethodNode) {
                    MethodNode method = (MethodNode)declaration;
                    if (isStaticObjectExpression && !method.isStatic() && !SimpleTypeLookup.isStaticReferenceToInstanceMethod(scope)) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    } else if (method.isPrivate()) {
                        if (SimpleTypeLookup.isSuperObjectExpression(scope)) {
                            if (scope.getEnclosingNode() instanceof MethodPointerExpression || GroovyUtils.getGroovyVersion().getMajor() > 3) {
                                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                            }
                        } else if (SimpleTypeLookup.isThisObjectExpression(scope) && SimpleTypeLookup.isNotThisOrOuterClass(declaring, resolvedDeclaringType)) {
                            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                        }
                    } else {
                        if (method.getName().startsWith("is") && !name.startsWith("is") && !scope.isMethodCall() && SimpleTypeLookup.isSuperObjectExpression(scope) && GroovyUtils.getGroovyVersion().getMajor() < 4) {
                            String newName = "get" + MetaClassHelper.capitalize((String)name);
                            scope.setMethodCallArgumentTypes(Collections.emptyList());
                            return this.findTypeForNameWithKnownObjectExpression(newName, type, declaringType, scope, isLhsExpression, isStaticObjectExpression);
                        }
                        if (!(!SimpleTypeLookup.isLooseMatch(scope.getMethodCallArgumentTypes(), method.getParameters()) || isStaticObjectExpression && SimpleTypeLookup.isStaticReferenceToUnambiguousMethod(scope, name, declaringType) || AccessorSupport.isGetter(method) && !scope.isMethodCall() && scope.getEnclosingNode() instanceof PropertyExpression)) {
                            confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                        }
                    }
                    if (SimpleTypeLookup.isTraitHelper(resolvedDeclaringType) && method.getOriginal() != method) {
                        resolvedDeclaringType = method.getOriginal().getDeclaringClass();
                        declaration = method.getOriginal();
                    }
                }
                if (confidence.isAtLeast(TypeLookupResult.TypeConfidence.INFERRED) && isLhsExpression && SimpleTypeLookup.isCompoundAssignment(scope)) {
                    if (declaration instanceof MethodNode) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    } else if (SimpleTypeLookup.findPropertyAccessorMethod(name, declaringType, false, isStaticObjectExpression, null).filter(getter -> !SimpleTypeLookup.isSynthetic(getter) && (fieldAccessPolicy == 0 || !declaringType.equals((Object)getter.getDeclaringClass()))).isPresent()) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                }
            } else if (resolvedDeclaringType.equals((Object)VariableScope.CLASS_CLASS_NODE) && declaration instanceof MethodNode) {
                MethodNode classMethod = (MethodNode)declaration;
                if (isStaticObjectExpression && !classMethod.isStatic()) {
                    List argumentTypes = scope.getMethodCallArgumentTypes();
                    if (argumentTypes == null && !name.equals(classMethod.getName()) && !isLhsExpression) {
                        argumentTypes = Collections.EMPTY_LIST;
                    }
                    if (SimpleTypeLookup.isLooseMatch(argumentTypes, ((MethodNode)declaration).getParameters())) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                }
            }
        }
        return new TypeLookupResult(resolvedType, resolvedDeclaringType, declaration, confidence, scope);
    }

    protected TypeLookupResult findTypeForVariable(VariableExpression var, VariableScope scope, ClassNode declaringType) {
        boolean isDirectAccess;
        VariableExpression decl = var;
        ClassNode type = var.getType();
        ClassNode resolvedDeclaringType = declaringType;
        TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.EXACT;
        Variable accessedVar = var.getAccessedVariable();
        VariableScope.VariableInfo variableInfo = scope.lookupName(var.getName());
        int resolveStrategy = scope.getEnclosingClosureResolveStrategy();
        boolean isAssignTarget = scope.getWormhole().get("lhs") == var;
        boolean bl = isDirectAccess = accessedVar instanceof AnnotatedNode && declaringType.equals((Object)((AnnotatedNode)accessedVar).getDeclaringClass());
        if (accessedVar instanceof FieldNode && (!isDirectAccess || !scope.isFieldAccessDirect()) || accessedVar instanceof PropertyNode && GeneralUtils.isOrImplements((ClassNode)declaringType, (ClassNode)VariableScope.MAP_CLASS_NODE) || isDirectAccess && resolveStrategy != 0 && resolveStrategy != 2) {
            accessedVar = new DynamicVariable(var.getName(), scope.isStatic());
        } else if (accessedVar instanceof Parameter && ((Parameter)accessedVar).getEnd() < 1 && var.getEnd() > 0 && variableInfo != null && variableInfo.scopeNode instanceof ConstructorNode) {
            accessedVar = ((MethodNode)variableInfo.scopeNode).getDeclaringClass().getField(var.getName());
        }
        if (accessedVar instanceof ASTNode) {
            decl = (ASTNode)accessedVar;
            if (decl instanceof FieldNode || decl instanceof MethodNode || decl instanceof PropertyNode) {
                PropertyNode prop;
                if (decl instanceof PropertyNode && (prop = (PropertyNode)decl).isDynamicTyped() && prop.getField().hasNoRealSourcePosition()) {
                    Optional<MethodNode> accessor = SimpleTypeLookup.findPropertyAccessorMethod(prop.getName(), declaringType, isAssignTarget, prop.isStatic(), scope.getMethodCallArgumentTypes());
                    decl = accessor.map(meth -> meth).orElse((ASTNode)decl);
                }
                type = SimpleTypeLookup.getTypeFromDeclaration((ASTNode)decl);
                resolvedDeclaringType = ((AnnotatedNode)decl).getDeclaringClass();
                if (decl instanceof MethodNode || !((Variable)decl).isDynamicTyped()) {
                    variableInfo = null;
                }
            }
        } else if (accessedVar instanceof DynamicVariable) {
            ASTNode candidate = this.findDeclarationForDynamicVariable(var, declaringType, scope, isAssignTarget, resolveStrategy);
            if (candidate != null && (!(candidate instanceof MethodNode) || scope.isMethodCall() || (AccessorSupport.isGetter((MethodNode)candidate) || AccessorSupport.isSetter((MethodNode)candidate)) && !var.getName().equals(((MethodNode)candidate).getName()))) {
                ClassNode implicitThisType;
                ClassNode classNode = implicitThisType = VariableScope.CLOSURE_CLASS_NODE.equals((Object)declaringType) ? scope.getEnclosingTypeDeclaration() : declaringType;
                if (candidate instanceof FieldNode) {
                    FieldNode field = (FieldNode)candidate;
                    ClassNode owner = field.getDeclaringClass();
                    if (field.getName().contains("__") && GroovyUtils.implementsTrait(owner)) {
                        candidate = (ASTNode)SimpleTypeLookup.findTraitField(field.getName(), owner).orElse(field);
                    } else if (field.isPrivate() && SimpleTypeLookup.isNotThisOrOuterClass(implicitThisType, owner)) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                } else if (candidate instanceof MethodNode) {
                    MethodNode method = (MethodNode)candidate;
                    List<ClassNode> argumentTypes = scope.getMethodCallArgumentTypes();
                    if (argumentTypes != null && SimpleTypeLookup.isLooseMatch(argumentTypes, method.getParameters())) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                    if (method.isPrivate() && SimpleTypeLookup.isNotThisOrOuterClass(implicitThisType, method.getDeclaringClass())) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                } else if (candidate instanceof PropertyNode && ((PropertyNode)candidate).isSynthetic()) {
                    if (var.getAccessedVariable() instanceof FieldNode && declaringType.getOuterClasses().contains(((FieldNode)var.getAccessedVariable()).getDeclaringClass())) {
                        candidate = (FieldNode)var.getAccessedVariable();
                    } else {
                        TypeLookupResult.TypeConfidence typeConfidence = confidence = isAssignTarget || !scope.isMethodCall() ? TypeLookupResult.TypeConfidence.INFERRED : TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                }
                if (confidence.isAtLeast(TypeLookupResult.TypeConfidence.INFERRED) && isAssignTarget && SimpleTypeLookup.isCompoundAssignment(scope) && (candidate instanceof MethodNode || !candidate.equals(this.findDeclarationForDynamicVariable(var, declaringType, scope, false, resolveStrategy)))) {
                    confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                }
                decl = candidate;
                type = SimpleTypeLookup.getTypeFromDeclaration((ASTNode)decl);
                resolvedDeclaringType = SimpleTypeLookup.getDeclaringTypeFromDeclaration((ASTNode)decl, declaringType);
                if (!VariableScope.CLOSURE_CLASS_NODE.equals((Object)resolvedDeclaringType)) {
                    variableInfo = null;
                }
            } else {
                type = VariableScope.OBJECT_CLASS_NODE;
                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                if (variableInfo != null && !scope.inScriptRunMethod()) {
                    variableInfo = null;
                }
            }
        }
        if (variableInfo != null) {
            type = Optional.ofNullable(variableInfo.type).orElseGet(ClassHelper::dynamicType);
            resolvedDeclaringType = SimpleTypeLookup.getMorePreciseType(declaringType, variableInfo);
            if (VariableScope.isThisOrSuper((Variable)var)) {
                decl = type;
            }
            confidence = TypeLookupResult.TypeConfidence.INFERRED;
        }
        return new TypeLookupResult(type, resolvedDeclaringType, (ASTNode)decl, confidence, scope);
    }

    protected ASTNode findDeclarationForDynamicVariable(VariableExpression var, ClassNode owner, VariableScope scope, boolean isAssignTarget, int resolveStrategy) {
        ASTNode candidate = null;
        List<ClassNode> callArgs = scope.getMethodCallArgumentTypes();
        if (resolveStrategy == 1 || resolveStrategy == 3) {
            candidate = this.findDeclaration(var.getName(), scope.getDelegate(), isAssignTarget, false, 0, callArgs);
        }
        if (candidate == null && resolveStrategy < 3) {
            VariableScope outer = (VariableScope)owner.getNodeMetaData((Object)"outer.scope");
            if (outer != null) {
                try {
                    outer.setMethodCallArgumentTypes(callArgs);
                    candidate = this.findDeclarationForDynamicVariable(var, SimpleTypeLookup.getBaseDeclaringType(outer.getOwner()), outer, isAssignTarget, outer.getEnclosingClosureResolveStrategy());
                }
                finally {
                    outer.setMethodCallArgumentTypes(null);
                }
            } else {
                candidate = this.findDeclaration(var.getName(), owner, isAssignTarget, scope.isOwnerStatic(), scope.isFieldAccessDirect() ? 1 : 0, callArgs);
            }
            if (candidate == null && resolveStrategy < 1 && scope.getEnclosingClosure() != null) {
                candidate = this.findDeclaration(var.getName(), scope.getDelegate(), isAssignTarget, false, 0, callArgs);
            }
            if (candidate == null && scope.getEnclosingClosure() == null && scope.getEnclosingMethodDeclaration() != null) {
                Parameter[] parameterArray = scope.getEnclosingMethodDeclaration().getParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter parameter = parameterArray[n2];
                    if (parameter.getName().equals(var.getName())) {
                        candidate = parameter;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (candidate == null && resolveStrategy <= 4 && (resolveStrategy > 0 || scope.getEnclosingClosure() != null)) {
            candidate = this.findDeclaration(var.getName(), VariableScope.CLOSURE_CLASS_NODE, isAssignTarget, false, 0, callArgs);
        }
        return candidate;
    }

    protected ASTNode findDeclaration(String name, ClassNode declaringType, boolean isLhsExpression, boolean isStaticExpression, int directFieldAccess, List<ClassNode> methodCallArgumentTypes) {
        Optional<MethodNode> mopMethod;
        ClassNode type3;
        FieldNode field;
        boolean dynamicProperty;
        boolean isCallExpression;
        if (declaringType.isArray()) {
            if ("length".equals(name)) {
                return SimpleTypeLookup.createLengthField(declaringType);
            }
            return this.findDeclaration(name, VariableScope.OBJECT_CLASS_NODE, isLhsExpression, isStaticExpression, 0, methodCallArgumentTypes);
        }
        boolean bl = isCallExpression = !isLhsExpression && methodCallArgumentTypes != null;
        if (isCallExpression) {
            if (!isStaticExpression && declaringType.implementsInterface(ClassHelper.GROOVY_INTERCEPTABLE_TYPE)) {
                return declaringType.getMethod("invokeMethod", new Parameter[]{new Parameter(VariableScope.STRING_CLASS_NODE, "name"), new Parameter(VariableScope.OBJECT_CLASS_NODE, "args")});
            }
            MethodNode method = this.findMethodDeclaration(name, declaringType, methodCallArgumentTypes, isStaticExpression);
            if (SimpleTypeLookup.isCompatible((AnnotatedNode)method, isStaticExpression)) {
                return method;
            }
        }
        boolean bl2 = dynamicProperty = !isCallExpression && !isStaticExpression && GeneralUtils.isOrImplements((ClassNode)declaringType, (ClassNode)VariableScope.MAP_CLASS_NODE);
        if (dynamicProperty && directFieldAccess == 0 && !isLhsExpression) {
            return SimpleTypeLookup.createDynamicProperty(name, SimpleTypeLookup.getMapPropertyType(declaringType), declaringType, isStaticExpression);
        }
        Optional<MethodNode> accessor = SimpleTypeLookup.findPropertyAccessorMethod(name, declaringType, isLhsExpression, isStaticExpression, methodCallArgumentTypes).filter(it -> !SimpleTypeLookup.isSynthetic(it));
        boolean nonPrivateAccessor = accessor.filter(it -> !it.isPrivate() || declaringType.equals((Object)it.getDeclaringClass())).isPresent();
        if (nonPrivateAccessor && directFieldAccess == 0) {
            return (ASTNode)accessor.get();
        }
        LinkedHashSet<ClassNode> typeHierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(declaringType, typeHierarchy, true);
        for (ClassNode type2 : typeHierarchy) {
            Object property = type2.getProperty(name);
            if (property == null && GroovyUtils.implementsTrait(declaringType) && Traits.isTrait((ClassNode)type2)) {
                property = Optional.ofNullable((List)type2.redirect().getNodeMetaData((Object)"trait.properties")).flatMap(list -> list.stream().filter(prop -> prop.getName().equals(name)).findFirst()).orElse(null);
            }
            if (!(!SimpleTypeLookup.isCompatible((AnnotatedNode)property, isStaticExpression) || isLhsExpression && Flags.isFinal((int)property.getModifiers()) || (accessor.isPresent() || dynamicProperty && !isLhsExpression) && (directFieldAccess != 1 || !declaringType.equals((Object)property.getDeclaringClass())))) {
                return property;
            }
            if (property != null) break;
        }
        if (!(!SimpleTypeLookup.isCompatible((AnnotatedNode)(field = declaringType.getField(name)), isStaticExpression) || Flags.isSynthetic((int)field.getModifiers()) && field.getType().equals((Object)ClassHelper.REFERENCE_TYPE) || (nonPrivateAccessor || dynamicProperty && (!isLhsExpression || field.isFinal() || !field.isPublic() && !field.isProtected())) && (directFieldAccess < 1 || !declaringType.equals((Object)field.getDeclaringClass()) || directFieldAccess != 1 && field.isPrivate()))) {
            return field;
        }
        if (!(!dynamicProperty || isLhsExpression && nonPrivateAccessor)) {
            return SimpleTypeLookup.createDynamicProperty(name, SimpleTypeLookup.getMapPropertyType(declaringType), declaringType, isStaticExpression);
        }
        if (accessor.isPresent()) {
            return (ASTNode)accessor.get();
        }
        for (ClassNode type3 : typeHierarchy) {
            if (!type3.isInterface() || type3 == declaringType || (field = type3.getDeclaredField(name)) == null || !field.isFinal() || !field.isStatic()) continue;
            return field;
        }
        if (!declaringType.equals((Object)VariableScope.CLASS_CLASS_NODE) && !declaringType.equals((Object)VariableScope.OBJECT_CLASS_NODE) && !declaringType.equals((Object)ClassHelper.SCRIPT_TYPE) && (mopMethod = SimpleTypeLookup.findMetaObjectMethods(declaringType, isLhsExpression, isStaticExpression, methodCallArgumentTypes).filter(mm -> {
            if (SimpleTypeLookup.isSynthetic(mm)) {
                return false;
            }
            Parameter[] p = mm.getParameters();
            if (mm.getName().startsWith("g")) {
                return p.length == 1 && p[0].getType().equals((Object)VariableScope.STRING_CLASS_NODE);
            }
            if (!mm.getName().endsWith("yMissing")) {
                return p.length == 2 && p[0].getType().equals((Object)VariableScope.STRING_CLASS_NODE) && p[1].getType().equals((Object)VariableScope.OBJECT_CLASS_NODE);
            }
            return p.length == 1;
        }).findFirst()).isPresent()) {
            return (ASTNode)mopMethod.map(mm -> !isCallExpression ? SimpleTypeLookup.createDynamicProperty(name, VariableScope.OBJECT_CLASS_NODE, declaringType, isStaticExpression) : mm).get();
        }
        type3 = SimpleTypeLookup.getBaseDeclaringType(declaringType);
        while (type3 != null) {
            if (type3.getOuterClass() != null) {
                boolean isStatic = isStaticExpression || Flags.isStatic((int)type3.getModifiers());
                ASTNode declaration = this.findDeclaration(name, type3.getOuterClass(), isLhsExpression, isStatic, 0, methodCallArgumentTypes);
                if (declaration != null) {
                    return declaration;
                }
            }
            type3 = type3.getSuperClass();
        }
        if (!isCallExpression && !isStaticExpression && GeneralUtils.isOrImplements((ClassNode)declaringType, (ClassNode)ClassHelper.METACLASS_TYPE)) {
            try {
                if ("constructor".equals(name)) {
                    return SimpleTypeLookup.createDynamicProperty(name, ClassHelper.make(Class.forName("groovy.lang.ExpandoMetaClass$ExpandoMetaConstructor")), declaringType, false);
                }
                if ("static".equals(name)) {
                    return SimpleTypeLookup.createDynamicProperty(name, ClassHelper.make(Class.forName("groovy.lang.ExpandoMetaClass$ExpandoMetaProperty")), declaringType, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (methodCallArgumentTypes == null || methodCallArgumentTypes == UNKNOWN_TYPES) {
            return this.findMethodDeclaration(name, declaringType, methodCallArgumentTypes, isStaticExpression);
        }
        return null;
    }

    protected MethodNode findMethodDeclaration(String name, ClassNode declaringType, List<ClassNode> argumentTypes, boolean isStaticExpression) {
        LinkedHashSet<ClassNode> interfaces = new LinkedHashSet<ClassNode>();
        VariableScope.findAllInterfaces(declaringType, interfaces, false);
        if (!(declaringType.isAbstract() || declaringType.isInterface() || GroovyUtils.implementsTrait(declaringType))) {
            List<MethodNode> candidates = SimpleTypeLookup.getMethods(name, declaringType);
            for (ClassNode face : interfaces) {
                for (MethodNode method : face.getDeclaredMethods(name)) {
                    if (!method.isDefault()) continue;
                    candidates.add(method);
                }
            }
            return candidates.isEmpty() ? null : SimpleTypeLookup.findMethodDeclaration0(candidates, argumentTypes, isStaticExpression);
        }
        LinkedHashSet<ClassNode> types = new LinkedHashSet<ClassNode>();
        types.add(declaringType);
        types.addAll(interfaces);
        if (!GroovyUtils.implementsTrait(declaringType)) {
            types.add(VariableScope.OBJECT_CLASS_NODE);
        }
        MethodNode outerCandidate = null;
        for (ClassNode type : types) {
            MethodNode innerCandidate = null;
            List<MethodNode> candidates = SimpleTypeLookup.getMethods(name, type);
            if (!candidates.isEmpty() && (innerCandidate = SimpleTypeLookup.findMethodDeclaration0(candidates, argumentTypes, isStaticExpression)) != null) {
                if (SimpleTypeLookup.isTraitBridge(innerCandidate)) continue;
                if (outerCandidate == null) {
                    outerCandidate = innerCandidate;
                }
            }
            if (innerCandidate == null || argumentTypes == null) continue;
            Parameter[] methodParameters = innerCandidate.getParameters();
            if (argumentTypes.isEmpty() && methodParameters.length == 0) {
                return innerCandidate;
            }
            if (argumentTypes.size() != methodParameters.length) continue;
            outerCandidate = SimpleTypeLookup.closer(innerCandidate, outerCandidate, argumentTypes);
            Boolean suitable = SimpleTypeLookup.isTypeCompatible(argumentTypes, methodParameters);
            if (Boolean.FALSE.equals(suitable) || !Boolean.TRUE.equals(suitable)) continue;
            return innerCandidate;
        }
        return outerCandidate;
    }

    /*
     * WARNING - void declaration
     */
    private static MethodNode findMethodDeclaration0(List<? extends MethodNode> candidates, List<ClassNode> argumentTypes, boolean isStaticExpression) {
        void var3_9;
        void var3_7;
        Parameter[] parameters;
        if (argumentTypes == null || argumentTypes == UNKNOWN_TYPES) {
            for (MethodNode methodNode : candidates) {
                if (!SimpleTypeLookup.isCompatible((AnnotatedNode)methodNode, isStaticExpression)) continue;
                return methodNode;
            }
            return candidates.get(0);
        }
        Object var3_6 = null;
        int argumentCount = argumentTypes.size();
        for (MethodNode methodNode : candidates) {
            parameters = methodNode.getParameters();
            if (parameters.length == 0) {
                if (argumentCount != 0) continue;
                return methodNode;
            }
            if (argumentCount != parameters.length && (argumentCount < parameters.length - 1 || !GenericsMapper.isVargs(parameters))) continue;
            Boolean suitable = SimpleTypeLookup.isTypeCompatible(argumentTypes, parameters);
            if (Boolean.TRUE.equals(suitable)) {
                return methodNode;
            }
            if (Boolean.FALSE.equals(suitable)) continue;
            MethodNode methodNode2 = SimpleTypeLookup.closer(methodNode, (MethodNode)var3_7, argumentTypes);
        }
        if (var3_7 == null) {
            if (argumentCount == 0) {
                if (candidates.size() == 1 && candidates.get(0).getParameters().length == 1 && !ClassHelper.isPrimitiveType((ClassNode)candidates.get(0).getParameters()[0].getOriginType())) {
                    return candidates.get(0);
                }
            } else if (argumentTypes.stream().anyMatch(t -> ClassHelper.isPrimitiveType((ClassNode)ClassHelper.getUnwrapper((ClassNode)t)) || ClassHelper.OBJECT_TYPE.equals(t) || ClassHelper.STRING_TYPE.equals(t))) {
                for (MethodNode methodNode : candidates) {
                    parameters = methodNode.getParameters();
                    if (argumentCount != parameters.length && (argumentCount < parameters.length - 1 || !GenericsMapper.isVargs(parameters))) continue;
                    if (SimpleTypeLookup.isCompatible((AnnotatedNode)methodNode, isStaticExpression)) {
                        return methodNode;
                    }
                    MethodNode methodNode3 = methodNode;
                }
            }
        }
        return var3_9;
    }

    private static Stream<MethodNode> findMetaObjectMethods(ClassNode declaringType, boolean isLhsExpression, boolean isStaticExpression, List<ClassNode> methodCallArgumentTypes) {
        Stream<String> names = isLhsExpression ? (!isStaticExpression ? Stream.of("setProperty", "set") : Stream.empty()) : (methodCallArgumentTypes == null ? (!isStaticExpression ? Stream.of("getProperty", "get", "propertyMissing") : Stream.of("$static_propertyMissing")) : (!isStaticExpression ? Stream.of("methodMissing", "invokeMethod") : Stream.of("$static_methodMissing")));
        return names.flatMap(name -> declaringType.getDeclaredMethods(name).stream()).filter(node -> node.isStatic() == node.getName().startsWith("$static"));
    }

    private static Optional<MethodNode> findPropertyAccessorMethod(String propertyName, ClassNode declaringType, boolean isLhsExpression, boolean isStaticExpression, List<ClassNode> methodCallArgumentTypes) {
        Stream<MethodNode> accessors = AccessorSupport.findAccessorMethodsForPropertyName(propertyName, declaringType, false, !isLhsExpression ? READER : WRITER);
        accessors = accessors.filter(accessor -> SimpleTypeLookup.isCompatible((AnnotatedNode)accessor, isStaticExpression) && !SimpleTypeLookup.isTraitBridge(accessor) && (!accessor.isStatic() || !accessor.getDeclaringClass().isInterface()));
        if (isLhsExpression) {
            accessors = accessors.sorted((m1, m2) -> m1 == SimpleTypeLookup.closer(m2, m1, methodCallArgumentTypes) ? -1 : 1);
        }
        return accessors.findFirst();
    }

    protected static MethodNode closer(MethodNode next, MethodNode last, List<ClassNode> args) {
        long d2;
        long d1;
        if (last != null && (d1 = SimpleTypeLookup.calculateParameterDistance(args, last.getParameters())) <= (d2 = SimpleTypeLookup.calculateParameterDistance(args, next.getParameters()))) {
            return last;
        }
        return next;
    }

    protected static long calculateParameterDistance(List<ClassNode> arguments, Parameter[] parameters) {
        try {
            int n = arguments.size();
            Class[] args = new Class[n];
            int i = 0;
            while (i < n) {
                args[i] = arguments.get(i).getTypeClass();
                ++i;
            }
            n = parameters.length;
            Class[] prms = new Class[n];
            int i2 = 0;
            while (i2 < n) {
                prms[i2] = parameters[i2].getType().getTypeClass();
                ++i2;
            }
            return MetaClassHelper.calculateParameterDistance((Class[])args, (ParameterTypes)new ParameterTypes(prms));
        }
        catch (Throwable t) {
            ClassNode pt = ((Parameter)DefaultGroovyMethods.last((Object[])parameters)).getType();
            if (pt.isArray()) {
                pt = pt.getComponentType();
            }
            return Long.MAX_VALUE - (long)(VariableScope.isVoidOrObject(pt) ? 0 : 1);
        }
    }

    protected static PropertyNode createDynamicProperty(String name, ClassNode type, ClassNode declaringType, boolean staticProperty) {
        FieldNode fn = new FieldNode(name, 1 | (staticProperty ? 8 : 0), type, declaringType, null);
        fn.setDeclaringClass(declaringType);
        fn.setHasNoRealSourcePosition(true);
        fn.setSynthetic(true);
        PropertyNode pn = new PropertyNode(fn, fn.getModifiers(), null, null);
        pn.setDeclaringClass(declaringType);
        pn.setSynthetic(true);
        return pn;
    }

    protected static FieldNode createLengthField(ClassNode declaringType) {
        FieldNode fn = new FieldNode("length", 1, ClassHelper.int_TYPE, declaringType, null);
        fn.setDeclaringClass(declaringType);
        fn.setHasNoRealSourcePosition(true);
        return fn;
    }

    protected static ClassNode getBaseDeclaringType(ClassNode declaringType) {
        GenericsType genericsType;
        if (VariableScope.CLASS_CLASS_NODE.equals((Object)declaringType) && declaringType.isUsingGenerics() && !(genericsType = declaringType.getGenericsTypes()[0]).isWildcard()) {
            return genericsType.getType();
        }
        return declaringType;
    }

    protected static ClassNode getMapPropertyType(ClassNode mapType) {
        ClassNode propertyType = VariableScope.OBJECT_CLASS_NODE;
        for (ClassNode face : GroovyUtils.getAllInterfaces(mapType)) {
            if (!face.equals((Object)VariableScope.MAP_CLASS_NODE)) continue;
            GenericsType[] generics = GroovyUtils.getGenericsTypes(face);
            if (generics.length != 2) break;
            propertyType = generics[1].getType();
            break;
        }
        return propertyType;
    }

    protected static List<MethodNode> getMethods(String name, ClassNode type) {
        List methods = type.getMethods(name);
        List traitMethods = (List)type.redirect().getNodeMetaData((Object)"trait.methods");
        if (traitMethods != null) {
            for (MethodNode method : traitMethods) {
                if (!method.getName().equals(name)) continue;
                methods.add(method);
            }
        }
        methods.removeIf(m -> Flags.isSynthetic((int)m.getModifiers()));
        return methods.size() <= 1 ? methods : DefaultGroovyMethods.unique((List)methods, Comparator.comparing(m -> {
            StringBuilder sb = new StringBuilder();
            Parameter[] parameterArray = m.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = parameterArray[n2];
                sb.append(p.getType().getName());
                sb.append(',');
                ++n2;
            }
            return sb.toString();
        }));
    }

    protected static MethodNode getMethodTarget(Expression expr) {
        if (expr instanceof MethodCallExpression) {
            MethodNode target = ((MethodCallExpression)expr).getMethodTarget();
            return target;
        }
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)expr.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        if (meta != null) {
            MethodNode target = (MethodNode)ReflectionUtils.getPrivateField(OptimizingStatementWriter.StatementMeta.class, "target", meta);
            return target;
        }
        return null;
    }

    protected static ClassNode getMorePreciseType(ClassNode declaringType, VariableScope.VariableInfo info) {
        ClassNode maybeDeclaringType;
        ClassNode classNode = maybeDeclaringType = info != null ? info.declaringType : VariableScope.OBJECT_CLASS_NODE;
        if (maybeDeclaringType.equals((Object)VariableScope.OBJECT_CLASS_NODE) && !VariableScope.OBJECT_CLASS_NODE.equals((Object)declaringType)) {
            return declaringType;
        }
        return maybeDeclaringType;
    }

    protected static ClassNode getTypeFromDeclaration(ASTNode declaration) {
        ClassNode type;
        PropertyNode property;
        ASTNode decl = declaration;
        if (decl instanceof PropertyNode && (property = (PropertyNode)decl).getField() != null) {
            decl = property.getField();
        }
        if (decl instanceof FieldNode) {
            FieldNode field = (FieldNode)decl;
            type = field.getType();
        } else {
            type = decl instanceof ConstructorNode ? ((ConstructorNode)decl).getDeclaringClass() : (decl instanceof MethodNode ? ((MethodNode)decl).getReturnType() : (decl instanceof Expression ? ((Expression)decl).getType() : VariableScope.OBJECT_CLASS_NODE));
        }
        return type;
    }

    protected static ClassNode getDeclaringTypeFromDeclaration(ASTNode declaration, ClassNode inferredDeclaringType) {
        ClassNode declaringType = declaration instanceof FieldNode ? ((FieldNode)declaration).getDeclaringClass() : (declaration instanceof MethodNode ? ((MethodNode)declaration).getDeclaringClass() : (declaration instanceof PropertyNode ? ((PropertyNode)declaration).getDeclaringClass() : VariableScope.OBJECT_CLASS_NODE));
        if (inferredDeclaringType.equals((Object)declaringType)) {
            return inferredDeclaringType;
        }
        return declaringType;
    }

    protected static Optional<FieldNode> findTraitField(String name, ClassNode type) {
        String[] parts = name.split("__");
        ClassNode[] classNodeArray = type.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode face = classNodeArray[n2];
            if (face.getName().equals(parts[0].replace('_', '.'))) {
                List traitFields = (List)face.redirect().getNodeMetaData((Object)"trait.fields");
                return Optional.ofNullable(traitFields).flatMap(fields -> fields.stream().filter(f -> f.getName().equals(parts[1])).findFirst());
            }
            ++n2;
        }
        return Optional.empty();
    }

    protected static boolean isCompoundAssignment(VariableScope scope) {
        return scope.getEnclosingAssignmentOperator().filter(op -> op.getType() != 100).isPresent();
    }

    protected static Expression getObjectExpression(VariableScope scope) {
        ASTNode node = scope.getEnclosingNode();
        if (node instanceof PropertyExpression) {
            return ((PropertyExpression)node).getObjectExpression();
        }
        if (node instanceof MethodCallExpression) {
            return ((MethodCallExpression)node).getObjectExpression();
        }
        if (node instanceof MethodPointerExpression) {
            return ((MethodPointerExpression)node).getExpression();
        }
        return null;
    }

    protected static boolean isThisObjectExpression(VariableScope scope) {
        Expression expr = SimpleTypeLookup.getObjectExpression(scope);
        return expr instanceof VariableExpression && ((VariableExpression)expr).isThisExpression();
    }

    protected static boolean isSuperObjectExpression(VariableScope scope) {
        Expression expr = SimpleTypeLookup.getObjectExpression(scope);
        return expr instanceof VariableExpression && ((VariableExpression)expr).isSuperExpression();
    }

    protected static boolean isStaticReferenceToInstanceMethod(VariableScope scope) {
        if (scope.getEnclosingNode() instanceof MethodPointerExpression && scope.getCurrentNode() instanceof ConstantExpression) {
            return GroovyUtils.getGroovyVersion().getMajor() >= 3;
        }
        return false;
    }

    protected static boolean isStaticReferenceToUnambiguousMethod(VariableScope scope, String name, ClassNode type) {
        if (scope.getEnclosingNode() instanceof ImportNode) {
            long staticMethodCount = SimpleTypeLookup.getMethods(name, type).stream().filter(meth -> SimpleTypeLookup.isCompatible((AnnotatedNode)meth, true)).count();
            return staticMethodCount == 1L;
        }
        return false;
    }

    protected static boolean isCompatible(AnnotatedNode declaration, boolean isStaticExpression) {
        if (declaration != null) {
            boolean isStatic = false;
            if (declaration instanceof FieldNode) {
                isStatic = ((FieldNode)declaration).isStatic();
            } else if (declaration instanceof MethodNode) {
                isStatic = ((MethodNode)declaration).isStatic();
            } else if (declaration instanceof PropertyNode) {
                isStatic = ((PropertyNode)declaration).isStatic();
            }
            if (!isStaticExpression || isStatic || VariableScope.CLASS_CLASS_NODE.equals((Object)declaration.getDeclaringClass()) || VariableScope.OBJECT_CLASS_NODE.equals((Object)declaration.getDeclaringClass())) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isNotThisOrOuterClass(ClassNode thisType, ClassNode declaringClass) {
        return !thisType.equals((Object)declaringClass) && !thisType.getOuterClasses().contains(declaringClass) && (!GroovyUtils.implementsTrait(thisType) || !thisType.implementsInterface(declaringClass));
    }

    protected static boolean isSynthetic(MethodNode method) {
        return method.isSynthetic() || method.getDeclaringClass().equals((Object)VariableScope.CLOSURE_CLASS_NODE) || GroovyUtils.getAnnotations((AnnotatedNode)method, "groovy.transform.Generated").anyMatch(annotationNode -> true);
    }

    protected static boolean isTraitBridge(MethodNode method) {
        return method.getAnnotations().stream().map(AnnotationNode::getClassNode).anyMatch(arg_0 -> ((ClassNode)Traits.TRAITBRIDGE_CLASSNODE).equals(arg_0));
    }

    protected static boolean isTraitHelper(ClassNode candidate) {
        return Flags.isSynthetic((int)candidate.getModifiers()) && candidate.getName().endsWith("Helper") && candidate.getName().contains("$Trait$") && Traits.isTrait((ClassNode)candidate.getOuterClass());
    }

    protected static boolean isLooseMatch(List<ClassNode> arguments, Parameter[] parameters) {
        ClassNode lastType;
        int argCount;
        int n = argCount = arguments == null ? -1 : arguments.size();
        if (argCount != parameters.length && (!GenericsMapper.isVargs(parameters) || argCount != parameters.length - 1 && argCount <= parameters.length)) {
            return true;
        }
        return argCount > 0 && arguments.get(argCount - 1).equals((Object)VariableScope.CLOSURE_CLASS_NODE) && !(lastType = GroovyUtils.getBaseType(parameters[parameters.length - 1].getType())).equals((Object)VariableScope.CLOSURE_CLASS_NODE);
    }

    protected static Boolean isTypeCompatible(List<ClassNode> arguments, Parameter[] parameters) {
        Boolean result = Boolean.TRUE;
        int i = 0;
        int n = Math.max(arguments.size(), parameters.length);
        while (i < n) {
            ClassNode argument;
            ClassNode parameter = parameters[Math.min(i, parameters.length - 1)].getType();
            ClassNode classNode = argument = i < arguments.size() ? arguments.get(i) : parameter;
            if (i >= parameters.length) {
                assert (parameter.isArray());
                parameter = parameter.getComponentType();
            } else if (!(i != parameters.length - 1 || arguments.size() < parameters.length || !parameter.isArray() || argument.isArray() && GroovyUtils.isAssignable(argument, parameter))) {
                parameter = parameter.getComponentType();
            }
            Boolean partialResult = SimpleTypeLookup.isTypeCompatible(argument, parameter);
            if (partialResult == null) {
                result = null;
            } else if (!partialResult.booleanValue()) {
                return Boolean.FALSE;
            }
            ++i;
        }
        if (arguments.size() != parameters.length || !arguments.isEmpty() && ((ClassNode)DefaultGroovyMethods.last(arguments)).isArray() != ((Parameter)DefaultGroovyMethods.last((Object[])parameters)).getType().isArray()) {
            return null;
        }
        return result;
    }

    protected static Boolean isTypeCompatible(ClassNode source, ClassNode target) {
        Boolean result = Boolean.TRUE;
        if (!target.equals((Object)source) && (VariableScope.NULL_TYPE != source || ClassHelper.isPrimitiveType((ClassNode)target))) {
            result = !GroovyUtils.isAssignable(source, target) && (!VariableScope.CLOSURE_CLASS_NODE.equals((Object)source) || !ClassHelper.isSAMType((ClassNode)target)) ? Boolean.FALSE : null;
        }
        return result;
    }
}

