/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.composites;

import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.mobile.objectspy.components.MobileKeywordContextMenu;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileElementLabelProvider;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileElementTreeContentProvider;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecoderMessagesConstants;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class MobileAllObjectsComposite
extends Composite {
    private MobileElementInspectorDialog parentDialog;
    private TreeViewer allElementTreeViewer;

    public TreeViewer getAllElementTreeViewer() {
        return this.allElementTreeViewer;
    }

    public MobileAllObjectsComposite(MobileElementInspectorDialog parentDialog, Composite parent, int style) {
        super(parent, style);
        this.parentDialog = parentDialog;
        this.createComposite(parent);
    }

    public MobileAllObjectsComposite(MobileElementInspectorDialog parentDialog, Composite parent) {
        this(parentDialog, parent, 0);
    }

    private void createComposite(Composite parent) {
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.setLayout((Layout)new GridLayout());
        this.createCompositeLabel(this);
        this.createAllObjectsTreeComposite(this);
    }

    private void createCompositeLabel(Composite parent) {
        Label lblAllObjects = new Label(parent, 0);
        lblAllObjects.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ControlUtils.setFontToBeBold((Control)lblAllObjects);
        lblAllObjects.setText(MobileRecoderMessagesConstants.LBL_ALL_OBJECTS);
    }

    private void createAllObjectsTreeComposite(Composite parent) {
        Composite allObjectsTreeComposite = new Composite(parent, 0);
        allObjectsTreeComposite.setLayoutData((Object)new GridData(1808));
        allObjectsTreeComposite.setLayout((Layout)new GridLayout(1, false));
        this.createAllObjectsTreeViewer(allObjectsTreeComposite);
    }

    private void createAllObjectsTreeViewer(Composite allObjectsTreeComposite) {
        this.allElementTreeViewer = new CTreeViewer(allObjectsTreeComposite, 68356);
        this.allElementTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.allElementTreeViewer.setLabelProvider((IBaseLabelProvider)new MobileElementLabelProvider());
        this.allElementTreeViewer.setContentProvider((IContentProvider)new MobileElementTreeContentProvider());
        this.allElementTreeViewer.getTree().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.allElementTreeViewer, (int)2);
        this.allElementTreeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TreeItem item = MobileAllObjectsComposite.this.allElementTreeViewer.getTree().getItem(pt);
                if (item != null) {
                    TreeMobileElement treeSnapshotItem = (TreeMobileElement)item.getData();
                    MobileAllObjectsComposite.this.parentDialog.setSelectedElement((MobileElement)treeSnapshotItem);
                }
            }
        });
        Tree tree = (Tree)this.allElementTreeViewer.getControl();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeColumn[] treeColumnArray = treeColumns;
                        int n = treeColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn treeColumn = treeColumnArray[n2];
                            treeColumn.pack();
                            ++n2;
                        }
                    }
                });
            }
        };
        tree.addListener(17, listener);
        this.createKeywordContextMenu();
    }

    public void createKeywordContextMenu() {
        MobileKeywordContextMenu keywordContextMenu = new MobileKeywordContextMenu(this.allElementTreeViewer.getControl());
        keywordContextMenu.onKeywordClickedListener((mobileAction, currentPoint) -> {
            Point pt = new Point(currentPoint.x, currentPoint.y);
            TreeItem item = this.allElementTreeViewer.getTree().getItem(pt);
            if (item != null) {
                TreeMobileElement treeSnapshotItem = (TreeMobileElement)item.getData();
                this.parentDialog.setSelectedElement((MobileElement)treeSnapshotItem);
                this.parentDialog.onActionChosen(mobileAction, treeSnapshotItem);
            }
        });
        keywordContextMenu.whichElementChosen(currentPoint -> {
            TreeItem item = this.allElementTreeViewer.getTree().getItem(currentPoint);
            if (item != null) {
                TreeMobileElement treeSnapshotItem = (TreeMobileElement)item.getData();
                return this.parentDialog.captureMobileElement(treeSnapshotItem);
            }
            return null;
        });
    }

    public void setInput(TreeMobileElement rootElement) {
        this.allElementTreeViewer.setInput((Object)new Object[]{rootElement});
        this.allElementTreeViewer.refresh();
        this.allElementTreeViewer.expandAll();
    }

    public void focusToElementsTree() {
        this.allElementTreeViewer.getTree().setFocus();
    }

    public void setSelection(TreeMobileElement selection) {
        this.allElementTreeViewer.setSelection((ISelection)(selection != null ? new StructuredSelection((Object)selection) : StructuredSelection.EMPTY));
    }

    public void clearAllSelections() {
        this.allElementTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    public void clearAllElements() {
        this.allElementTreeViewer.setInput((Object)new Object[0]);
        this.allElementTreeViewer.refresh();
    }

    public void refreshTree() {
        this.allElementTreeViewer.refresh();
    }

    public void refreshTree(TreeMobileElement element) {
        this.allElementTreeViewer.refresh((Object)element);
    }

    public TreeMobileElement getSelectedElement() {
        return (TreeMobileElement)this.allElementTreeViewer.getStructuredSelection().getFirstElement();
    }
}

