/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.composites;

import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.KeyEventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverter;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.MobileActionUtil;
import com.kms.katalon.composer.mobile.objectspy.viewer.CapturedObjectTableViewer;
import com.kms.katalon.composer.mobile.recorder.types.CapturedMobileElementEdittingSupport;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.ast.treetable.AstBuiltInKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.components.KeywordTreeViewerToolTipSupport;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.TreeTableMenuItemConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariableView;
import com.kms.katalon.composer.testcase.providers.AstTreeItemLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstTreeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstTreeTableContentProvider;
import com.kms.katalon.composer.testcase.support.DescriptionColumnEditingSupport;
import com.kms.katalon.composer.testcase.support.InputColumnEditingSupport;
import com.kms.katalon.composer.testcase.support.ItemColumnEditingSupport;
import com.kms.katalon.composer.testcase.support.OutputColumnEditingSupport;
import com.kms.katalon.composer.testcase.util.TestCaseMenuUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.Keys;

public class MobileRecordedStepsViewComposite
extends Composite
implements ITestCasePart {
    private Dialog parentDialog;
    private ScriptNodeWrapper wrapper;
    private CTreeViewer treeViewer;
    private TestCaseTreeTableInput treeTableInput;
    private ToolItem tltmAddStep;
    private ToolItem tltmRemoveStep;
    private ToolItem tltmUp;
    private ToolItem tltmDown;
    private TestCaseVariableView variableView;
    private CapturedObjectTableViewer capturedElementsTableViewer;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    public ScriptNodeWrapper getWrapper() {
        return this.wrapper;
    }

    public CapturedObjectTableViewer getCapturedElementsTableViewer() {
        return this.capturedElementsTableViewer;
    }

    public void setCapturedElementsTableViewer(CapturedObjectTableViewer capturedElementsTableViewer) {
        this.capturedElementsTableViewer = capturedElementsTableViewer;
    }

    public MobileRecordedStepsViewComposite(Dialog parentDialog, Composite parent, int style) {
        super(parent, style);
        this.parentDialog = parentDialog;
        this.wrapper = new ScriptNodeWrapper();
        this.wrapper.addDefaultImports();
        this.wrapper.addImport(Keys.class);
        this.createComposite(parent);
    }

    public MobileRecordedStepsViewComposite(Dialog parentDialog, Composite parent) {
        this(parentDialog, parent, 0);
    }

    public void createComposite(Composite parent) {
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        GridLayout glContainer = new GridLayout();
        glContainer.marginWidth = 0;
        glContainer.marginHeight = 0;
        this.setLayout((Layout)glContainer);
        this.createStepButtons(this);
        Composite compositeTable = new Composite((Composite)this, 0);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new CTreeViewer(compositeTable, 67586);
        Tree childTableTree = this.treeViewer.getTree();
        childTableTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        childTableTree.setLinesVisible(ControlUtils.shouldLineVisble((Display)childTableTree.getDisplay()));
        childTableTree.setHeaderVisible(true);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        compositeTable.setLayout((Layout)treeColumnLayout);
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, ComposerTestcaseMessageConstants.PA_COL_ITEM, 175, 0, (CellLabelProvider)new AstTreeItemLabelProvider(), (EditingSupport)new ItemColumnEditingSupport((TreeViewer)this.treeViewer, (ITestCasePart)this));
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, GlobalMessageConstants.OBJECT, 120, 0, (CellLabelProvider)new AstTreeLabelProvider(), (EditingSupport)new CapturedMobileElementEdittingSupport((TreeViewer)this.treeViewer, this));
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, GlobalMessageConstants.INPUT, 150, 0, (CellLabelProvider)new AstTreeLabelProvider(), (EditingSupport)new InputColumnEditingSupport((TreeViewer)this.treeViewer, (ITestCasePart)this));
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, GlobalMessageConstants.OUTPUT, 80, 0, (CellLabelProvider)new AstTreeLabelProvider(), (EditingSupport)new OutputColumnEditingSupport((TreeViewer)this.treeViewer, (ITestCasePart)this));
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, GlobalMessageConstants.DESCRIPTION, 100, 0, (CellLabelProvider)new AstTreeLabelProvider(), (EditingSupport)new DescriptionColumnEditingSupport((TreeViewer)this.treeViewer, (ITestCasePart)this));
        this.treeViewer.setContentProvider((IContentProvider)new AstTreeTableContentProvider());
        this.setTreeTableActivation();
        this.treeTableInput = new TestCaseTreeTableInput(this.wrapper, (TreeViewer)this.treeViewer, (ITestCasePart)this);
        this.treeViewer.setInput((Object)this.treeTableInput.getMainClassNode().getAstChildren());
        this.createTreeTableMenu();
        KeywordTreeViewerToolTipSupport.enableFor((TreeViewer)this.treeViewer);
    }

    private void createStepButtons(Composite compositeSteps) {
        Composite compositeToolbars = new Composite(compositeSteps, 0);
        compositeToolbars.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compositeToolbars.setLayout((Layout)layout);
        ToolBar toolbar = new ToolBar(compositeToolbars, 0x820000);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        toolbar.setLayoutData((Object)new GridData(768));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object item = e.getSource();
                if (item instanceof ToolItem) {
                    MobileRecordedStepsViewComposite.this.performToolItemSelected((ToolItem)e.getSource(), e);
                    return;
                }
                if (item instanceof MenuItem var3_4) {
                    if (menuItem.getText().equals(ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_CUSTOM_KEYWORD) && !MobileRecordedStepsViewComposite.this.featureService.canUse(KSEFeature.CUSTOM_KEYWORD)) {
                        KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CUSTOM_KEYWORD);
                        return;
                    }
                    MobileRecordedStepsViewComposite.this.performMenuItemSelected((MenuItem)e.getSource());
                }
            }
        };
        this.tltmAddStep = new ToolItem(toolbar, 4);
        this.tltmAddStep.setText(GlobalMessageConstants.ADD);
        this.tltmAddStep.setImage(ImageManager.getImage((String)"add_16.png"));
        this.tltmAddStep.addSelectionListener((SelectionListener)selectionListener);
        Menu addMenu = new Menu((Control)this.tltmAddStep.getParent().getShell());
        this.tltmAddStep.setData((Object)addMenu);
        TestCaseMenuUtil.fillActionMenu((TreeTableMenuItemConstants.AddAction)TreeTableMenuItemConstants.AddAction.Add, (SelectionListener)selectionListener, (Menu)addMenu, null);
        this.tltmRemoveStep = new ToolItem(toolbar, 0);
        this.tltmRemoveStep.setText(GlobalMessageConstants.REMOVE);
        this.tltmRemoveStep.setImage(ImageManager.getImage((String)"delete_16.png"));
        this.tltmRemoveStep.addSelectionListener((SelectionListener)selectionListener);
        this.tltmUp = new ToolItem(toolbar, 0);
        this.tltmUp.setText("Move Up");
        this.tltmUp.setImage(ImageManager.getImage((String)"move_up_16.png"));
        this.tltmUp.addSelectionListener((SelectionListener)selectionListener);
        this.tltmDown = new ToolItem(toolbar, 0);
        this.tltmDown.setText("Move Down");
        this.tltmDown.setImage(ImageManager.getImage((String)"move_down_16.png"));
        this.tltmDown.addSelectionListener((SelectionListener)selectionListener);
    }

    private TreeViewerColumn addTreeTableColumn(TreeViewer parent, TreeColumnLayout treeColumnLayout, String headerText, int width, int weight, CellLabelProvider labelProvider, EditingSupport editingSupport) {
        TreeViewerColumn treeTableColumn = new TreeViewerColumn(parent, 0);
        TreeColumn treeColumn = treeTableColumn.getColumn();
        treeColumn.setWidth(width);
        treeColumn.setMoveable(true);
        treeColumn.setText(headerText);
        treeTableColumn.setLabelProvider(labelProvider);
        treeTableColumn.setEditingSupport(editingSupport);
        treeColumnLayout.setColumnData((Widget)treeTableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, treeColumn.getWidth()));
        return treeTableColumn;
    }

    private void setTreeTableActivation() {
        ColumnViewerUtil.setTreeTableActivation((TreeViewer)this.treeViewer);
    }

    public void performToolItemSelected(ToolItem toolItem, SelectionEvent selectionEvent) {
        this.treeViewer.applyEditorValue();
        if (toolItem.equals(this.tltmAddStep)) {
            this.openToolItemForAddMenu(toolItem, selectionEvent);
            return;
        }
        if (toolItem.equals(this.tltmRemoveStep)) {
            this.getTreeTableInput().removeSelectedRows();
            return;
        }
        if (toolItem.equals(this.tltmUp)) {
            this.getTreeTableInput().moveUp();
            return;
        }
        if (toolItem.equals(this.tltmDown)) {
            this.getTreeTableInput().moveDown();
            return;
        }
    }

    private void openToolItemForAddMenu(ToolItem toolItem, SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 4 && toolItem.getData() instanceof Menu) {
            Rectangle rect = toolItem.getBounds();
            Point pt = toolItem.getParent().toDisplay(new Point(rect.x, rect.y));
            Menu menu = (Menu)toolItem.getData();
            menu.setLocation(pt.x, pt.y + rect.height);
            menu.setVisible(true);
        } else {
            this.getTreeTableInput().addNewDefaultBuiltInKeyword(TestCaseTreeTableInput.NodeAddType.Add);
        }
    }

    public void performMenuItemSelected(MenuItem menuItem) {
        this.treeViewer.applyEditorValue();
        TestCaseTreeTableInput.NodeAddType addType = TestCaseTreeTableInput.NodeAddType.Add;
        Object value = menuItem.getData("ACTION");
        if (value instanceof TreeTableMenuItemConstants.AddAction) {
            switch ((TreeTableMenuItemConstants.AddAction)value) {
                case Add: {
                    addType = TestCaseTreeTableInput.NodeAddType.Add;
                    break;
                }
                case InsertAfter: {
                    addType = TestCaseTreeTableInput.NodeAddType.InserAfter;
                    break;
                }
                case InsertBefore: {
                    addType = TestCaseTreeTableInput.NodeAddType.InserBefore;
                }
            }
        }
        switch (menuItem.getID()) {
            case 128: {
                Object failureHandlingValue = menuItem.getData("FAILURE_HANDLING_KEY");
                if (!(failureHandlingValue instanceof FailureHandling)) break;
                this.getTreeTableInput().changeFailureHandling((FailureHandling)failureHandlingValue);
                break;
            }
            case 64: {
                this.getTreeTableInput().copy(this.getTreeTableInput().getSelectedNodes());
                break;
            }
            case 65: {
                this.getTreeTableInput().cut(this.getTreeTableInput().getSelectedNodes());
                break;
            }
            case 66: {
                this.getTreeTableInput().paste(this.getTreeTableInput().getSelectedNode(), addType);
                break;
            }
            case 67: {
                this.getTreeTableInput().removeSelectedRows();
                break;
            }
            case 69: {
                this.getTreeTableInput().enable();
                break;
            }
            case 68: {
                this.getTreeTableInput().disable();
                break;
            }
            default: {
                try {
                    this.refreshTree();
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    LoggerSingleton.logError((Throwable)exception);
                }
                this.getTreeTableInput().addNewAstObject(menuItem.getID(), this.getTreeTableInput().getSelectedNode(), addType);
            }
        }
    }

    private void createTreeTableMenu() {
        final Tree tree = this.treeViewer.getTree();
        tree.addListener(35, new Listener(){
            private SelectionListener selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    MenuItem item = (MenuItem)e.widget;
                    switch (item.getID()) {
                        case 64: {
                            MobileRecordedStepsViewComposite.this.copyTestStep();
                            break;
                        }
                        case 65: {
                            MobileRecordedStepsViewComposite.this.cutTestStep();
                            break;
                        }
                        case 66: {
                            MobileRecordedStepsViewComposite.this.pasteTestStep();
                            break;
                        }
                        case 67: {
                            MobileRecordedStepsViewComposite.this.removeTestStep();
                            break;
                        }
                        case 69: {
                            MobileRecordedStepsViewComposite.this.getTreeTableInput().enable();
                            break;
                        }
                        case 68: {
                            MobileRecordedStepsViewComposite.this.getTreeTableInput().disable();
                        }
                    }
                }
            };

            private String createMenuItemLabel(String text, String keyCombination) {
                return String.valueOf(text) + "\t" + keyCombination;
            }

            public void handleEvent(Event event) {
                Menu menu = tree.getMenu();
                if (menu != null) {
                    menu.dispose();
                }
                boolean hasSelection = tree.getSelectionCount() > 0;
                menu = new Menu((Control)tree);
                MenuItem removeMenuItem = new MenuItem(menu, 8);
                removeMenuItem.setText(this.createMenuItemLabel(GlobalStringConstants.DELETE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"DEL"})));
                removeMenuItem.addSelectionListener(this.selectionListener);
                removeMenuItem.setID(67);
                removeMenuItem.setEnabled(hasSelection);
                MenuItem copyMenuItem = new MenuItem(menu, 8);
                copyMenuItem.setText(this.createMenuItemLabel(GlobalStringConstants.COPY, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "C"})));
                copyMenuItem.addSelectionListener(this.selectionListener);
                copyMenuItem.setID(64);
                copyMenuItem.setEnabled(hasSelection);
                MenuItem cutMenuItem = new MenuItem(menu, 8);
                cutMenuItem.setText(this.createMenuItemLabel(GlobalStringConstants.CUT, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "X"})));
                cutMenuItem.addSelectionListener(this.selectionListener);
                cutMenuItem.setID(65);
                cutMenuItem.setEnabled(hasSelection);
                MenuItem pasteMenuItem = new MenuItem(menu, 8);
                pasteMenuItem.setText(this.createMenuItemLabel(GlobalStringConstants.PASTE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "V"})));
                pasteMenuItem.addSelectionListener(this.selectionListener);
                pasteMenuItem.setID(66);
                pasteMenuItem.setEnabled(MobileRecordedStepsViewComposite.this.getTreeTableInput().canPaste());
                tree.setMenu(menu);
                new MenuItem(menu, 2);
                MenuItem disableMenuItem = new MenuItem(menu, 8);
                disableMenuItem.setText(this.createMenuItemLabel(ComposerTestcaseMessageConstants.ADAP_MENU_CONTEXT_DISABLE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "/"})));
                disableMenuItem.addSelectionListener(this.selectionListener);
                disableMenuItem.setID(68);
                disableMenuItem.setEnabled(hasSelection);
                MenuItem enableMenuItem = new MenuItem(menu, 8);
                enableMenuItem.setText(this.createMenuItemLabel(ComposerTestcaseMessageConstants.ADAP_MENU_CONTEXT_ENABLE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"ALT", "M1", "/"})));
                enableMenuItem.addSelectionListener(this.selectionListener);
                enableMenuItem.setID(69);
                enableMenuItem.setEnabled(hasSelection);
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MobileRecordedStepsViewComposite.this.removeTestStep();
                    return;
                }
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1) {
                    if (e.keyCode == 99) {
                        MobileRecordedStepsViewComposite.this.copyTestStep();
                        return;
                    }
                    if (e.keyCode == 120) {
                        MobileRecordedStepsViewComposite.this.cutTestStep();
                        return;
                    }
                    if (e.keyCode == 118) {
                        MobileRecordedStepsViewComposite.this.pasteTestStep();
                        return;
                    }
                    if (e.keyCode == 47 && (e.stateMask & 0x10000) == 65536) {
                        MobileRecordedStepsViewComposite.this.treeTableInput.enable();
                        return;
                    }
                    if (e.keyCode == 47) {
                        MobileRecordedStepsViewComposite.this.treeTableInput.disable();
                        return;
                    }
                }
            }
        });
    }

    public void removeTestStep() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.treeViewer.getStructuredSelection().isEmpty();
        if (hasSelection) {
            this.treeTableInput.removeSelectedRows();
        }
    }

    public void copyTestStep() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.treeViewer.getStructuredSelection().isEmpty();
        if (hasSelection) {
            this.treeTableInput.copy(this.treeTableInput.getSelectedNodes());
        }
    }

    public void cutTestStep() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.treeViewer.getStructuredSelection().isEmpty();
        if (hasSelection) {
            this.treeTableInput.cut(this.treeTableInput.getSelectedNodes());
        }
    }

    public void pasteTestStep() {
        if (this.treeTableInput.canPaste()) {
            this.treeTableInput.paste(this.treeTableInput.getSelectedNode(), TestCaseTreeTableInput.NodeAddType.Add);
        }
    }

    public void addNode(MobileActionMapping newAction) throws ClassNotFoundException, InvocationTargetException, InterruptedException {
        this.refreshTree();
        CapturedMobileElement targetElement = newAction.getTargetElement();
        CapturedMobileElementConverter converter = new CapturedMobileElementConverter();
        ExpressionStatementWrapper wrapper = (ExpressionStatementWrapper)MobileActionUtil.generateMobileTestStep((MobileActionMapping)newAction, (WebElementEntity)converter.convert(targetElement), (ASTNodeWrapper)this.treeTableInput.getMainClassNode());
        this.treeTableInput.addNewAstObject((ASTNodeWrapper)wrapper, null, TestCaseTreeTableInput.NodeAddType.Add);
        this.treeViewer.refresh();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.getLatestNode()));
    }

    public AstBuiltInKeywordTreeTableNode getLatestNode() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        if (items == null || items.length == 0) {
            return null;
        }
        TreeItem latestItem = items[items.length - 1];
        if (latestItem.getData() instanceof AstBuiltInKeywordTreeTableNode) {
            return (AstBuiltInKeywordTreeTableNode)latestItem.getData();
        }
        return null;
    }

    public AstBuiltInKeywordTreeTableNode getNodeItem(int offset) {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        if (items == null || items.length == 0) {
            return null;
        }
        TreeItem item = items[offset];
        if (item.getData() instanceof AstBuiltInKeywordTreeTableNode) {
            return (AstBuiltInKeywordTreeTableNode)item.getData();
        }
        return null;
    }

    public List<AstTreeTableNode> getNodes() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        if (items == null || items.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AstTreeTableNode> nodes = new ArrayList<AstTreeTableNode>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            if (i.getData() instanceof AstTreeTableNode) {
                nodes.add((AstTreeTableNode)i.getData());
            }
            ++n2;
        }
        return nodes;
    }

    public void addSimpleKeyword(String keywordName, boolean hasParam) {
        String webUiKwAliasName = MobileActionUtil.getMobileKeywordClass().getAliasName();
        MethodCallExpressionWrapper methodCallExpressionWrapper = new MethodCallExpressionWrapper(webUiKwAliasName, keywordName, (ASTNodeWrapper)this.treeTableInput.getMainClassNode());
        if (hasParam) {
            ArgumentListExpressionWrapper arguments = methodCallExpressionWrapper.getArguments();
            arguments.addExpression((ExpressionWrapper)new ConstantExpressionWrapper((Object)""));
        }
        ExpressionStatementWrapper openBrowserStmt = new ExpressionStatementWrapper((ExpressionWrapper)methodCallExpressionWrapper);
        this.treeTableInput.addNewAstObject((ASTNodeWrapper)openBrowserStmt, null, TestCaseTreeTableInput.NodeAddType.Add);
        this.treeViewer.refresh();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.getLatestNode()));
    }

    public void refreshTree() throws InvocationTargetException, InterruptedException {
        this.treeTableInput.reloadTreeTableNodes();
    }

    public void setDirty(boolean isDirty) {
        this.treeTableInput.reloadTestCaseVariables(this.getVariables());
    }

    public void addVariables(VariableEntity[] variables) {
        this.variableView.addVariable(variables);
    }

    public VariableEntity[] getVariables() {
        return new VariableEntity[0];
    }

    public void deleteVariables(List<VariableEntity> variableList) {
    }

    public TestCaseEntity getTestCase() {
        return new TestCaseEntity();
    }

    public TestCaseTreeTableInput getTreeTableInput() {
        return this.treeTableInput;
    }

    public List<AstTreeTableNode> getDragNodes() {
        return null;
    }

    public void createDynamicGotoMenu(Menu menu) {
    }
}

