/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.mobile.objectspy.actions.IMobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionParam;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionParamValueType;
import com.kms.katalon.composer.mobile.objectspy.dialog.SaveScreenshotDialog;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.MobileActionHelper;
import com.kms.katalon.composer.mobile.recorder.components.MobileActionButtonWrapper;
import com.kms.katalon.composer.mobile.recorder.components.MobileRecorderDialog;
import com.kms.katalon.composer.mobile.recorder.composites.GetTextDialog;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecoderMessagesConstants;
import com.kms.katalon.composer.testcase.ast.dialogs.ArgumentInputBuilderDialog;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.model.InputParameterBuilder;
import com.kms.katalon.composer.testcase.model.InputParameterClass;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.util.CryptoUtil;
import io.appium.java_client.AppiumDriver;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.Keys;

public class RecordActionPerformHandler {
    private MobileRecorderDialog parentDialog;
    private List<MobileActionButtonWrapper> actionButtons = new ArrayList<MobileActionButtonWrapper>();

    public RecordActionPerformHandler(MobileRecorderDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    private Shell getShell() {
        return this.parentDialog.getShell();
    }

    public Composite renderActionButtons(SashForm sashForm, ActionButtonListener buttonListener) {
        Composite actionListComposite = (Composite)ComponentBuilder.gridContainer((Composite)sashForm).build();
        ComponentBuilder.label((Composite)actionListComposite).text(MobileRecoderMessagesConstants.LBL_POSSIBLE_ACTIONS).bold().build();
        Composite buttonsWrapper = (Composite)ComponentBuilder.gridContainer((Composite)actionListComposite, (int)1, (int)0).fill().build();
        Composite buttonsComposite = (Composite)ComponentBuilder.gridContainer((Composite)buttonsWrapper, (int)0).noFillVertical().build();
        RowLayout layout = new RowLayout();
        buttonsComposite.setLayout((Layout)layout);
        this.actionButtons.addAll(Arrays.asList(MobileAction.values()).stream().filter(action -> action.isUserInputAction()).map(action -> buttonListener.wrapActionOnClick((MobileAction)action, buttonsComposite)).collect(Collectors.toList()));
        ScrolledComposite scrollContainer = DialogUtil.autoScroll((Composite)buttonsWrapper, (int)512, (boolean)true);
        ComponentEventUtil.addListeners((Widget)actionListComposite, event -> {
            int scrollbarWidth = scrolledComposite.getVerticalBar().getSize().x;
            int width = composite.getSize().x - scrollbarWidth;
            int buttonHeight = this.actionButtons.get((int)0).getButton().computeSize((int)-1, (int)-1).y;
            int childrenHeight = buttonHeight + rowLayout.spacing;
            int lineLength = buttonHeight;
            for (MobileActionButtonWrapper buttonI : this.actionButtons) {
                int buttonWidth = buttonI.getButton().computeSize((int)-1, (int)-1).x;
                buttonHeight = buttonI.getButton().computeSize((int)-1, (int)-1).y;
                if ((lineLength += buttonWidth + rowLayout.spacing) <= width) continue;
                childrenHeight += buttonHeight + rowLayout.spacing;
                lineLength = buttonWidth;
            }
            ComponentUtil.setSize((Control)buttonsComposite, (int)width, (int)childrenHeight);
            buttonsComposite.pack();
            buttonsWrapper.pack();
            scrollContainer.setMinSize(width, childrenHeight);
        }, (int[])new int[]{11});
        scrollContainer.pack();
        actionListComposite.pack();
        return buttonsComposite;
    }

    public MobileActionMapping performAction(MobileAction action, CapturedMobileElement targetElement, MobileActionMapping mobileActionMapping, AppiumDriver<?> driver) throws Exception {
        MobileActionHelper mobileActionHelper = new MobileActionHelper(driver);
        MobileTestObject testObject = this.parentDialog.convertMobileElementToTestObject(targetElement, this.parentDialog.getCurrentMobileDriverType());
        mobileActionMapping.setAction((IMobileAction)action);
        mobileActionMapping.setTargetElement(targetElement);
        switch (action) {
            case ClearText: {
                mobileActionHelper.clearText((TestObject)testObject);
                break;
            }
            case HideKeyboard: {
                mobileActionHelper.hideKeyboard();
                break;
            }
            case PressBack: {
                mobileActionHelper.pressBack();
                break;
            }
            case GetText: {
                this.handleGetText((TestObject)testObject, mobileActionMapping, mobileActionHelper);
                break;
            }
            case SetText: {
                this.handleSetText((TestObject)testObject, mobileActionMapping, mobileActionHelper);
                break;
            }
            case SetEncryptedText: {
                this.handleSetEncryptedText(mobileActionHelper, mobileActionMapping, (TestObject)testObject);
                break;
            }
            case ScrollToText: {
                this.handleScrollToText(mobileActionHelper, mobileActionMapping);
                break;
            }
            case SwitchToLandscape: {
                mobileActionHelper.switchToLandscape();
                break;
            }
            case SwitchToPortrait: {
                mobileActionHelper.switchToPortrait();
                break;
            }
            case Tap: {
                mobileActionHelper.tap((TestObject)testObject);
                break;
            }
            case TapAndHold: {
                mobileActionHelper.tapAndHold((TestObject)testObject);
                break;
            }
            case Swipe: {
                this.handleSwipeAction(mobileActionHelper, mobileActionMapping);
                break;
            }
            case SwitchToWebView: {
                mobileActionHelper.switchToWebView();
                break;
            }
            case SwitchToNative: {
                mobileActionHelper.switchToNative();
                break;
            }
            case TakeScreenshot: {
                ArrayList<MobileActionParam> screenshotParams = new ArrayList<MobileActionParam>();
                screenshotParams.add(new MobileActionParam("fileName", String.class));
                action.setParams(screenshotParams.toArray(new MobileActionParam[screenshotParams.size()]));
                mobileActionMapping.setAction((IMobileAction)action);
                this.handleTakeScreenshotAction(mobileActionHelper, mobileActionMapping);
                break;
            }
            case SendKeys: {
                this.handleSendKeys((TestObject)testObject, mobileActionHelper, mobileActionMapping);
                break;
            }
            case VerifyElementText: {
                this.handleVerifyElementText((TestObject)testObject, mobileActionHelper, mobileActionMapping);
            }
        }
        return mobileActionMapping;
    }

    public void updateActionButtonsVisibility(MobileElement mobileElement, MobileDriverType currentMobileDriverType, AppiumDriver<?> driver) {
        this.actionButtons.stream().forEach(actionButton -> {
            MobileAction action = actionButton.getMobileAction();
            actionButton.setEnabledButton(driver != null && (!action.hasElement() || mobileElement != null) && currentMobileDriverType != null && action.isDriverTypeSupported(currentMobileDriverType));
        });
    }

    private void handleGetText(TestObject testObject, MobileActionMapping mobileActionMapping, MobileActionHelper mobileActionHelper) throws Exception {
        final String elementText = mobileActionHelper.getText(testObject);
        final MutableBoolean isCanceled = new MutableBoolean(false);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                GetTextDialog getTextDialog = new GetTextDialog(RecordActionPerformHandler.this.getShell(), elementText);
                if (getTextDialog.open() != 0) {
                    isCanceled.setTrue();
                }
            }
        });
        if (isCanceled.isTrue()) {
            throw new CancellationException();
        }
    }

    private void handleSetText(TestObject testObject, MobileActionMapping mobileActionMapping, MobileActionHelper mobileActionHelper) throws Exception {
        final StringBuilder stringBuilder = new StringBuilder();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                InputDialog inputDialog = new InputDialog(RecordActionPerformHandler.this.parentDialog.getShell(), MobileRecoderMessagesConstants.DLG_TITLE_TEXT_INPUT, MobileRecoderMessagesConstants.DLG_MSG_TEXT_INPUT, null, null);
                if (inputDialog.open() == 0) {
                    stringBuilder.append(inputDialog.getValue());
                }
            }
        });
        String textInput = stringBuilder.toString();
        if (textInput.isEmpty()) {
            throw new CancellationException();
        }
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)textInput));
        mobileActionHelper.setText(testObject, textInput);
    }

    private void handleSetEncryptedText(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping, TestObject testObject) throws Exception {
        final StringBuilder stringBuilder = new StringBuilder();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                InputDialog inputDialog = new InputDialog(RecordActionPerformHandler.this.getShell(), MobileRecoderMessagesConstants.DLG_TITLE_TEXT_INPUT, MobileRecoderMessagesConstants.DLG_MSG_TEXT_INPUT, null, null){

                    protected int getInputTextStyle() {
                        return super.getInputTextStyle() | 0x400000;
                    }
                };
                if (inputDialog.open() == 0) {
                    stringBuilder.append(inputDialog.getValue());
                }
            }
        });
        String password = stringBuilder.toString();
        String encryptedPassword = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)password));
        if (password.isEmpty()) {
            throw new CancellationException();
        }
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)encryptedPassword));
        mobileActionHelper.setText(testObject, password);
    }

    private void handleScrollToText(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        final StringBuilder stringBuilder = new StringBuilder();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                InputDialog inputDialog = new InputDialog(RecordActionPerformHandler.this.getShell(), MobileRecoderMessagesConstants.DLG_TITLE_TEXT_INPUT, MobileRecoderMessagesConstants.DLG_MSG_TEXT_INPUT, null, null);
                if (inputDialog.open() == 0) {
                    stringBuilder.append(inputDialog.getValue());
                }
            }
        });
        String textInput = stringBuilder.toString();
        if (textInput.isEmpty()) {
            throw new CancellationException();
        }
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)textInput));
        mobileActionHelper.scrollToText(textInput);
    }

    private void handleSwipeAction(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        ArrayList<InputParameter> parameters = new ArrayList<InputParameter>();
        InputParameterClass integerParamType = new InputParameterClass(Integer.class);
        ConstantExpressionWrapper defaultValue = new ConstantExpressionWrapper((Object)0);
        parameters.add(new InputParameter("startX", integerParamType, (Object)defaultValue));
        parameters.add(new InputParameter("startY", integerParamType, (Object)defaultValue));
        parameters.add(new InputParameter("endX", integerParamType, (Object)defaultValue));
        parameters.add(new InputParameter("endY", integerParamType, (Object)defaultValue));
        final InputParameterBuilder parameterBuilder = InputParameterBuilder.createForNestedMethodCall(parameters);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ArgumentInputBuilderDialog inputDialog = new ArgumentInputBuilderDialog(RecordActionPerformHandler.this.getShell(), parameterBuilder, null);
                inputDialog.open();
            }
        });
        MobileActionParamValueType[] actionParams = mobileActionMapping.getData();
        List touchCoords = parameterBuilder.getOriginalParameters();
        ArrayList coords = new ArrayList();
        IntStream.range(0, actionParams.length).forEach(index -> {
            coords.add((Integer)((ConstantExpressionWrapper)((InputParameter)touchCoords.get(index)).getValue()).getValue());
            actionParams[index].setValue(((InputParameter)touchCoords.get(index)).getValue());
        });
        if (coords.stream().allMatch(coord -> coord == 0)) {
            throw new CancellationException();
        }
        mobileActionHelper.swipe(((Integer)coords.get(0)).intValue(), ((Integer)coords.get(1)).intValue(), ((Integer)coords.get(2)).intValue(), ((Integer)coords.get(3)).intValue());
    }

    private void handleTakeScreenshotAction(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        final StringBuilder absolutePath = new StringBuilder();
        final StringBuilder messageError = new StringBuilder();
        final File tempFile = mobileActionHelper.takeScreenshot();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    SaveScreenshotDialog dialog = new SaveScreenshotDialog(RecordActionPerformHandler.this.getShell());
                    dialog.setFilePath(tempFile.getPath());
                    if (dialog.open() != 0) {
                        FileUtils.forceDelete((File)tempFile);
                        return;
                    }
                    absolutePath.append(dialog.getFilePath());
                    if (!absolutePath.toString().equals(tempFile.getPath())) {
                        FileUtils.copyFile((File)tempFile, (File)new File(absolutePath.toString()));
                        FileUtils.forceDelete((File)tempFile);
                    }
                    String finalCommand = absolutePath.toString();
                    if (Util.isLinux() || Util.isMac()) {
                        Runtime.getRuntime().exec(new String[]{"open", finalCommand});
                    } else {
                        finalCommand = "CMD /C \"" + absolutePath.toString() + "\"";
                        Runtime.getRuntime().exec(finalCommand);
                    }
                }
                catch (Exception e) {
                    messageError.append(e.getMessage());
                    try {
                        FileUtils.forceDelete((File)tempFile);
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        String filePath = absolutePath.toString();
        if (filePath.isEmpty()) {
            throw new CancellationException();
        }
        if (filePath.length() > 255) {
            throw new Exception(MessageFormat.format(MobileRecoderMessagesConstants.MSG_ERR_CANNOT_SAVE_SCREENSHOT, filePath.length()));
        }
        if (!messageError.toString().isEmpty()) {
            throw new Exception(messageError.toString());
        }
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)filePath));
    }

    private void handleSendKeys(TestObject testObject, MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        ArrayList<InputParameter> parameters = new ArrayList<InputParameter>();
        InputParameterClass stringParamType = new InputParameterClass(String.class);
        ConstantExpressionWrapper defaultValue = new ConstantExpressionWrapper((Object)"");
        parameters.add(new InputParameter("strokeKeys", stringParamType, (Object)defaultValue));
        final ASTNodeWrapper astNode = (ASTNodeWrapper)((InputParameter)parameters.get(0)).getValue();
        final InputParameterBuilder parameterBuilder = InputParameterBuilder.createForNestedMethodCall(parameters);
        final MutableBoolean isCanceled = new MutableBoolean(false);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ArgumentInputBuilderDialog inputDialog = new ArgumentInputBuilderDialog(RecordActionPerformHandler.this.getShell(), parameterBuilder, astNode);
                if (inputDialog.open() != 0) {
                    isCanceled.setTrue();
                }
            }
        });
        if (isCanceled.isTrue()) {
            throw new CancellationException();
        }
        List keys = parameterBuilder.getOriginalParameters();
        Object key = ((InputParameter)keys.get(0)).getValue();
        String strokeKeys = "";
        if (key instanceof ConstantExpressionWrapper) {
            ConstantExpressionWrapper expression = (ConstantExpressionWrapper)key;
            strokeKeys = (String)expression.getValue();
            mobileActionMapping.getData()[0].setValue((Object)expression);
        } else if (key instanceof MethodCallExpressionWrapper) {
            MethodCallExpressionWrapper methodCall = (MethodCallExpressionWrapper)key;
            ArgumentListExpressionWrapper argumentExpressionWrapper = methodCall.getArguments();
            mobileActionMapping.getData()[0].setValue(key);
            String keysChord = mobileActionHelper.getKeys(argumentExpressionWrapper);
            strokeKeys = Keys.chord((CharSequence[])new CharSequence[]{keysChord});
        }
        mobileActionHelper.sendKeys(testObject, strokeKeys);
    }

    private void handleVerifyElementText(TestObject testObject, MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)mobileActionHelper.getText(testObject)));
    }

    @FunctionalInterface
    public static interface ActionButtonListener {
        public MobileActionButtonWrapper wrapActionOnClick(MobileAction var1, Composite var2);
    }
}

