/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptSource;
import com.github.markusbernhardt.proxy.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;

public class UrlPacScriptSource
implements PacScriptSource {
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    public static final String OVERRIDE_CONNECT_TIMEOUT = "com.btr.proxy.url.connectTimeout";
    public static final String OVERRIDE_READ_TIMEOUT = "com.btr.proxy.url.readTimeout";
    private final String scriptUrl;
    private String scriptContent;
    private long expireAtMillis = 0L;

    public UrlPacScriptSource(String url) {
        this.scriptUrl = url;
    }

    @Override
    public synchronized String getScriptContent() throws IOException {
        if (this.scriptContent == null || this.expireAtMillis > 0L && this.expireAtMillis < System.currentTimeMillis()) {
            try {
                this.expireAtMillis = 0L;
                this.scriptContent = this.scriptUrl.startsWith("file:/") || this.scriptUrl.indexOf(":/") == -1 ? this.readPacFileContent(this.scriptUrl) : this.downloadPacContent(this.scriptUrl);
            }
            catch (IOException e) {
                Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Loading script failed from: {0} with error {1}", this.scriptUrl, e);
                this.scriptContent = "";
                throw e;
            }
        }
        return this.scriptContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPacFileContent(String scriptUrl) throws IOException {
        try {
            File file = null;
            file = scriptUrl.indexOf(":/") == -1 ? new File(scriptUrl) : new File(new URL(scriptUrl).toURI());
            BufferedReader r = new BufferedReader(new FileReader(file));
            StringBuilder result = new StringBuilder();
            try {
                String line;
                while ((line = r.readLine()) != null) {
                    result.append(line).append("\n");
                }
            }
            finally {
                r.close();
            }
            return result.toString();
        }
        catch (Exception e) {
            System.out.println(System.getProperty("user.dir"));
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "File reading error.", e);
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadPacContent(String url) throws IOException {
        if (url == null) {
            throw new IOException("Invalid PAC script URL: null");
        }
        this.setPacProxySelectorEnabled(false);
        HttpURLConnection con = null;
        try {
            con = this.setupHTTPConnection(url);
            if (con.getResponseCode() != 200) {
                throw new IOException("Server returned: " + con.getResponseCode() + " " + con.getResponseMessage());
            }
            this.expireAtMillis = con.getExpiration();
            BufferedReader r = this.getReader(con);
            String result = this.readAllContent(r);
            r.close();
            String string = result;
            return string;
        }
        finally {
            this.setPacProxySelectorEnabled(true);
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private void setPacProxySelectorEnabled(boolean enable) {
        PacProxySelector.setEnabled(enable);
    }

    private String readAllContent(BufferedReader r) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        while ((line = r.readLine()) != null) {
            result.append(line).append("\n");
        }
        return result.toString();
    }

    private BufferedReader getReader(HttpURLConnection con) throws UnsupportedEncodingException, IOException {
        String charsetName = this.parseCharsetFromHeader(con.getContentType());
        BufferedReader r = new BufferedReader(new InputStreamReader(con.getInputStream(), charsetName));
        return r;
    }

    private HttpURLConnection setupHTTPConnection(String url) throws IOException, MalformedURLException {
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
        con.setConnectTimeout(this.getTimeOut(OVERRIDE_CONNECT_TIMEOUT, 15000));
        con.setReadTimeout(this.getTimeOut(OVERRIDE_READ_TIMEOUT, 20000));
        con.setInstanceFollowRedirects(true);
        con.setRequestProperty("accept", "application/x-ns-proxy-autoconfig, */*;q=0.8");
        return con;
    }

    protected int getTimeOut(String overrideProperty, int defaultValue) {
        int timeout = defaultValue;
        String prop = System.getProperty(overrideProperty);
        if (prop != null && prop.trim().length() > 0) {
            try {
                timeout = Integer.parseInt(prop.trim());
            }
            catch (NumberFormatException e) {
                Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Invalid override property : {0}={1}", overrideProperty, prop);
            }
        }
        return timeout;
    }

    String parseCharsetFromHeader(String contentType) {
        String result = "ISO-8859-1";
        if (contentType != null) {
            String[] paramList;
            for (String param : paramList = contentType.split(";")) {
                if (!param.toLowerCase().trim().startsWith("charset") || param.indexOf("=") == -1) continue;
                result = param.substring(param.indexOf("=") + 1).trim();
            }
        }
        return result;
    }

    public String toString() {
        return this.scriptUrl;
    }

    @Override
    public boolean isScriptValid() {
        try {
            String script = this.getScriptContent();
            if (script == null || script.trim().length() == 0) {
                Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "PAC script is empty. Skipping script!", new Object[0]);
                return false;
            }
            if (script.indexOf("FindProxyForURL") == -1) {
                Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "PAC script entry point FindProxyForURL not found. Skipping script!", new Object[0]);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "File reading error: {0}", e);
            return false;
        }
    }
}

