/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.Argument;
import cucumber.api.HookType;
import cucumber.api.Result;
import cucumber.api.Scenario;
import cucumber.runner.EventBus;
import cucumber.runner.HookTestStep;
import cucumber.runner.TestStep;
import cucumber.runtime.DefinitionArgument;
import cucumber.runtime.PickleStepDefinitionMatch;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class PickleStepTestStep
extends TestStep
implements cucumber.api.PickleStepTestStep {
    private final String uri;
    private final PickleStep step;
    private final List<HookTestStep> afterStepHookSteps;
    private final List<HookTestStep> beforeStepHookSteps;
    private final PickleStepDefinitionMatch definitionMatch;

    PickleStepTestStep(String uri, PickleStep step, PickleStepDefinitionMatch definitionMatch) {
        this(uri, step, Collections.emptyList(), Collections.emptyList(), definitionMatch);
    }

    PickleStepTestStep(String uri, PickleStep step, List<HookTestStep> beforeStepHookSteps, List<HookTestStep> afterStepHookSteps, PickleStepDefinitionMatch definitionMatch) {
        super(definitionMatch);
        this.uri = uri;
        this.step = step;
        this.afterStepHookSteps = afterStepHookSteps;
        this.beforeStepHookSteps = beforeStepHookSteps;
        this.definitionMatch = definitionMatch;
    }

    @Override
    Result run(EventBus bus, String language, Scenario scenario, boolean skipSteps) {
        boolean skipNextStep = skipSteps;
        ArrayList<Result> results = new ArrayList<Result>();
        for (HookTestStep before : this.beforeStepHookSteps) {
            Result result = before.run(bus, language, scenario, skipSteps);
            skipNextStep |= !result.is(Result.Type.PASSED);
            results.add(result);
        }
        results.add(super.run(bus, language, scenario, skipNextStep));
        for (HookTestStep after : this.afterStepHookSteps) {
            results.add(after.run(bus, language, scenario, skipSteps));
        }
        return Collections.max(results, Result.SEVERITY);
    }

    List<HookTestStep> getBeforeStepHookSteps() {
        return this.beforeStepHookSteps;
    }

    List<HookTestStep> getAfterStepHookSteps() {
        return this.afterStepHookSteps;
    }

    @Override
    public PickleStep getPickleStep() {
        return this.step;
    }

    @Override
    public String getStepLocation() {
        return this.uri + ":" + Integer.toString(this.getStepLine());
    }

    @Override
    public int getStepLine() {
        return ((PickleLocation)this.step.getLocations().get(this.step.getLocations().size() - 1)).getLine();
    }

    @Override
    public String getStepText() {
        return this.step.getText();
    }

    @Override
    public List<Argument> getDefinitionArgument() {
        return DefinitionArgument.createArguments(this.definitionMatch.getArguments());
    }

    @Override
    public List<gherkin.pickles.Argument> getStepArgument() {
        return this.step.getArgument();
    }

    @Override
    @Deprecated
    public HookType getHookType() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isHook() {
        return false;
    }

    @Override
    public String getPattern() {
        return this.definitionMatch.getPattern();
    }
}

