/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.entity;

import com.kms.katalon.core.appium.constants.AppiumStringConstants;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.integration.kobiton.entity.KobitonDeviceCapabilities;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openqa.selenium.ScreenOrientation;

public class KobitonDevice {
    private static final String CAPABILITIES_SESSION_DESCRIPTION = "sessionDescription";
    private static final String CAPABILITIES_SESSION_NAME = "sessionName";
    private static final String CAPABILITIES_ACCEPT_SSL_CERTS = "acceptSslCerts";
    private static final String CAPABILITIES_CAPTURE_SREEN_SHOTS = "captureSreenShots";
    private static final String CAPABILITIES_DEVICE_ORIENTATION = "deviceOrientation";
    private static final String CAPABILITIES_PLATFORM_VERSION = "platformVersion";
    private static final String CAPABILITIES_BROWSER_NAME = "browserName";
    private static final String CAPABILITIES_DEVICE_NAME = "deviceName";
    private static final String CAPABILITIES_PLATFORM_NAME = "platformName";
    private static final String BROWSER_CHROME = "chrome";
    private static final String BROWSER_SAFARI = "safari";
    public static final String PLATFORM_NAME_ANDROID = "Android";
    public static final String PLATFORM_NAME_IOS = "iOS";
    private int id;
    private String udid;
    private boolean isBooked;
    private KobitonDeviceCapabilities capabilities;
    private ScreenOrientation orientation = ScreenOrientation.PORTRAIT;
    private boolean captureScreenShots = true;
    private boolean isHidden;
    private boolean isOnline;
    private boolean isFavorite;
    private boolean isCloud;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getUdid() {
        return this.udid;
    }

    public void setUdid(String udid) {
        this.udid = udid;
    }

    public boolean isBooked() {
        return this.isBooked;
    }

    public void setBooked(boolean isBooked) {
        this.isBooked = isBooked;
    }

    public KobitonDeviceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(KobitonDeviceCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public ScreenOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ScreenOrientation orientation) {
        this.orientation = orientation;
    }

    public boolean isCaptureScreenShots() {
        return this.captureScreenShots;
    }

    public void setCaptureScreenShots(boolean captureScreenShots) {
        this.captureScreenShots = captureScreenShots;
    }

    private String getBrowserName() {
        KobitonDeviceCapabilities.Browser[] installedBrowsers = this.capabilities.getInstalledBrowsers();
        if (installedBrowsers == null || installedBrowsers.length == 0) {
            if (this.capabilities.getPlatformName().equals(PLATFORM_NAME_IOS)) {
                return BROWSER_SAFARI;
            }
            if (this.capabilities.getPlatformName().equals(PLATFORM_NAME_ANDROID)) {
                return BROWSER_CHROME;
            }
        }
        return installedBrowsers[0].getName();
    }

    public Map<String, Object> toDesireCapabilitiesMap() {
        HashMap<String, Object> desireCapabilitiesMap = new HashMap<String, Object>();
        desireCapabilitiesMap.put(CAPABILITIES_PLATFORM_NAME, this.capabilities.getPlatformName());
        desireCapabilitiesMap.put(CAPABILITIES_DEVICE_NAME, this.capabilities.getDisplayDeviceName());
        desireCapabilitiesMap.put(CAPABILITIES_BROWSER_NAME, this.getBrowserName());
        desireCapabilitiesMap.put(CAPABILITIES_PLATFORM_VERSION, this.capabilities.getPlatformVersion());
        desireCapabilitiesMap.put(CAPABILITIES_DEVICE_ORIENTATION, this.orientation.value());
        desireCapabilitiesMap.put(CAPABILITIES_CAPTURE_SREEN_SHOTS, true);
        desireCapabilitiesMap.put(CAPABILITIES_ACCEPT_SSL_CERTS, true);
        desireCapabilitiesMap.put(CAPABILITIES_SESSION_NAME, "Automation test session");
        desireCapabilitiesMap.put(CAPABILITIES_SESSION_DESCRIPTION, "");
        return desireCapabilitiesMap;
    }

    public Map<String, Object> getSystemPropertiesMap() {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put(AppiumStringConstants.CONF_EXECUTED_DEVICE_NAME, this.capabilities.getDisplayDeviceName());
        systemProperties.put(AppiumStringConstants.CONF_EXECUTED_DEVICE_OS, this.capabilities.getPlatformName());
        systemProperties.put(AppiumStringConstants.CONF_EXECUTED_DEVICE_OS_VERSON, this.capabilities.getPlatformVersion());
        if (this.capabilities.getPlatformName().equals(PLATFORM_NAME_IOS)) {
            systemProperties.put("devicePlatform", MobileDriverType.IOS_DRIVER.getPropertyValue());
        }
        if (this.capabilities.getPlatformName().equals(PLATFORM_NAME_ANDROID)) {
            systemProperties.put("devicePlatform", MobileDriverType.ANDROID_DRIVER.getPropertyValue());
        }
        return systemProperties;
    }

    public String toString() {
        return "KobitonDevice [id=" + this.id + ", uuid=" + this.udid + ", isBooked=" + this.isBooked + ", isHidden=" + this.isHidden + ", isOnline=" + this.isOnline + ", isFavorite=" + this.isFavorite + ", isCloud=" + this.isCloud + ", capabilities=" + this.capabilities + ", orientation=" + this.orientation + ", captureScreenShots=" + this.captureScreenShots + "]";
    }

    public String getDisplayString() {
        return String.valueOf((String.valueOf(this.getDeviceDisplayName()) + ", version=" + this.capabilities.getPlatformVersion()).trim()) + ", id=" + this.getId();
    }

    private String getDeviceDisplayName() {
        return MessageFormat.format("{0} {1}", StringUtils.defaultString((String)this.capabilities.getBrandName()), this.capabilities.getDisplayDeviceName());
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public void setOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }

    public boolean isFavorite() {
        return this.isFavorite;
    }

    public void setFavorite(boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public boolean isCloud() {
        return this.isCloud;
    }

    public void setCloud(boolean isCloud) {
        this.isCloud = isCloud;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append((Object)this.udid).append(this.isBooked).append((Object)this.orientation).append(this.captureScreenShots).append(this.isHidden).append(this.isOnline).append(this.isFavorite).append(this.isCloud).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KobitonDevice other = (KobitonDevice)obj;
        return new EqualsBuilder().append(this.id, other.id).append((Object)this.udid, (Object)other.udid).append(this.isBooked, other.isBooked).append((Object)this.orientation, (Object)other.orientation).append(this.captureScreenShots, other.captureScreenShots).append(this.isHidden, this.isHidden).append(this.isOnline, other.isOnline).append(this.isFavorite, this.isFavorite).append(this.isCloud, this.isCloud).isEquals();
    }
}

