/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.integration.kobiton.entity.KobitonApiKey;
import com.kms.katalon.integration.kobiton.entity.KobitonApplication;
import com.kms.katalon.integration.kobiton.entity.KobitonApplications;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.entity.KobitonJsonDeserializer;
import com.kms.katalon.integration.kobiton.entity.KobitonLoginInfo;
import com.kms.katalon.integration.kobiton.exceptions.KobitonApiException;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class KobitonApiProvider {
    private static final String HEADER_VALUE_AUTHORIZATION_PREFIX = "Basic ";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_VALUE_CONTENT_TYPE_JSON = "application/json";
    private static final String HEADER_CONTENT_TYPE = "Content-type";
    private static final String LOGIN_PARAM_PW = "password";
    private static final String LOGIN_PARAM_EMAIL_OR_USERNAME = "emailOrUsername";
    private static final String DATE_FORMAT_ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public static HttpClient getHttpClient() throws KobitonApiException {
        try {
            return HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getSystemProxyInformation()).getClientBuilder().build();
        }
        catch (IOException | URISyntaxException | GeneralSecurityException e) {
            throw new KobitonApiException(e.getMessage());
        }
    }

    public static KobitonLoginInfo login(String username, String password) throws URISyntaxException, ClientProtocolException, IOException, KobitonApiException {
        HttpClient httpClient = KobitonApiProvider.getHttpClient();
        HttpPost httpPost = new HttpPost(KobitonApiProvider.getKobitonURI("/v1/users/login"));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(LOGIN_PARAM_EMAIL_OR_USERNAME, (JsonElement)new JsonPrimitive(username));
        jsonObject.add(LOGIN_PARAM_PW, (JsonElement)new JsonPrimitive(password));
        httpPost.setEntity((HttpEntity)new StringEntity(jsonObject.toString()));
        httpPost.setHeader(HEADER_CONTENT_TYPE, HEADER_VALUE_CONTENT_TYPE_JSON);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        KobitonApiProvider.checkForApiError(responseString);
        Gson gson = new GsonBuilder().setDateFormat(DATE_FORMAT_ISO_8601).create();
        return (KobitonLoginInfo)gson.fromJson(responseString, KobitonLoginInfo.class);
    }

    public static boolean testConnection(String username, String apiKey, String serverUrlString) throws KobitonApiException, URISyntaxException, ClientProtocolException, IOException {
        URL serverUrl = new URL(serverUrlString);
        String host = serverUrl.getHost();
        Integer port = serverUrl.getPort();
        String protocol = serverUrl.getProtocol();
        HttpClient httpClient = KobitonApiProvider.getHttpClient();
        HttpGet request = new HttpGet(KobitonApiProvider.getKobitonURI(protocol, host, port, "/v1/apps"));
        KobitonApiProvider.setHeaderForKobitonRequest(KobitonApiProvider.buildToken(username, apiKey), (HttpRequest)request);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
        String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        KobitonApiProvider.checkForApiError(responseString);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new KobitonApiException(responseString);
        }
        List<KobitonApplication> apps = ((KobitonApplications)new Gson().fromJson(responseString, KobitonApplications.class)).getApps();
        return apps != null;
    }

    private static void checkForApiError(String responseString) throws KobitonApiException {
        try {
            KobitonApiException apiException = (KobitonApiException)new Gson().fromJson(responseString, KobitonApiException.class);
            if (apiException.isError()) {
                throw apiException;
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            return;
        }
    }

    private static URI getKobitonURI(String loginPath) throws URISyntaxException, MalformedURLException {
        String kobitonServerUrlString = KobitonPreferencesProvider.getKobitonServerUrl();
        URL kobitonServerUrl = new URL(kobitonServerUrlString);
        return KobitonApiProvider.getKobitonURI(kobitonServerUrl, loginPath);
    }

    private static URI getKobitonURI(URL serverUrl, String loginPath) throws URISyntaxException {
        return new URIBuilder().setScheme(serverUrl.getProtocol()).setHost(serverUrl.getHost()).setPort(serverUrl.getPort()).setPath(loginPath).build();
    }

    private static URI getKobitonURI(String protocol, String host, Integer port, String loginPath) throws URISyntaxException {
        return new URIBuilder().setScheme(protocol).setHost(host).setPort(port.intValue()).setPath(loginPath).build();
    }

    public static List<KobitonApiKey> getApiKeyList(String token) throws URISyntaxException, ClientProtocolException, IOException, KobitonApiException {
        HttpClient httpClient = KobitonApiProvider.getHttpClient();
        HttpGet httpGet = new HttpGet(KobitonApiProvider.getKobitonURI("/v1/users/keys"));
        KobitonApiProvider.setHeaderForKobitonRequest(token, (HttpRequest)httpGet);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        KobitonApiProvider.checkForApiError(responseString);
        return (List)new Gson().fromJson(responseString, new TypeToken<List<KobitonApiKey>>(){}.getType());
    }

    public static List<KobitonDevice> getKobitonFavoriteDevices(String token) throws URISyntaxException, ClientProtocolException, IOException, KobitonApiException {
        HttpClient httpClient = KobitonApiProvider.getHttpClient();
        HttpGet httpGet = new HttpGet(KobitonApiProvider.getKobitonURI("/v1/devices"));
        KobitonApiProvider.setHeaderForKobitonRequest(token, (HttpRequest)httpGet);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        KobitonApiProvider.checkForApiError(responseString);
        Map allDevices = (Map)new GsonBuilder().registerTypeAdapter(KobitonDevice.class, (Object)new KobitonJsonDeserializer()).create().fromJson(responseString, new TypeToken<Map<String, List<KobitonDevice>>>(){}.getType());
        List onlineAndFavouriteDevices = allDevices.getOrDefault("favoriteDevices", Collections.emptyList()).stream().filter(d -> !d.isHidden() && d.isOnline() && d.isFavorite()).collect(Collectors.toList());
        LinkedHashSet<KobitonDevice> filteredDuplicatedDevices = new LinkedHashSet<KobitonDevice>();
        for (KobitonDevice device : onlineAndFavouriteDevices) {
            filteredDuplicatedDevices.add(device);
        }
        return new ArrayList<KobitonDevice>(filteredDuplicatedDevices);
    }

    public static List<KobitonApplication> getKobitionApplications(String token) throws URISyntaxException, ParseException, IOException, KobitonApiException {
        HttpClient httpClient = KobitonApiProvider.getHttpClient();
        HttpGet httpGet = new HttpGet(KobitonApiProvider.getKobitonURI("/v1/apps"));
        KobitonApiProvider.setHeaderForKobitonRequest(token, (HttpRequest)httpGet);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        KobitonApiProvider.checkForApiError(responseString);
        return ((KobitonApplications)new Gson().fromJson(responseString, KobitonApplications.class)).getApps();
    }

    public static String buildToken(String username, String apiKey) {
        return Base64.basicEncode((String)username, (String)apiKey);
    }

    private static void setHeaderForKobitonRequest(String token, HttpRequest httpGet) {
        httpGet.setHeader(HEADER_CONTENT_TYPE, HEADER_VALUE_CONTENT_TYPE_JSON);
        httpGet.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + token);
    }
}

