/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.studioassist.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.studioassist.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.studioassist.handlers.GPTBaseHandler;
import com.kms.katalon.composer.studioassist.util.StudioAssistActionUtil;
import com.kms.katalon.tracking.service.Trackings;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExplainCodeHandler
extends GPTBaseHandler {
    @Override
    public void trackFeatureUsage() {
        Trackings.trackStudioAssistUsage((String)"EXPLAIN_CODE");
        this.currentProfile = UserProfileHelper.getCurrentProfile();
        int numOfExplainCodeUsed = this.currentProfile.getNumberOfTimeExplainCodeUsed();
        int newNumOfExplainCodeUsed = numOfExplainCodeUsed + 1;
        this.currentProfile.setNumberOfTimeExplainCodeUsed(newNumOfExplainCodeUsed);
        UserProfileHelper.saveProfile((UserProfile)this.currentProfile);
    }

    @Override
    protected void showFeedbackDialog() {
        if (this.currentProfile.getNumberOfTimeExplainCodeUsed() == 10) {
            this.openShareFeedbackDialog();
        }
    }

    @Override
    public String getProgressText() {
        return ComposerStudioAssistConstants.EXPLAIN_CODE_JOB_PROGRESS_MSG;
    }

    @Override
    public void insertCodeIntoEditor(String result, IWorkbenchWindow window) {
        UISynchronizeService.asyncExec(() -> {
            if (StringUtils.isNotBlank((CharSequence)result)) {
                int resultOffset = StudioAssistActionUtil.insertCodeIntoEditor("\n" + result, window);
                this.scrollTo(resultOffset);
            }
        });
    }

    @Override
    public String getPrompt() {
        String thePrompt = this.getSelectedText().split("\n").length == 1 ? "    Summarize the code with the rules as follows:\n        - Do not explain the programming language\n        - Start the summarization with a verb in base form. Do not use word in other forms\n        - Summarize the code with one sentence\n        - Your result must have the following format: // <The summarization>\n" : ComposerStudioAssistConstants.EXPLAIN_CODE_PROMPT_FOR_MULTIPLE_LINES;
        return String.valueOf(thePrompt) + "\n" + ComposerStudioAssistConstants.FINAL_WORK;
    }

    private void scrollTo(int insertedCodeOffset) {
        IEditorPart editor = this.window.getActivePage().getActiveEditor();
        if (editor instanceof ITextEditor var3_4) {
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
            ITextSelection selectedText = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            int visibleEndOffset = selectedText.getLength() + selectedText.getOffset();
            if (insertedCodeOffset >= visibleEndOffset) {
                try {
                    int insertedCodeLineNumber = document.getLineOfOffset(insertedCodeOffset) + 1;
                    textEditor.selectAndReveal(document.getLineOffset(insertedCodeLineNumber), 0);
                }
                catch (BadLocationException error) {
                    LoggerSingleton.logError((Throwable)error);
                }
            }
        }
    }
}

