/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.studioassist.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.studioassist.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.studioassist.dialog.StudioAssistFeedbackDialog;
import com.kms.katalon.composer.studioassist.preference.StudioAssistPreferenceStore;
import com.kms.katalon.composer.studioassist.util.StudioAssistActionUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.webserver.WebViewController;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.service.OpenAiService;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class GPTBaseHandler
extends AbstractHandler {
    private OpenAiService openAiService;
    private String model = ComposerStudioAssistConstants.MODEL_DEFAULT;
    private String selectedText;
    protected UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
    protected IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled() {
        ITextSelection iTextSelection;
        void textEditor;
        ISelection selection;
        void var3_2;
        ITextEditor iTextEditor;
        IEditorPart editor = this.window.getActivePage().getActiveEditor();
        IEditorPart iEditorPart = editor;
        if (iEditorPart instanceof ITextEditor && (iTextEditor = (ITextEditor)iEditorPart) == (ITextEditor)var3_2 && ( instanceOfPatternExpressionValue = (selection = textEditor.getSelectionProvider().getSelection())) instanceof ITextSelection && (iTextSelection = (ITextSelection) instanceOfPatternExpressionValue) == (ITextSelection) instanceOfPatternExpressionValue) {
            void textSelection;
            return textSelection.getText().length() != 0;
        }
        return false;
    }

    public Object execute(ExecutionEvent event) {
        this.trackFeatureUsage();
        String apiKey = this.getStoredApiKey(this.window);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            this.showFeedbackDialog();
            return null;
        }
        this.setSelectedText(StudioAssistActionUtil.getSelectedTexts(this.window));
        try {
            this.perform(this.window);
        }
        catch (InterruptedException | InvocationTargetException error) {
            LoggerSingleton.logError((Throwable)error);
            this.handleStudioAssistError(this.window, error);
        }
        this.showFeedbackDialog();
        return null;
    }

    protected void setSelectedText(String aText) {
        this.selectedText = aText;
    }

    protected String getSelectedText() {
        return StringUtils.defaultString((String)this.selectedText);
    }

    private String getStoredApiKey(IWorkbenchWindow window) {
        String apiKey = null;
        try {
            apiKey = StudioAssistActionUtil.getStoredApiKey(window);
        }
        catch (Exception error) {
            LoggerSingleton.logError((Throwable)error);
        }
        if (!StringUtils.isNotEmpty((CharSequence)apiKey)) {
            UISynchronizeService.asyncExec(() -> {
                int returnedCode = MessageDialog.open((int)1, (Shell)window.getShell(), (String)ComposerStudioAssistConstants.ERROR, (String)ComposerStudioAssistConstants.MISSING_OPENAI_SECRET_KEY_MSG, (int)0, (String[])new String[]{ComposerStudioAssistConstants.OPEN_SETTINGS, ComposerStudioAssistConstants.CLOSE});
                if (returnedCode == 0) {
                    EventBrokerSingleton.getInstance().getEventBroker().post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.studioassist.preference.studioassist");
                }
            });
            return null;
        }
        this.openAiService = new OpenAiService(apiKey, ComposerStudioAssistConstants.DEFAULT_TIMEOUT);
        return apiKey;
    }

    public void trackFeatureUsage() {
        LogUtil.logInfo((String)ComposerStudioAssistConstants.BASE_FEATURE_TRACKING_MSG);
    }

    public String getProgressText() {
        return "";
    }

    public void perform(final IWorkbenchWindow window) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(GPTBaseHandler.this.getProgressText(), 4);
                        String result = GPTBaseHandler.this.requestChatCompletionResult(GPTBaseHandler.this.getSelectedText(), window, monitor);
                        monitor.worked(2);
                        Thread.sleep(800L);
                        GPTBaseHandler.this.insertCodeIntoEditor(result, window);
                        monitor.worked(1);
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception, exception.getMessage());
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    public void insertCodeIntoEditor(String result, IWorkbenchWindow window) {
        UISynchronizeService.asyncExec(() -> StudioAssistActionUtil.insertCodeIntoEditor(result, window));
    }

    public String requestChatCompletionResult(String selectedText, IWorkbenchWindow window, IProgressMonitor monitor) throws Exception {
        int maxToken = StudioAssistPreferenceStore.getMaxToken() == 0 ? 2000 : StudioAssistPreferenceStore.getMaxToken();
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        ChatMessage systemMessage = new ChatMessage(ChatMessageRole.SYSTEM.value(), this.getPrompt());
        messages.add(systemMessage);
        ChatMessage userMessage = new ChatMessage(ChatMessageRole.USER.value(), selectedText);
        messages.add(userMessage);
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().model(this.model).messages(messages).n(Integer.valueOf(1)).maxTokens(Integer.valueOf(maxToken)).logitBias(new HashMap()).temperature(Double.valueOf(0.0)).build();
        monitor.worked(1);
        Thread.sleep(100L);
        String result = ((ChatCompletionChoice)this.openAiService.createChatCompletion(chatCompletionRequest).getChoices().iterator().next()).getMessage().getContent();
        this.openAiService.shutdownExecutor();
        return result;
    }

    public void handleStudioAssistError(IWorkbenchWindow window, Exception error) {
        if (StringUtils.contains((CharSequence)error.getMessage(), (CharSequence)"401")) {
            UISynchronizeService.asyncExec(() -> MessageDialog.openError((Shell)window.getShell(), (String)(String.valueOf(ComposerStudioAssistConstants.ERROR) + " 401 - Forbidden"), (String)(String.valueOf(error.getMessage()) + ComposerStudioAssistConstants.ERROR_MESSAGE_FOR_401_CODE)));
        } else {
            UISynchronizeService.asyncExec(() -> MessageDialog.openError((Shell)window.getShell(), (String)ComposerStudioAssistConstants.ERROR, (String)error.getMessage()));
        }
    }

    public String getPrompt() {
        return "";
    }

    protected void showFeedbackDialog() {
    }

    public void openShareFeedbackDialog() {
        String url = WebViewController.getInstance().getPage("ShareYourFeedback.html");
        Display display = Display.getDefault();
        Shell aShell = new Shell(display, 1264);
        aShell.setLocation(display.getBounds().width, display.getBounds().height);
        StudioAssistFeedbackDialog dialog = new StudioAssistFeedbackDialog(aShell, url);
        dialog.open();
    }
}

