/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.studioassist.preference;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.studioassist.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.studioassist.preference.StudioAssistPreferenceStore;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.util.CryptoUtil;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class StudioAssistPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String oldApiKey;
    private static final int MAX_TOKENS = 4096;
    private static final String OPENAI_KEY_ERROR = "OpenAI API key is required";

    public StudioAssistPreferencePage() {
        super(1);
        ScopedPreferenceStore preferenceStore = StudioAssistPreferenceStore.getPreferenceStore();
        this.setPreferenceStore((IPreferenceStore)preferenceStore);
        preferenceStore.setDefault(ComposerStudioAssistConstants.OPENAI_MAX_TOKEN, 2000);
        this.oldApiKey = this.getPreferenceStore().getString(ComposerStudioAssistConstants.OPENAI_API_KEY);
    }

    public void init(IWorkbench workbench) {
    }

    public void createFieldEditors() {
        StringFieldEditor apiKeyField = new StringFieldEditor(ComposerStudioAssistConstants.OPENAI_API_KEY, ComposerStudioAssistConstants.API_KEY_LABEL, this.getFieldEditorParent());
        apiKeyField.getTextControl(this.getFieldEditorParent()).setEchoChar('*');
        apiKeyField.setEmptyStringAllowed(true);
        apiKeyField.setErrorMessage(OPENAI_KEY_ERROR);
        this.addField((FieldEditor)apiKeyField);
        IntegerFieldEditor maxTokenField = new IntegerFieldEditor(ComposerStudioAssistConstants.OPENAI_MAX_TOKEN, ComposerStudioAssistConstants.MAX_TOKEN_LABEL, this.getFieldEditorParent());
        maxTokenField.getTextControl(this.getFieldEditorParent()).setTextLimit(4);
        maxTokenField.setValidRange(1, 4096);
        this.addField((FieldEditor)maxTokenField);
        Label lblModel = new Label(this.getFieldEditorParent(), 0);
        lblModel.setText(ComposerStudioAssistConstants.MODEL_LABEL);
        Label lblModelName = new Label(this.getFieldEditorParent(), 0);
        lblModelName.setText(ComposerStudioAssistConstants.MODEL_DEFAULT);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        String apiKey = this.getPreferenceStore().getString(ComposerStudioAssistConstants.OPENAI_API_KEY);
        int maxToken = this.getPreferenceStore().getInt(ComposerStudioAssistConstants.OPENAI_MAX_TOKEN);
        if (!apiKey.isEmpty() && !apiKey.equals(this.oldApiKey)) {
            try {
                CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)apiKey);
                apiKey = CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
                this.getPreferenceStore().setValue(ComposerStudioAssistConstants.OPENAI_API_KEY, apiKey);
            }
            catch (Exception error) {
                LoggerSingleton.logError((Throwable)error);
                return false;
            }
        }
        this.getPreferenceStore().setValue(ComposerStudioAssistConstants.OPENAI_MAX_TOKEN, maxToken);
        return result;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getPreferenceStore().setValue(ComposerStudioAssistConstants.OPENAI_API_KEY, "");
        this.getPreferenceStore().setValue(ComposerStudioAssistConstants.OPENAI_MAX_TOKEN, 2000);
    }
}

