/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.studioassist.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.studioassist.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.studioassist.preference.StudioAssistPreferenceStore;
import com.kms.katalon.composer.studioassist.util.StudioAssistException;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class StudioAssistActionUtil {
    public static Boolean isValidModel(String model, String apiKey) throws Exception {
        Request request;
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Response response = client.newCall(request = new Request.Builder().url(ComposerStudioAssistConstants.CHAT_COMPLETION_ENDPOINT.concat(model)).method(ComposerStudioAssistConstants.GET, null).addHeader(ComposerStudioAssistConstants.AUTHORIZATION, ComposerStudioAssistConstants.BEARER.concat(apiKey)).build()).execute();
        if (response.code() == 200) {
            return true;
        }
        throw new StudioAssistException(StudioAssistException.StudioAssistExceptionType.INVALID_MODEL);
    }

    public static boolean isJavaDocComment(String input) {
        return input.matches("(?s)/\\*\\*.*\\n\\s*\\*\\s*(.+\\n)*.*\\*/.*");
    }

    private String getModel(IWorkbenchWindow window, ProgressMonitorDialog pmd, String apiKey, IEclipsePreferences preferences) throws IOException, Exception {
        String model = preferences.get(ComposerStudioAssistConstants.OPENAI_MODEL, null);
        if (StringUtils.isBlank((CharSequence)model)) {
            model = ComposerStudioAssistConstants.MODEL_DEFAULT;
        } else if (!StudioAssistActionUtil.isValidModel(model, apiKey).booleanValue()) {
            pmd.close();
            MessageDialog.openError((Shell)window.getShell(), (String)ComposerStudioAssistConstants.ERROR, (String)"Model ".concat(model).concat(" is not valid.\nPlease change your model name or restore default."));
        }
        return model;
    }

    private String getMaxToken(IEclipsePreferences preferences) {
        String maxToken = preferences.get(ComposerStudioAssistConstants.OPENAI_MAX_TOKEN, null);
        if (maxToken == null || maxToken.isEmpty() || maxToken == "") {
            maxToken = Integer.toString(2000);
        }
        return maxToken;
    }

    public static String getStoredApiKey(IWorkbenchWindow window) throws Exception {
        return CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)StudioAssistPreferenceStore.getAPIKey()));
    }

    public static int insertCodeIntoEditor(String code, IWorkbenchWindow window) {
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (editor instanceof ITextEditor var3_4) {
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
            ISelection selection = textEditor.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection var8_9) {
                int offset = textSelection.getOffset();
                int length = textSelection.getLength();
                try {
                    document.replace(offset + length, 0, code);
                    return offset + length;
                }
                catch (BadLocationException error) {
                    LoggerSingleton.logError((Throwable)error);
                }
            }
        }
        return -1;
    }

    public static String getSelectedTexts(IWorkbenchWindow window) {
        IEditorPart editor = window.getActivePage().getActiveEditor();
        StringBuilder sb = new StringBuilder();
        if (editor instanceof ITextEditor var3_4) {
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
            ISelection selection = textEditor.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection var8_9) {
                int startLine = textSelection.getStartLine();
                int endLine = textSelection.getEndLine();
                int i = startLine;
                while (i <= endLine) {
                    try {
                        String lineText = String.valueOf(document.get(document.getLineOffset(i), document.getLineLength(i)).trim()) + "\n";
                        if (lineText != null && !lineText.isEmpty() && lineText != "") {
                            sb.append(lineText);
                        }
                    }
                    catch (BadLocationException error) {
                        LoggerSingleton.logError((Throwable)error);
                    }
                    ++i;
                }
            }
        }
        return sb.toString();
    }
}

