/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.handler;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.global.part.ExecutionProfilePartUI;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenGlobalVariableHandler {
    @Inject
    MApplication application;
    @Inject
    EModelService modelService;
    @Inject
    IEclipseContext context;
    @Inject
    EPartService partService;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && ExecutionProfileEntity.class.isInstance(object)) {
                    OpenGlobalVariableHandler.this.execute((ExecutionProfileEntity)object);
                }
            }
        });
    }

    protected void execute(ExecutionProfileEntity profileEntity) {
        try {
            MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (stack != null) {
                String globalVariablePartId = this.getPartId(profileEntity);
                MPart globalVariablePart = (MPart)this.modelService.find(globalVariablePartId, (MUIElement)this.application);
                if (globalVariablePart == null) {
                    ExecutionProfilePartUI.create(profileEntity, stack);
                } else {
                    stack.setSelectedElement((MUIElement)globalVariablePart);
                }
            }
        }
        catch (IOException | CoreException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        Trackings.trackOpenObject((String)"profile");
    }

    public String getPartId(ExecutionProfileEntity executionProfile) {
        return EntityPartUtil.getExecutionProfilePartId((String)executionProfile.getId());
    }
}

