/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.part;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.global.part.ExecutionProfilePartUI;
import com.kms.katalon.composer.global.part.GlobalVariableEditorPart;
import com.kms.katalon.composer.global.part.GlobalVariablePart;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.osgi.service.event.Event;

public class ExecutionProfileCompositePart
implements IComposerPartEvent,
SavableCompositePart {
    @Inject
    protected MApplication application;
    @Inject
    protected EModelService modelService;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    protected IStylingEngine styleEngine;
    @Inject
    protected EPartService partService;
    @Inject
    private MDirtyable dirty;
    protected MCompositePart compositePart;
    private MPartStack subPartStack;
    protected ExecutionProfileEntity executionProfileEntity;
    protected GlobalVariablePart globalVariablePart;
    protected GlobalVariableEditorPart globalVariableEditorPart;
    protected ExecutionProfilePartUI ui;
    private CTabFolder tabFolder;
    protected Composite parent;
    private boolean invalidSchema;
    private boolean variableTab = true;

    public MDirtyable getDirty() {
        return this.dirty;
    }

    @PostConstruct
    public void init(Composite parent, MCompositePart part) {
        this.compositePart = part;
        this.executionProfileEntity = (ExecutionProfileEntity)part.getObject();
        this.parent = parent;
        this.dirty.setDirty(false);
        new HelpToolBarForMPart((MPart)part, DocumentationMessageConstants.GLOBAL_VARIABLES);
        this.invalidSchema = false;
    }

    public void initComponents(ExecutionProfilePartUI executionProfilePartUi) {
        this.ui = executionProfilePartUi;
        this.initComponent();
    }

    public void initComponent() {
        this.compositePart.setIconURI(ImageManager.getImageURLString((String)"global_variable_16.png"));
        List compositePartChildren = this.compositePart.getChildren();
        if (compositePartChildren.size() == 1 && compositePartChildren.get(0) instanceof MPartStack) {
            this.subPartStack = (MPartStack)compositePartChildren.get(0);
            if (this.subPartStack.getChildren().size() == 2) {
                for (MStackElement stackElement : this.subPartStack.getChildren()) {
                    if (!(stackElement instanceof MPart)) continue;
                    Object partObject = ((MPart)stackElement).getObject();
                    if (partObject instanceof GlobalVariablePart) {
                        this.globalVariablePart = (GlobalVariablePart)partObject;
                        continue;
                    }
                    if (!(partObject instanceof GlobalVariableEditorPart)) continue;
                    this.globalVariableEditorPart = (GlobalVariableEditorPart)((Object)partObject);
                }
            }
            if (this.subPartStack.getWidget() instanceof CTabFolder) {
                this.tabFolder = this.ui.getTabFolder();
                this.tabFolder.setTabPosition(1024);
                this.tabFolder.setBorderVisible(false);
                this.tabFolder.setMaximizeVisible(false);
                this.tabFolder.setMinimizeVisible(false);
                if (this.tabFolder.getItemCount() == 2) {
                    CTabItem globalVariablePartTab = this.ui.getGlobalVariableTab();
                    globalVariablePartTab.setImage(ImageConstants.IMG_16_MANUAL);
                    globalVariablePartTab.setShowClose(false);
                    CTabItem globalVariableEditorPartTab = this.ui.getGlobalVariableEditorTab();
                    globalVariableEditorPartTab.setImage(ImageConstants.IMG_16_SCRIPT);
                    globalVariableEditorPartTab.setShowClose(false);
                }
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (ExecutionProfileCompositePart.this.tabFolder == null) {
                            return;
                        }
                        if (ExecutionProfileCompositePart.this.tabFolder.getSelectionIndex() == 0) {
                            if (ExecutionProfileCompositePart.this.dirty.isDirty()) {
                                ExecutionProfileCompositePart.this.updateVariableManualView();
                            }
                            ExecutionProfileCompositePart.this.variableTab = true;
                            return;
                        }
                        if (ExecutionProfileCompositePart.this.tabFolder.getSelectionIndex() == 1) {
                            if (ExecutionProfileCompositePart.this.dirty.isDirty()) {
                                ExecutionProfileCompositePart.this.updateVariableScriptView();
                            }
                            ExecutionProfileCompositePart.this.variableTab = false;
                            return;
                        }
                    }
                });
                this.tabFolder.layout();
            }
            this.updateVariableScriptView();
        }
    }

    private void updateVariableScriptView() {
        try {
            this.globalVariableEditorPart.setScriptContentFrom(this.globalVariablePart.getExecutionProfileEntity());
            this.setInvalidScheme(false);
        }
        catch (Exception exception) {
            this.setInvalidScheme(true);
        }
    }

    private void updateVariableManualView() {
        try {
            this.globalVariablePart.setVariablesFromScriptContent(this.globalVariableEditorPart.getScriptContent());
            this.setInvalidScheme(false);
        }
        catch (Exception exception) {
            this.setInvalidScheme(true);
        }
    }

    private void setInvalidScheme(boolean value) {
        this.invalidSchema = value;
    }

    @Persist
    public void save() {
        try {
            if (this.variableTab) {
                this.updateVariableScriptView();
            } else {
                this.updateVariableManualView();
                this.updateVariableScriptView();
            }
            this.globalVariablePart.updateVariableReferences();
            GlobalVariableController.getInstance().updateExecutionProfile(this.executionProfileEntity);
            this.setDirty(false);
            this.eventBroker.post("EXPLORER/REFRESH", null);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void dispose() {
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.compositePart);
    }

    public void setDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
    }

    public String getEntityId() {
        return this.executionProfileEntity.getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.executionProfileEntity == null) {
            return;
        }
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !part.getElementId().equals(this.compositePart.getElementId())) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.executionProfileEntity);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof ExecutionProfileEntity)) {
            return;
        }
        ExecutionProfileEntity updatedEntity = (ExecutionProfileEntity)eventData;
        if (updatedEntity.getIdForDisplay().equals(this.getEntityId())) {
            return;
        }
        ExecutionProfileEntity oldExecutionProfileEntity = this.executionProfileEntity;
        this.executionProfileEntity = updatedEntity;
        this.executionProfileEntity.setProject(oldExecutionProfileEntity.getProject());
        this.executionProfileEntity.setParentFolder(oldExecutionProfileEntity.getParentFolder());
        this.eventBroker.post("PROPERTIES/ENTITY", (Object)this.executionProfileEntity);
        this.setDirty(true);
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
        this.dispose();
    }

    public boolean isDirty() {
        return this.dirty.isDirty();
    }

    public List<MPart> getChildParts() {
        return Arrays.asList(this.ui.getGlobalVariablePart(), this.ui.getGlobalVariableEditorPart());
    }
}

