/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.testcloud.provider;

import com.kms.katalon.composer.components.dialogs.AbstractDialogCellEditor;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.webui.execution.testsuite.RemoteExecutionDriverEntry;
import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.integration.testcloud.entity.TestCloudEntity;
import com.kms.katalon.integration.testcloud.entity.TestCloudEnvironment;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileDevice;
import coms.kms.katalon.composer.integration.testcloud.dialogs.TestCloudConfigureWithTestSuiteCollectionDialog;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TestCloudExecutionDriverEntry
extends RemoteExecutionDriverEntry {
    protected TestCloudExecutionDriverEntry(String groupName) {
        super((DriverType)WebUIDriverType.TESTCLOUD_DRIVER, groupName, ImageManager.getImageURLString((String)"testcloud_icon_16x16.png"));
    }

    public CellEditor getRunConfigurationDataCellEditor(Composite parent) {
        return new AbstractDialogCellEditor(parent){

            protected void updateContents(Object value) {
                super.updateContents((Object)TestCloudExecutionDriverEntry.this.getTestCloudEntityName(value));
            }

            protected Object openDialogBox(Control cellEditorWindow) {
                TestCloudConfigureWithTestSuiteCollectionDialog dialog = new TestCloudConfigureWithTestSuiteCollectionDialog(this.getParentShell(), TestCloudExecutionDriverEntry.this.getTestCloudEntity((Map)this.getValue()));
                if (dialog.open() != 0) {
                    return null;
                }
                HashMap<String, String> runConfigurationData = new HashMap<String, String>();
                if (dialog.getSelectedEntity() instanceof TestCloudEnvironment) {
                    runConfigurationData.put("testCloudEnvironment", JsonUtil.toJson((Object)dialog.getSelectedEntity()));
                } else {
                    runConfigurationData.put("testCloudMobile", JsonUtil.toJson((Object)dialog.getSelectedEntity()));
                }
                return runConfigurationData;
            }
        };
    }

    public Map<String, String> changeRunConfigurationData(Shell shell, Map<String, String> runConfigurationData) {
        TestCloudConfigureWithTestSuiteCollectionDialog dialog = new TestCloudConfigureWithTestSuiteCollectionDialog(shell, this.getTestCloudEntity(runConfigurationData));
        if (dialog.open() != 0) {
            return runConfigurationData;
        }
        HashMap<String, String> updatedData = new HashMap<String, String>();
        if (dialog.getSelectedEntity() instanceof TestCloudEnvironment) {
            updatedData.put("testCloudEnvironment", JsonUtil.toJson((Object)dialog.getSelectedEntity()));
        } else {
            updatedData.put("testCloudMobile", JsonUtil.toJson((Object)dialog.getSelectedEntity()));
        }
        return updatedData;
    }

    public String displayRunConfigurationData(Map<String, String> runConfigurationData) {
        return this.getTestCloudEntityName(runConfigurationData);
    }

    private String getTestCloudEntityName(Object value) {
        TestCloudEntity entity = this.getTestCloudEntity((Map)value);
        return entity != null ? entity.getDisplayName() : "";
    }

    private TestCloudEntity getTestCloudEntity(Map<String, String> runConfigurationData) {
        if (runConfigurationData == null) {
            return null;
        }
        String environmentJson = runConfigurationData.get("testCloudEnvironment");
        String mobileJson = runConfigurationData.get("testCloudMobile");
        if (!StringUtils.isEmpty((String)environmentJson)) {
            return (TestCloudEntity)JsonUtil.fromJson((String)environmentJson, TestCloudEnvironment.class);
        }
        if (!StringUtils.isEmpty((String)mobileJson)) {
            return (TestCloudEntity)JsonUtil.fromJson((String)mobileJson, TestCloudMobileDevice.class);
        }
        return null;
    }

    public boolean requiresExtraConfiguration() {
        return true;
    }
}

