/*
 * Decompiled with CFR 0.152.
 */
package coms.kms.katalon.composer.integration.testcloud.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.integration.testcloud.constants.IntegrationTestCloudComposerMessageConstants;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.integration.testcloud.entity.TestCloudBrowser;
import com.kms.katalon.integration.testcloud.entity.TestCloudBrowserVersion;
import com.kms.katalon.integration.testcloud.entity.TestCloudEntity;
import com.kms.katalon.integration.testcloud.entity.TestCloudEnvironment;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileDevice;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileOS;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileOSVersion;
import com.kms.katalon.integration.testcloud.entity.TestCloudOS;
import com.kms.katalon.integration.testcloud.exception.TestCloudAPIException;
import com.kms.katalon.integration.testcloud.model.APITestCloudEnvironment;
import com.kms.katalon.integration.testcloud.model.APITestCloudMobileDevice;
import com.kms.katalon.integration.testcloud.model.APITestCloudTunnel;
import com.kms.katalon.integration.testcloud.provider.TestCloudConfigurationProvider;
import com.kms.katalon.integration.testcloud.provider.TestCloudService;
import com.kms.katalon.integration.testcloud.util.TestCloudModelParser;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import coms.kms.katalon.composer.integration.testcloud.dialogs.SetupTunnelInstructionDialog;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class TestCloudConfigurationDialog
extends Dialog {
    private int latestReloadTunnelRequestId = 0;
    public static final int CONTAINER_MARGIN = 15;
    public static final int BTN_WIDTH = 95;
    public static final int CBB_WIDTH = 30;
    public static final int DIA_WIDTH = SystemUtils.IS_OS_WINDOWS ? 600 : 800;
    public static final int DEFAULT_HORIZONTAL_INDENT = 10;
    public static final int BUTTON_BAR_VERTICAL_INDENT = 20;
    public static final int BUTTON_BAR_MARGIN_BOTTOM = 10;
    public static final int DIALOG_MARGIN_WIDTH = 15;
    public static final int DIALOG_MARGIN_HEIGHT = 20;
    public static final int BUTTON_HORIZONTAL_INDENT = 7;
    private static final String TESTCLOUD_DEVICE_OPTION = "platform.testcloud.deviceOS";
    private static final String TESTCLOUD_USING_TUNNEL_OPTION = "platform.testcloud.usingTunnel";
    private static final String TESTCLOUD_OS_NAME_OPTION = "platform.testcloud.os";
    private static final String TESTCLOUD_BROWSER_NAME_OPTION = "platform.testcloud.browsername";
    private static final String TESTCLOUD_BROWSER_VERSION_OPTION = "platform.testcloud.browserversion";
    private static final String TESTCLOUD_MOBILE_OS_NAME_OPTION = "platform.testcloud.mobile.os";
    private static final String TESTCLOUD_MOBILE_OS_VERSION_OPTION = "platform.testcloud.mobile.osVersion";
    private static final String TESTCLOUD_MOBILE_DEVICE_NAME_OPTION = "platform.testcloud.mobile.deviceName";
    private ScopedPreferenceStore preferenceStore = null;
    private Combo cbbOs;
    private Combo cbbBrowser;
    private Combo cbbBrowserVersion;
    private Combo cbbMobileOs;
    private Combo cbbMobileOsVersion;
    private Combo cbbMobileDeviceName;
    private Button radioDesktop;
    private Button radioMobile;
    private Button executeWithTunnelForPrivateDomainTesting;
    private Link lblTunnelStatus;
    private Button btnRefresh;
    private Button btnCancel;
    protected Button btnRun;
    private List<TestCloudOS> environmentList = new ArrayList<TestCloudOS>();
    private List<TestCloudMobileOS> mobileDeviceList = new ArrayList<TestCloudMobileOS>();
    private TestCloudEntity selectedTestCloudEntity;
    private String trialMessage;

    public TestCloudConfigurationDialog(Shell parentShell) {
        super(parentShell);
    }

    public TestCloudConfigurationDialog(Shell parentShell, TestCloudEntity environment) {
        super(parentShell);
        this.selectedTestCloudEntity = environment;
    }

    public int open() {
        try {
            this.fetchData();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable cause = invocationTargetException.getCause();
            if (cause instanceof TestCloudAPIException) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)cause, (String)IntegrationTestCloudComposerMessageConstants.TITLE_ERR_FETCH_TESTCLOUD_ENVIRONMENTS, (String)IntegrationTestCloudComposerMessageConstants.MSG_ERR_FETCH_TESTCLOUD_ENVIRONMENTS);
                this.close();
            }
            LoggerSingleton.logError((String)Arrays.toString(cause.getStackTrace()));
            return 1;
        }
        catch (InterruptedException interruptedException) {
            LogUtil.logError((Throwable)interruptedException);
            return 1;
        }
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(IntegrationTestCloudComposerMessageConstants.DIA_TESTCLOUD_CONFIGURATION_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).autoWidth(DIA_WIDTH).fill().margin(20, 15).build();
        Composite content = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)4).fill().build();
        this.radioDesktop = (Button)ComponentBuilder.radio((Composite)content).text("Desktop Browser").build();
        this.cbbOs = (Combo)ComponentBuilder.comboBox((Composite)content, (int)8).horizontalIndent(10).fillHorizontal().autoWidth(90).build();
        this.cbbBrowser = (Combo)ComponentBuilder.comboBox((Composite)content, (int)8).autoWidth(90).fillHorizontal().horizontalIndent(7).build();
        this.cbbBrowserVersion = (Combo)ComponentBuilder.comboBox((Composite)content, (int)8).autoWidth(120).fillHorizontal().horizontalIndent(7).build();
        this.enableDesktopCbb(true);
        ComponentBuilder.emptyCell((Composite)content).verticalIndent(2).colSpan(4).build();
        this.radioMobile = (Button)ComponentBuilder.radio((Composite)content).text("Mobile Browser").build();
        this.cbbMobileOs = (Combo)ComponentBuilder.comboBox((Composite)content, (int)8).horizontalIndent(10).autoWidth(90).fillHorizontal().build();
        this.cbbMobileOsVersion = (Combo)ComponentBuilder.comboBox((Composite)content, (int)8).autoWidth(90).fillHorizontal().horizontalIndent(7).build();
        this.cbbMobileDeviceName = (Combo)ComponentBuilder.comboBox((Composite)content, (int)8).autoWidth(120).fillHorizontal().horizontalIndent(7).build();
        this.enableMobileCbb(false);
        ComponentBuilder.emptyCell((Composite)content).verticalIndent(2).colSpan(4).build();
        this.executeWithTunnelForPrivateDomainTesting = (Button)ComponentBuilder.checkBox((Composite)content).text(IntegrationTestCloudComposerMessageConstants.DIA_EXECUTE_TUNNEL_LBL_V2).build();
        ComponentBuilder.helpButton((Composite)content, (String)IntegrationTestCloudComposerMessageConstants.DIA_TUNNEL_INFO_LINK).left().build();
        ComponentBuilder.emptyCell((Composite)content).build();
        this.lblTunnelStatus = (Link)ComponentBuilder.link((Composite)content).horizontalIndent(10).fillHorizontal().height(0).colSpan(4).onSelection(event -> {
            SetupTunnelInstructionDialog instructionDialog = new SetupTunnelInstructionDialog(this.getShell());
            instructionDialog.open();
        }).build();
        Composite btnBarComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)3).right().verticalIndent(20).build();
        this.btnRefresh = (Button)ComponentBuilder.button((Composite)btnBarComposite).text(IntegrationTestCloudComposerMessageConstants.DIA_REFRESH_BTN).autoWidth(95).hide().build();
        this.btnCancel = (Button)ComponentBuilder.button((Composite)btnBarComposite).text(IntegrationTestCloudComposerMessageConstants.DIA_CANCEL_BTN).autoWidth(95).build();
        this.btnRun = (Button)ComponentBuilder.button((Composite)btnBarComposite).autoWidth(95).build();
        this.setTextForRunButton();
        ComponentBuilder.separator((Composite)container).colSpan(4).verticalIndent(10).build();
        Composite statusLine = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).colSpan(4).fillHorizontal().build();
        ComponentBuilder.label((Composite)statusLine).text("Notes: ").top().bold().build();
        ComponentBuilder.link((Composite)statusLine).text(this.trialMessage).fillHorizontal().build();
        this.setInput();
        this.registerControlListeners();
        return container;
    }

    protected void setTextForRunButton() {
        this.btnRun.setText(IntegrationTestCloudComposerMessageConstants.DIA_RUN_BTN);
    }

    protected Control createButtonBar(Composite parent) {
        this.getShell().setDefaultButton(this.btnRun);
        return this.buttonBar;
    }

    private void setTunnelProgressMessage(String message) {
        this.setTunnelProgressMessage(message, false);
    }

    private void setTunnelErrorMessage(String message) {
        this.setTunnelProgressMessage(message, true);
    }

    private void setTunnelProgressMessage(String message, boolean isError) {
        UISynchronizeService.syncExec(() -> {
            if (isError) {
                ComponentUtil.showError((Control)this.lblTunnelStatus, (String)message, (boolean)true);
            } else {
                ComponentUtil.showSuccess((Control)this.lblTunnelStatus, (String)message, (boolean)true);
            }
        });
    }

    protected void trackOnConfiguredSuccessfully() {
        Trackings.trackClickExecuteTestSuiteWithTestCloud();
    }

    public void enableDesktopCbb(boolean isEnable) {
        this.radioDesktop.setSelection(isEnable);
        this.cbbOs.setEnabled(isEnable);
        this.cbbBrowser.setEnabled(isEnable);
        this.cbbBrowserVersion.setEnabled(isEnable);
    }

    public void enableMobileCbb(boolean isEnable) {
        this.radioMobile.setSelection(isEnable);
        this.cbbMobileOs.setEnabled(isEnable);
        this.cbbMobileOsVersion.setEnabled(isEnable);
        this.cbbMobileDeviceName.setEnabled(isEnable);
    }

    private void registerControlListeners() {
        this.radioDesktop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.radioDesktop.setSelection(true);
                TestCloudConfigurationDialog.this.radioMobile.setSelection(false);
                TestCloudConfigurationDialog.this.enableDesktopCbb(true);
                TestCloudConfigurationDialog.this.enableMobileCbb(false);
            }
        });
        this.radioMobile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.radioDesktop.setSelection(false);
                TestCloudConfigurationDialog.this.radioMobile.setSelection(true);
                TestCloudConfigurationDialog.this.enableDesktopCbb(false);
                TestCloudConfigurationDialog.this.enableMobileCbb(true);
            }
        });
        this.btnRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.selectedTestCloudEntity = TestCloudConfigurationDialog.this.radioDesktop.getSelection() ? ((TestCloudBrowserVersion)((TestCloudBrowser)TestCloudConfigurationDialog.this.environmentList.get(TestCloudConfigurationDialog.this.cbbOs.getSelectionIndex()).getBrowsers().get(TestCloudConfigurationDialog.this.cbbBrowser.getSelectionIndex())).getVersions().get(TestCloudConfigurationDialog.this.cbbBrowserVersion.getSelectionIndex())).getEnvironment() : (TestCloudEntity)((TestCloudMobileOSVersion)TestCloudConfigurationDialog.this.mobileDeviceList.get(TestCloudConfigurationDialog.this.cbbMobileOs.getSelectionIndex()).getOsVersion().get(TestCloudConfigurationDialog.this.cbbMobileOsVersion.getSelectionIndex())).getDeviceList().get(TestCloudConfigurationDialog.this.cbbMobileDeviceName.getSelectionIndex());
                TestCloudConfigurationDialog.this.selectedTestCloudEntity.setUsingTunnel(TestCloudConfigurationDialog.this.executeWithTunnelForPrivateDomainTesting.getSelection());
                try {
                    TestCloudConfigurationDialog.this.selectedTestCloudEntity.setTimeout(TestCloudConfigurationProvider.getInstance().getOSTimeout(TestCloudConfigurationDialog.this.selectedTestCloudEntity.getOs()));
                }
                catch (TestCloudAPIException exception) {
                    LoggerSingleton.logError((Throwable)exception);
                }
                TestCloudConfigurationDialog.this.saveUserInputTestCloudOptions();
                TestCloudConfigurationDialog.this.trackOnConfiguredSuccessfully();
                TestCloudConfigurationDialog.this.okPressed();
            }
        });
        this.executeWithTunnelForPrivateDomainTesting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.reloadTunnelStatus();
            }
        });
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.reloadTunnelStatus();
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.cancelPressed();
            }
        });
        this.cbbOs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudOS selectedOS = TestCloudConfigurationDialog.this.environmentList.get(TestCloudConfigurationDialog.this.cbbOs.getSelectionIndex());
                TestCloudConfigurationDialog.this.loadDataForCbbBrowser(selectedOS.getBrowsers());
            }
        });
        this.cbbBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudBrowser selectedBrowser = (TestCloudBrowser)TestCloudConfigurationDialog.this.environmentList.get(TestCloudConfigurationDialog.this.cbbOs.getSelectionIndex()).getBrowsers().get(TestCloudConfigurationDialog.this.cbbBrowser.getSelectionIndex());
                TestCloudConfigurationDialog.this.loadDataForCbbBrowserVersion(selectedBrowser.getVersions());
            }
        });
        this.cbbMobileOs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileOS selectedOS = TestCloudConfigurationDialog.this.mobileDeviceList.get(TestCloudConfigurationDialog.this.cbbMobileOs.getSelectionIndex());
                TestCloudConfigurationDialog.this.loadDataForCbbMobileOsVersion(selectedOS.getOsVersion());
            }
        });
        this.cbbMobileOsVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileOSVersion selectedOSVersion = (TestCloudMobileOSVersion)TestCloudConfigurationDialog.this.mobileDeviceList.get(TestCloudConfigurationDialog.this.cbbMobileOs.getSelectionIndex()).getOsVersion().get(TestCloudConfigurationDialog.this.cbbMobileOsVersion.getSelectionIndex());
                TestCloudConfigurationDialog.this.loadDataForCbbMobileDevice(selectedOSVersion.getDeviceList());
            }
        });
        this.cbbMobileDeviceName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.cbbMobileDeviceName.setToolTipText(TestCloudConfigurationDialog.this.cbbMobileDeviceName.getText());
            }
        });
    }

    private void reloadTunnelStatus() {
        int requestId;
        boolean useTunnel = this.executeWithTunnelForPrivateDomainTesting.getSelection();
        ComponentUtil.setVisible((Control)this.btnRefresh, (boolean)useTunnel);
        this.latestReloadTunnelRequestId = requestId = this.latestReloadTunnelRequestId + 1;
        if (useTunnel) {
            this.setTunnelProgressMessage(IntegrationTestCloudComposerMessageConstants.MSG_LOADING);
            Executors.newFixedThreadPool(1).submit(() -> {
                try {
                    Long orgId = AnalyticsSettingStore.getStore().getOrganization().getId();
                    APITestCloudTunnel[] tunnels = TestCloudService.getInstance().getTunnels(orgId);
                    if (tunnels.length <= 0) {
                        throw new NullPointerException(IntegrationTestCloudComposerMessageConstants.MSG_ERR_NO_TUNNEL);
                    }
                    if (requestId < this.latestReloadTunnelRequestId) {
                        return;
                    }
                    this.setTunnelProgressMessage(IntegrationTestCloudComposerMessageConstants.MSG_STATUS_AVAILABLE);
                }
                catch (TestCloudAPIException | NullPointerException fetchTunnelException) {
                    LoggerSingleton.logError((Throwable)fetchTunnelException);
                    UISynchronizeService.syncExec(() -> this.setTunnelErrorMessage(MessageFormat.format(IntegrationTestCloudComposerMessageConstants.MSG_TUNNEL_NOT_AVAILABLE, ComponentUtil.wrapLink((String)IntegrationTestCloudComposerMessageConstants.LNK_TUNNEL_SETUP_HELPER, (String)""))));
                }
            });
        } else {
            this.setTunnelProgressMessage("");
        }
    }

    private void selectOS(int index) {
        this.cbbOs.select(index);
        TestCloudOS selectedOS = this.environmentList.get(index);
        this.loadDataForCbbBrowser(selectedOS.getBrowsers());
    }

    private void selectBrowserName(int index) {
        this.cbbBrowser.select(index);
        TestCloudBrowser selectedBrowser = (TestCloudBrowser)this.environmentList.get(this.cbbOs.getSelectionIndex()).getBrowsers().get(this.cbbBrowser.getSelectionIndex());
        this.loadDataForCbbBrowserVersion(selectedBrowser.getVersions());
    }

    private void selectBrowserVersion(int index) {
        this.cbbBrowserVersion.select(index);
    }

    private void selectMobileOS(int index) {
        this.cbbMobileOs.select(index);
        TestCloudMobileOS selectedOS = this.mobileDeviceList.get(index);
        this.loadDataForCbbMobileOsVersion(selectedOS.getOsVersion());
    }

    private void selectMobileOSVersion(int index) {
        this.cbbMobileOsVersion.select(index);
        this.loadDataForCbbMobileDevice(((TestCloudMobileOSVersion)this.mobileDeviceList.get(this.cbbMobileOs.getSelectionIndex()).getOsVersion().get(this.cbbMobileOsVersion.getSelectionIndex())).getDeviceList());
    }

    private void selectMobileDevice(int index) {
        this.cbbMobileDeviceName.select(index);
        this.cbbMobileDeviceName.setToolTipText(this.cbbMobileDeviceName.getText());
    }

    protected boolean isResizable() {
        return true;
    }

    private void setInput() {
        if (this.environmentList.isEmpty()) {
            this.selectedTestCloudEntity = null;
            return;
        }
        this.loadDataForCbbOs(this.environmentList);
        this.loadDataForCbbMobileOs(this.mobileDeviceList);
        if (this.selectedTestCloudEntity == null) {
            this.loadLastWorkingTestCloudOptions();
            return;
        }
        this.loadSelectedTestCloudOptions(this.selectedTestCloudEntity);
    }

    private void fetchData() throws InvocationTargetException, InterruptedException {
        this.environmentList.clear();
        this.mobileDeviceList.clear();
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(IntegrationTestCloudComposerMessageConstants.JOB_LOADING_ENVIRONMENTS, 3);
                        APITestCloudEnvironment[] rawData = TestCloudService.getInstance().getEnvironments();
                        APITestCloudMobileDevice[] mobileData = TestCloudService.getInstance().getMobileDevices();
                        monitor.worked(1);
                        TestCloudConfigurationDialog.this.environmentList.addAll(TestCloudModelParser.parseArrayAPITestCloudEnvironmentToTestCloudOSList((APITestCloudEnvironment[])rawData));
                        TestCloudConfigurationDialog.this.mobileDeviceList.addAll(TestCloudModelParser.parseArrayAPITestCloudMobileDevideToTestMobileDeviceList((APITestCloudMobileDevice[])mobileData));
                        monitor.worked(1);
                        monitor.setTaskName(IntegrationTestCloudComposerMessageConstants.JOB_LOADING_TRIAL_INFORMATION);
                        TestCloudConfigurationDialog.this.trialMessage = TestCloudConfigurationProvider.getInstance().getGATrialMessage();
                        monitor.worked(1);
                    }
                    catch (TestCloudAPIException exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private void loadDataForCbbOs(List<TestCloudOS> oses) {
        String[] osList = new String[oses.size()];
        int i = 0;
        while (i < oses.size()) {
            osList[i] = oses.get(i).getOsDisplayName();
            ++i;
        }
        this.cbbOs.setItems(osList);
        this.cbbOs.select(0);
        this.loadDataForCbbBrowser(oses.get(0).getBrowsers());
    }

    private void loadDataForCbbBrowser(List<TestCloudBrowser> browsers) {
        String[] osList = new String[browsers.size()];
        int i = 0;
        while (i < browsers.size()) {
            osList[i] = browsers.get(i).getBrowserDisplayName();
            ++i;
        }
        this.cbbBrowser.setItems(osList);
        this.cbbBrowser.select(0);
        this.loadDataForCbbBrowserVersion(browsers.get(0).getVersions());
    }

    private void loadDataForCbbBrowserVersion(List<TestCloudBrowserVersion> versions) {
        String[] osList = new String[versions.size()];
        int i = 0;
        while (i < versions.size()) {
            osList[i] = versions.get(i).getBrowserVersion();
            ++i;
        }
        this.cbbBrowserVersion.setItems(osList);
        this.cbbBrowserVersion.select(0);
    }

    private void loadDataForCbbMobileOs(List<TestCloudMobileOS> mobileOs) {
        String[] osList = new String[mobileOs.size()];
        int i = 0;
        while (i < mobileOs.size()) {
            osList[i] = mobileOs.get(i).getOs();
            ++i;
        }
        this.cbbMobileOs.setItems(osList);
        this.cbbMobileOs.select(0);
        this.loadDataForCbbMobileOsVersion(mobileOs.get(0).getOsVersion());
    }

    private void loadDataForCbbMobileOsVersion(List<TestCloudMobileOSVersion> osVersions) {
        String[] osVersionList = new String[osVersions.size()];
        int i = 0;
        while (i < osVersions.size()) {
            osVersionList[i] = osVersions.get(i).getOsVersion();
            ++i;
        }
        this.cbbMobileOsVersion.setItems(osVersionList);
        this.cbbMobileOsVersion.select(0);
        this.loadDataForCbbMobileDevice(osVersions.get(0).getDeviceList());
    }

    private void loadDataForCbbMobileDevice(List<TestCloudMobileDevice> listDevice) {
        String[] deviceName = new String[listDevice.size()];
        int i = 0;
        while (i < listDevice.size()) {
            deviceName[i] = listDevice.get(i).getName();
            ++i;
        }
        this.cbbMobileDeviceName.setItems(deviceName);
        this.cbbMobileDeviceName.select(0);
        this.cbbMobileDeviceName.setToolTipText(this.cbbMobileDeviceName.getText());
    }

    public TestCloudEntity getSelectedEntity() {
        return this.selectedTestCloudEntity;
    }

    public ScopedPreferenceStore getPreferenceStore() {
        if (this.preferenceStore != null) {
            return this.preferenceStore;
        }
        return PreferenceStoreManager.getPreferenceStore(TestCloudConfigurationDialog.class);
    }

    private void loadSelectedTestCloudOptions(TestCloudEntity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof TestCloudEnvironment) {
            this.enableDesktopCbb(true);
            this.enableMobileCbb(false);
            this.loadSelectedTestCloudEnvironmentOptions((TestCloudEnvironment)entity);
        } else {
            this.enableDesktopCbb(false);
            this.enableMobileCbb(true);
            this.loadSelectedTestCloudMobileOptions((TestCloudMobileDevice)entity);
        }
        this.executeWithTunnelForPrivateDomainTesting.setSelection(entity.isUsingTunnel());
        if (entity.isUsingTunnel()) {
            this.reloadTunnelStatus();
        }
        ComponentUtil.setVisible((Control)this.btnRefresh, (boolean)entity.isUsingTunnel());
    }

    private void loadSelectedTestCloudEnvironmentOptions(TestCloudEnvironment environment) {
        String[] osList = this.cbbOs.getItems();
        boolean foundOS = false;
        int i = 0;
        while (i < osList.length) {
            if (osList[i].equalsIgnoreCase(environment.getOs())) {
                this.selectOS(i);
                foundOS = true;
                break;
            }
            ++i;
        }
        if (!foundOS) {
            this.selectOS(0);
        }
        String[] browserNameList = this.cbbBrowser.getItems();
        boolean foundBrowserName = false;
        int i2 = 0;
        while (i2 < browserNameList.length) {
            if (browserNameList[i2].equalsIgnoreCase(environment.getBrowserName())) {
                this.selectBrowserName(i2);
                foundBrowserName = true;
                break;
            }
            ++i2;
        }
        if (!foundBrowserName) {
            this.selectBrowserName(0);
        }
        String[] browserVersionList = this.cbbBrowserVersion.getItems();
        int i3 = 0;
        while (i3 < browserVersionList.length) {
            if (browserVersionList[i3].equalsIgnoreCase(environment.getBrowserVersion())) {
                this.selectBrowserVersion(i3);
                return;
            }
            ++i3;
        }
        this.selectBrowserVersion(0);
    }

    private void loadSelectedTestCloudMobileOptions(TestCloudMobileDevice mobile) {
        String[] mobileOsList = this.cbbMobileOs.getItems();
        boolean foundOS = false;
        int i = 0;
        while (i < mobileOsList.length) {
            if (mobileOsList[i].equalsIgnoreCase(mobile.getOs())) {
                this.selectMobileOS(i);
                foundOS = true;
                break;
            }
            ++i;
        }
        if (!foundOS) {
            this.selectOS(0);
        }
        String[] mobileOsVersionList = this.cbbMobileOsVersion.getItems();
        boolean foundMobileOsVersion = false;
        int i2 = 0;
        while (i2 < mobileOsVersionList.length) {
            if (mobileOsVersionList[i2].equalsIgnoreCase(mobile.getOsVersion())) {
                this.selectMobileOSVersion(i2);
                foundMobileOsVersion = true;
                break;
            }
            ++i2;
        }
        if (!foundMobileOsVersion) {
            this.selectMobileOSVersion(0);
        }
        String[] deviceNameList = this.cbbMobileDeviceName.getItems();
        int i3 = 0;
        while (i3 < deviceNameList.length) {
            if (deviceNameList[i3].equalsIgnoreCase(mobile.getName())) {
                this.selectMobileDevice(i3);
                return;
            }
            ++i3;
        }
        this.selectMobileDevice(0);
    }

    private void loadLastWorkingTestCloudOptions() {
        String testCloudDevice;
        ScopedPreferenceStore prefStore = this.getPreferenceStore();
        boolean isDesktop = true;
        String string = testCloudDevice = prefStore.contains(TESTCLOUD_DEVICE_OPTION) ? prefStore.getString(TESTCLOUD_DEVICE_OPTION) : "";
        if (testCloudDevice.equalsIgnoreCase("mobile")) {
            isDesktop = false;
        }
        this.radioDesktop.setSelection(isDesktop);
        this.enableDesktopCbb(isDesktop);
        this.radioMobile.setSelection(!isDesktop);
        this.enableMobileCbb(!isDesktop);
        int osNameOption = prefStore.contains(TESTCLOUD_OS_NAME_OPTION) ? prefStore.getInt(TESTCLOUD_OS_NAME_OPTION) : 0;
        this.selectOS(osNameOption);
        int browserNameOption = prefStore.contains(TESTCLOUD_BROWSER_NAME_OPTION) ? prefStore.getInt(TESTCLOUD_BROWSER_NAME_OPTION) : 0;
        this.selectBrowserName(browserNameOption);
        int browserVersionOption = prefStore.contains(TESTCLOUD_BROWSER_VERSION_OPTION) ? prefStore.getInt(TESTCLOUD_BROWSER_VERSION_OPTION) : 0;
        this.selectBrowserVersion(browserVersionOption);
        int mobileOsOption = prefStore.contains(TESTCLOUD_MOBILE_OS_NAME_OPTION) ? prefStore.getInt(TESTCLOUD_MOBILE_OS_NAME_OPTION) : 0;
        this.selectMobileOS(mobileOsOption);
        int mobileOsVersion = prefStore.contains(TESTCLOUD_MOBILE_OS_VERSION_OPTION) ? prefStore.getInt(TESTCLOUD_MOBILE_OS_VERSION_OPTION) : 0;
        this.selectMobileOSVersion(mobileOsVersion);
        int mobileDevice = prefStore.contains(TESTCLOUD_MOBILE_DEVICE_NAME_OPTION) ? prefStore.getInt(TESTCLOUD_MOBILE_DEVICE_NAME_OPTION) : 0;
        this.selectMobileDevice(mobileDevice);
        boolean usingTunnelOption = prefStore.contains(TESTCLOUD_USING_TUNNEL_OPTION) ? prefStore.getBoolean(TESTCLOUD_USING_TUNNEL_OPTION) : false;
        this.executeWithTunnelForPrivateDomainTesting.setSelection(usingTunnelOption);
        if (usingTunnelOption) {
            this.reloadTunnelStatus();
        }
        ComponentUtil.setVisible((Control)this.btnRefresh, (boolean)usingTunnelOption);
    }

    private void saveUserInputTestCloudOptions() {
        ScopedPreferenceStore prefStore = this.getPreferenceStore();
        String testCloudDevice = "desktop";
        if (this.radioMobile.getSelection()) {
            testCloudDevice = "mobile";
        }
        prefStore.setValue(TESTCLOUD_DEVICE_OPTION, testCloudDevice);
        prefStore.setValue(TESTCLOUD_USING_TUNNEL_OPTION, this.executeWithTunnelForPrivateDomainTesting.getSelection());
        prefStore.setValue(TESTCLOUD_OS_NAME_OPTION, this.cbbOs.getSelectionIndex());
        prefStore.setValue(TESTCLOUD_BROWSER_NAME_OPTION, this.cbbBrowser.getSelectionIndex());
        prefStore.setValue(TESTCLOUD_BROWSER_VERSION_OPTION, this.cbbBrowserVersion.getSelectionIndex());
        prefStore.setValue(TESTCLOUD_MOBILE_OS_NAME_OPTION, this.cbbMobileOs.getSelectionIndex());
        prefStore.setValue(TESTCLOUD_MOBILE_OS_VERSION_OPTION, this.cbbMobileOsVersion.getSelectionIndex());
        prefStore.setValue(TESTCLOUD_MOBILE_DEVICE_NAME_OPTION, this.cbbMobileDeviceName.getSelectionIndex());
        try {
            prefStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

