/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.device;

import com.google.common.collect.ImmutableList;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.ProxyUtil;
import com.kms.katalon.core.util.internal.ZipUtil;
import com.kms.katalon.execution.mobile.constants.ExecutionMobileMessageConstants;
import com.kms.katalon.execution.mobile.device.AndroidDeviceInfo;
import com.kms.katalon.execution.mobile.device.AndroidSDKDownloadMessage;
import com.kms.katalon.execution.mobile.device.AndroidSDKLocator;
import com.kms.katalon.execution.mobile.exception.AndroidSetupException;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.listener.EventListener;
import com.kms.katalon.util.listener.EventManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.InputSource;

public class AndroidSDKDownloadManager
implements EventManager<String> {
    private static final String REPO_ROOT_URL = "http://dl-ssl.google.com/android/repository/";
    private static final String REPO_LIST = "repository-12.xml";
    private static final String SDK_ELEMENT_PATTERN = "sdk:";
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 10000;
    private AndroidSDKLocator sdkLocator;
    private Map<String, Set<EventListener<String>>> eventListeners = new HashMap<String, Set<EventListener<String>>>();

    public AndroidSDKDownloadManager(AndroidSDKLocator sdkLocator) {
        this.sdkLocator = sdkLocator;
    }

    public Iterable<EventListener<String>> getListeners(String event) {
        return this.eventListeners.get(event);
    }

    public void addListener(EventListener<String> listener, Iterable<String> events) {
        events.forEach(e -> {
            Set<EventListener<String>> listenerOnEvent = this.eventListeners.get(e);
            if (listenerOnEvent == null) {
                listenerOnEvent = new HashSet<EventListener<String>>();
            }
            listenerOnEvent.add(listener);
            this.eventListeners.put((String)e, listenerOnEvent);
        });
    }

    private static String getOS() {
        String osName = StringUtils.deleteWhitespace((String)System.getProperty("os.name")).toLowerCase();
        if (osName.contains("windows")) {
            return "windows";
        }
        if (osName.contains("macos")) {
            return "macosx";
        }
        return "linux";
    }

    private void throwHelperException(String errorMessage, String sdkRepo) throws AndroidSetupException {
        throw new AndroidSetupException(MessageFormat.format(ExecutionMobileMessageConstants.MSG_SDK_COULD_NOT_CONNECT, sdkRepo, errorMessage, AndroidSDKDownloadManager.getOS(), this.sdkLocator.getPlatformToolsFolder(), this.sdkLocator.getBuildToolsFolder()));
    }

    private Proxy getProxy() throws IOException, AndroidSetupException {
        try {
            return ProxyUtil.getProxy((ProxyInformation)ProxyPreferences.getSystemProxyInformation());
        }
        catch (URISyntaxException e) {
            throw new AndroidSetupException(e.getMessage());
        }
    }

    public void downloadAndInstall() throws AndroidSetupException {
        block11: {
            String sdkRepo = "http://dl-ssl.google.com/android/repository/repository-12.xml";
            HttpURLConnection httpConnection = null;
            InputStream is = null;
            try {
                try {
                    URL url = new URL(sdkRepo);
                    this.logAndInvoke(AndroidSDKDownloadMessage.create(MessageFormat.format(ExecutionMobileMessageConstants.MSG_SDK_FETCHING_SDK_INFO, sdkRepo), 0));
                    is = url.openConnection(this.getProxy()).getInputStream();
                    String responseBody = IOUtils.toString((InputStream)is);
                    this.logAndInvoke(AndroidSDKDownloadMessage.create(ExecutionMobileMessageConstants.MSG_SDK_FETCH_COMPLETED, 10));
                    SDKUrlHolder urlHolder = this.parseSDKInfo(responseBody);
                    this.downloadSDK(urlHolder);
                }
                catch (IOException | InterruptedException e) {
                    this.throwHelperException(e.getMessage(), sdkRepo);
                    if (httpConnection != null) {
                        httpConnection.disconnect();
                    }
                    if (is != null) {
                        IOUtils.closeQuietly(is);
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
                if (is != null) {
                    IOUtils.closeQuietly(is);
                }
                throw throwable;
            }
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    private void downloadUsingProxy(Proxy proxy, URL url, File file) throws IOException {
        try (InputStream inputStream = null;){
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
                    int len;
                    URLConnection connection = url.openConnection(proxy);
                    connection.setConnectTimeout(60000);
                    connection.setReadTimeout(10000);
                    inputStream = connection.getInputStream();
                    byte[] buffer = new byte[65536];
                    while ((len = inputStream.read(buffer)) >= 0) {
                        ((OutputStream)outputStream).write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                file.delete();
                throw ex;
            }
        }
    }

    private SDKUrlHolder parseSDKInfo(String xmlContent) throws AndroidSetupException {
        try {
            this.logAndInvoke(AndroidSDKDownloadMessage.create(ExecutionMobileMessageConstants.MSG_SDK_PARSING_SDK_INFO, 0));
            Element rootElement = new SAXReader().read(new InputSource(new StringReader(xmlContent))).getRootElement();
            SDKUrlHolder urlHolder = new SDKUrlHolder();
            Element platfromToolElement = rootElement.element("platform-tool");
            urlHolder.platformToolPack = this.parseArchPack(platfromToolElement);
            ArrayList<SDKArchivePack> buildToolArchLst = new ArrayList<SDKArchivePack>();
            Iterator buildToolElementIterator = rootElement.elementIterator("build-tool");
            while (buildToolElementIterator.hasNext()) {
                Element buildToolElement = (Element)buildToolElementIterator.next();
                buildToolArchLst.add(this.parseArchPack(buildToolElement));
            }
            urlHolder.buildToolPacks = ImmutableList.copyOf(buildToolArchLst);
            this.logAndInvoke(AndroidSDKDownloadMessage.create(ExecutionMobileMessageConstants.MSG_SDK_PARSE_COMPLETED, 10));
            return urlHolder;
        }
        catch (DocumentException e) {
            throw new AndroidSetupException(e.getMessage());
        }
    }

    private SDKArchivePack parseArchPack(Element archPackElement) {
        SDKArchivePack archPack = new SDKArchivePack();
        archPack.name = archPackElement.getName().replaceFirst(SDK_ELEMENT_PATTERN, "");
        Element revElement = archPackElement.element("revision");
        archPack.major = Integer.valueOf(revElement.elementText("major"));
        archPack.minor = Integer.valueOf(revElement.elementText("minor"));
        archPack.micro = Integer.valueOf(revElement.elementText("micro"));
        if (revElement.elementText("preview") != null) {
            archPack.preview = Integer.valueOf(revElement.elementText("preview"));
        }
        ArrayList<SDKArchive> archiveLst = new ArrayList<SDKArchive>();
        Iterator archiveElementIterator = archPackElement.element("archives").elementIterator("archive");
        while (archiveElementIterator.hasNext()) {
            Element archElement = (Element)archiveElementIterator.next();
            SDKArchive archive = new SDKArchive();
            archive.size = Long.valueOf(archElement.elementText("size"));
            archive.url = archElement.elementText("url");
            archive.hostOS = archElement.elementText("host-os");
            Element checksumElement = archElement.element("checksum");
            archive.checksum = checksumElement.getText();
            archive.checksumType = checksumElement.attributeValue("type");
            archiveLst.add(archive);
        }
        archPack.archives = ImmutableList.copyOf(archiveLst);
        return archPack;
    }

    private void logAndInvoke(AndroidSDKDownloadMessage sdkMessage) {
        LogUtil.printOutputLine((String)sdkMessage.getMessage());
        this.invoke("ANDROID_SDK_DOWNLOAD_EVENT", sdkMessage);
    }

    private void downloadAndExtract(String fileName, String url, File downloadFolder, File extractedFolder, int startFragment) throws IOException, AndroidSetupException {
        File downloadedFile = new File(downloadFolder, fileName);
        try {
            this.logAndInvoke(AndroidSDKDownloadMessage.create(MessageFormat.format(ExecutionMobileMessageConstants.MSG_SDK_DOWNLOADING_X_FROM_Y, fileName, url), 0));
            Proxy proxy = this.getProxy();
            if (proxy != null && proxy != Proxy.NO_PROXY && proxy.type() != Proxy.Type.DIRECT) {
                this.downloadUsingProxy(this.getProxy(), new URL(url), downloadedFile);
            } else {
                FileUtils.copyURLToFile((URL)new URL(url), (File)downloadedFile, (int)60000, (int)10000);
            }
            this.logAndInvoke(AndroidSDKDownloadMessage.create(ExecutionMobileMessageConstants.MSG_SDK_DOWNLOAD_COMPLETED, 30));
            this.logAndInvoke(AndroidSDKDownloadMessage.create(MessageFormat.format(ExecutionMobileMessageConstants.MSG_SDK_EXTRACTING_X_TO_Y, fileName, extractedFolder.getAbsolutePath()), 0));
            ZipUtil.extractContent((File)downloadedFile, (File)extractedFolder, (int)startFragment);
            this.logAndInvoke(AndroidSDKDownloadMessage.create(ExecutionMobileMessageConstants.MSG_SDK_EXTRACT_COMPLETED, 10));
        }
        catch (Throwable throwable) {
            if (downloadedFile.exists()) {
                try {
                    FileUtils.forceDelete((File)downloadedFile);
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (downloadedFile.exists()) {
            try {
                FileUtils.forceDelete((File)downloadedFile);
            }
            catch (IOException iOException) {}
        }
    }

    private void downloadSDK(SDKUrlHolder urlHolder) throws IOException, AndroidSetupException, InterruptedException {
        this.logAndInvoke(AndroidSDKDownloadMessage.create(ExecutionMobileMessageConstants.MSG_SDK_DONWLOADING_SDK, 0));
        File downloadFolder = new File(GlobalStringConstants.APP_TEMP_DIR, "zip/android-sdk");
        SDKArchivePack platformToolPack = urlHolder.platformToolPack;
        SDKArchive platformArchive = platformToolPack.getSuitableArchive();
        File platformToolFolder = this.sdkLocator.getPlatformToolsFolder();
        if (!platformToolFolder.exists()) {
            platformToolFolder.mkdirs();
        }
        int ignoredFragement = 1;
        this.downloadAndExtract(platformArchive.url, REPO_ROOT_URL + platformArchive.url, downloadFolder, platformToolFolder, ignoredFragement);
        SDKArchivePack buildToolPack = this.getSuitableBuildToolPack(urlHolder.buildToolPacks);
        SDKArchive buildToolArchive = buildToolPack.getSuitableArchive();
        File buildToolsFolder = this.sdkLocator.getBuildToolsFolder();
        File buildToolRevFolder = new File(buildToolsFolder, buildToolPack.version());
        if (!buildToolRevFolder.exists()) {
            buildToolRevFolder.mkdirs();
        }
        this.downloadAndExtract(buildToolArchive.url, REPO_ROOT_URL + buildToolArchive.url, downloadFolder, buildToolRevFolder, ignoredFragement);
        String sdkToolsUrl = this.getSdkTooksUrl();
        File toolsFolder = this.sdkLocator.getToolsFolder();
        if (!toolsFolder.exists()) {
            toolsFolder.mkdirs();
        }
        this.downloadAndExtract(sdkToolsUrl, REPO_ROOT_URL + sdkToolsUrl, downloadFolder, this.sdkLocator.getToolsFolder(), ignoredFragement);
        AndroidDeviceInfo.makeAllAndroidSDKBinaryExecutable();
        this.logAndInvoke(AndroidSDKDownloadMessage.create(ExecutionMobileMessageConstants.MSG_SDK_DOWNLOAD_AND_INSTALL_SDK_COMPELTED, 0));
    }

    private SDKArchivePack getSuitableBuildToolPack(List<SDKArchivePack> buildToolPacks) {
        for (SDKArchivePack archivePack : buildToolPacks) {
            if (archivePack.preview > 0) continue;
            return archivePack;
        }
        return buildToolPacks.get(0);
    }

    private String getSdkTooksUrl() {
        switch (Platform.getOS()) {
            case "win32": {
                return "sdk-tools-windows-4333796.zip";
            }
            case "macosx": {
                return "sdk-tools-darwin-4333796.zip";
            }
        }
        return "sdk-tools-linux-4333796.zip";
    }

    private class SDKArchive {
        private long size;
        private String checksum;
        private String checksumType;
        private String url;
        private String hostOS;

        private SDKArchive() {
        }
    }

    private class SDKArchivePack {
        String name;
        private int major;
        private int minor;
        private int micro;
        private int preview;
        private List<SDKArchive> archives;

        private SDKArchivePack() {
        }

        private SDKArchive getSuitableArchive() {
            if (this.archives == null) {
                return null;
            }
            String systemOS = AndroidSDKDownloadManager.getOS();
            return this.archives.stream().filter(arch -> systemOS.equals(arch.hostOS)).findFirst().get();
        }

        private String version() {
            return String.format("%d.%d.%d", this.major, this.minor, this.micro);
        }
    }

    private class SDKUrlHolder {
        private SDKArchivePack platformToolPack;
        private List<SDKArchivePack> buildToolPacks;

        private SDKUrlHolder() {
        }
    }
}

