/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.device;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.util.FileUtil;
import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AndroidSDKLocator {
    private File baseDir;

    public AndroidSDKLocator(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getSDKFolder() {
        File sdkFolder;
        String androidHome = GlobalStringConstants.ANDROID_HOME_ENV;
        if (StringUtils.isNotBlank((CharSequence)androidHome) && (sdkFolder = new File(androidHome)).exists()) {
            return sdkFolder;
        }
        return new File(this.baseDir, "android_sdk");
    }

    public File getPlatformToolsFolder() {
        File sdkFolder = this.getSDKFolder();
        File existingPlatformToolsFolder = FileUtil.findFolderByName((String)sdkFolder.getAbsolutePath(), (String)"platform-tools.*");
        return existingPlatformToolsFolder != null ? existingPlatformToolsFolder : new File(sdkFolder, "platform-tools");
    }

    public File getBuildToolsFolder() {
        File sdkFolder = this.getSDKFolder();
        File existingBuildToolsFolder = FileUtil.findFolderByName((String)sdkFolder.getAbsolutePath(), (String)"build-tools.*");
        return existingBuildToolsFolder != null ? existingBuildToolsFolder : new File(sdkFolder, "build-tools");
    }

    public File getBuildToolsRootFolder() {
        File buildToolsFolder = this.getBuildToolsFolder();
        return FileUtil.findFolderByName((String)buildToolsFolder.getAbsolutePath(), (String)".*");
    }

    public File getToolsFolder() {
        File sdkFolder = this.getSDKFolder();
        File existingToolsFolder = FileUtil.findFolderByName((String)sdkFolder.getAbsolutePath(), (String)"tools.*");
        return existingToolsFolder != null ? existingToolsFolder : new File(sdkFolder, "tools");
    }

    public boolean checkSDKExists() {
        File sdkFolder = this.getSDKFolder();
        if (!sdkFolder.exists() || !sdkFolder.isDirectory()) {
            return false;
        }
        File platformToolsFolder = this.getPlatformToolsFolder();
        if (!platformToolsFolder.exists() || !platformToolsFolder.isDirectory() || ArrayUtils.isEmpty((Object[])platformToolsFolder.listFiles())) {
            return false;
        }
        File buildToolsFolder = this.getBuildToolsFolder();
        return buildToolsFolder.exists() && buildToolsFolder.isDirectory() && !ArrayUtils.isEmpty((Object[])buildToolsFolder.listFiles());
    }
}

