/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.util;

import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.execution.mobile.device.IosDeviceInfo;
import com.kms.katalon.execution.mobile.identity.IosIdentityInfo;
import com.kms.katalon.logging.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;

public class SystemCertificationUtil {
    static final String GET_CERTIFICATE_COMMAND = "security find-certificate -p -c \"%s\"";

    public static Certificate getCertificate(String name) throws IOException, InterruptedException, CertificateException {
        Map<String, String> envs = IosDeviceInfo.getIosAdditionalEnvironmentVariables();
        List rawCertificates = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])SystemCertificationUtil.generateCommand(String.format(GET_CERTIFICATE_COMMAND, name)), envs, (boolean)true);
        List<Certificate> certificates = SystemCertificationUtil.readCertificates(rawCertificates);
        return certificates != null && certificates.size() > 0 ? certificates.get(0) : null;
    }

    public static List<Certificate> readCertificates(List<String> certificateLines) throws CertificateException, IOException {
        String rawCertificates = certificateLines.stream().collect(Collectors.joining("\n"));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(rawCertificates.getBytes());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        while (((InputStream)inputStream).available() > 0) {
            try {
                Certificate cert = certificateFactory.generateCertificate(inputStream);
                certificates.add(cert);
            }
            catch (CertificateException error) {
                LogUtil.logError((Throwable)error);
            }
        }
        return certificates;
    }

    public static IosIdentityInfo getTeamInfoFromCertificate(Certificate cert) {
        Matcher commonNameMatcher;
        X500Principal subject = ((X509Certificate)cert).getSubjectX500Principal();
        String subjectString = subject.getName("RFC2253");
        String id = null;
        String name = null;
        Matcher idMatcher = Pattern.compile("OU=(\\w+),").matcher(subjectString);
        if (idMatcher.find()) {
            id = idMatcher.group(1);
        }
        if ((commonNameMatcher = Pattern.compile("CN=(.+?),").matcher(subjectString)).find()) {
            name = commonNameMatcher.group(1);
        }
        if (id == null || name == null) {
            return null;
        }
        IosIdentityInfo team = new IosIdentityInfo(name, id, "");
        return team;
    }

    public static IosIdentityInfo getTeamInfoByCertificateName(String name, String fingerprint) throws CertificateException, IOException, InterruptedException {
        Certificate cert = SystemCertificationUtil.getCertificate(name);
        if (cert == null) {
            return null;
        }
        return SystemCertificationUtil.getTeamInfoFromCertificate(cert);
    }

    private static String[] generateCommand(String command) {
        return new String[]{"/bin/sh", "-c", command};
    }

    public static List<X509Certificate> parseDeveloperCertificates(String plistContent) throws CertificateException, IOException, InterruptedException {
        List<String> rawCertificates = SystemCertificationUtil.parseRawDeveloperCertificates(plistContent);
        return rawCertificates.stream().map(rawCert -> {
            try {
                return SystemCertificationUtil.decodeCertificate(rawCert);
            }
            catch (CertificateException certificateException) {
                return null;
            }
        }).collect(Collectors.toList());
    }

    private static List<String> parseRawDeveloperCertificates(String plistContent) {
        ArrayList<String> developerCertificates = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<key>DeveloperCertificates</key>\\s*<array>(.*?)</array>", 32);
        Matcher matcher = pattern.matcher(plistContent);
        while (matcher.find()) {
            String provisionedDeviceKey = matcher.group(1);
            pattern = Pattern.compile("<data>(.*?)</data>", 32);
            matcher = pattern.matcher(provisionedDeviceKey);
            while (matcher.find()) {
                developerCertificates.add(matcher.group(1));
            }
        }
        return developerCertificates;
    }

    private static X509Certificate decodeCertificate(String base64String) throws CertificateException {
        byte[] derCertificate = Base64.getDecoder().decode(base64String);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream stream = new ByteArrayInputStream(derCertificate);
        return (X509Certificate)certificateFactory.generateCertificate(stream);
    }

    public static String getFingerPrint(X509Certificate certificate) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] encoded = certificate.getEncoded();
        byte[] sha1Fingerprint = digest.digest(encoded);
        String fingerprintHex = SystemCertificationUtil.toHexString(sha1Fingerprint).toUpperCase();
        return fingerprintHex;
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X", b));
            ++n2;
        }
        return sb.toString();
    }
}

