/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath;

import com.katalon.platform.api.extension.ToolItemWithMenuDescription;
import com.katalon.platform.api.model.Entity;
import com.katalon.platform.api.model.ProjectEntity;
import com.katalon.platform.api.service.ApplicationManager;
import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.controller.AutoHealingController;
import com.katalon.plugin.smart_xpath.logger.LoggerSingleton;
import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.io.IOException;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SmartXPathToolItemWithMenuDescription
implements ToolItemWithMenuDescription {
    private Menu newMenu;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();

    public Menu getMenu(Control parent) {
        this.newMenu = new Menu(parent);
        this.evaluateAndAddMenuItem(this.newMenu);
        return null;
    }

    public void defaultEventHandler() {
        if (this.newMenu != null) {
            this.evaluateAndAddMenuItem(this.newMenu);
            this.newMenu.setVisible(true);
        }
    }

    private void evaluateAndAddMenuItem(Menu newMenu) {
        MenuItem[] menuItemArray = newMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
        ProjectEntity currentProject = ApplicationManager.getInstance().getProjectManager().getCurrentProject();
        if (currentProject != null) {
            AutoHealingController.createXPathFilesIfNecessary((Entity)currentProject);
            WebUiExecutionSettingStore webUIExecutionSettingStore = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
            if (this.canUseSelfHealing() && webUIExecutionSettingStore.getSelfHealingEnabled(this.canUseSelfHealing())) {
                this.addDisableSelfHealingMenuItem(newMenu, true);
            } else {
                this.addEnableSelfHealingMenuItem(newMenu, true);
            }
            this.addGoToSelfHealingSettingsMenuItem(newMenu, true);
            this.addOpenSelfHealingInsightsMenuItem(newMenu, true);
        }
    }

    private MenuItem addEnableSelfHealingMenuItem(Menu parentMenu, boolean enable) {
        MenuItem selfHealingEnable = new MenuItem(parentMenu, 8);
        selfHealingEnable.setEnabled(enable);
        selfHealingEnable.setText(SmartXPathMessageConstants.LBL_ENABLE_SELF_HEALING);
        selfHealingEnable.setToolTipText(SmartXPathMessageConstants.LBL_ENABLE_SELF_HEALING);
        selfHealingEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SmartXPathToolItemWithMenuDescription.this.canUseSelfHealing()) {
                    try {
                        WebUiExecutionSettingStore preferenceStore = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
                        preferenceStore.setEnableSelfHealing(true);
                    }
                    catch (IOException e1) {
                        LoggerSingleton.logError(e1);
                    }
                } else {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.SELF_HEALING);
                }
            }
        });
        return selfHealingEnable;
    }

    private MenuItem addDisableSelfHealingMenuItem(Menu parentMenu, boolean enable) {
        MenuItem selfHealingDisable = new MenuItem(parentMenu, 8);
        selfHealingDisable.setEnabled(enable);
        selfHealingDisable.setText(SmartXPathMessageConstants.LBL_DISABLE_SELF_HEALING);
        selfHealingDisable.setToolTipText(SmartXPathMessageConstants.LBL_DISABLE_SELF_HEALING);
        selfHealingDisable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SmartXPathToolItemWithMenuDescription.this.canUseSelfHealing()) {
                    try {
                        WebUiExecutionSettingStore preferenceStore = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
                        preferenceStore.setEnableSelfHealing(false);
                    }
                    catch (IOException e1) {
                        LoggerSingleton.logError(e1);
                    }
                } else {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.SELF_HEALING);
                }
            }
        });
        return selfHealingDisable;
    }

    private MenuItem addGoToSelfHealingSettingsMenuItem(Menu parentMenu, boolean enable) {
        MenuItem selfHealingSettingsMenuItem = new MenuItem(parentMenu, 8);
        selfHealingSettingsMenuItem.setEnabled(enable);
        selfHealingSettingsMenuItem.setText(SmartXPathMessageConstants.LBL_SELF_HEALING_SETTINGS);
        selfHealingSettingsMenuItem.setToolTipText(SmartXPathMessageConstants.LBL_SELF_HEALING_SETTINGS);
        selfHealingSettingsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmartXPathToolItemWithMenuDescription.this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)"com.katalon.katalon-studio-smart-xpath.self_healing.webui");
            }
        });
        return selfHealingSettingsMenuItem;
    }

    private MenuItem addOpenSelfHealingInsightsMenuItem(Menu parentMenu, boolean enable) {
        MenuItem selfHealingInsightsMenuItem = new MenuItem(parentMenu, 8);
        selfHealingInsightsMenuItem.setEnabled(enable);
        selfHealingInsightsMenuItem.setText(SmartXPathMessageConstants.LBL_SELF_HEALING_INSIGHTS);
        selfHealingInsightsMenuItem.setToolTipText(SmartXPathMessageConstants.LBL_SELF_HEALING_INSIGHTS);
        selfHealingInsightsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
                MApplication application = ApplicationSingleton.getInstance().getApplication();
                EPartService partService = PartServiceSingleton.getInstance().getPartService();
                List psList = modelService.findElements((MUIElement)application, null, MPerspectiveStack.class, null);
                MPartStack consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)psList.get(0)).getSelectedElement());
                consolePartStack.getTags().remove("Minimized");
                consolePartStack.setVisible(true);
                if (!consolePartStack.isToBeRendered()) {
                    consolePartStack.setToBeRendered(true);
                }
                MPart selfHealingInsightsPart = (MPart)modelService.find("com.kms.katalon.composer.execution.part.selfHealing", (MUIElement)consolePartStack);
                if (!consolePartStack.getChildren().contains(selfHealingInsightsPart)) {
                    partService.createPart("com.kms.katalon.composer.execution.part.selfHealing");
                    consolePartStack.getChildren().add(selfHealingInsightsPart);
                }
                if (!selfHealingInsightsPart.isToBeRendered()) {
                    selfHealingInsightsPart.setToBeRendered(true);
                }
                selfHealingInsightsPart.setVisible(true);
                consolePartStack.setSelectedElement((MUIElement)selfHealingInsightsPart);
                partService.activate(selfHealingInsightsPart, true);
            }
        });
        return selfHealingInsightsMenuItem;
    }

    public String iconUrl() {
        return "platform:/plugin/com.katalon.katalon-studio-smart-xpath/icons/self-healing_32x24.png";
    }

    public String name() {
        return SmartXPathMessageConstants.LBL_SELF_HEALING;
    }

    public String toolItemId() {
        return "com.katalon.plugin.smart_xpath.smartXpathToolItemWithDescription";
    }

    private boolean canUseSelfHealing() {
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        return featureService.canUse(KSEFeature.SELF_HEALING);
    }
}

