/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings;

import com.katalon.plugin.smart_xpath.logger.LoggerSingleton;
import com.katalon.plugin.smart_xpath.settings.AbstractSettingPage;
import com.katalon.plugin.smart_xpath.settings.composites.AttributesSelectionComposite;
import com.katalon.plugin.smart_xpath.settings.composites.DefaultWebLocatorSelectionComposite;
import com.katalon.plugin.smart_xpath.settings.composites.XPathsSelectionComposite;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelfHealingTestDesignSettingPage
extends AbstractSettingPage {
    private final Map<String, SelectorMethod> defaultLocatorOptions = new LinkedHashMap<String, SelectorMethod>(){
        {
            this.put("XPath", SelectorMethod.XPATH);
            this.put("Attributes", SelectorMethod.BASIC);
        }
    };
    private DefaultWebLocatorSelectionComposite defaultWebLocatorComposite;
    private XPathsSelectionComposite XPathComposite;
    private AttributesSelectionComposite attributesComposite;

    @Override
    protected void createSettingsArea(Composite containter) {
        this.createDefaultLocatorSelectionArea(this.container);
        this.createLocatorPriorityTabs(this.container);
    }

    private Composite createDefaultLocatorSelectionArea(Composite parent) {
        if (this.defaultWebLocatorComposite == null) {
            this.defaultWebLocatorComposite = new DefaultWebLocatorSelectionComposite(parent, 0);
            this.defaultWebLocatorComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingTestDesignSettingPage.this.handleInputChanged((Control)SelfHealingTestDesignSettingPage.this.defaultWebLocatorComposite, null);
                }
            });
        }
        return this.defaultWebLocatorComposite;
    }

    private Composite createLocatorPriorityTabs(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, -1, true, false));
        this.defaultLocatorOptions.forEach((label, selectorMethod) -> {
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setText(label);
            Control tabContent = this.getTabContentBySelectorMethod((SelectorMethod)selectorMethod, (Composite)tabFolder);
            tabItem.setControl(tabContent);
        });
        tabFolder.setSelection(0);
        return tabFolder;
    }

    private Control getTabContentBySelectorMethod(SelectorMethod selectorMethod, Composite parent) {
        switch (selectorMethod) {
            case XPATH: {
                return this.createXPathComposite(parent);
            }
            case BASIC: {
                return this.createAttributesComposite(parent);
            }
        }
        return null;
    }

    private Composite createXPathComposite(Composite parent) {
        if (this.XPathComposite == null) {
            this.XPathComposite = new XPathsSelectionComposite(parent, 0);
            this.XPathComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingTestDesignSettingPage.this.handleInputChanged((Control)SelfHealingTestDesignSettingPage.this.XPathComposite, null);
                }
            });
        }
        return this.XPathComposite;
    }

    private Control createAttributesComposite(Composite parent) {
        if (this.attributesComposite == null) {
            this.attributesComposite = new AttributesSelectionComposite(parent, 0);
            this.attributesComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingTestDesignSettingPage.this.handleInputChanged((Control)SelfHealingTestDesignSettingPage.this.attributesComposite, null);
                }
            });
        }
        return this.attributesComposite;
    }

    @Override
    protected void initialize() throws IOException {
        WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
        this.defaultWebLocatorComposite.setInput(store.getCapturedTestObjectSelectorMethod(), store.getSelectorMethodIsSmartLocator());
        this.XPathComposite.setInput(store.getCapturedTestObjectXpathLocators());
        this.attributesComposite.setInput(store.getCapturedTestObjectAttributeLocators());
    }

    @Override
    protected void performDefaults() {
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        if (!featureService.canUse(KSEFeature.SELF_HEALING)) {
            KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.SELF_HEALING);
            return;
        }
        try {
            WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
            store.setDefaultCapturedTestObjectSelectorMethods();
            store.setDefaultCapturedTestObjectXpathLocators();
            store.setDefaultCapturedTestObjectAttributeLocators();
            this.initialize();
        }
        catch (IOException e) {
            LoggerSingleton.logError(e);
        }
        super.performDefaults();
    }

    @Override
    protected boolean saveSettings() {
        try {
            WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
            if (!this.defaultWebLocatorComposite.isUsingSmartLocator()) {
                store.setCapturedTestObjectSelectorMethod(this.defaultWebLocatorComposite.getInput());
                store.setBufferedSelectorMethod(this.defaultWebLocatorComposite.getInput());
            }
            store.setSelectorMethodIsSmartLocator(this.defaultWebLocatorComposite.isUsingSmartLocator());
            store.setCapturedTestObjectXpathLocators(this.XPathComposite.getInput());
            store.setCapturedTestObjectAttributeLocators(this.attributesComposite.getInput());
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return false;
        }
        return true;
    }

    @Override
    protected boolean hasChanged() {
        WebUiExecutionSettingStore store;
        block7: {
            boolean isXPathLocatorsChanged;
            block6: {
                boolean isSelectorMethodChanged;
                if (!this.isValid()) {
                    return false;
                }
                store = WebUiExecutionSettingStore.getStore();
                SelectorMethod originalSelectorMethod = store.getCapturedTestObjectSelectorMethod();
                boolean bl = isSelectorMethodChanged = !this.defaultWebLocatorComposite.compareInput(originalSelectorMethod);
                if (!isSelectorMethodChanged) break block6;
                return true;
            }
            List originalXPathLocatorsPriority = store.getCapturedTestObjectXpathLocators();
            boolean bl = isXPathLocatorsChanged = !this.XPathComposite.compareInput(originalXPathLocatorsPriority);
            if (!isXPathLocatorsChanged) break block7;
            return true;
        }
        try {
            boolean isSelectedAttributesChanged;
            List originalSelectedAttributes = store.getCapturedTestObjectAttributeLocators();
            boolean bl = isSelectedAttributesChanged = !this.attributesComposite.compareInput(originalSelectedAttributes);
            if (isSelectedAttributesChanged) {
                return true;
            }
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        return false;
    }

    @Override
    public boolean hasDocumentation() {
        return true;
    }

    @Override
    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_WEBLOCATORS;
    }
}

