/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings.composites;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class DefaultWebLocatorSelectionComposite
extends Group {
    private SelectorMethod selectedSelectorMethod = SelectorMethod.XPATH;
    private List<Button> radioSelectorMethods = new ArrayList<Button>();
    private final Map<String, SelectorMethod> defaultLocatorOptions = new LinkedHashMap<String, SelectorMethod>(){
        {
            this.put("XPath", SelectorMethod.XPATH);
            this.put("Attributes", SelectorMethod.BASIC);
            this.put("CSS", SelectorMethod.CSS);
            this.put("Image", SelectorMethod.IMAGE);
            this.put("Smart Locator", SelectorMethod.SMART_LOCATOR);
        }
    };

    public DefaultWebLocatorSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    protected void checkSubclass() {
    }

    private void createContents() {
        this.setLayout((Layout)new GridLayout());
        this.setText(SmartXPathMessageConstants.GRP_DEFAULT_LOCATOR_SELECTION_AREA);
        this.setLayoutData(new GridData(4, 4, false, true, 1, 1));
        Composite defaultWebLocatorComposite = new Composite((Composite)this, 0);
        RowLayout defaultLocatorRowLayout = new RowLayout(256);
        defaultLocatorRowLayout.spacing = 5;
        defaultLocatorRowLayout.marginHeight = 5;
        defaultWebLocatorComposite.setLayout((Layout)defaultLocatorRowLayout);
        this.defaultLocatorOptions.forEach((label, selectorMethod) -> {
            if (selectorMethod == SelectorMethod.SMART_LOCATOR && LicenseUtil.isFreeLicense()) {
                return;
            }
            final Button radioDefaultLocator = new Button(defaultWebLocatorComposite, 16);
            radioDefaultLocator.setText(label);
            radioDefaultLocator.setData(selectorMethod);
            radioDefaultLocator.setSelection(selectorMethod == this.selectedSelectorMethod);
            radioDefaultLocator.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (radioDefaultLocator.getSelection()) {
                        DefaultWebLocatorSelectionComposite.this.handleSelectionChange(event);
                    }
                }
            });
            this.radioSelectorMethods.add(radioDefaultLocator);
        });
    }

    public void setInput(SelectorMethod selectorMethod, boolean isUsingSmartLocator) {
        this.selectedSelectorMethod = LicenseUtil.isFreeLicense() && (isUsingSmartLocator || selectorMethod == SelectorMethod.SMART_LOCATOR) ? SelectorMethod.XPATH : (isUsingSmartLocator ? SelectorMethod.SMART_LOCATOR : selectorMethod);
        this.radioSelectorMethods.forEach(radioSelectorMethod -> radioSelectorMethod.setSelection(radioSelectorMethod.getData() == this.selectedSelectorMethod));
    }

    public SelectorMethod getInput() {
        try {
            if (this.selectedSelectorMethod == SelectorMethod.SMART_LOCATOR) {
                return WebUiExecutionSettingStore.getStore().getCapturedTestObjectSelectorMethod();
            }
            return this.selectedSelectorMethod;
        }
        catch (Exception exception) {
            return SelectorMethod.XPATH;
        }
    }

    public boolean isUsingSmartLocator() {
        return this.selectedSelectorMethod == SelectorMethod.SMART_LOCATOR;
    }

    public boolean compareInput(SelectorMethod selectorMethod) {
        return this.selectedSelectorMethod == selectorMethod;
    }

    private void handleSelectionChange(SelectionEvent selectionEvent) {
        SelectorMethod chosenMethod;
        this.selectedSelectorMethod = chosenMethod = (SelectorMethod)((Button)selectionEvent.getSource()).getData();
        this.dispatchSelectionEvent(selectionEvent);
    }

    private void dispatchSelectionEvent(SelectionEvent selectionEvent) {
        this.notifyListeners(13, null);
        this.notifyListeners(14, null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }
}

