/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings.composites;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.util.collections.Pair;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class PrioritizeSelectionMethodsComposite
extends Composite {
    private static final String GRP_LBL_PRIORITIZE_SELECTION_METHODS_FOR_SELF_HEALING_EXECUTION = SmartXPathMessageConstants.GRP_PRIORITIZE_SELECTION_METHODS_FOR_SELF_HEALING_EXECUTION;
    private static final String BUTTON_MOVE_UP_PRIORITIZE_SELF_HEALING_EXECUTION_ORDER = SmartXPathMessageConstants.BUTTON_MOVE_UP_PRIORITIZE_SELF_HEALING_EXECUTION_ORDER;
    private static final String BUTTON_MOVE_DOWN_PRIORITIZE_SELF_HEALING_EXECUTION_ORDER = SmartXPathMessageConstants.BUTTON_MOVE_DOWN_PRIORITIZE_SELF_HEALING_EXECUTION_ORDER;
    private static final String COLUMN_SELECTION_METHOD = SmartXPathMessageConstants.COLUMN_SELECTION_METHOD;
    private static final String COLUMN_SELECT = SmartXPathMessageConstants.COLUMN_SELECT;
    private TableViewer tvPrioritizeSelectionMethods;
    private Table tPrioritizeSelectionMethods;
    private TableViewerColumn cvPrioritizeSelectionMethodColumn;
    private TableColumn cPrioritizeSelectionMethodColumn;
    private TableViewerColumn cvMethodsSelected;
    private TableColumn cMethodsSelected;
    private Link link;
    private List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder = Collections.emptyList();

    public PrioritizeSelectionMethodsComposite(Composite parent, int style) {
        super(parent, style);
        this.createContents(parent);
    }

    public void setInput(List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder) {
        this.methodsPriorityOrder = methodsPriorityOrder;
        this.tvPrioritizeSelectionMethods.setInput(this.methodsPriorityOrder);
    }

    private void createContents(Composite parent) {
        this.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        GridLayout glSelectionMethodComp = new GridLayout(1, false);
        glSelectionMethodComp.marginHeight = 0;
        glSelectionMethodComp.marginWidth = 0;
        this.setLayout((Layout)glSelectionMethodComp);
        this.createMethodsPriorityOrderComposite();
    }

    private void createMethodsPriorityOrderComposite() {
        Group prioritizeGroup = new Group((Composite)this, 0);
        prioritizeGroup.setLayout((Layout)new GridLayout());
        prioritizeGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        prioritizeGroup.setText(GRP_LBL_PRIORITIZE_SELECTION_METHODS_FOR_SELF_HEALING_EXECUTION);
        this.createPrioritizeOrderToolbar((Composite)prioritizeGroup);
        this.createPrioritizeTable((Composite)prioritizeGroup);
    }

    private void createPrioritizeOrderToolbar(Composite parent) {
        Composite compositeToolbar = new Composite(parent, 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(1, 128, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmUp = new ToolItem(toolBar, 0);
        tltmUp.setText(BUTTON_MOVE_UP_PRIORITIZE_SELF_HEALING_EXECUTION_ORDER);
        tltmUp.setImage(ImageConstants.IMG_16_MOVE_UP);
        tltmUp.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int selectedIndex = PrioritizeSelectionMethodsComposite.this.tPrioritizeSelectionMethods.getSelectionIndex();
                if (selectedIndex > 0 && selectedIndex < PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.size()) {
                    Pair<SelectorMethod, Boolean> method = PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.get(selectedIndex);
                    PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.remove(selectedIndex);
                    PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.add(selectedIndex - 1, method);
                    PrioritizeSelectionMethodsComposite.this.tvPrioritizeSelectionMethods.setSelection((ISelection)new StructuredSelection(method));
                    PrioritizeSelectionMethodsComposite.this.tvPrioritizeSelectionMethods.refresh();
                    PrioritizeSelectionMethodsComposite.this.handleSelectionChange(null);
                }
            }
        });
        ToolItem tltmDown = new ToolItem(toolBar, 0);
        tltmDown.setText(BUTTON_MOVE_DOWN_PRIORITIZE_SELF_HEALING_EXECUTION_ORDER);
        tltmDown.setImage(ImageConstants.IMG_16_MOVE_DOWN);
        tltmDown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int selectedIndex = PrioritizeSelectionMethodsComposite.this.tPrioritizeSelectionMethods.getSelectionIndex();
                if (selectedIndex >= 0 && selectedIndex < PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.size() - 1) {
                    Pair<SelectorMethod, Boolean> method = PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.get(selectedIndex);
                    PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.remove(selectedIndex);
                    PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.add(selectedIndex + 1, method);
                    PrioritizeSelectionMethodsComposite.this.tvPrioritizeSelectionMethods.setSelection((ISelection)new StructuredSelection(method));
                    PrioritizeSelectionMethodsComposite.this.tvPrioritizeSelectionMethods.refresh();
                    PrioritizeSelectionMethodsComposite.this.handleSelectionChange(null);
                }
            }
        });
        Composite compositeNav = new Composite(compositeToolbar, 0);
        RowLayout navLayout = new RowLayout();
        navLayout.marginRight = 10;
        compositeNav.setLayout((Layout)navLayout);
        Label linkImage = new Label(compositeNav, 0);
        linkImage.setImage(ImageConstants.IMG_16_SETTING);
        this.link = new Link(compositeNav, 0);
        this.link.setText(String.format("<a>%s</a>", SmartXPathMessageConstants.SELF_HEALING_NAVIGATE_TO_TEST_DESIGN));
    }

    private void createPrioritizeTable(Composite parent) {
        Composite tableSelectionPriorityOrderComposite = new Composite(parent, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true);
        ldTableComposite.minimumHeight = 70;
        tableSelectionPriorityOrderComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableSelectionPriorityOrderComposite.setLayout((Layout)tableColumnLayout);
        this.tvPrioritizeSelectionMethods = new TableViewer(tableSelectionPriorityOrderComposite, 68354);
        this.tvPrioritizeSelectionMethods.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tvPrioritizeSelectionMethods.addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                StructuredSelection selection = (StructuredSelection)PrioritizeSelectionMethodsComposite.this.tvPrioritizeSelectionMethods.getSelection();
                Pair method = (Pair)selection.getFirstElement();
                event.data = String.valueOf(PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.indexOf(method));
            }
        });
        this.tvPrioritizeSelectionMethods.addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                Pair item = (Pair)((TableItem)event.item).getData();
                int newIndex = PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.indexOf(item);
                String index = (String)event.data;
                if (index != null && newIndex >= 0) {
                    int indexVal = Integer.parseInt(index);
                    Pair<SelectorMethod, Boolean> method = PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.get(indexVal);
                    PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.remove(indexVal);
                    PrioritizeSelectionMethodsComposite.this.methodsPriorityOrder.add(newIndex, method);
                    PrioritizeSelectionMethodsComposite.this.tvPrioritizeSelectionMethods.setSelection((ISelection)new StructuredSelection(method));
                    PrioritizeSelectionMethodsComposite.this.tvPrioritizeSelectionMethods.refresh();
                }
                PrioritizeSelectionMethodsComposite.this.handleSelectionChange((TypedEvent)event);
            }
        });
        this.tPrioritizeSelectionMethods = this.tvPrioritizeSelectionMethods.getTable();
        this.tPrioritizeSelectionMethods.setHeaderVisible(true);
        this.tPrioritizeSelectionMethods.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.tPrioritizeSelectionMethods.getDisplay()));
        this.cvPrioritizeSelectionMethodColumn = new TableViewerColumn(this.tvPrioritizeSelectionMethods, 16384);
        this.cPrioritizeSelectionMethodColumn = this.cvPrioritizeSelectionMethodColumn.getColumn();
        this.cPrioritizeSelectionMethodColumn.setText(COLUMN_SELECTION_METHOD);
        this.cvPrioritizeSelectionMethodColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((SelectorMethod)((Pair)element).getLeft()).getName();
            }
        });
        this.cvMethodsSelected = new TableViewerColumn(this.tvPrioritizeSelectionMethods, 0x1000000);
        this.cMethodsSelected = this.cvMethodsSelected.getColumn();
        this.cMethodsSelected.setText(COLUMN_SELECT);
        this.cvMethodsSelected.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object property = cell.getElement();
                if (!(property instanceof Pair)) {
                    return;
                }
                Boolean isSelected = (Boolean)((Pair)property).getRight();
                ((TableItem)cell.getViewerRow().getItem()).setChecked(isSelected.booleanValue());
                PrioritizeSelectionMethodsComposite.this.tPrioritizeSelectionMethods.redraw();
            }
        });
        this.cvMethodsSelected.setEditingSupport(new EditingSupport(this.cvMethodsSelected.getViewer()){

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor();
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((Pair)element).getRight();
            }

            protected void setValue(Object element, Object value) {
                ((Pair)element).setRight((Object)((Boolean)value));
                PrioritizeSelectionMethodsComposite.this.tvPrioritizeSelectionMethods.update(element, null);
                PrioritizeSelectionMethodsComposite.this.handleSelectionChange(null);
            }
        });
        tableColumnLayout.setColumnData((Widget)this.cPrioritizeSelectionMethodColumn, (ColumnLayoutData)new ColumnWeightData(80, 100));
        tableColumnLayout.setColumnData((Widget)this.cMethodsSelected, (ColumnLayoutData)new ColumnWeightData(20, 100));
        this.tPrioritizeSelectionMethods.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 1) {
                    Pair data = (Pair)((TableItem)event.item).getData();
                    Image tmpImage = PrioritizeSelectionMethodsComposite.this.getCheckboxSymbol((Boolean)data.getRight());
                    int tmpWidth = 0;
                    int tmpHeight = 0;
                    int tmpX = 0;
                    int tmpY = 0;
                    tmpWidth = PrioritizeSelectionMethodsComposite.this.tPrioritizeSelectionMethods.getColumn(event.index).getWidth();
                    tmpHeight = ((TableItem)event.item).getBounds().height;
                    tmpX = tmpImage.getBounds().width;
                    tmpX = tmpWidth / 2 - tmpX / 2;
                    tmpY = tmpImage.getBounds().height;
                    tmpY = tmpHeight / 2 - tmpY / 2;
                    tmpX = tmpX <= 0 ? event.x : (tmpX += event.x);
                    tmpY = tmpY <= 0 ? event.y : (tmpY += event.y);
                    event.gc.drawImage(tmpImage, tmpX, tmpY);
                }
            }
        });
    }

    protected Image getCheckboxSymbol(boolean isChecked) {
        return isChecked ? ImageConstants.IMG_16_CHECKED : ImageConstants.IMG_16_UNCHECKED;
    }

    public List<Pair<SelectorMethod, Boolean>> getInput() {
        return this.methodsPriorityOrder;
    }

    public boolean compareInput(List<Pair<SelectorMethod, Boolean>> methodsPriorityOrderBeforeSetting) {
        return this.methodsPriorityOrder != null && this.methodsPriorityOrder.equals(methodsPriorityOrderBeforeSetting);
    }

    private void handleSelectionChange(TypedEvent selectionEvent) {
        this.notifyListeners(13, null);
        this.notifyListeners(14, null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void addNavigateToWebUITestDesignListener(SelectionListener listener) {
        this.link.addSelectionListener(listener);
    }
}

