/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings.composites;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.logger.LoggerSingleton;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class XPathsSelectionComposite
extends Composite {
    private List<Pair<String, Boolean>> selectedXPaths = Collections.emptyList();
    private TableViewer tvXpath;

    public XPathsSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createXpathTableToolbar(this);
        this.createXPathTable(this);
    }

    private void createXpathTableToolbar(Composite parent) {
        Composite compositeXpathTableToolBar = new Composite(parent, 0);
        compositeXpathTableToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeXpathTableToolBar.setLayout((Layout)new GridLayout(1, false));
        Button resetDefault = new Button(compositeXpathTableToolBar, 64);
        resetDefault.setLayoutData((Object)new GridData(1, 4, false, false));
        resetDefault.setText(StringConstants.RESET_DEFAULT);
        Label lblDragDropXPath = new Label(compositeXpathTableToolBar, 0);
        lblDragDropXPath.setText(SmartXPathMessageConstants.LBL_TIPS_FOR_XPATH_TEST_DESIGN_SETTING);
        resetDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
                    XPathsSelectionComposite.this.setInput(store.getDefaultCapturedObjectXpathLocators());
                    XPathsSelectionComposite.this.handleSelectionChange(null);
                }
                catch (IOException exception) {
                    LoggerSingleton.logError(exception);
                }
            }
        });
    }

    private Control createXPathTable(Composite parent) {
        Composite tableXPathComposite = new Composite(parent, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true);
        ldTableComposite.minimumHeight = 70;
        ldTableComposite.heightHint = 300;
        tableXPathComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableXPathComposite.setLayout((Layout)tableColumnLayout);
        this.tvXpath = new TableViewer(tableXPathComposite, 68354);
        this.tvXpath.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tvXpath.addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                StructuredSelection selection = (StructuredSelection)XPathsSelectionComposite.this.tvXpath.getSelection();
                Pair xpath = (Pair)selection.getFirstElement();
                event.data = String.valueOf(XPathsSelectionComposite.this.selectedXPaths.indexOf(xpath));
            }
        });
        this.tvXpath.addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                Pair item = (Pair)((TableItem)event.item).getData();
                int newIndex = XPathsSelectionComposite.this.selectedXPaths.indexOf(item);
                String index = (String)event.data;
                if (index != null && newIndex >= 0) {
                    int indexVal = Integer.parseInt(index);
                    Pair<String, Boolean> xpath = XPathsSelectionComposite.this.selectedXPaths.get(indexVal);
                    XPathsSelectionComposite.this.selectedXPaths.remove(indexVal);
                    XPathsSelectionComposite.this.selectedXPaths.add(newIndex, xpath);
                    XPathsSelectionComposite.this.tvXpath.setSelection((ISelection)new StructuredSelection(xpath));
                    XPathsSelectionComposite.this.tvXpath.refresh();
                    XPathsSelectionComposite.this.handleSelectionChange((TypedEvent)event);
                }
            }
        });
        Table tXpath = this.tvXpath.getTable();
        tXpath.setHeaderVisible(true);
        tXpath.setLinesVisible(ControlUtils.shouldLineVisble((Display)tXpath.getDisplay()));
        TableViewerColumn cvXpathName = new TableViewerColumn(this.tvXpath, 16384);
        TableColumn cName = cvXpathName.getColumn();
        cName.setText(StringConstants.NAME);
        cvXpathName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)((Pair)element).getLeft();
            }
        });
        tableColumnLayout.setColumnData((Widget)cName, (ColumnLayoutData)new ColumnWeightData(80, false));
        return tableXPathComposite;
    }

    public void setInput(List<Pair<String, Boolean>> input) {
        this.selectedXPaths = input;
        this.tvXpath.setInput(this.selectedXPaths);
    }

    public List<Pair<String, Boolean>> getInput() {
        List emptyXpathItems = this.selectedXPaths.stream().filter(i -> ((String)i.getLeft()).isEmpty()).collect(Collectors.toList());
        this.selectedXPaths.removeAll(emptyXpathItems);
        return this.selectedXPaths;
    }

    public boolean compareInput(List<Pair<String, Boolean>> selectedXPaths) {
        List<Pair<String, Boolean>> _selectedXPaths = this.getInput();
        return _selectedXPaths != null && _selectedXPaths.equals(selectedXPaths);
    }

    private void handleSelectionChange(TypedEvent selectionEvent) {
        this.dispatchSelectionEvent(selectionEvent);
    }

    private void dispatchSelectionEvent(TypedEvent selectionEvent) {
        this.notifyListeners(13, null);
        this.notifyListeners(14, null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }
}

