/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import org.apache.commons.lang3.StringUtils;

public class NameUtil {
    private static final String ELLIPSIS = "...";
    private static final char ASTERISK = '*';

    public static String shortenNameMiddle(String name, int offset, int length) {
        return NameUtil.abbreviateMiddle(name, ELLIPSIS, offset, length);
    }

    public static String shortenNameAtTail(String name, int length) {
        return StringUtils.abbreviate((String)name, (int)length);
    }

    private static String abbreviateMiddle(String str, String middle, int offset, int length) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)middle)) {
            return str;
        }
        if (length >= str.length() || length < middle.length() + 2) {
            return str;
        }
        int targetSting = length - middle.length();
        int endOffset = str.length() - targetSting / 2;
        StringBuilder builder = new StringBuilder(length);
        builder.append(str.substring(0, offset));
        builder.append(middle);
        builder.append(str.substring(endOffset));
        return builder.toString();
    }

    public static String censor(String name, int length) {
        if (name == null) {
            return name;
        }
        if (length == -1) {
            length = name.length();
        }
        StringBuilder builder = new StringBuilder("");
        int i = 0;
        while (i < length) {
            builder.append('*');
            ++i;
        }
        return builder.toString();
    }

    public static String censor(String str, String searchStr, int length) {
        if (str == null || searchStr == null) {
            return str;
        }
        if (length == -1) {
            length = searchStr.length();
        }
        StringBuilder builder = new StringBuilder("");
        int i = 0;
        while (i < length) {
            builder.append('*');
            ++i;
        }
        String asterisks = builder.toString();
        str = str.replace(searchStr, asterisks);
        return str;
    }
}

