/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import com.kms.katalon.util.collections.NameValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.CharArrayBuffer;

public class URLBuilder {
    private static final char QP_SEP_A = '&';
    private static final char QP_SEP_S = ';';
    private static final char NAME_VALUE_SEPARATOR = '=';
    private String path;
    private List<NameValuePair> queryParams;
    private String query;
    private String ref;

    public URLBuilder() {
    }

    public URLBuilder(String string) {
        this.digestURL(string);
    }

    private void digestURL(String string) {
        String url = string;
        int ind = url.indexOf(35);
        this.ref = ind < 0 ? null : url.substring(ind + 1);
        url = ind < 0 ? url : url.substring(0, ind);
        int q = url.lastIndexOf(63);
        if (q != -1) {
            this.query = url.substring(q + 1);
            this.path = url.substring(0, q);
        } else {
            this.path = url;
        }
        if (!StringUtils.isBlank((CharSequence)this.query)) {
            this.queryParams = this.parseQuery(this.query);
        }
    }

    private List<NameValuePair> parseQuery(String query) {
        if (!StringUtils.isBlank((CharSequence)query)) {
            CharArrayBuffer buffer = new CharArrayBuffer(query.length());
            buffer.append(query);
            return this.parse(buffer, '&', ';');
        }
        return this.queryParams;
    }

    private List<NameValuePair> parse(CharArrayBuffer buf, char ... separators) {
        String[] params = buf.toString().split(StringUtils.join((char[])separators, (char)'|'));
        return Arrays.stream(params).map(paramI -> {
            int delimiterOffset = paramI.indexOf(61);
            if (delimiterOffset < 0) {
                return null;
            }
            String name = paramI.substring(0, delimiterOffset);
            String value = paramI.substring(delimiterOffset + 1, paramI.length());
            if (StringUtils.isBlank((CharSequence)name)) {
                return null;
            }
            return new NameValuePair(name, value);
        }).filter(paramI -> paramI != null).collect(Collectors.toList());
    }

    public URLBuilder setParameters(List<NameValuePair> nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        } else {
            this.queryParams.clear();
        }
        this.queryParams.addAll(nvps);
        this.query = null;
        return this;
    }

    public URLBuilder addParameters(List<NameValuePair> nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        this.queryParams.addAll(nvps);
        this.query = null;
        return this;
    }

    public List<NameValuePair> getQueryParams() {
        if (this.queryParams != null) {
            return new ArrayList<NameValuePair>(this.queryParams);
        }
        return new ArrayList<NameValuePair>();
    }

    public String getPath() {
        return this.path;
    }

    public String buildString() {
        StringBuilder sb = new StringBuilder();
        if (this.path != null) {
            sb.append(this.path);
        }
        if (this.query != null) {
            sb.append("?").append(this.query);
        } else if (this.queryParams != null && !this.queryParams.isEmpty()) {
            sb.append("?").append(this.toQueryString(this.queryParams));
        }
        if (this.ref != null) {
            sb.append("#").append(this.ref);
        }
        return sb.toString();
    }

    private String toQueryString(List<NameValuePair> queryParams) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair parameter : queryParams) {
            String name = parameter.getName();
            String value = parameter.getValue();
            if (result.length() > 0) {
                result.append('&');
            }
            result.append(name);
            if (value == null) continue;
            result.append('=');
            result.append(value);
        }
        return result.toString();
    }
}

