/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FixBrokenTestObjectSurveyDialog
extends AbstractDialog {
    private static final String DIALOG_TITLE_FIX_BROKEN_TEST_OBJECT_SURVEY = "Fix broken Test Object Survey";
    public static final int BACK_TO_SPY_TOOL_CODE = 100;
    public static final String SHOULD_NOT_SHOW_SURVEY_FOR_USERS_FAILINNG_TO_FIX_BROKEN_TEST_OBJECTS = "shouldNotShowSurveyForUsersFailingToFixBrokenTestObjects";
    public static final String SHOULD_NOT_SHOW_SURVEY_FOR_USERS_SUCCEEDING_IN_FIXING_BROKEN_TEST_OBJECTS = "shouldNotShowSurveyForUsersSucceedingInFixingBrokenTestObjects";
    private boolean isUserJourneySuccessful;
    private String userChoiceText = "";
    private String userAnswer = "";
    private String userFeedback = "";
    private ScopedPreferenceStore store;

    protected FixBrokenTestObjectSurveyDialog(Shell parentShell, boolean isUserJourneySuccessful) {
        super(parentShell);
        this.isUserJourneySuccessful = isUserJourneySuccessful;
        this.store = PreferenceStoreManager.getPreferenceStore(((Object)((Object)this)).getClass());
        this.setDialogTitle(DIALOG_TITLE_FIX_BROKEN_TEST_OBJECT_SURVEY);
    }

    public boolean shouldDisplaySurvey() {
        if (this.isUserJourneySuccessful) {
            return this.shouldShowSurveyForUsersSucceedingInFixingBrokenTestObjects();
        }
        return this.shouldShowSurveyForUsersFailingToFixBrokenTestObjects();
    }

    private boolean shouldShowSurveyForUsersFailingToFixBrokenTestObjects() {
        return !this.store.getBoolean(SHOULD_NOT_SHOW_SURVEY_FOR_USERS_FAILINNG_TO_FIX_BROKEN_TEST_OBJECTS);
    }

    private boolean shouldShowSurveyForUsersSucceedingInFixingBrokenTestObjects() {
        return !this.store.getBoolean(SHOULD_NOT_SHOW_SURVEY_FOR_USERS_SUCCEEDING_IN_FIXING_BROKEN_TEST_OBJECTS);
    }

    protected void buttonPressed(int buttonId) {
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(((Object)((Object)this)).getClass());
        if (buttonId == 0) {
            try {
                if (this.isUserJourneySuccessful) {
                    store.setValue(SHOULD_NOT_SHOW_SURVEY_FOR_USERS_SUCCEEDING_IN_FIXING_BROKEN_TEST_OBJECTS, true);
                    Trackings.trackUsersSucceededInFixingBrokenTestObjectsFeedback((String)this.userAnswer);
                } else {
                    store.setValue(SHOULD_NOT_SHOW_SURVEY_FOR_USERS_FAILINNG_TO_FIX_BROKEN_TEST_OBJECTS, true);
                    Trackings.trackUsersFailedToFixBrokenTestObjectsFeedback((String)this.userAnswer, (String)this.userChoiceText);
                }
                store.save();
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } else if (buttonId == 1) {
            store.setValue(SHOULD_NOT_SHOW_SURVEY_FOR_USERS_SUCCEEDING_IN_FIXING_BROKEN_TEST_OBJECTS, true);
            store.setValue(SHOULD_NOT_SHOW_SURVEY_FOR_USERS_SUCCEEDING_IN_FIXING_BROKEN_TEST_OBJECTS, true);
        } else if (buttonId == 100) {
            this.setReturnCode(100);
            this.close();
        }
        try {
            store.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        super.buttonPressed(buttonId);
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 64);
        GridLayout glContainer = new GridLayout();
        glContainer.verticalSpacing = 5;
        container.setLayout((Layout)glContainer);
        this.createSurveyQuestionsForCorrespondingUserJourney(container);
        return container;
    }

    private void createSurveyQuestionsForCorrespondingUserJourney(Composite container) {
        Composite userSurveyComposite = new Composite(container, 64);
        GridLayout glContent = new GridLayout(1, false);
        GridData gdContent = new GridData(4, 128, true, false, 1, 1);
        gdContent.minimumHeight = 150;
        gdContent.widthHint = 400;
        glContent.verticalSpacing = 10;
        userSurveyComposite.setLayout((Layout)glContent);
        userSurveyComposite.setLayoutData((Object)gdContent);
        Label lblUserFeedback = new Label(userSurveyComposite, 64);
        lblUserFeedback.setText(this.getTextForCorrespondingUserJourney());
        lblUserFeedback.setLayoutData((Object)new GridData(4, 4, true, false));
        ArrayList listOfOptions = new ArrayList();
        Composite providedOptionsComposite = new Composite(userSurveyComposite, 64);
        GridLayout glProvidedOptionsComposite = new GridLayout(1, false);
        GridData gdProvidedOptionsComposite = new GridData(4, 128, true, false, 1, 1);
        glContent.verticalSpacing = 10;
        providedOptionsComposite.setLayout((Layout)glProvidedOptionsComposite);
        providedOptionsComposite.setLayoutData((Object)gdProvidedOptionsComposite);
        if (!this.isUserJourneySuccessful) {
            List<String> optionText = Arrays.asList("I don't know what to do", "I could not capture the element I need", "I am able to capture the element, but I don\u2019t want to do it yet", "Other");
            optionText.forEach(txt -> {
                final Button btnOption = new Button(providedOptionsComposite, 16);
                btnOption.setLayoutData((Object)new GridData(4, 4, true, false));
                btnOption.setText(txt);
                listOfOptions.add(btnOption);
                btnOption.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (btnOption.getSelection()) {
                            FixBrokenTestObjectSurveyDialog.this.userChoiceText = btnOption.getText();
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            });
        }
        final Text txtOtherOption = new Text(providedOptionsComposite, 2050);
        GridData gdOtherOption = new GridData(4, 128, true, false, 1, 1);
        gdOtherOption.heightHint = 30;
        txtOtherOption.setLayoutData((Object)gdOtherOption);
        txtOtherOption.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FixBrokenTestObjectSurveyDialog.this.userAnswer = txtOtherOption.getText();
            }
        });
    }

    private String getTextForCorrespondingUserJourney() {
        if (this.isUserJourneySuccessful) {
            return "Congratulations ! You have fixed the broken Test Object. Was there anything on this feature that we can improve ?";
        }
        return "It seems like you have not fixed the broken test object. Could you tell us what prevented you from doing so ?";
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        if (!this.isUserJourneySuccessful) {
            this.createButton(parent, 100, "Back to Spy Tool", false);
        }
        super.createButtonsForButtonBar(parent);
        this.getButton(1).setText("No, thanks");
    }

    protected Point getInitialLocation(Point initialSize) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Rectangle screen = display.getMonitors()[0].getBounds();
        return new Point((screen.width - initialSize.x) / 2, (screen.height - initialSize.y) / 2);
    }
}

