/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.objectspy.dialog.SaveToObjectRepositoryDialog;
import com.kms.katalon.objectspy.element.ConflictWebElementWrapper;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.WebParent;
import com.kms.katalon.objectspy.util.WebElementUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ObjectRepositoryService {
    public SaveActionResult saveObjectForWebRecorder(SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult) throws Exception {
        ArrayList<Object[]> testObjectIds = new ArrayList<Object[]>();
        Set<ITreeEntity> newSelectionOnExplorer = new HashSet<ITreeEntity>();
        int numberOfPages = 0;
        for (ConflictWebElementWrapper webPageWrapper : dialogResult.getAllSelectedPages()) {
            if (webPageWrapper.getType() != WebElement.WebElementType.PAGE) continue;
            ++numberOfPages;
            WebPage page = (WebPage)webPageWrapper.getOriginalWebElement();
            WebPage clonedWebPage = (WebPage)page.clone();
            clonedWebPage.getChildren().clear();
            clonedWebPage.setTag("cloned");
            for (ConflictWebElementWrapper webElementChildWrapper : webPageWrapper.getChildren()) {
                if (webElementChildWrapper.isConflicted()) {
                    this.addConflictedWebElement(page, webElementChildWrapper, dialogResult, testObjectIds);
                    this.addConflictedChildrenWebElement(page, webElementChildWrapper, dialogResult, testObjectIds);
                    continue;
                }
                WebElement clonedWebElement = webElementChildWrapper.getOriginalWebElement();
                clonedWebElement.setParent(clonedWebPage);
                newSelectionOnExplorer = this.addNonConflictedWebElement(clonedWebPage, clonedWebElement, dialogResult);
                newSelectionOnExplorer.addAll(this.getSelectionOnExplorer(page, webElementChildWrapper, dialogResult));
            }
        }
        int savedObjectCount = dialogResult.getEntitySavedMap().size();
        if (!dialogResult.isCreateFolderAsPageNameAllowed()) {
            savedObjectCount -= dialogResult.getAllSelectedPages().size();
        }
        if (savedObjectCount > 0) {
            savedObjectCount -= numberOfPages;
        }
        return new SaveActionResult(testObjectIds, newSelectionOnExplorer, savedObjectCount);
    }

    public SaveActionResult saveObjectForSpyTool(SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult) throws Exception {
        ArrayList<Object[]> testObjectIds = new ArrayList<Object[]>();
        Set<ITreeEntity> newSelectionOnExplorer = new HashSet<ITreeEntity>();
        int numberOfPages = 0;
        for (ConflictWebElementWrapper webPageWrapper : dialogResult.getAllSelectedPages()) {
            if (webPageWrapper.getType() != WebElement.WebElementType.PAGE) continue;
            ++numberOfPages;
            WebPage page = (WebPage)webPageWrapper.getOriginalWebElement();
            for (ConflictWebElementWrapper webElementChildWrapper : webPageWrapper.getChildren()) {
                if (webElementChildWrapper.isConflicted()) {
                    this.addConflictedWebElement(page, webElementChildWrapper, dialogResult, testObjectIds);
                    this.addConflictedChildrenWebElement(page, webElementChildWrapper, dialogResult, testObjectIds);
                    continue;
                }
                WebElement clonedWebElement = webElementChildWrapper.getOriginalWebElement();
                newSelectionOnExplorer = this.addNonConflictedWebElement(page, clonedWebElement, dialogResult);
                newSelectionOnExplorer.addAll(this.getSelectionOnExplorer(page, webElementChildWrapper, dialogResult));
            }
        }
        int savedObjectCount = dialogResult.getEntitySavedMap().size();
        if (!dialogResult.isCreateFolderAsPageNameAllowed()) {
            savedObjectCount -= dialogResult.getAllSelectedPages().size();
        }
        if (savedObjectCount > 0) {
            savedObjectCount -= numberOfPages;
        }
        return new SaveActionResult(testObjectIds, newSelectionOnExplorer, savedObjectCount);
    }

    private void addConflictedChildrenWebElement(WebPage webPage, ConflictWebElementWrapper webParent, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult, List<Object[]> testObjectIds) throws Exception {
        for (ConflictWebElementWrapper webElementChildWrapper : webParent.getChildren()) {
            this.addConflictedWebElement(webPage, webElementChildWrapper, dialogResult, testObjectIds);
            if (webElementChildWrapper.getChildren().size() <= 0) continue;
            this.addConflictedChildrenWebElement(webPage, webElementChildWrapper, dialogResult, testObjectIds);
        }
    }

    private Set<ITreeEntity> getSelectionOnExplorer(WebPage page, ConflictWebElementWrapper webParent, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult) throws Exception {
        HashSet<ITreeEntity> newSelectionOnExplorer = new HashSet<ITreeEntity>();
        for (ConflictWebElementWrapper webElementChildWrapper : webParent.getChildren()) {
            if (webElementChildWrapper.getChildren().size() > 0) {
                newSelectionOnExplorer.addAll(this.getSelectionOnExplorer(page, webElementChildWrapper, dialogResult));
            }
            WebElement clonedWebElement = webElementChildWrapper.getOriginalWebElement();
            newSelectionOnExplorer.addAll(this.addNonConflictedWebElement(page, clonedWebElement, dialogResult));
        }
        return newSelectionOnExplorer;
    }

    private Set<ITreeEntity> addNonConflictedWebElement(WebPage pageElement, WebElement selectedWebElement, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult) throws Exception {
        HashSet<ITreeEntity> newSelectionOnExplorer = new HashSet();
        boolean createFolderAsPageNameAllowed = dialogResult.isCreateFolderAsPageNameAllowed();
        FolderTreeEntity selectedParentFolder = dialogResult.getSelectedParentFolder();
        Map<WebElement, FileEntity> entitySavedMap = dialogResult.getEntitySavedMap();
        FolderEntity pageFolder = this.getPageFolder(pageElement, selectedParentFolder);
        FolderTreeEntity webPageDestinationFolder = selectedParentFolder;
        if (createFolderAsPageNameAllowed) {
            webPageDestinationFolder = pageFolder == null ? this.createTreeFolderForPageElement(pageElement, selectedParentFolder, createFolderAsPageNameAllowed) : new FolderTreeEntity(pageFolder, (ITreeEntity)selectedParentFolder);
        }
        entitySavedMap.put(pageElement, (FileEntity)webPageDestinationFolder.getObject());
        newSelectionOnExplorer = this.createNewObject(webPageDestinationFolder, selectedWebElement, entitySavedMap);
        return newSelectionOnExplorer;
    }

    private FolderEntity getPageFolder(WebPage pageElement, FolderTreeEntity selectedParentFolder) throws Exception {
        String pageFolderAbsolutePath = String.valueOf(selectedParentFolder.getObject().getLocation()) + File.separator + StringUtils.trim((String)pageElement.getName());
        FolderEntity pageFolder = FolderController.getInstance().getFolder(pageFolderAbsolutePath);
        return pageFolder;
    }

    private Set<ITreeEntity> createNewObject(FolderTreeEntity webPageFolder, WebElement selectedWebElement, Map<WebElement, FileEntity> entitySavedMap) throws Exception {
        HashSet<ITreeEntity> newSelectionOnExplorer = new HashSet<ITreeEntity>();
        newSelectionOnExplorer.add((ITreeEntity)webPageFolder);
        newSelectionOnExplorer.addAll(this.createWebElementTree(selectedWebElement, webPageFolder, null, entitySavedMap));
        return newSelectionOnExplorer;
    }

    private FolderTreeEntity createTreeFolderForPageElement(WebPage pageElement, FolderTreeEntity selectedParentFolder, boolean createFolderAsPageNameAllowed) throws Exception {
        if (createFolderAsPageNameAllowed) {
            return new FolderTreeEntity(this.createFolderForPageElement(pageElement, selectedParentFolder, createFolderAsPageNameAllowed), (ITreeEntity)selectedParentFolder);
        }
        return selectedParentFolder;
    }

    public FolderEntity createFolderForPageElement(WebPage pageElement, FolderTreeEntity selectedParentFolder, boolean createFolderAsPageNameAllowed) throws Exception {
        FolderEntity parentFolder = selectedParentFolder.getObject();
        return createFolderAsPageNameAllowed ? this.newPageWebElementAsFolder(parentFolder, pageElement) : parentFolder;
    }

    private FolderEntity newPageWebElementAsFolder(FolderEntity parentFolder, WebPage pageElement) throws Exception {
        return ObjectRepositoryController.getInstance().importWebElementFolder(WebElementUtils.convertWebPageToFolder(pageElement, parentFolder), parentFolder);
    }

    private Collection<ITreeEntity> createWebElementTree(WebElement element, FolderTreeEntity parentTreeFolder, WebElementEntity refElement, Map<WebElement, FileEntity> entitySavedMap) throws Exception {
        FolderEntity parentFolderEntity = parentTreeFolder.getObject();
        WebElementEntity importedElement = ObjectRepositoryController.getInstance().importWebElement(WebElementUtils.convertWebElementToTestObject(element, refElement, parentFolderEntity), parentFolderEntity);
        WebElementTreeEntity webElementNode = new WebElementTreeEntity(importedElement, (ITreeEntity)parentTreeFolder);
        entitySavedMap.put(element, (FileEntity)importedElement);
        ArrayList<ITreeEntity> newWebElementTree = new ArrayList<ITreeEntity>();
        newWebElementTree.add((ITreeEntity)webElementNode);
        return newWebElementTree;
    }

    private void addConflictedWebElement(WebPage webPage, ConflictWebElementWrapper wrapElement, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult, List<Object[]> testObjectIds) throws Exception {
        FolderTreeEntity selectedParentFolder = dialogResult.getSelectedParentFolder();
        SaveToObjectRepositoryDialog.ConflictOptions selectedConflictOption = dialogResult.getSelectedConflictOption();
        Map<WebElement, FileEntity> entitySavedMap = dialogResult.getEntitySavedMap();
        List<WebElementEntity> allConflictedElementEntites = dialogResult.getAllConflictedElementEntities();
        WebElement newWebElement = wrapElement.getOriginalWebElement().clone();
        WebParent webParent = newWebElement.getParent();
        String folderPath = String.valueOf(ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator + selectedParentFolder.getObject().getRelativePath();
        if (dialogResult.isCreateFolderAsPageNameAllowed()) {
            folderPath = String.valueOf(folderPath) + File.separator + StringUtils.trim((String)webPage.getName());
        }
        FolderEntity conflictedFolderEntity = FolderController.getInstance().getFolder(folderPath);
        String oldName = "";
        newWebElement.getProperties().remove(newWebElement.getProperty("ref_element"));
        if (webParent != null && !(webParent instanceof WebPage)) {
            oldName = webParent.getName();
            for (Map.Entry<WebElement, FileEntity> entry2 : entitySavedMap.entrySet()) {
                if (!entry2.getKey().equals(newWebElement.getParent())) continue;
                WebElementEntity webElementEntityParent = (WebElementEntity)entry2.getValue();
                webParent.setName(webElementEntityParent.getName());
                break;
            }
        }
        entitySavedMap.put(webPage, (FileEntity)conflictedFolderEntity);
        if (wrapElement.isConflicted()) {
            String oldElementAbsolutePath = String.valueOf(folderPath) + File.separator + StringUtils.trim((String)newWebElement.getName()) + WebElementEntity.getWebElementFileExtension();
            WebElementEntity objectAtDestinationFolder = ObjectRepositoryController.getInstance().getWebElement(oldElementAbsolutePath);
            WebElementEntity oldWebElementEntity = objectAtDestinationFolder == null ? allConflictedElementEntites.stream().filter(entity -> {
                int entityAHash;
                int newElementAHash = newWebElement.getAttributeHashValue();
                return newElementAHash == (entityAHash = WebElementUtils.getHashValue(entity));
            }).findFirst().get() : objectAtDestinationFolder;
            switch (selectedConflictOption) {
                case CREATE_NEW_OBJECT: {
                    newWebElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(conflictedFolderEntity, StringUtils.trim((String)newWebElement.getName())));
                    WebElementEntity importedWebElement = ObjectRepositoryController.getInstance().importWebElement(WebElementUtils.convertWebElementToTestObject(newWebElement, null, conflictedFolderEntity), conflictedFolderEntity);
                    entitySavedMap.put(wrapElement.getOriginalWebElement(), (FileEntity)importedWebElement);
                    if (webParent == null || !StringUtils.isNotEmpty((String)oldName)) break;
                    webParent.setName(oldName);
                    break;
                }
                case REPLACE_EXISTING_OBJECT: {
                    oldWebElementEntity.setWebElementProperties(newWebElement.getProperties());
                    oldWebElementEntity.setWebElementXpaths(newWebElement.getXpaths());
                    oldWebElementEntity.setSelectorMethod(WebElementSelectorMethod.valueOf((String)wrapElement.getOriginalWebElement().getSelectorMethod().toString()));
                    newWebElement.getSelectorCollection().entrySet().forEach(entry -> oldWebElementEntity.setSelectorValue(WebElementSelectorMethod.valueOf((String)((SelectorMethod)entry.getKey()).toString()), (String)entry.getValue()));
                    entitySavedMap.put(wrapElement.getOriginalWebElement(), (FileEntity)oldWebElementEntity);
                    if (webParent != null && !(webParent instanceof WebPage)) {
                        oldWebElementEntity.getWebElementProperties().remove(oldWebElementEntity.getProperty("ref_element"));
                        oldWebElementEntity.getWebElementProperties().add(new WebElementPropertyEntity("ref_element", String.valueOf(conflictedFolderEntity.getIdForDisplay()) + "/" + newWebElement.getParent().getName()));
                    }
                    if (webParent != null && WebElement.WebElementType.SHADOW == webParent.getType()) {
                        oldWebElementEntity.getWebElementProperties().add(new WebElementPropertyEntity("ref_element_is_shadow_root", "true"));
                    }
                    oldWebElementEntity.setName(newWebElement.getName());
                    ObjectRepositoryController.getInstance().updateTestObject(oldWebElementEntity);
                    break;
                }
                case MERGE_CHANGE_TO_EXISTING_OBJECT: {
                    List mergedProperties = oldWebElementEntity.getWebElementProperties();
                    int numOldWebElementProperties = oldWebElementEntity.getWebElementProperties().size();
                    for (WebElementPropertyEntity newWebElementProperty : newWebElement.getProperties()) {
                        boolean newPropertyUsed = false;
                        int i = 0;
                        while (i < numOldWebElementProperties) {
                            if (newWebElementProperty.getName().equals(((WebElementPropertyEntity)mergedProperties.get(i)).getName())) {
                                mergedProperties.set(i, newWebElementProperty);
                                newPropertyUsed = true;
                                break;
                            }
                            ++i;
                        }
                        if (newPropertyUsed) continue;
                        mergedProperties.add(newWebElementProperty);
                    }
                    oldWebElementEntity.setWebElementProperties(mergedProperties);
                    LinkedHashSet<WebElementXpathEntity> mergedXpaths = new LinkedHashSet<WebElementXpathEntity>();
                    mergedXpaths.addAll(newWebElement.getXpaths());
                    for (WebElementXpathEntity wXpath : oldWebElementEntity.getWebElementXpaths()) {
                        wXpath.setIsSelected(Boolean.valueOf(false));
                    }
                    mergedXpaths.addAll(oldWebElementEntity.getWebElementXpaths());
                    oldWebElementEntity.setWebElementXpaths(new ArrayList(mergedXpaths));
                    oldWebElementEntity.setSelectorMethod(WebElementSelectorMethod.valueOf((String)wrapElement.getOriginalWebElement().getSelectorMethod().toString()));
                    newWebElement.getSelectorCollection().entrySet().forEach(entry -> oldWebElementEntity.setSelectorValue(WebElementSelectorMethod.valueOf((String)((SelectorMethod)entry.getKey()).toString()), (String)entry.getValue()));
                    entitySavedMap.put(wrapElement.getOriginalWebElement(), (FileEntity)oldWebElementEntity);
                    if (webParent != null && !(webParent instanceof WebPage)) {
                        oldWebElementEntity.getWebElementProperties().remove(oldWebElementEntity.getProperty("ref_element"));
                        oldWebElementEntity.getWebElementProperties().add(new WebElementPropertyEntity("ref_element", String.valueOf(conflictedFolderEntity.getIdForDisplay()) + "/" + webParent.getName()));
                    }
                    if (webParent != null && WebElement.WebElementType.SHADOW == webParent.getType()) {
                        oldWebElementEntity.getWebElementProperties().add(new WebElementPropertyEntity("ref_element_is_shadow_root", "true"));
                    }
                    ObjectRepositoryController.getInstance().updateTestObject(oldWebElementEntity);
                    break;
                }
            }
            entitySavedMap.put(webPage, (FileEntity)conflictedFolderEntity);
            testObjectIds.add(new Object[]{oldWebElementEntity.getId(), oldWebElementEntity});
        } else {
            WebElementEntity newWebElementEntity = ObjectRepositoryController.getInstance().importWebElement(WebElementUtils.convertWebElementToTestObject(newWebElement, null, conflictedFolderEntity), conflictedFolderEntity);
            testObjectIds.add(new Object[]{newWebElementEntity.getId(), conflictedFolderEntity});
        }
    }

    public class SaveActionResult {
        List<Object[]> updatedTestObjectIds;
        Set<ITreeEntity> newSelectionOnExplorer;
        int savedObjectCount;
        int capturedObjectsNumber;
        int duplicatedObjectsNumber;
        int duplicatedByObjectsID;

        public SaveActionResult(List<Object[]> updatedTestObjectIds, Set<ITreeEntity> newSelectionOnExplorer, int savedObjectCount) {
            this.updatedTestObjectIds = updatedTestObjectIds;
            this.newSelectionOnExplorer = newSelectionOnExplorer;
            this.savedObjectCount = savedObjectCount;
        }

        public List<Object[]> getUpdatedTestObjectIds() {
            return this.updatedTestObjectIds;
        }

        public Set<ITreeEntity> getNewSelectionOnExplorer() {
            return this.newSelectionOnExplorer;
        }

        public int getSavedObjectCount() {
            return this.savedObjectCount;
        }
    }
}

