/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.common.XPathBuilder;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.WebParent;
import com.kms.katalon.objectspy.element.WebShadow;
import com.kms.katalon.util.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.BooleanUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class WebElementUtils {
    private static final String SCREENSHOT_PATH = "/Screenshots/Targets/";
    private static final String PAGE_ELEMENT_NAME_PREFIX = "Page_";
    private static final String FRAME_ELEMENT_NAME_PREFIX = "Frame_";
    private static final String WEB_ELEMENT_NAME_PREFIX = "Element_";
    private static final String ELEMENT_ATTRIBUTES_STYLE_KEY = "style";
    private static final int NAME_LENGTH_LIMIT = 220;
    public static final String PAGE_TITLE_KEY = "title";
    private static final String ELEMENT_PARENT_KEY = "parent";
    private static final String ELEMENT_PAGE_KEY = "page";
    private static final String ELEMENT_XPATHS_KEY = "xpaths";
    private static final String ELEMENT_CSS_KEY = "css";
    private static final String ELEMENT_USEFUL_NEIGHBOR_TEXT = "neighbor_text";
    private static final String ELEMENT_ATTRIBUTES_KEY = "attributes";
    private static final String ELEMENT_CONTENT_KEY = "content";
    private static final String ELEMENT_TEXT_KEY = "text";
    private static final String ELEMENT_ID_KEY = "id";
    private static final String ELEMENT_NAME_KEY = "name";
    private static final String ELEMENT_CLASS_KEY = "class";
    private static final String ELEMENT_TYPE_KEY = "type";
    private static final String ELEMENT_TAG_KEY = "tag";
    private static final String XPATH_KEY = "xpath";
    private static final String CUSTOM_XPATH_KEY = "xpath:customAttributes";
    private static final String PAGE_URL_KEY = "url";
    private static final List<String> PRIORITY_PROPERTIES = Arrays.asList("id", "name", "alt", "checked", "form", "href", "placeholder", "selected", "src", "title", "type", "text", "linked_text");
    private static final String SHADOW_ELEMENT = "shadow_element";
    private static final String SHADOW_ROOT = "shadow_root";
    private static final String TITLE = "title";
    private static final String PROPERY_CONTENT_EDITABLE = "contenteditable";
    private static final String SMART_LOCATORS_KEY = "smart_locator";
    private static final int ID_LENGTH = 3;

    public static String generateWebElementName(String elementType, List<WebElementPropertyEntity> properties, String usefulNeighborText) {
        Map<String, String> propsMap = properties.stream().filter(p -> ELEMENT_TEXT_KEY.equals(p.getName()) || ELEMENT_NAME_KEY.equals(p.getName()) || ELEMENT_ID_KEY.equals(p.getName()) || ELEMENT_CLASS_KEY.equals(p.getName())).collect(Collectors.toMap(WebElementPropertyEntity::getName, WebElementPropertyEntity::getValue));
        String content = propsMap.get(ELEMENT_TEXT_KEY);
        if (content != null) {
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(content);
        }
        String name = propsMap.get(ELEMENT_NAME_KEY);
        if (name != null) {
            if ("".equals(usefulNeighborText)) {
                return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(name);
            }
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(usefulNeighborText) + "_" + WebElementUtils.toValidFileName(name);
        }
        String id = propsMap.get(ELEMENT_ID_KEY);
        if (id != null) {
            if ("".equals(usefulNeighborText)) {
                return String.valueOf(elementType) + WebElementUtils.toValidFileName(id);
            }
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(usefulNeighborText) + "_" + WebElementUtils.toValidFileName(id);
        }
        String cssClass = propsMap.get(ELEMENT_CLASS_KEY);
        if (cssClass != null) {
            if ("".equals(usefulNeighborText)) {
                return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(cssClass);
            }
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(usefulNeighborText) + "_" + WebElementUtils.toValidFileName(cssClass);
        }
        for (WebElementPropertyEntity property : properties) {
            if (!property.getName().equals(ELEMENT_TYPE_KEY)) continue;
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(property.getValue());
        }
        return elementType;
    }

    public static String decodeURIComponent(String encodedString) throws UnsupportedEncodingException {
        return URLDecoder.decode(encodedString.replace("+", "%2B"), "UTF-8").replace("%2B", "+");
    }

    public static WebElement buildWebElement(String jsonString) throws Exception {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(WebElementUtils.decodeURIComponent(jsonString).trim());
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return WebElementUtils.buildWebElement(jsonObject, false);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static WebElement buildWebElement(JsonObject elementJsonObject, boolean isFrame) throws UnsupportedEncodingException {
        void pageJsonObject;
        JsonObject jsonObject;
        JsonElement pageObject;
        JsonElement jsonElement;
        JsonElement jsObject;
        if (elementJsonObject == null || !elementJsonObject.get(ELEMENT_TYPE_KEY).isJsonPrimitive()) {
            return null;
        }
        String elementType = elementJsonObject.getAsJsonPrimitive(ELEMENT_TYPE_KEY).getAsString();
        ArrayList<WebElementPropertyEntity> attributes = new ArrayList<WebElementPropertyEntity>();
        attributes.add(new WebElementPropertyEntity(ELEMENT_TAG_KEY, elementType, false));
        WebElementUtils.collectElementContents(elementJsonObject, attributes);
        WebElementUtils.collectElementAttributes(elementJsonObject, attributes);
        ArrayList<WebElementXpathEntity> xpaths = new ArrayList<WebElementXpathEntity>();
        WebElementUtils.collectElementXpaths(elementJsonObject, xpaths);
        String xpathString = WebElementUtils.getElementXpath(elementJsonObject);
        Map<String, Boolean> customSettings = WebElementUtils.getCapturedTestObjectAttributeLocatorSettings().stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        attributes.stream().filter(i -> customSettings.get(i.getName()) != null).forEach(i -> i.setIsSelected((Boolean)customSettings.get(i.getName())));
        if (!customSettings.containsKey(XPATH_KEY)) {
            boolean shouldHaveXpath = true;
            for (WebElementPropertyEntity property : attributes) {
                if (!property.getIsSelected().booleanValue()) continue;
                shouldHaveXpath = false;
                break;
            }
            attributes.add(new WebElementPropertyEntity(XPATH_KEY, xpathString, shouldHaveXpath));
        }
        Optional<WebElementPropertyEntity> prop = attributes.stream().filter(s -> s.getName().equalsIgnoreCase(PROPERY_CONTENT_EDITABLE)).findFirst();
        boolean contenteditable = false;
        if (prop.isPresent()) {
            contenteditable = Boolean.valueOf(prop.get().getValue());
        }
        ArrayList<TestObjectProperty> customAttrs = new ArrayList<TestObjectProperty>();
        for (WebElementPropertyEntity tempProp : attributes) {
            if (!BooleanUtils.isTrue((Boolean)customSettings.get(tempProp.getName())) || contenteditable && tempProp.getName().equalsIgnoreCase(ELEMENT_TEXT_KEY)) continue;
            customAttrs.add(new TestObjectProperty(tempProp.getName(), ConditionType.EQUALS, tempProp.getValue()));
        }
        customAttrs.add(new TestObjectProperty(ELEMENT_TAG_KEY, ConditionType.EQUALS, elementType));
        if (customAttrs.size() > 1) {
            XPathBuilder xpathBuilder = new XPathBuilder(customAttrs);
            String customXPath = xpathBuilder.build();
            xpaths.add(new WebElementXpathEntity(CUSTOM_XPATH_KEY, customXPath, false));
        }
        SelectorMethod selectorMethod = WebElementUtils.getCapturedTestObjectSelectorMethod();
        final List capturedTestObjectXpaths = WebElementUtils.getCapturedTestObjectXpathLocatorSettings().stream().map(o -> (String)o.getLeft()).collect(Collectors.toList());
        Comparator<WebElementXpathEntity> comparator = new Comparator<WebElementXpathEntity>(){

            @Override
            public int compare(WebElementXpathEntity o1, WebElementXpathEntity o2) {
                int p1 = capturedTestObjectXpaths.indexOf(o1.getName());
                int p2 = capturedTestObjectXpaths.indexOf(o2.getName());
                if (p1 == -1 && p2 != -1) {
                    return 1;
                }
                if (p1 != -1 && p2 == -1) {
                    return -1;
                }
                if (p1 != p2) {
                    return p1 - p2;
                }
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(xpaths, comparator);
        Iterator it = xpaths.iterator();
        while (it.hasNext()) {
            WebElementXpathEntity xpath = (WebElementXpathEntity)it.next();
            if (capturedTestObjectXpaths.indexOf(xpath.getName()) != -1) continue;
            it.remove();
        }
        if (!xpaths.isEmpty()) {
            Optional.ofNullable((WebElementXpathEntity)xpaths.get(0)).ifPresent(a -> a.setIsSelected(Boolean.valueOf(true)));
        }
        String usefulNeighborText = WebElementUtils.getElementUsefulNeighborText(elementJsonObject);
        WebParent parentElement = WebElementUtils.getParentElement(elementJsonObject);
        String newName = WebElementUtils.generateWebElementName(elementType, attributes, usefulNeighborText);
        if (newName.length() > 220) {
            newName = newName.substring(0, 220);
        }
        boolean isShadowRoot = elementJsonObject.has(SHADOW_ROOT);
        WebElement el = isFrame ? new WebFrame(newName) : (isShadowRoot ? new WebShadow(newName) : new WebElement(newName));
        el.setParent(parentElement);
        el.setWindowTitle(parentElement.getWindowTitle());
        el.setProperties(attributes);
        el.setXpaths(xpaths);
        el.setUsefulNeighborText(usefulNeighborText);
        el.setSelectorMethod(selectorMethod);
        if ((isShadowRoot || elementJsonObject.has(SHADOW_ELEMENT)) && selectorMethod != SelectorMethod.SMART_LOCATOR) {
            el.setSelectorMethod(SelectorMethod.CSS);
            el.setName(WebElementUtils.updateNewElementName(el));
        }
        if (elementJsonObject.has(SMART_LOCATORS_KEY) && LicenseUtil.isNotFreeLicense() && !(jsObject = elementJsonObject.get(SMART_LOCATORS_KEY)).isJsonNull()) {
            el.setSelectorValue(SelectorMethod.SMART_LOCATOR, jsObject.getAsString());
        }
        if ((jsonElement = (pageObject = elementJsonObject.get(ELEMENT_PAGE_KEY))) instanceof JsonObject && (jsonObject = (JsonObject)jsonElement) == (JsonObject)jsonElement && pageJsonObject != null && pageJsonObject.has("title")) {
            el.setWindowTitle(pageJsonObject.get("title").getAsString());
        }
        String cssSelector = WebElementUtils.getElementCSS(elementJsonObject);
        el.setSelectorValue(SelectorMethod.CSS, cssSelector);
        if (!xpaths.isEmpty()) {
            String value = Optional.ofNullable((WebElementXpathEntity)xpaths.get(0)).orElse(new WebElementXpathEntity("", "")).getValue();
            el.setSelectorValue(SelectorMethod.XPATH, value);
        }
        return el;
    }

    public static String takeScreenShotForImageBasedObjectRecognition(WebDriver driver, WebElement el) {
        String currentProjectLocation = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        TestObject testObject = WebElementUtils.buildTestObject(el);
        String objectRepositoryFolder = testObject.getObjectId().replace(el.getName(), "");
        File imageFolder = new File(String.valueOf(currentProjectLocation) + SCREENSHOT_PATH + objectRepositoryFolder);
        imageFolder.mkdirs();
        boolean isValidLocator = testObject.getSelectorMethod() != SelectorMethod.IMAGE;
        SelectorMethod selectorMethod = isValidLocator ? testObject.getSelectorMethod() : SelectorMethod.XPATH;
        By findElementBy = WebUiCommonHelper.buildLocator((TestObject)testObject, (SelectorMethod)selectorMethod);
        org.openqa.selenium.WebElement webElement = null;
        if (selectorMethod == SelectorMethod.SMART_LOCATOR) {
            JavascriptExecutor js = (JavascriptExecutor)driver;
            String jsLocator = String.format("return katalonSmartLocator.find_element_by_smart_locator(`%s`)", testObject.getSmartSelectorCollection().get(SelectorMethod.SMART_LOCATOR));
            webElement = (org.openqa.selenium.WebElement)js.executeScript(jsLocator, new Object[0]);
        } else {
            webElement = driver.findElement(findElementBy);
        }
        return Optional.ofNullable(webElement).map(element -> {
            try {
                return WebUiCommonHelper.saveWebElementScreenshotAndResize((WebDriver)driver, (org.openqa.selenium.WebElement)element, (String)el.getName(), (String)imageFolder.getAbsolutePath());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return "";
            }
        }).get();
    }

    private static List<Pair<String, Boolean>> getCapturedTestObjectAttributeLocatorSettings() {
        WebUiExecutionSettingStore store = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
        try {
            return store.getCapturedTestObjectAttributeLocators();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<Pair<String, Boolean>> getCapturedTestObjectXpathLocatorSettings() {
        WebUiExecutionSettingStore store = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
        try {
            return store.getCapturedTestObjectXpathLocators();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private static SelectorMethod getCapturedTestObjectSelectorMethod() {
        WebUiExecutionSettingStore store = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
        try {
            SelectorMethod chosenMethod = store.getCapturedTestObjectSelectorMethod();
            if (chosenMethod == SelectorMethod.SMART_LOCATOR && LicenseUtil.isFreeLicense()) {
                chosenMethod = SelectorMethod.XPATH;
            }
            return chosenMethod;
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return SelectorMethod.BASIC;
        }
    }

    public static String toValidFileName(String fileName) {
        return EntityController.toValidFileName((String)fileName);
    }

    private static WebParent getParentElement(JsonObject elementJsonObject) throws UnsupportedEncodingException {
        WebPage parentElement = null;
        if (elementJsonObject.has(ELEMENT_PARENT_KEY) && elementJsonObject.get(ELEMENT_PARENT_KEY).isJsonObject()) {
            boolean isShadow = elementJsonObject.has(SHADOW_ELEMENT);
            WebElement tempParentElement = WebElementUtils.buildWebElement(elementJsonObject.getAsJsonObject(ELEMENT_PARENT_KEY), !isShadow);
            if (tempParentElement instanceof WebShadow var4_5) {
                parentElement = webShadow;
            }
            if (( instanceOfPatternExpressionValue = tempParentElement) instanceof WebFrame var6_7) {
                parentElement = webFrame;
            }
        } else {
            parentElement = WebElementUtils.buildWebPageElement(elementJsonObject.getAsJsonObject(ELEMENT_PAGE_KEY));
        }
        return parentElement;
    }

    private static String getElementXpath(JsonObject elementJsonObject) {
        if (elementJsonObject.has(XPATH_KEY) && elementJsonObject.get(XPATH_KEY).isJsonPrimitive()) {
            return elementJsonObject.getAsJsonPrimitive(XPATH_KEY).getAsString();
        }
        return null;
    }

    private static void collectElementAttributes(JsonObject elementJsonObject, List<WebElementPropertyEntity> properties) {
        if (!WebElementUtils.isElementAttributesSet(elementJsonObject)) {
            return;
        }
        boolean contenteditable = false;
        if (elementJsonObject.getAsJsonObject(ELEMENT_ATTRIBUTES_KEY).getAsJsonPrimitive(PROPERY_CONTENT_EDITABLE) != null) {
            contenteditable = elementJsonObject.getAsJsonObject(ELEMENT_ATTRIBUTES_KEY).getAsJsonPrimitive(PROPERY_CONTENT_EDITABLE).getAsBoolean();
        }
        for (Map.Entry entry : elementJsonObject.getAsJsonObject(ELEMENT_ATTRIBUTES_KEY).entrySet()) {
            if (!WebElementUtils.isValidElementAttribute(entry) || contenteditable && ((String)entry.getKey()).equals(ELEMENT_TEXT_KEY)) continue;
            String propertyName = (String)entry.getKey();
            properties.add(new WebElementPropertyEntity(propertyName, ((JsonElement)entry.getValue()).getAsString(), false));
        }
    }

    private static String getElementUsefulNeighborText(JsonObject elementJsonObject) {
        if (elementJsonObject.has(ELEMENT_USEFUL_NEIGHBOR_TEXT) && elementJsonObject.get(ELEMENT_USEFUL_NEIGHBOR_TEXT).isJsonPrimitive()) {
            return elementJsonObject.getAsJsonPrimitive(ELEMENT_USEFUL_NEIGHBOR_TEXT).getAsString();
        }
        return "";
    }

    private static void collectElementXpaths(JsonObject elementJsonObject, List<WebElementXpathEntity> xpaths) {
        if (!WebElementUtils.isElementXpathsSet(elementJsonObject)) {
            return;
        }
        for (Map.Entry entry : elementJsonObject.getAsJsonObject(ELEMENT_XPATHS_KEY).entrySet()) {
            String xpathFinder = (String)entry.getKey();
            JsonElement xpath = (JsonElement)entry.getValue();
            if (xpath instanceof JsonObject) {
                xpaths.add(new WebElementXpathEntity(xpathFinder, ((JsonElement)entry.getValue()).getAsString(), false));
                continue;
            }
            if (!(xpath instanceof JsonArray)) continue;
            for (JsonElement jsonElement : xpath.getAsJsonArray()) {
                xpaths.add(new WebElementXpathEntity(xpathFinder, jsonElement.getAsString(), false));
            }
        }
    }

    private static String getElementCSS(JsonObject elementJsonObject) {
        if (!WebElementUtils.isElementXpathsSet(elementJsonObject)) {
            return "";
        }
        String cssSelector = "";
        for (Map.Entry entry : elementJsonObject.getAsJsonObject(ELEMENT_XPATHS_KEY).entrySet()) {
            String xpathFinder = (String)entry.getKey();
            JsonElement xpath = (JsonElement)entry.getValue();
            if (!(xpath instanceof JsonArray) || !StringUtils.equals((String)xpathFinder, (String)ELEMENT_CSS_KEY)) continue;
            for (JsonElement jsonElement : xpath.getAsJsonArray()) {
                cssSelector = jsonElement.getAsString();
                if (StringUtils.isBlank((String)cssSelector) || !cssSelector.startsWith("css=")) continue;
                return cssSelector.substring("css=".length());
            }
        }
        return "";
    }

    private static boolean isElementAttributesSet(JsonObject elementJsonObject) {
        return elementJsonObject.has(ELEMENT_ATTRIBUTES_KEY) && elementJsonObject.get(ELEMENT_ATTRIBUTES_KEY).isJsonObject();
    }

    private static boolean isElementXpathsSet(JsonObject elementJsonObject) {
        return elementJsonObject.has(ELEMENT_XPATHS_KEY) && elementJsonObject.get(ELEMENT_XPATHS_KEY).isJsonObject();
    }

    private static boolean isValidElementAttribute(Map.Entry<String, JsonElement> attributeEntry) {
        return attributeEntry.getValue() != null && StringUtils.isNotBlank((String)attributeEntry.getValue().getAsString()) && !ELEMENT_ATTRIBUTES_STYLE_KEY.equals(attributeEntry.getKey());
    }

    private static void collectElementContents(JsonObject elementJsonObject, List<WebElementPropertyEntity> properties) {
        if (!WebElementUtils.isElementContent(elementJsonObject)) {
            return;
        }
        JsonArray contentArray = elementJsonObject.getAsJsonArray(ELEMENT_CONTENT_KEY);
        if (!WebElementUtils.isValidElementContent(contentArray)) {
            return;
        }
        properties.add(new WebElementPropertyEntity(ELEMENT_TEXT_KEY, contentArray.get(0).getAsString(), false));
    }

    private static boolean isElementContent(JsonObject elementJsonObject) {
        return elementJsonObject.has(ELEMENT_CONTENT_KEY) && elementJsonObject.get(ELEMENT_CONTENT_KEY).isJsonArray();
    }

    private static boolean isValidElementContent(JsonArray contentArray) {
        return contentArray != null && contentArray.size() == 1 && contentArray.get(0).isJsonPrimitive() && StringUtils.isNotBlank((String)contentArray.get(0).getAsString());
    }

    private static WebPage buildWebPageElement(JsonObject parentPageJsonObject) {
        if (parentPageJsonObject == null) {
            return null;
        }
        String pageUrlString = parentPageJsonObject.getAsJsonPrimitive(PAGE_URL_KEY).getAsString();
        String pageTitleString = parentPageJsonObject.getAsJsonPrimitive("title").getAsString();
        ArrayList<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
        properties.add(new WebElementPropertyEntity(PAGE_URL_KEY, pageUrlString, PRIORITY_PROPERTIES.contains(PAGE_URL_KEY)));
        properties.add(new WebElementPropertyEntity("title", pageTitleString, PRIORITY_PROPERTIES.contains("title")));
        WebPage webPage = new WebPage(WebElementUtils.generateWebPageName(pageTitleString));
        webPage.setProperties(properties);
        return webPage;
    }

    private static String generateWebPageName(String pageTitleString) {
        return PAGE_ELEMENT_NAME_PREFIX + StringUtils.substring((String)WebElementUtils.toValidFileName(pageTitleString), (int)0, (int)220);
    }

    public static WebElementEntity convertWebElementToTestObject(WebElement element, WebElementEntity refElement, FolderEntity parentFolder) throws Exception {
        WebElementEntity newWebElement = new WebElementEntity();
        newWebElement.setUseRalativeImagePath(true);
        newWebElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(parentFolder, WebElementUtils.toValidFileName(StringUtils.trim((String)element.getName()))));
        newWebElement.setParentFolder(parentFolder);
        newWebElement.setElementGuidId(Util.generateGuid());
        newWebElement.setProject(parentFolder.getProject());
        newWebElement.setWebElementProperties(new ArrayList<WebElementPropertyEntity>(element.getProperties()));
        newWebElement.setWebElementXpaths(new ArrayList<WebElementXpathEntity>(element.getXpaths()));
        newWebElement.setSelectorMethod(WebElementSelectorMethod.valueOf((String)element.getSelectorMethod().name()));
        element.getSelectorCollection().entrySet().forEach(entry -> {
            SelectorMethod selectorMethod = (SelectorMethod)entry.getKey();
            if (SelectorMethod.BASIC == selectorMethod) {
                return;
            }
            newWebElement.setSelectorValue(WebElementSelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        WebParent webParent = element.getParent();
        if (webParent != null && WebElement.WebElementType.SHADOW == webParent.getType() && !StringUtils.isEmpty((String)webParent.getName())) {
            newWebElement.getWebElementProperties().add(new WebElementPropertyEntity("ref_element", String.valueOf(parentFolder.getRelativePath().replace("\\", "/")) + "/" + webParent.getName()));
            newWebElement.getWebElementProperties().add(new WebElementPropertyEntity("ref_element_is_shadow_root", "true"));
        } else if (webParent instanceof WebParent && !(webParent instanceof WebPage)) {
            newWebElement.getWebElementProperties().add(new WebElementPropertyEntity("ref_element", String.valueOf(parentFolder.getRelativePath().replace("\\", "/")) + "/" + webParent.getName()));
        }
        if (refElement == null) {
            return newWebElement;
        }
        newWebElement.getWebElementProperties().add(new WebElementPropertyEntity("ref_element", refElement.getIdForDisplay()));
        return newWebElement;
    }

    public static FolderEntity convertWebPageToFolder(WebPage page, FolderEntity parentFolder) throws Exception {
        FolderEntity newFolder = new FolderEntity();
        newFolder.setName(WebElementUtils.toValidFileName(StringUtils.trim((String)page.getName())));
        newFolder.setParentFolder(parentFolder);
        newFolder.setDescription("folder");
        newFolder.setFolderType(parentFolder.getFolderType());
        newFolder.setProject(parentFolder.getProject());
        return newFolder;
    }

    public static WebPage createWebPage() {
        return new WebPage(PAGE_ELEMENT_NAME_PREFIX + System.currentTimeMillis());
    }

    public static WebFrame createWebFrame(WebFrame parent) {
        long currentTime = System.currentTimeMillis();
        WebFrame el = new WebFrame(FRAME_ELEMENT_NAME_PREFIX + currentTime);
        el.setTag("IFRAME");
        el.setParent(parent);
        el.addProperty(XPATH_KEY, XPATH_KEY + currentTime);
        return el;
    }

    public static WebElement createWebElement(WebParent parent) {
        long currentTime = System.currentTimeMillis();
        WebElement el = new WebElement(WEB_ELEMENT_NAME_PREFIX + currentTime);
        el.setTag("DIV");
        el.setParent(parent);
        el.addProperty(XPATH_KEY, XPATH_KEY + currentTime);
        return el;
    }

    public static String buildXpathForHTMLElement(WebElement element) {
        if (element != null && element.getParent() instanceof WebParent) {
            if (element.getXpath().startsWith("/")) {
                return String.valueOf(WebElementUtils.buildXpathForHTMLElement(element.getParent())) + element.getXpath();
            }
            return element.getXpath();
        }
        return GlobalStringConstants.EMPTY;
    }

    public static List<WebPage> createWebElementFromFolder(FolderEntity folder, Map<String, WebElement> elementsMap) {
        if (folder == null) {
            return Collections.emptyList();
        }
        ArrayList<WebPage> pageElements = new ArrayList<WebPage>();
        WebElement mappedWebPage = elementsMap.get(folder.getId());
        if (mappedWebPage != null) {
            pageElements.add((WebPage)mappedWebPage);
            return pageElements;
        }
        WebPage pageElement = WebElementUtils.createWebPage();
        pageElement.setName(folder.getName());
        elementsMap.put(folder.getId(), pageElement);
        pageElements.add(pageElement);
        try {
            for (FileEntity entity : FolderController.getInstance().getChildren(folder)) {
                if (entity instanceof WebElementEntity) {
                    WebElementUtils.createWebElementFromTestObject((WebElementEntity)entity, false, pageElement, elementsMap);
                    continue;
                }
                if (!(entity instanceof FolderEntity)) continue;
                List<WebPage> childPageElements = WebElementUtils.createWebElementFromFolder((FolderEntity)entity, elementsMap);
                pageElements.addAll(childPageElements);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return pageElements;
    }

    public static WebElement createWebElementFromTestObject(WebElementEntity webElementEntity, boolean isFrame, WebPage pageElement, Map<String, WebElement> elementsMap) {
        if (webElementEntity == null) {
            return null;
        }
        String entityId = webElementEntity.getId();
        WebElement mappedWebElement = elementsMap.get(entityId);
        if (mappedWebElement != null) {
            if (isFrame && !(mappedWebElement instanceof WebFrame)) {
                elementsMap.remove(entityId);
                WebParent parentElementOfFrame = mappedWebElement.getParent();
                parentElementOfFrame.getChildren().remove(mappedWebElement);
                WebFrame replacedElement = new WebFrame(mappedWebElement.getName());
                replacedElement.setParent(parentElementOfFrame);
                if (mappedWebElement.hasProperty()) {
                    replacedElement.setProperties(mappedWebElement.getProperties());
                }
                if (mappedWebElement.hasXpath()) {
                    replacedElement.setXpaths(mappedWebElement.getXpaths());
                }
                SelectorMethod selector = mappedWebElement.getSelectorMethod();
                replacedElement.setSelectorMethod(selector);
                replacedElement.setSelectorValue(selector, mappedWebElement.getSelectorCollection().get(selector));
                elementsMap.put(entityId, replacedElement);
                return replacedElement;
            }
            return mappedWebElement;
        }
        WebParent parentFrameElement = null;
        Optional<WebElementPropertyEntity> refElement = webElementEntity.getWebElementProperties().stream().filter(p -> "ref_element".equals(p.getName())).findFirst();
        if (refElement.isPresent()) {
            try {
                parentFrameElement = (WebParent)WebElementUtils.createWebElementFromTestObject(ObjectRepositoryController.getInstance().getWebElementByDisplayPk(refElement.get().getValue()), true, pageElement, elementsMap);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        String entityName = webElementEntity.getName();
        WebElement element = isFrame ? new WebFrame(entityName) : new WebElement(entityName);
        element.setParent(parentFrameElement != null ? parentFrameElement : pageElement);
        element.setProperties(webElementEntity.getWebElementProperties());
        element.setXpaths(webElementEntity.getWebElementXpaths());
        element.setSelectorMethod(SelectorMethod.valueOf((String)webElementEntity.getGenericSelectorMethod().name()));
        webElementEntity.getSelectorCollection().entrySet().forEach(entry -> {
            WebElementSelectorMethod selectorMethod = (WebElementSelectorMethod)entry.getKey();
            if (WebElementSelectorMethod.BASIC == selectorMethod) {
                return;
            }
            element.setSelectorValue(SelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        element.setSelectorMethod(SelectorMethod.valueOf((String)webElementEntity.getGenericSelectorMethod().name()));
        webElementEntity.getSelectorCollection().entrySet().forEach(entry -> {
            WebElementSelectorMethod selectorMethod = (WebElementSelectorMethod)entry.getKey();
            if (WebElementSelectorMethod.BASIC == selectorMethod) {
                return;
            }
            element.setSelectorValue(SelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        element.setSelectorMethod(SelectorMethod.valueOf((String)webElementEntity.getGenericSelectorMethod().name()));
        webElementEntity.getSelectorCollection().entrySet().forEach(entry -> {
            WebElementSelectorMethod selectorMethod = (WebElementSelectorMethod)entry.getKey();
            if (WebElementSelectorMethod.BASIC == selectorMethod) {
                return;
            }
            element.setSelectorValue(SelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        element.setSelectorMethod(SelectorMethod.valueOf((String)webElementEntity.getGenericSelectorMethod().name()));
        webElementEntity.getSelectorCollection().entrySet().forEach(entry -> {
            WebElementSelectorMethod selectorMethod = (WebElementSelectorMethod)entry.getKey();
            if (WebElementSelectorMethod.BASIC == selectorMethod) {
                return;
            }
            element.setSelectorValue(SelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        WebElementPropertyEntity shadowProperty = webElementEntity.getProperty("ref_element_is_shadow_root");
        boolean isHasShadow = shadowProperty != null ? Boolean.parseBoolean(shadowProperty.getValue()) : false;
        WebParent webParent = element.getParent();
        if (webParent != null && !(webParent instanceof WebPage) && isHasShadow) {
            WebElementPropertyEntity shadowRef = webElementEntity.getProperty("ref_element");
            try {
                WebShadow shadowElement = (WebShadow)WebElementUtils.createWebElementFromTestObject(ObjectRepositoryController.getInstance().getWebElementByDisplayPk(shadowRef.getValue()), true, pageElement, elementsMap);
                element.setParent(shadowElement);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        elementsMap.put(entityId, element);
        return element;
    }

    public static TestObject buildTestObject(WebElement webElement) {
        TestObject testObject = new TestObject(webElement.getScriptId());
        WebParent webParent = webElement.getParent();
        if (webParent != null && !(webParent instanceof WebPage)) {
            TestObject parent = WebElementUtils.buildTestObject(webParent);
            testObject.setParentObject(parent);
        }
        webElement.getProperties().forEach(prop -> testObject.addProperty(prop.getName(), ConditionType.fromValue((String)prop.getMatchCondition()), prop.getValue(), prop.getIsSelected().booleanValue()));
        webElement.getXpaths().forEach(xpath -> testObject.addXpath(xpath.getName(), ConditionType.fromValue((String)xpath.getMatchCondition()), xpath.getValue(), xpath.getIsSelected().booleanValue()));
        if (webParent != null && WebElement.WebElementType.SHADOW == webParent.getType() && StringUtils.isNotEmpty((String)webParent.getName())) {
            testObject.setParentObjectShadowRoot(true);
            for (WebElement el : webParent.getChildren()) {
                if (!el.getName().equalsIgnoreCase(webParent.getName())) continue;
                testObject.setParentObject(WebElementUtils.buildTestObject(el));
                break;
            }
        }
        testObject.setSelectorMethod(webElement.getSelectorMethod());
        webElement.getSelectorCollection().entrySet().forEach(entry -> testObject.setSelectorValue((SelectorMethod)entry.getKey(), (String)entry.getValue()));
        testObject.setSmartSelectorCollection(webElement.getSelectorCollection());
        return testObject;
    }

    public static int getHashValue(WebElementEntity aWebElementEntity) {
        ArrayList entityProperties = new ArrayList();
        entityProperties.addAll(aWebElementEntity.getWebElementProperties());
        Collections.sort(entityProperties, new Comparator<WebElementPropertyEntity>(){

            @Override
            public int compare(WebElementPropertyEntity o1, WebElementPropertyEntity o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (WebElementPropertyEntity webElementPropertyEntity : entityProperties) {
            String propertyName = webElementPropertyEntity.getName();
            if (!propertyName.equals(ELEMENT_TAG_KEY) && !propertyName.equals(ELEMENT_TEXT_KEY) && !propertyName.equals(ELEMENT_ID_KEY) && !propertyName.equals("src") && !propertyName.equals("href") && !propertyName.equals(ELEMENT_PARENT_KEY) && !propertyName.equals("shadowroot")) continue;
            hashCodeBuilder.append((Object)webElementPropertyEntity.getValue());
        }
        return hashCodeBuilder.toHashCode();
    }

    private static String updateNewElementName(WebElement webElement) {
        WebParent webParent = webElement.getParent();
        String id = webElement.toString().substring(webElement.toString().length() - 3);
        if (webParent != null) {
            int index = webParent.getName().length() - 6 - 1;
            String parentId = webParent.getName().substring(index > 0 ? index : 0);
            return String.valueOf(webElement.getName()) + "-" + parentId + "-" + id;
        }
        return webElement.getName();
    }
}

