/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.websocket;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.objectspy.element.HTMLRawElement;
import com.kms.katalon.objectspy.util.HTMLElementUtil;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.objectspy.websocket.AddonBrowserType;
import com.kms.katalon.objectspy.websocket.AddonCommand;
import com.kms.katalon.objectspy.websocket.AddonSocketServer;
import com.kms.katalon.objectspy.websocket.messages.AddonMessage;
import com.kms.katalon.objectspy.websocket.messages.BrowserInfoMessageData;
import com.kms.katalon.objectspy.websocket.messages.KatalonVersionAddOnMessage;
import com.kms.katalon.objectspy.websocket.messages.StartInspectAddonMessage;
import com.kms.katalon.util.DocumentBuilderProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;

@ClientEndpoint
@ServerEndpoint(value="/")
public class AddonSocket {
    private static final String DATA_KEY = "data";
    private static final String COMMAND_KEY = "command";
    private static final int DEFAULT_MAX_TEXT_MESSAGE_SIZE = 0xA00000;
    public static final String TEXT_HTML = "text/html";
    protected static final String EQUALS = "=";
    protected static final String ELEMENT_KEY = "element";
    private static final String ELEMENT_MAP_KEY = "elementsMap";
    protected static final String ELEMENT_ACTION_KEY = "elementAction";
    private static final String SELENIUM_SOCKET_KEY = "SELENIUM_SOCKET";
    private Session session;
    private AddonBrowserType browserType;
    private AddonSocketServer socketServer;
    private boolean isConnected = false;

    public AddonBrowserType getBrowserType() {
        return this.browserType;
    }

    @OnOpen
    public void onWebSocketConnect(Session sess) {
        this.session = sess;
        this.isConnected = true;
        this.setupSession();
        this.socketServer = AddonSocketServer.getInstance();
        this.socketServer.addActiveSocket(this);
        this.sendMessage(new KatalonVersionAddOnMessage());
    }

    protected void seleniumSocketResponder() {
        this.sendMessage(new StartInspectAddonMessage());
    }

    private void setupSession() {
        this.session.setMaxTextMessageBufferSize(0xA00000);
    }

    public void sendMessage(AddonMessage message) {
        this.sendText(new Gson().toJson((Object)message));
    }

    private void sendText(String text) {
        try {
            RemoteEndpoint.Basic remote = this.session.getBasicRemote();
            remote.sendText(text);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @OnMessage
    public void onWebSocketText(String message) {
        if (message.indexOf(EQUALS) == -1) {
            this.handleCommandMessage(message);
            return;
        }
        this.handleOldElementMessage(message);
    }

    protected void handleOldElementMessage(String message) {
        try {
            String key;
            switch (key = HTMLElementUtil.decodeURIComponent(message.substring(0, message.indexOf(EQUALS)))) {
                case "element": {
                    this.addNewElement(message.substring(message.indexOf(EQUALS) + 1, message.length()));
                    break;
                }
                case "elementsMap": {
                    this.updateHTMLDOM(message);
                    break;
                }
                case "SELENIUM_SOCKET": {
                    System.out.println("Client is a Selenium Socket");
                    this.seleniumSocketResponder();
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void handleCommandMessage(String message) {
        try {
            Gson gson = new Gson();
            JsonElement jsonElement = new JsonParser().parse(message);
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            AddonCommand command = AddonCommand.valueOf(jsonObject.getAsJsonPrimitive(COMMAND_KEY).getAsString());
            switch (command) {
                case BROWSER_INFO: {
                    BrowserInfoMessageData data = (BrowserInfoMessageData)gson.fromJson((JsonElement)jsonObject.getAsJsonObject(DATA_KEY), BrowserInfoMessageData.class);
                    this.browserType = AddonBrowserType.getEnum(data.getBrowserName());
                    break;
                }
            }
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @OnClose
    public void onWebSocketClose(CloseReason reason) {
        this.socketServer.removeActiveSocket(this);
        this.isConnected = false;
    }

    @OnError
    public void onWebSocketError(Throwable cause) {
        LoggerSingleton.logError((Throwable)cause);
        this.socketServer.removeActiveSocket(this);
        this.isConnected = false;
    }

    private void updateHTMLDOM(String sb) {
        final String value = sb.substring(sb.indexOf(EQUALS) + 1, sb.length());
        new Thread(new Runnable(){

            @Override
            public void run() {
                Document htmlDocument = null;
                HTMLRawElement newRootElement = null;
                try {
                    DocumentBuilder docBuilder = DocumentBuilderProvider.newBuilderInstance();
                    htmlDocument = docBuilder.newDocument();
                    newRootElement = HTMLElementUtil.buildHTMLRawElement(htmlDocument, value);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                if (htmlDocument != null && newRootElement != null) {
                    EventBrokerSingleton.getInstance().getEventBroker().post("OBJECT_SPY/HTML_DOM_CAPTURED", (Object)new Object[]{newRootElement, htmlDocument});
                }
            }
        }).run();
    }

    private void addNewElement(String value) {
        try {
            EventBrokerSingleton.getInstance().getEventBroker().post("OBJECT_SPY/HTML_ELEMENT_CAPTURED", (Object)WebElementUtils.buildWebElement(value));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

