/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Directives;
import graphql.Internal;
import graphql.VisibleForTesting;
import graphql.execution.ValuesResolver;
import graphql.language.Directive;
import graphql.language.NodeUtil;
import java.util.List;
import java.util.Map;

@Internal
public class ConditionalNodes {
    @VisibleForTesting
    ValuesResolver valuesResolver = new ValuesResolver();

    public boolean shouldInclude(Map<String, Object> variables, List<Directive> directives) {
        boolean skip = this.getDirectiveResult(variables, directives, Directives.SkipDirective.getName(), false);
        boolean include = this.getDirectiveResult(variables, directives, Directives.IncludeDirective.getName(), true);
        return !skip && include;
    }

    private boolean getDirectiveResult(Map<String, Object> variables, List<Directive> directives, String directiveName, boolean defaultValue) {
        Directive foundDirective = NodeUtil.findNodeByName(directives, directiveName);
        if (foundDirective != null) {
            Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(Directives.SkipDirective.getArguments(), foundDirective.getArguments(), variables);
            Object flag = argumentValues.get("if");
            Assert.assertTrue(flag instanceof Boolean, () -> String.format("The '%s' directive MUST have a value for the 'if' argument", directiveName));
            return (Boolean)flag;
        }
        return defaultValue;
    }
}

