/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.language.Argument;
import graphql.language.AstValueHelper;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.Value;
import graphql.schema.idl.DirectiveInfo;
import graphql.schema.idl.ScalarInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@PublicApi
public class IntrospectionResultToSchema {
    public Document createSchemaDefinition(ExecutionResult introspectionResult) {
        if (!introspectionResult.isDataPresent()) {
            return null;
        }
        Map introspectionResultMap = (Map)introspectionResult.getData();
        return this.createSchemaDefinition(introspectionResultMap);
    }

    public Document createSchemaDefinition(Map<String, Object> introspectionResult) {
        Assert.assertTrue(introspectionResult.get("__schema") != null, () -> "__schema expected");
        Map schema = (Map)introspectionResult.get("__schema");
        Map queryType = (Map)schema.get("queryType");
        Assert.assertNotNull(queryType, () -> "queryType expected");
        TypeName query = TypeName.newTypeName().name((String)queryType.get("name")).build();
        boolean nonDefaultQueryName = !"Query".equals(query.getName());
        SchemaDefinition.Builder schemaDefinition = SchemaDefinition.newSchemaDefinition();
        schemaDefinition.description(this.toDescription(schema));
        schemaDefinition.operationTypeDefinition(OperationTypeDefinition.newOperationTypeDefinition().name("query").typeName(query).build());
        Map mutationType = (Map)schema.get("mutationType");
        boolean nonDefaultMutationName = false;
        if (mutationType != null) {
            TypeName mutation = TypeName.newTypeName().name((String)mutationType.get("name")).build();
            nonDefaultMutationName = !"Mutation".equals(mutation.getName());
            schemaDefinition.operationTypeDefinition(OperationTypeDefinition.newOperationTypeDefinition().name("mutation").typeName(mutation).build());
        }
        Map subscriptionType = (Map)schema.get("subscriptionType");
        boolean nonDefaultSubscriptionName = false;
        if (subscriptionType != null) {
            TypeName subscription = TypeName.newTypeName().name((String)subscriptionType.get("name")).build();
            nonDefaultSubscriptionName = !"Subscription".equals(subscription.getName());
            schemaDefinition.operationTypeDefinition(OperationTypeDefinition.newOperationTypeDefinition().name("subscription").typeName(subscription).build());
        }
        Document.Builder document = Document.newDocument();
        if (nonDefaultQueryName || nonDefaultMutationName || nonDefaultSubscriptionName) {
            document.definition(schemaDefinition.build());
        }
        List types = (List)schema.get("types");
        for (Map type : types) {
            TypeDefinition typeDefinition = this.createTypeDefinition(type);
            if (typeDefinition == null) continue;
            document.definition(typeDefinition);
        }
        List directives = (List)schema.get("directives");
        if (directives != null) {
            for (Map directive : directives) {
                DirectiveDefinition directiveDefinition = this.createDirective(directive);
                if (directiveDefinition == null) continue;
                document.definition(directiveDefinition);
            }
        }
        return document.build();
    }

    private DirectiveDefinition createDirective(Map<String, Object> input) {
        String directiveName = (String)input.get("name");
        if (DirectiveInfo.isGraphqlSpecifiedDirective(directiveName)) {
            return null;
        }
        DirectiveDefinition.Builder directiveDefBuilder = DirectiveDefinition.newDirectiveDefinition();
        directiveDefBuilder.name(directiveName).description(this.toDescription(input));
        List locations = (List)input.get("locations");
        List<DirectiveLocation> directiveLocations = this.createDirectiveLocations(locations);
        directiveDefBuilder.directiveLocations(directiveLocations);
        List args = (List)input.get("args");
        List<InputValueDefinition> inputValueDefinitions = this.createInputValueDefinitions(args);
        directiveDefBuilder.inputValueDefinitions(inputValueDefinitions);
        Optional.ofNullable((Boolean)input.get("isRepeatable")).ifPresent(value -> directiveDefBuilder.repeatable((boolean)value));
        return directiveDefBuilder.build();
    }

    private List<DirectiveLocation> createDirectiveLocations(List<Object> locations) {
        Assert.assertNotEmpty(locations, () -> "the locations of directive should not be empty.");
        ArrayList<DirectiveLocation> result = new ArrayList<DirectiveLocation>();
        for (Object location : locations) {
            DirectiveLocation directiveLocation = DirectiveLocation.newDirectiveLocation().name(location.toString()).build();
            result.add(directiveLocation);
        }
        return result;
    }

    private TypeDefinition createTypeDefinition(Map<String, Object> type) {
        String kind = (String)type.get("kind");
        String name = (String)type.get("name");
        if (name.startsWith("__")) {
            return null;
        }
        switch (kind) {
            case "INTERFACE": {
                return this.createInterface(type);
            }
            case "OBJECT": {
                return this.createObject(type);
            }
            case "UNION": {
                return this.createUnion(type);
            }
            case "ENUM": {
                return this.createEnum(type);
            }
            case "INPUT_OBJECT": {
                return this.createInputObject(type);
            }
            case "SCALAR": {
                return this.createScalar(type);
            }
        }
        return (TypeDefinition)Assert.assertShouldNeverHappen("unexpected kind %s", kind);
    }

    private TypeDefinition createScalar(Map<String, Object> input) {
        String name = (String)input.get("name");
        if (ScalarInfo.isGraphqlSpecifiedScalar(name)) {
            return null;
        }
        return ScalarTypeDefinition.newScalarTypeDefinition().name(name).description(this.toDescription(input)).build();
    }

    UnionTypeDefinition createUnion(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("UNION"), () -> "wrong input");
        UnionTypeDefinition.Builder unionTypeDefinition = UnionTypeDefinition.newUnionTypeDefinition();
        unionTypeDefinition.name((String)input.get("name"));
        unionTypeDefinition.description(this.toDescription(input));
        List possibleTypes = (List)input.get("possibleTypes");
        for (Map possibleType : possibleTypes) {
            TypeName typeName = TypeName.newTypeName().name((String)possibleType.get("name")).build();
            unionTypeDefinition.memberType(typeName);
        }
        return unionTypeDefinition.build();
    }

    EnumTypeDefinition createEnum(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("ENUM"), () -> "wrong input");
        EnumTypeDefinition.Builder enumTypeDefinition = EnumTypeDefinition.newEnumTypeDefinition().name((String)input.get("name"));
        enumTypeDefinition.description(this.toDescription(input));
        List enumValues = (List)input.get("enumValues");
        for (Map enumValue : enumValues) {
            EnumValueDefinition.Builder enumValueDefinition = EnumValueDefinition.newEnumValueDefinition().name((String)enumValue.get("name"));
            enumTypeDefinition.description(this.toDescription(input));
            this.createDeprecatedDirective(enumValue, enumValueDefinition);
            enumTypeDefinition.enumValueDefinition(enumValueDefinition.build());
        }
        return enumTypeDefinition.build();
    }

    InterfaceTypeDefinition createInterface(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("INTERFACE"), () -> "wrong input");
        InterfaceTypeDefinition.Builder interfaceTypeDefinition = InterfaceTypeDefinition.newInterfaceTypeDefinition().name((String)input.get("name"));
        interfaceTypeDefinition.description(this.toDescription(input));
        if (input.containsKey("interfaces") && input.get("interfaces") != null) {
            interfaceTypeDefinition.implementz(ImmutableKit.map((List)input.get("interfaces"), this::createTypeIndirection));
        }
        List fields = (List)input.get("fields");
        interfaceTypeDefinition.definitions(this.createFields(fields));
        return interfaceTypeDefinition.build();
    }

    InputObjectTypeDefinition createInputObject(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("INPUT_OBJECT"), () -> "wrong input");
        InputObjectTypeDefinition.Builder inputObjectTypeDefinition = InputObjectTypeDefinition.newInputObjectDefinition().name((String)input.get("name")).description(this.toDescription(input));
        List fields = (List)input.get("inputFields");
        List<InputValueDefinition> inputValueDefinitions = this.createInputValueDefinitions(fields);
        inputObjectTypeDefinition.inputValueDefinitions(inputValueDefinitions);
        return inputObjectTypeDefinition.build();
    }

    ObjectTypeDefinition createObject(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("OBJECT"), () -> "wrong input");
        ObjectTypeDefinition.Builder objectTypeDefinition = ObjectTypeDefinition.newObjectTypeDefinition().name((String)input.get("name"));
        objectTypeDefinition.description(this.toDescription(input));
        if (input.containsKey("interfaces")) {
            objectTypeDefinition.implementz(ImmutableKit.map((List)input.get("interfaces"), this::createTypeIndirection));
        }
        List fields = (List)input.get("fields");
        objectTypeDefinition.fieldDefinitions(this.createFields(fields));
        return objectTypeDefinition.build();
    }

    private List<FieldDefinition> createFields(List<Map<String, Object>> fields) {
        ArrayList<FieldDefinition> result = new ArrayList<FieldDefinition>();
        for (Map<String, Object> field : fields) {
            FieldDefinition.Builder fieldDefinition = FieldDefinition.newFieldDefinition().name((String)field.get("name"));
            fieldDefinition.description(this.toDescription(field));
            fieldDefinition.type(this.createTypeIndirection((Map)field.get("type")));
            this.createDeprecatedDirective(field, fieldDefinition);
            List args = (List)field.get("args");
            List<InputValueDefinition> inputValueDefinitions = this.createInputValueDefinitions(args);
            fieldDefinition.inputValueDefinitions(inputValueDefinitions);
            result.add(fieldDefinition.build());
        }
        return result;
    }

    private void createDeprecatedDirective(Map<String, Object> field, NodeDirectivesBuilder nodeDirectivesBuilder) {
        ArrayList<Directive> directives = new ArrayList<Directive>();
        if (((Boolean)field.get("isDeprecated")).booleanValue()) {
            String reason = (String)field.get("deprecationReason");
            if (reason == null) {
                reason = "No longer supported";
            }
            Argument reasonArg = Argument.newArgument().name("reason").value(StringValue.newStringValue().value(reason).build()).build();
            Directive deprecated = Directive.newDirective().name("deprecated").arguments(Collections.singletonList(reasonArg)).build();
            directives.add(deprecated);
        }
        nodeDirectivesBuilder.directives(directives);
    }

    private List<InputValueDefinition> createInputValueDefinitions(List<Map<String, Object>> args) {
        ArrayList<InputValueDefinition> result = new ArrayList<InputValueDefinition>();
        for (Map<String, Object> arg : args) {
            Type argType = this.createTypeIndirection((Map)arg.get("type"));
            InputValueDefinition.Builder inputValueDefinition = InputValueDefinition.newInputValueDefinition().name((String)arg.get("name")).type(argType);
            inputValueDefinition.description(this.toDescription(arg));
            String valueLiteral = (String)arg.get("defaultValue");
            if (valueLiteral != null) {
                Value<?> defaultValue = AstValueHelper.valueFromAst(valueLiteral);
                inputValueDefinition.defaultValue(defaultValue);
            }
            result.add(inputValueDefinition.build());
        }
        return result;
    }

    private Type createTypeIndirection(Map<String, Object> type) {
        String kind;
        switch (kind = (String)type.get("kind")) {
            case "INTERFACE": 
            case "OBJECT": 
            case "UNION": 
            case "ENUM": 
            case "INPUT_OBJECT": 
            case "SCALAR": {
                return TypeName.newTypeName().name((String)type.get("name")).build();
            }
            case "NON_NULL": {
                return NonNullType.newNonNullType().type(this.createTypeIndirection((Map)type.get("ofType"))).build();
            }
            case "LIST": {
                return ListType.newListType().type(this.createTypeIndirection((Map)type.get("ofType"))).build();
            }
        }
        return (Type)Assert.assertShouldNeverHappen("Unknown kind %s", kind);
    }

    private Description toDescription(Map<String, Object> input) {
        String description = (String)input.get("description");
        if (description == null) {
            return null;
        }
        String[] lines = description.split("\n");
        if (lines.length > 1) {
            return new Description(description, null, true);
        }
        return new Description(description, null, false);
    }
}

