/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.Comment;
import graphql.language.IgnoredChars;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class Directive
extends AbstractNode<Directive>
implements NamedNode<Directive> {
    private final String name;
    private final ImmutableList<Argument> arguments;
    public static final String CHILD_ARGUMENTS = "arguments";

    @Internal
    protected Directive(String name, List<Argument> arguments, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData);
        this.name = name;
        this.arguments = ImmutableList.copyOf(arguments);
    }

    public Directive(String name, List<Argument> arguments) {
        this(name, arguments, null, ImmutableKit.emptyList(), IgnoredChars.EMPTY, ImmutableKit.emptyMap());
    }

    public Directive(String name) {
        this(name, ImmutableKit.emptyList(), null, ImmutableKit.emptyList(), IgnoredChars.EMPTY, ImmutableKit.emptyMap());
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public Map<String, Argument> getArgumentsByName() {
        return NodeUtil.argumentsByName(this.arguments);
    }

    public Argument getArgument(String argumentName) {
        return NodeUtil.findNodeByName(this.arguments, argumentName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> getChildren() {
        return ImmutableList.copyOf(this.arguments);
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_ARGUMENTS, this.arguments).build();
    }

    @Override
    public Directive withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.arguments(newChildren.getChildren(CHILD_ARGUMENTS)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Directive that = (Directive)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public Directive deepCopy() {
        return new Directive(this.name, this.deepCopy(this.arguments), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "Directive{name='" + this.name + '\'' + ", arguments=" + this.arguments + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitDirective(this, context);
    }

    public static Builder newDirective() {
        return new Builder();
    }

    public Directive transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private ImmutableList<Argument> arguments = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(Directive existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.arguments = ImmutableList.copyOf(existing.getArguments());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder arguments(List<Argument> arguments) {
            this.arguments = ImmutableList.copyOf(arguments);
            return this;
        }

        public Builder argument(Argument argument) {
            this.arguments = ImmutableKit.addToList(this.arguments, argument, new Argument[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public Directive build() {
            return new Directive(this.name, this.arguments, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

