/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.Internal;
import graphql.language.BooleanValue;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;

@Internal
public class GraphqlBooleanCoercing
implements Coercing<Boolean, Boolean> {
    private Boolean convertImpl(Object input) {
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof String) {
            return Boolean.parseBoolean((String)input);
        }
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return (Boolean)Assert.assertShouldNeverHappen();
            }
            return value.compareTo(BigDecimal.ZERO) != 0;
        }
        return null;
    }

    @Override
    public Boolean serialize(Object input) {
        Boolean result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Expected type 'Boolean' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @Override
    public Boolean parseValue(Object input) {
        Boolean result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Expected type 'Boolean' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @Override
    public Boolean parseLiteral(Object input) {
        if (!(input instanceof BooleanValue)) {
            throw new CoercingParseLiteralException("Expected AST type 'BooleanValue' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return ((BooleanValue)input).isValue();
    }
}

