/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Internal;
import graphql.language.IntValue;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.math.BigInteger;

@Internal
public class GraphqlByteCoercing
implements Coercing<Byte, Byte> {
    private static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    private static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);

    private Byte convertImpl(Object input) {
        if (input instanceof Byte) {
            return (Byte)input;
        }
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
            try {
                return value.byteValueExact();
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Byte serialize(Object input) {
        Byte result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Expected type 'Byte' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @Override
    public Byte parseValue(Object input) {
        Byte result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Expected type 'Byte' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        return result;
    }

    @Override
    public Byte parseLiteral(Object input) {
        if (!(input instanceof IntValue)) {
            throw new CoercingParseLiteralException("Expected AST type 'IntValue' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        BigInteger value = ((IntValue)input).getValue();
        if (value.compareTo(BYTE_MIN) < 0 || value.compareTo(BYTE_MAX) > 0) {
            throw new CoercingParseLiteralException("Expected value to be in the Byte range but it was '" + value.toString() + "'");
        }
        return value.byteValue();
    }
}

