/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.configuration;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.setting.VideoRecorderSetting;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RunConfiguration {
    public static final String CURRENT_TESTCASE = "current_testcase";
    public static final String SMART_XPATH_BUNDLE_ID = "com.katalon.katalon-studio-smart-xpath";
    public static final String ALLOW_USING_SELF_HEALING = "allowUsingSelfHealing";
    public static final String ALLOW_USING_TIME_CAPSULE = "allowUsingTimeCapsule";
    public static final String EXCLUDE_KEYWORDS = "excludeKeywords";
    public static final String SELF_HEALING_ENABLE = "selfHealingEnabled";
    public static final String TIME_CAPSULE_ENABLE = "timeCapsuleEnabled";
    public static final String METHODS_PRIORITY_ORDER = "methodsPriorityOrder";
    public static final String OVERRIDING_GLOBAL_VARIABLES = "overridingGlobalVariables";
    public static final String REPORT_FOLDER_PATH_PROPERTY = "reportFolder";
    public static final String LOG_FILE_PATH_PROPERTY = "logFilePath";
    public static final String TIMEOUT_PROPERTY = "timeout";
    public static final String PROJECT_DIR_PROPERTY = "projectDir";
    public static final String HOST = "host";
    public static final String HOST_NAME = "hostName";
    public static final String HOST_OS = "os";
    public static final String HOST_ADDRESS = "hostAddress";
    public static final String HOST_PORT = "hostPort";
    public static final String EXECUTION_GENERAL_PROPERTY = "general";
    public static final String EXECUTION_DRIVER_PROPERTY = "drivers";
    public static final String EXECUTION_SYSTEM_PROPERTY = "system";
    public static final String EXECUTION_PREFS_PROPERTY = "preferences";
    public static final String EXECUTION_TEST_DATA_INFO_PROPERTY = "testDataInfo";
    public static final String REMOTE_DRIVER_PROPERTY = "Remote";
    public static final String EXECUTION_PROPERTY = "execution";
    public static final String EXCUTION_SOURCE = "source";
    public static final String EXCUTION_SOURCE_NAME = "name";
    public static final String EXCUTION_SOURCE_ID = "id";
    public static final String EXCUTION_SOURCE_DESCRIPTION = "description";
    public static final String APP_VERSION = "katalonVersion";
    public static final String APP_INFO_FILE_LOCATION = StringConstants.APP_INFO_FILE_LOCATION;
    public static final String SESSION_SERVER_HOST = "sessionServer.host";
    public static final String SESSION_SERVER_PORT = "sessionServer.port";
    public static final String EXCUTION_DEFAULT_FAILURE_HANDLING = "defaultFailureHandling";
    public static final String PROXY_PROPERTY = "proxy";
    public static final String IS_DEBUG_LAUNCH_MODE = "isDebugLaunchMode";
    public static final String TERMINATE_DRIVER_AFTER_TEST_CASE = "terminateDriverAfterTestCase";
    public static final String TERMINATE_DRIVER_AFTER_TEST_SUITE = "terminateDriverAfterTestSuite";
    public static final String EXECUTION_PROFILE_PROPERTY = "executionProfile";
    public static final String LOGBACK_CONFIG_FILE_LOCATION = "logbackConfigFileLocation";
    public static final String RUNNING_MODE = "runningMode";
    public static final String RECORD_CAPTURED_OBJECTS_FILE = "recordCapturedObjectsCache";
    public static final String AUTO_APPLY_NEIGHBOR_XPATHS = "autoApplyNeighborXpaths";
    public static final String PLUGIN_TEST_LISTENERS = "pluginTestListeners";
    public static final String LOCAL_SMART_WAIT_MODE = "localSmartWaitEnabled";
    public static final String GLOBAL_SMART_WAIT_MODE = "globalSmartWaitEnabled";
    public static final String SMART_LOCATOR_MODE = "smartLocatorEnabled";
    public static final String LOG_TEST_STEPS = "logTestSteps";
    public static final String HIDE_HOSTNAME = "hideHostname";
    public static final String XPATHS_PRIORITY = "xpathsPriority";
    public static final String ALLOW_CUSTOMIZE_REQUEST_TIMEOUT = "allowCustomizeRequestTimeout";
    public static final String REQUEST_CONNECTION_TIMEOUT = "requestConnectionTimeout";
    public static final String REQUEST_SOCKET_TIMEOUT = "requestSocketTimeout";
    public static final String REQUEST_ENABLE_HAR_FILE_GENERATION = "requestEnableHarFileGeneration";
    public static final String ALLOW_CUSTOMIZE_REQUEST_RESPONSE_SIZE_LIMIT = "allowCustomizeRequestResponseSizeLimit";
    public static final String REQUEST_MAX_RESPONSE_SIZE = "maxResponseSize";
    public static final String VM_ARGUMENTS = "vmArguments";
    public static final String TC_RETRY_FAILED_EXECUTIONS_ONLY = "retryFailedExecutionsOnlyTcBinding";
    public static final String TC_RETRY_IMMEDIATELY_BINDINGS = "retryImmediatelyTcBinding";
    public static final String HTTPS_PROTOCOL = "httpsProtocol";
    public static final String FAILED_TEST_THRESHOLD = "maxFailedTests";
    public static final String APPIUM_DIRECTORY = "appiumDirectory";
    public static final String RESTRICT_CUSTOM_KEYWORDS = "restrictCustomKeywords";
    private static String settingFilePath;
    private static RunConfiguration _instance;
    private boolean isLaunchingDebugMode = false;
    private String appiumDirectoryDefinedWithArgument;
    private static final ThreadLocal<Map<String, Object>> localExecutionSettingMapStorage;
    private static final ThreadLocal<String> localAppiumDriverStores;
    private static final ThreadLocal<List<Object>> localDriverStorage;
    private static final ThreadLocal<Properties> applicationInfo;

    static {
        localExecutionSettingMapStorage = new InheritableThreadLocal<Map<String, Object>>(){

            @Override
            protected Map<String, Object> initialValue() {
                return new HashMap<String, Object>();
            }
        };
        localAppiumDriverStores = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return new String();
            }
        };
        localDriverStorage = new ThreadLocal<List<Object>>(){

            @Override
            protected List<Object> initialValue() {
                return new ArrayList<Object>();
            }
        };
        applicationInfo = new ThreadLocal<Properties>(){

            @Override
            protected Properties initialValue() {
                File appPropFile = new File(APP_INFO_FILE_LOCATION);
                Properties appProp = new Properties();
                if (!appPropFile.exists()) {
                    return appProp;
                }
                try {
                    appProp.load(new FileInputStream(appPropFile));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
                return appProp;
            }
        };
    }

    private RunConfiguration() {
    }

    public static RunConfiguration getInstance() {
        if (_instance == null) {
            _instance = new RunConfiguration();
        }
        return _instance;
    }

    public static void setAppiumLogFilePath(String logFilePath) {
        if (logFilePath == null) {
            return;
        }
        localAppiumDriverStores.set(logFilePath);
    }

    public static void setExecutionSettingFile(String executionSettingFilePath) {
        if (executionSettingFilePath == null) {
            return;
        }
        settingFilePath = executionSettingFilePath;
        File executionSettingFile = new File(executionSettingFilePath);
        if (executionSettingFile.exists() && executionSettingFile.isFile()) {
            Gson gsonObj = new Gson();
            try {
                String propertyConfigFileContent = FileUtils.readFileToString((File)executionSettingFile);
                Type collectionType = new TypeToken<Map<String, Object>>(){}.getType();
                Map result = (Map)gsonObj.fromJson(propertyConfigFileContent, collectionType);
                if (result != null) {
                    localExecutionSettingMapStorage.set(result);
                }
            }
            catch (IOException iOException) {
            }
            catch (JsonSyntaxException jsonSyntaxException) {}
        }
    }

    public static void setExecutionSetting(Map<String, Object> executionSettingMap) {
        if (executionSettingMap == null) {
            return;
        }
        localExecutionSettingMapStorage.set(executionSettingMap);
    }

    public static void setWebDriverPreferencesProperty(String propName, Object propVal) {
        RunConfiguration.setDriverPreferencesProperty("WebUI", propName, propVal);
    }

    public static void setMobileDriverPreferencesProperty(String propName, Object propVal) {
        RunConfiguration.setDriverPreferencesProperty("Mobile", propName, propVal);
    }

    private static void setDriverPreferencesProperty(String driverType, String propName, Object propVal) {
        Map<String, Object> props = RunConfiguration.getDriverPreferencesProperties(driverType);
        if (props != null) {
            props.put(propName, propVal);
        }
    }

    public static Object getProperty(String propertyKey) {
        return localExecutionSettingMapStorage.get().get(propertyKey);
    }

    public static String getStringProperty(String propertyKey) {
        return String.valueOf(RunConfiguration.getProperty(propertyKey));
    }

    public static String getStringProperty(String propertyKey, Map<String, Object> jsonObjProperties) {
        return String.valueOf(jsonObjProperties.get(propertyKey));
    }

    public static int getIntProperty(String propertyKey, Map<String, Object> jsonObjProperties) {
        if (jsonObjProperties == null) {
            return 0;
        }
        Number doubleValue = (Number)jsonObjProperties.get(propertyKey);
        return doubleValue.intValue();
    }

    public static boolean getBooleanProperty(String propertyKey, Map<String, Object> jsonObjProperties) {
        return Boolean.valueOf(RunConfiguration.getStringProperty(propertyKey, jsonObjProperties));
    }

    public static Map<String, Object> getDriverExecutionProperties(String driverName) {
        Map driverProps = (Map)RunConfiguration.getExecutionProperties().get(EXECUTION_DRIVER_PROPERTY);
        return (Map)driverProps.get(driverName);
    }

    public static String getDriverSystemProperty(String driverConnectorId, String propertyName) {
        Map<String, Object> properties = RunConfiguration.getDriverSystemProperties(driverConnectorId);
        return properties != null ? (String)properties.get(propertyName) : null;
    }

    public static String getDriverSystemProperty(String driverConnectorId, String propertyName, String defaultValue) {
        Map<String, Object> properties = RunConfiguration.getDriverSystemProperties(driverConnectorId);
        if (properties != null && properties.get(propertyName) != null) {
            return String.valueOf(properties.get(propertyName));
        }
        return defaultValue;
    }

    public static String getDriverPreferencesProperty(String driverConnectorId, String propertyName) {
        Map<String, Object> properties = RunConfiguration.getDriverPreferencesProperties(driverConnectorId);
        return properties != null ? (String)properties.get(propertyName) : null;
    }

    public static Map<String, Object> getDriverSystemProperties(String driverConnectorId) {
        Map<String, Object> systemProperties = RunConfiguration.getDriverExecutionProperties(EXECUTION_SYSTEM_PROPERTY);
        return systemProperties.containsKey(driverConnectorId) ? (Map)systemProperties.get(driverConnectorId) : null;
    }

    public static Map<String, Object> getDriverPreferencesProperties(String driverConnectorId) {
        return (Map)RunConfiguration.getDriverPreferencesProperties().get(driverConnectorId);
    }

    public static Map<String, Object> getDriverPreferencesProperties() {
        return RunConfiguration.getDriverExecutionProperties(EXECUTION_PREFS_PROPERTY);
    }

    public static Map<String, Object> getHostProperties() {
        return (Map)localExecutionSettingMapStorage.get().get(HOST);
    }

    public static int getIntProperty(String propertyKey) {
        Number doubleValue = (Number)RunConfiguration.getProperty(propertyKey);
        return doubleValue.intValue();
    }

    public static String getSettingFilePath() {
        return settingFilePath;
    }

    public static String getLogFolderPath() {
        String logFilePath = RunConfiguration.getSettingFilePath();
        return logFilePath != null ? new File(logFilePath).getParentFile().getAbsolutePath() : "";
    }

    public static String getAppiumLogFilePath() {
        if (StringUtils.isBlank((String)localAppiumDriverStores.get())) {
            String appiumLogFilePath = String.valueOf(RunConfiguration.getLogFolderPath()) + File.separator + RunConfiguration.getDriverSystemProperty("Mobile", "appiumLogFile");
            localAppiumDriverStores.set(appiumLogFilePath);
        }
        return localAppiumDriverStores.get();
    }

    public static String getAppiumDirectory() {
        String appiumDirectoryDefinedWithArgument = RunConfiguration.getStringProperty(APPIUM_DIRECTORY);
        boolean doesAppiumDirectoryDefinedWithArgumentExist = !appiumDirectoryDefinedWithArgument.equals("null") && !appiumDirectoryDefinedWithArgument.isBlank();
        return doesAppiumDirectoryDefinedWithArgumentExist ? appiumDirectoryDefinedWithArgument : RunConfiguration.getDriverSystemProperty("Mobile", APPIUM_DIRECTORY);
    }

    public void setAppiumDirectoryDefinedWithArgument(String appiumDirectory) {
        this.appiumDirectoryDefinedWithArgument = appiumDirectory;
    }

    public String getAppiumDirectoryDefinedWithArgument() {
        return this.appiumDirectoryDefinedWithArgument;
    }

    public static String getDeviceConsoleExecutable() {
        return RunConfiguration.getDriverSystemProperty("Mobile", "deviceConsolePath");
    }

    public static int getTimeOut() {
        return RunConfiguration.getIntProperty(TIMEOUT_PROPERTY, RunConfiguration.getExecutionGeneralProperties());
    }

    public static String getProjectDir() {
        return RunConfiguration.getStringProperty(PROJECT_DIR_PROPERTY);
    }

    public static String getExecutionSource() {
        return RunConfiguration.getStringProperty(EXCUTION_SOURCE);
    }

    public static String getExecutionSourceName() {
        return RunConfiguration.getStringProperty(EXCUTION_SOURCE_NAME);
    }

    public static String getExecutionSourceId() {
        return RunConfiguration.getStringProperty(EXCUTION_SOURCE_ID);
    }

    public static String getExecutionSourceDescription() {
        return RunConfiguration.getStringProperty(EXCUTION_SOURCE_DESCRIPTION);
    }

    public static int getSessionServerPort() {
        return RunConfiguration.getIntProperty(SESSION_SERVER_PORT);
    }

    public static String getSessionServerHost() {
        return RunConfiguration.getStringProperty(SESSION_SERVER_HOST);
    }

    public static String getExistingSessionSessionId() {
        return RunConfiguration.getDriverSystemProperty("Existing", "existingSession.sessionId");
    }

    public static String getExistingSessionServerUrl() {
        return RunConfiguration.getDriverSystemProperty("Existing", "existingSession.serverUrl");
    }

    public static String getExistingSessionDriverType() {
        return RunConfiguration.getDriverSystemProperty("Existing", "existingSession.driverType");
    }

    public static String getHostName() {
        return RunConfiguration.getStringProperty(HOST_NAME, RunConfiguration.getHostProperties());
    }

    public static String getOS() {
        return RunConfiguration.getStringProperty(HOST_OS, RunConfiguration.getHostProperties());
    }

    public static int getPort() {
        return RunConfiguration.getIntProperty(HOST_PORT, RunConfiguration.getHostProperties());
    }

    public static String getHostAddress() {
        return RunConfiguration.getStringProperty(HOST_ADDRESS, RunConfiguration.getHostProperties());
    }

    public static Map<String, Object> getExecutionProperties() {
        return (Map)RunConfiguration.getProperty(EXECUTION_PROPERTY);
    }

    public static Map<String, Object> getExecutionGeneralProperties() {
        return (Map)RunConfiguration.getExecutionProperties().get(EXECUTION_GENERAL_PROPERTY);
    }

    public static String getLogbackConfigFileLocation() {
        return RunConfiguration.getStringProperty(LOGBACK_CONFIG_FILE_LOCATION);
    }

    public static Object[] getStoredDrivers() {
        return localDriverStorage.get().toArray();
    }

    public static void storeDriver(Object driver) {
        if (!localDriverStorage.get().contains(driver)) {
            localDriverStorage.get().add(driver);
        }
    }

    public static void removeDriver(Object driver) {
        if (localDriverStorage.get().contains(driver)) {
            localDriverStorage.get().remove(driver);
        }
    }

    public static String getAppVersion() {
        return RunConfiguration.getProperty("katalon.versionNumber") + "." + RunConfiguration.getProperty("katalon.buildNumber");
    }

    public static FailureHandling getDefaultFailureHandling() {
        try {
            return FailureHandling.valueOf(RunConfiguration.getStringProperty(EXCUTION_DEFAULT_FAILURE_HANDLING, RunConfiguration.getExecutionGeneralProperties()));
        }
        catch (NullPointerException nullPointerException) {
            return FailureHandling.STOP_ON_FAILURE;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return FailureHandling.STOP_ON_FAILURE;
        }
    }

    public static Map<String, String> getCollectedTestDataProperties() {
        Map<String, Object> generalProperties = RunConfiguration.getExecutionGeneralProperties();
        return (Map)generalProperties.get(EXECUTION_TEST_DATA_INFO_PROPERTY);
    }

    public static ProxyInformation getProxyInformation() {
        Map<String, Object> generalProperties = RunConfiguration.getExecutionGeneralProperties();
        if (!generalProperties.containsKey(PROXY_PROPERTY)) {
            return null;
        }
        Gson gson = new Gson();
        ProxyInformation proxyInfo = (ProxyInformation)gson.fromJson((String)generalProperties.get(PROXY_PROPERTY), ProxyInformation.class);
        String password = proxyInfo.getPassword();
        if (!StringUtils.isEmpty((String)password)) {
            try {
                CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)password);
                proxyInfo.setPassword(CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo));
            }
            catch (IOException | GeneralSecurityException exception) {}
        }
        return proxyInfo;
    }

    public static boolean shouldTerminateDriverAfterTestCase() {
        Map<String, Object> generalProperties = RunConfiguration.getExecutionGeneralProperties();
        if (generalProperties == null) {
            return false;
        }
        return (Boolean)generalProperties.getOrDefault(TERMINATE_DRIVER_AFTER_TEST_CASE, false);
    }

    public static boolean shouldTerminateDriverAfterTestSuite() {
        Map<String, Object> generalProperties = RunConfiguration.getExecutionGeneralProperties();
        if (generalProperties == null) {
            return false;
        }
        return (Boolean)generalProperties.getOrDefault(TERMINATE_DRIVER_AFTER_TEST_SUITE, false);
    }

    public static String getExecutionProfile() {
        Map<String, Object> generalProperties = RunConfiguration.getExecutionGeneralProperties();
        if (generalProperties == null) {
            return "default";
        }
        return (String)generalProperties.getOrDefault(EXECUTION_PROFILE_PROPERTY, "default");
    }

    private static Map<String, Object> getReportProperties() {
        Map<String, Object> generalProperties = RunConfiguration.getExecutionGeneralProperties();
        if (generalProperties == null) {
            return Collections.emptyMap();
        }
        return generalProperties.getOrDefault("report", Collections.emptyMap());
    }

    public static String getReportFolder() {
        return (String)RunConfiguration.getReportProperties().getOrDefault(REPORT_FOLDER_PATH_PROPERTY, "");
    }

    public static VideoRecorderSetting getRecorderSetting() {
        return JsonUtil.fromJson(JsonUtil.toJson(RunConfiguration.getReportProperties().getOrDefault("videoRecorderOption", "")), VideoRecorderSetting.class);
    }

    public static String getCapturedObjectsCacheFile() {
        return RunConfiguration.getStringProperty(RECORD_CAPTURED_OBJECTS_FILE);
    }

    public static Boolean shouldApplySelfHealing() {
        try {
            boolean isSelfHealingEnabled = (Boolean)RunConfiguration.getExecutionGeneralProperties().get(SELF_HEALING_ENABLE);
            boolean allowUsingSmartXPath = (Boolean)RunConfiguration.getProperty(ALLOW_USING_SELF_HEALING);
            if (isSelfHealingEnabled && allowUsingSmartXPath) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Boolean shouldApplyTimeCapsule() {
        try {
            boolean isTimeCapsuleEnabled = (Boolean)RunConfiguration.getExecutionGeneralProperties().get(TIME_CAPSULE_ENABLE);
            boolean allowUsingTimeCapsule = (Boolean)RunConfiguration.getProperty(ALLOW_USING_TIME_CAPSULE);
            if (isTimeCapsuleEnabled && allowUsingTimeCapsule) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<Pair<SelectorMethod, Boolean>> getMethodsPriorityOrder() {
        Map<String, Object> generalProperties = RunConfiguration.getExecutionGeneralProperties();
        List rawMethodsPriorityOrder = (List)generalProperties.get(METHODS_PRIORITY_ORDER);
        ArrayList<Pair<SelectorMethod, Boolean>> methodsPriorityOrder = new ArrayList<Pair<SelectorMethod, Boolean>>();
        rawMethodsPriorityOrder.stream().forEachOrdered(rawMethod -> {
            String key = (String)rawMethod.get((Object)"left");
            Pair method = Pair.of((Object)((Object)SelectorMethod.valueOf(key)), (Object)((Boolean)rawMethod.get((Object)"right")));
            methodsPriorityOrder.add(method);
        });
        return methodsPriorityOrder;
    }

    public static List<String> getExcludedKeywordsFromSelfHealing() {
        Map<String, Object> generalProperties = RunConfiguration.getExecutionGeneralProperties();
        List excludeKeywords = (List)generalProperties.get(EXCLUDE_KEYWORDS);
        return excludeKeywords;
    }

    public static RunningMode getRunningMode() {
        return RunningMode.valueOf(RunConfiguration.getStringProperty(RUNNING_MODE));
    }

    public static Map<String, Object> getOverridingParameters() {
        Map overridingParameters = (Map)RunConfiguration.getProperty(OVERRIDING_GLOBAL_VARIABLES);
        if (overridingParameters == null) {
            return new HashMap<String, Object>();
        }
        return overridingParameters;
    }

    public static List<String> getPluginTestListeners() {
        Object testListeners = RunConfiguration.getProperty(PLUGIN_TEST_LISTENERS);
        if (testListeners != null) {
            return (List)testListeners;
        }
        return Collections.emptyList();
    }

    public static String getOverridingGlobalVariable(String globalVariableName) {
        Object object = RunConfiguration.getOverridingParameters().get(globalVariableName);
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    public static List<Pair<String, Boolean>> getXPathsPriority() {
        List rawXPathsPriority = RunConfiguration.getExecutionGeneralProperties().getOrDefault(XPATHS_PRIORITY, Collections.emptyList());
        ArrayList<Pair<String, Boolean>> xpathPriority = new ArrayList<Pair<String, Boolean>>();
        rawXPathsPriority.stream().forEachOrdered(rawXPath -> {
            Pair xpath = Pair.of((Object)((String)rawXPath.get((Object)"left")), (Object)((Boolean)rawXPath.get((Object)"right")));
            xpathPriority.add(xpath);
        });
        return xpathPriority;
    }

    public static boolean canCustomizeRequestTimeout() {
        return Boolean.TRUE.equals(RunConfiguration.getProperty(ALLOW_CUSTOMIZE_REQUEST_TIMEOUT));
    }

    public static boolean canCustomizeRequestResponseSizeLimit() {
        return Boolean.TRUE.equals(RunConfiguration.getProperty(ALLOW_CUSTOMIZE_REQUEST_RESPONSE_SIZE_LIMIT));
    }

    public static boolean getHarFileGeneration() {
        boolean enableHarFileGeneration = !RunConfiguration.getExecutionGeneralProperties().containsKey(REQUEST_ENABLE_HAR_FILE_GENERATION) ? true : (Boolean)RunConfiguration.getExecutionGeneralProperties().get(REQUEST_ENABLE_HAR_FILE_GENERATION);
        return enableHarFileGeneration;
    }

    public static int getFailedTestThreshold() {
        Number failedTestThreshold = (Number)RunConfiguration.getProperty(FAILED_TEST_THRESHOLD);
        if (failedTestThreshold != null) {
            return failedTestThreshold.intValue();
        }
        return -1;
    }

    public static boolean isRunningDebugMode() {
        return Boolean.TRUE.equals(RunConfiguration.getProperty(IS_DEBUG_LAUNCH_MODE));
    }

    public void setLaunchingDebugMode(boolean isLaunchingDebugMode) {
        this.isLaunchingDebugMode = isLaunchingDebugMode;
    }

    public boolean isLaunchingDebugMode() {
        return this.isLaunchingDebugMode;
    }

    public static boolean isHideHostname() {
        if (RunConfiguration.getExecutionProperties() == null || RunConfiguration.getExecutionProperties().size() == 0) {
            return false;
        }
        return Boolean.TRUE.equals(RunConfiguration.getExecutionProperties().get(HIDE_HOSTNAME));
    }
}

