/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.context.internal;

import com.kms.katalon.core.constants.CoreMessageConstants;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.ExecutionListenerEventHandler;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.event.EventBusSingleton;
import com.kms.katalon.core.event.TestingEvent;
import com.kms.katalon.core.helper.screenrecorder.CDTVideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.Recorder;
import com.kms.katalon.core.helper.screenrecorder.VideoConfiguration;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderBuilder;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderException;
import com.kms.katalon.core.helper.screenrecorder.VideoSubtitleWriter;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.setting.VideoRecorderSetting;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.TestOpsUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.openqa.selenium.WebDriver;

public class VideoRecorderService
implements ExecutionListenerEventHandler {
    private static final String VIDEO_KEYWORD_NAME = "Video";
    private static final String VIDEOS_FOLDER_NAME = "videos";
    private static final String SCREEN_RECORDING_NAME_PATTERN = "screen_recording_%d_%d";
    private static final String BROWSER_RECORDING_NAME_PATTERN = "browser_recording_%d_%d";
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private String reportFolder;
    private VideoRecorderSetting videoRecorderSetting;
    private long actionStartTime = 0L;
    private VideoRecorder screenRecorder;
    private VideoRecorder browserRecorder;
    private VideoSubtitleWriter screenRecorderSubWriter;
    private int prevStepIndex = 0;
    private String prevStepName;
    private String prevStepDescription;
    private InternalTestCaseContext lastestTestCaseContext;

    public VideoRecorderService(String reportFolder, VideoRecorderSetting videoRecorderSetting) {
        this.reportFolder = reportFolder;
        this.videoRecorderSetting = videoRecorderSetting;
        EventBusSingleton.getInstance().getEventBus().register((Object)this);
    }

    private boolean shouldRecord() {
        return this.isEnableScreenRecorder() || this.isEnableBrowserRecorder();
    }

    private boolean isEnableScreenRecorder() {
        return this.videoRecorderSetting.isEnable() && !this.videoRecorderSetting.isUseBrowserRecorder() && (this.videoRecorderSetting.isAllowedRecordIfPassed() || this.videoRecorderSetting.isAllowedRecordIfFailed());
    }

    private boolean isEnableBrowserRecorder() {
        return this.videoRecorderSetting.isEnable() && this.videoRecorderSetting.isUseBrowserRecorder();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onTestingEvent(TestingEvent event) {
        switch (event.getType()) {
            case BROWSER_OPENED: {
                if (!this.isEnableBrowserRecorder()) break;
                this.startBrowserRecorder((WebDriver)event.getData());
                break;
            }
        }
    }

    @Override
    public void handleListenerEvent(ExecutionListenerEvent listenerEvent, Object[] testContext) {
        if (!this.shouldRecord()) {
            return;
        }
        switch (listenerEvent) {
            case BEFORE_TEST_CASE: {
                this.lastestTestCaseContext = (InternalTestCaseContext)testContext[0];
                if (!this.isMainTestCase() || this.isSkippedTestCase()) {
                    return;
                }
                if (this.isEnableScreenRecorder()) {
                    this.startScreenRecorder();
                }
                if (!this.isEnableBrowserRecorder()) break;
                this.startBrowserRecorder(null);
                break;
            }
            case AFTER_TEST_CASE: {
                this.lastestTestCaseContext = (InternalTestCaseContext)testContext[0];
                if (!this.isMainTestCase() || this.isSkippedTestCase()) {
                    return;
                }
                try {
                    this.flushSubTitles();
                    if (this.isEnableBrowserRecorder()) {
                        this.stopBrowserRecording();
                    }
                    if (!this.isEnableScreenRecorder()) break;
                    this.stopScreenRecording();
                }
                catch (VideoRecorderException error) {
                    this.logger.logError(ExceptionsUtil.getStackTraceForThrowable(error));
                }
                break;
            }
            case BEFORE_TEST_STEP: {
                if (!this.isMainTestCase() || this.isSkippedTestCase()) {
                    return;
                }
                this.safeWriteSub((Integer)testContext[0], (String)testContext[1], (String)testContext[2]);
                break;
            }
            case AFTER_TEST_STEP: {
                break;
            }
        }
    }

    private void startBrowserRecorder(WebDriver webDriver) {
        try {
            boolean isNewTestCase;
            String videoFolderName = this.getVideoFolder();
            int testCaseIndex = this.lastestTestCaseContext.getTestCaseIndex();
            String videoFileName = this.getBrowserRecordingName(testCaseIndex + 1);
            VideoConfiguration cdtVideoConfig = this.videoRecorderSetting.toVideoConfiguration();
            cdtVideoConfig.setRecorder(Recorder.CDT);
            VideoRecorder newBrowserRecorder = VideoRecorderBuilder.get().setVideoConfig(cdtVideoConfig).setOutputDirLocation(videoFolderName).setOutputVideoName(videoFileName).create();
            boolean bl = isNewTestCase = this.browserRecorder == null || !StringUtils.equals((String)this.browserRecorder.getCurrentVideoLocation(), (String)newBrowserRecorder.getCurrentVideoLocation());
            if (webDriver == null && this.browserRecorder != null && this.browserRecorder.getDelegate() instanceof CDTVideoRecorder) {
                webDriver = ((CDTVideoRecorder)this.browserRecorder.getDelegate()).getDriver();
            }
            if (isNewTestCase) {
                this.browserRecorder = newBrowserRecorder;
                ((CDTVideoRecorder)this.browserRecorder.getDelegate()).setDriver(webDriver);
                this.browserRecorder.start();
                this.startVideoSubWriter(videoFolderName, videoFileName);
            } else {
                ((CDTVideoRecorder)this.browserRecorder.getDelegate()).setDriver(webDriver);
                this.browserRecorder.resume();
            }
        }
        catch (VideoRecorderException error) {
            this.logger.logError(ExceptionsUtil.getStackTraceForThrowable(error));
        }
    }

    private void startScreenRecorder() {
        System.out.println(MessageFormat.format(CoreMessageConstants.EXEC_LOG_START_RECORDING_VIDEO, this.lastestTestCaseContext.getTestCaseId()));
        int testCaseIndex = this.lastestTestCaseContext.getTestCaseIndex();
        try {
            String videoFolderName = this.getVideoFolder();
            String videoFileName = this.getScreenRecordingName(testCaseIndex + 1);
            this.screenRecorder = VideoRecorderBuilder.get().setVideoConfig(this.videoRecorderSetting.toVideoConfiguration()).setOutputDirLocation(videoFolderName).setOutputVideoName(videoFileName).create();
            this.startVideoSubWriter(videoFolderName, videoFileName);
            this.screenRecorder.start();
        }
        catch (VideoRecorderException error) {
            this.logger.logError(ExceptionsUtil.getStackTraceForThrowable(error));
        }
    }

    private void startVideoSubWriter(String videoFolderName, String videoFileName) {
        this.screenRecorderSubWriter = new VideoSubtitleWriter(new File(videoFolderName, videoFileName).getAbsolutePath());
    }

    private void flushSubTitles() {
        this.safeWriteSub(0, null, null);
    }

    private void safeWriteSub(int stepIndex, String stepDescription, String stepName) {
        try {
            this.writeSub(stepIndex, stepDescription, stepName);
        }
        catch (IOException error) {
            this.logger.logError(ExceptionsUtil.getStackTraceForThrowable(error));
        }
    }

    private void writeSub(int stepIndex, String stepDescription, String stepName) throws IOException {
        String description = StringUtils.defaultIfEmpty((String)this.prevStepDescription, (String)this.prevStepName);
        if (StringUtils.isNotBlank((String)description) && this.screenRecorderSubWriter != null) {
            long subStartTime = Math.max(this.actionStartTime - this.getStartTime(), 0L);
            long subEndTime = Math.max(System.currentTimeMillis() - this.getStartTime(), 0L);
            if (this.getStartTime() == 0L) {
                subStartTime = 0L;
                subEndTime = 0L;
            }
            this.screenRecorderSubWriter.writeSub(subStartTime, subEndTime, String.format("%d. %s", this.prevStepIndex + 1, description));
        }
        this.prevStepIndex = stepIndex;
        this.prevStepName = stepName;
        this.prevStepDescription = stepDescription;
        this.actionStartTime = System.currentTimeMillis();
    }

    private void stopBrowserRecording() throws VideoRecorderException {
        if (this.browserRecorder == null || !this.browserRecorder.isStarted()) {
            return;
        }
        this.browserRecorder.stop();
        if (this.isTestCaseSkipped() || this.isTestCasePassed() && !this.videoRecorderSetting.isRecordAllTestCases()) {
            this.browserRecorder.delete();
            if (this.screenRecorderSubWriter != null) {
                this.screenRecorderSubWriter.delete();
            }
        } else {
            String videoLocation = this.browserRecorder.getCurrentVideoLocation();
            this.logVideoRecordingStep(videoLocation);
        }
    }

    private void stopScreenRecording() throws VideoRecorderException {
        if (this.screenRecorder == null || !this.screenRecorder.isStarted()) {
            return;
        }
        this.screenRecorder.stop();
        if (this.isTestCaseSkipped() || this.isTestCasePassed() && !this.videoRecorderSetting.isAllowedRecordIfPassed() || this.isTestCaseFailed() && !this.videoRecorderSetting.isAllowedRecordIfFailed()) {
            this.screenRecorder.delete();
            if (this.screenRecorderSubWriter != null) {
                this.screenRecorderSubWriter.delete();
            }
        } else {
            String videoLocation = this.screenRecorder.getCurrentVideoLocation();
            this.logVideoRecordingStep(videoLocation);
        }
    }

    private long getStartTime() {
        if (this.isEnableBrowserRecorder()) {
            return this.browserRecorder.getStartTime();
        }
        if (this.isEnableScreenRecorder()) {
            return this.screenRecorder.getStartTime();
        }
        return 0L;
    }

    private boolean isSkippedTestCase() {
        return this.lastestTestCaseContext != null && this.lastestTestCaseContext.isSkipped();
    }

    private boolean isMainTestCase() {
        return this.lastestTestCaseContext != null && this.lastestTestCaseContext.isMainTestCase();
    }

    private boolean isTestCaseFailed() {
        String testCaseStatus = this.lastestTestCaseContext.getTestCaseStatus();
        return TestStatus.TestStatusValue.valueOf(testCaseStatus) == TestStatus.TestStatusValue.FAILED;
    }

    private boolean isTestCasePassed() {
        String testCaseStatus = this.lastestTestCaseContext.getTestCaseStatus();
        return TestStatus.TestStatusValue.valueOf(testCaseStatus) == TestStatus.TestStatusValue.PASSED;
    }

    private boolean isTestCaseSkipped() {
        String testCaseStatus = this.lastestTestCaseContext.getTestCaseStatus();
        return TestStatus.TestStatusValue.valueOf(testCaseStatus) == TestStatus.TestStatusValue.SKIPPED;
    }

    private void logVideoRecordingStep(String videoLocation) {
        if (StringUtils.isBlank((String)videoLocation)) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("video-attachment", TestOpsUtil.getRelativePathForLog(videoLocation));
        String message = MessageFormat.format(CoreMessageConstants.EXEC_LOG_VIDEO_RECORDING_COMPLETED, this.lastestTestCaseContext.getTestCaseId());
        this.logger.startKeyword(VIDEO_KEYWORD_NAME, new HashMap<String, String>(), new Stack<KeywordLogger.KeywordStackElement>());
        this.logger.logInfo(message, attributes);
        this.logger.endKeyword(VIDEO_KEYWORD_NAME, new HashMap<String, String>(), new Stack<KeywordLogger.KeywordStackElement>());
    }

    private String getVideoFolder() {
        String rawPath = FilenameUtils.concat((String)this.reportFolder, (String)VIDEOS_FOLDER_NAME);
        return FilenameUtils.separatorsToSystem((String)rawPath);
    }

    private String getBrowserRecordingName(int id) {
        return this.getVideoRecordingName(BROWSER_RECORDING_NAME_PATTERN, id, this.lastestTestCaseContext.getRetryIndex());
    }

    private String getScreenRecordingName(int id) {
        return this.getVideoRecordingName(SCREEN_RECORDING_NAME_PATTERN, id, this.lastestTestCaseContext.getRetryIndex());
    }

    private String getVideoRecordingName(String pattern, int id, int retryIndex) {
        return String.format(pattern, id, retryIndex);
    }
}

