/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.db;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.db.ListResultSetHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;

public class SqlRunner
implements AutoCloseable {
    private Connection connection;
    private PreparedStatement preparedStatement;
    private QueryRunner queryRunner;
    private String query;
    private Object[] params;

    public SqlRunner(DatabaseConnection databaseConnection, String query) throws SQLException {
        this(databaseConnection.getConnection(), query);
    }

    public SqlRunner(DatabaseConnection databaseConnection, String query, Object[] params) throws SQLException {
        this(databaseConnection.getConnection(), query, params);
    }

    public SqlRunner(Connection connection, String query) throws SQLException {
        if (connection == null || connection.isClosed()) {
            throw new SQLException(StringConstants.EXC_DATABASE_CONNECTION_IS_CLOSED);
        }
        this.prepare(connection, query);
    }

    public SqlRunner(Connection connection, String query, Object[] params) throws SQLException {
        this(connection, query);
        this.params = params;
        this.queryRunner.fillStatement(this.preparedStatement, this.params);
    }

    private void prepare(Connection conn, String query) throws SQLException {
        this.connection = conn;
        this.connection.setAutoCommit(false);
        this.connection.setReadOnly(true);
        this.queryRunner = new QueryRunner();
        this.query = query;
        this.preparedStatement = this.connection.prepareStatement(this.query);
        try {
            this.preparedStatement.closeOnCompletion();
        }
        catch (SQLException sQLException) {}
    }

    public ResultSet query() throws SQLException {
        return this.preparedStatement.executeQuery();
    }

    public <T> T query(ListResultSetHandler<T> resultSetHandler) throws SQLException {
        if (this.params == null) {
            return (T)this.queryRunner.query(this.connection, this.query, resultSetHandler);
        }
        return (T)this.queryRunner.query(this.connection, this.query, resultSetHandler, this.params);
    }

    @Override
    public void close() {
        DbUtils.closeQuietly((Connection)this.connection);
    }

    public boolean isConnectionAlive() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }
}

