/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EventEmitter {
    Map<String, List<CustomEventListener>> listenerMap = new HashMap<String, List<CustomEventListener>>();

    public <EventType extends Enum<EventType>> void on(EventType eventType, CustomEventListener listener) {
        this.on(eventType.name(), listener);
    }

    public void on(String eventType, CustomEventListener listener) {
        this.getListeners(eventType).add(listener);
    }

    public <EventType extends Enum<EventType>> void off(EventType eventType, CustomEventListener listener) {
        this.off(eventType.name(), listener);
    }

    public void off(String eventType, CustomEventListener listener) {
        this.getListeners(eventType).remove(listener);
    }

    public List<CustomEventListener> getListeners(String type) {
        List<CustomEventListener> listeners = this.listenerMap.get(type);
        if (listeners == null) {
            listeners = new ArrayList<CustomEventListener>();
            this.listenerMap.put(type, listeners);
        }
        return listeners;
    }

    public <EventType extends CustomEvent> void emit(CustomEvent event) {
        this.emit(event.type, (Object)event);
    }

    public <EventType extends Enum<EventType>> void emit(EventType eventType, Object event) {
        this.emit(eventType.name(), event);
    }

    public void emit(String eventType, Object event) {
        if (StringUtils.isBlank((CharSequence)eventType)) {
            return;
        }
        List<CustomEventListener> listeners = this.getListeners(eventType);
        if (listeners.isEmpty()) {
            return;
        }
        listeners.forEach(listenerI -> listenerI.call(event));
    }

    public static class CustomEvent {
        public String type;
        public Object data;
    }

    public static interface CustomEventListener<EventType> {
        public void call(EventType var1);
    }
}

