/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging;

import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.XmlLogRecordException;
import com.kms.katalon.util.XmlInputFactoryProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class XMLLoggerParser {
    private static final String UTF_8 = "UTF-8";
    public static final String LOG_RECORD_PROP_NAME_ATTRIBUTE = "name";
    public static final String LOG_RECORD_NODE_NAME = "record";
    public static final String LEVEL_NODE_NAME = "level";
    public static final String MESSAGE_NODE_NAME = "message";
    public static final String MILLIS_NODE_NAME = "millis";
    public static final String METHOD_NODE_NAME = "method";
    private static final String NESTED_LEVEL_NODE_NAME = "nestedLevel";
    public static final String EXCEPTION_NODE_NAME = "exception";
    public static final String EXCEPTION_FRAME_NODE_NAME = "frame";
    public static final String EXCEPTION_CLASS_NODE_NAME = "class";
    public static final String EXCEPTION_METHOD_NODE_NAME = "method";
    public static final String EXCEPTION_LINE_NODE_NAME = "line";
    public static final String LOG_RECORD_PROP_NODE_NAME = "property";
    private static final String EXECUTION_LOG_FILE_BASE = "execution";
    public static final String ESCAPED_NODE_NAME = "escapedJava";

    public static String unescapeString(String text, boolean escapedJava) {
        String unescapeXml = StringEscapeUtils.unescapeXml((String)text);
        if (escapedJava) {
            return StringEscapeUtils.unescapeJava((String)unescapeXml);
        }
        return unescapeXml;
    }

    public static String getRecordDate(LogRecord record) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return format.format(new Date(record.getMillis()));
    }

    public static List<XmlLogRecord> readFromString(String xmlString) throws XMLStreamException, FileNotFoundException {
        if (StringUtils.isEmpty((String)xmlString)) {
            return Collections.emptyList();
        }
        XMLInputFactory inputFactory = XmlInputFactoryProvider.newInstance();
        try (XMLStreamReader reader = null;){
            reader = inputFactory.createXMLStreamReader(new StringReader(xmlString));
            List<XmlLogRecord> list = XMLLoggerParser.readDocument(reader);
            return list;
        }
    }

    public static File[] getSortedLogFile(String logFolder) {
        File folder = new File(logFolder);
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Pattern.matches("execution\\d+\\.log", name);
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                int num1 = Integer.parseInt(FilenameUtils.getBaseName((String)f1.getName()).replace(XMLLoggerParser.EXECUTION_LOG_FILE_BASE, ""));
                int num2 = Integer.parseInt(FilenameUtils.getBaseName((String)f2.getName()).replace(XMLLoggerParser.EXECUTION_LOG_FILE_BASE, ""));
                return num2 - num1;
            }
        });
        return files;
    }

    public static List<XmlLogRecord> readFromXMLFile(File xmlFile) throws XMLStreamException, IOException {
        if (xmlFile == null || !xmlFile.exists()) {
            return Collections.emptyList();
        }
        XMLInputFactory inputFactory = XmlInputFactoryProvider.newInstance();
        XMLStreamReader reader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(xmlFile);
            reader = inputFactory.createXMLStreamReader(fileInputStream, UTF_8);
            List<XmlLogRecord> list = XMLLoggerParser.readDocument(reader);
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static List<XmlLogRecord> readFromLogFolder(String logFolder) throws XMLStreamException, IOException {
        File[] files = XMLLoggerParser.getSortedLogFile(logFolder);
        ArrayList<XmlLogRecord> xmlLogRecords = new ArrayList<XmlLogRecord>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            xmlLogRecords.addAll(XMLLoggerParser.readFromXMLFile(file));
            ++n2;
        }
        return xmlLogRecords;
    }

    private static List<XmlLogRecord> readDocument(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<XmlLogRecord> logRecords = new ArrayList<XmlLogRecord>();
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    String elementName = reader.getLocalName();
                    if (!elementName.equals(LOG_RECORD_NODE_NAME)) break;
                    logRecords.add(XMLLoggerParser.readRecord(reader));
                    break;
                }
            }
        }
        return logRecords;
    }

    public static XmlLogRecord readRecord(XMLStreamReader reader) throws XMLStreamException {
        XmlLogRecord record = new XmlLogRecord(Level.ALL, "");
        String message = "";
        boolean shouldBreakWhile = false;
        while (reader.hasNext() && !shouldBreakWhile) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    String elementName;
                    switch (elementName = reader.getLocalName()) {
                        case "level": {
                            record.setLevel(LogLevel.valueOf(XMLLoggerParser.readCharacters(reader)).getLevel());
                            break;
                        }
                        case "message": {
                            message = XMLLoggerParser.readCharacters(reader);
                            break;
                        }
                        case "millis": {
                            record.setMillis(XMLLoggerParser.readLong(reader));
                            break;
                        }
                        case "method": {
                            record.setSourceMethodName(XMLLoggerParser.readCharacters(reader));
                            break;
                        }
                        case "exception": {
                            record.setExceptions(XMLLoggerParser.readExceptions(reader));
                            break;
                        }
                        case "property": {
                            String propName = reader.getAttributeValue(null, LOG_RECORD_PROP_NAME_ATTRIBUTE);
                            String propVal = XMLLoggerParser.readCharacters(reader);
                            record.getProperties().put(propName, propVal);
                            break;
                        }
                        case "nestedLevel": {
                            record.setNestedLevel(XMLLoggerParser.readInt(reader));
                            break;
                        }
                        case "escapedJava": {
                            record.setEscapedJava(XMLLoggerParser.readBoolean(reader));
                        }
                    }
                }
                case 2: {
                    String elementName = reader.getLocalName();
                    if (!elementName.equals(LOG_RECORD_NODE_NAME)) break;
                    shouldBreakWhile = true;
                }
            }
        }
        if (StringUtils.isNotEmpty((String)message)) {
            record.setMessage(XMLLoggerParser.unescapeString(message, record.isEscapedJava()));
        }
        return record;
    }

    private static List<XmlLogRecordException> readExceptions(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<XmlLogRecordException> exceptionLogRecords = new ArrayList<XmlLogRecordException>();
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    if (!EXCEPTION_FRAME_NODE_NAME.equals(reader.getLocalName())) break;
                    exceptionLogRecords.add(XMLLoggerParser.readException(reader));
                    break;
                }
                case 2: {
                    if (!EXCEPTION_NODE_NAME.equals(reader.getLocalName())) break;
                    return exceptionLogRecords;
                }
            }
        }
        return exceptionLogRecords;
    }

    private static XmlLogRecordException readException(XMLStreamReader reader) throws XMLStreamException {
        XmlLogRecordException logException = new XmlLogRecordException();
        while (reader.hasNext()) {
            int eventType = reader.next();
            block0 : switch (eventType) {
                case 1: {
                    String elementName;
                    switch (elementName = reader.getLocalName()) {
                        case "class": {
                            logException.setClassName(XMLLoggerParser.readCharacters(reader));
                            break block0;
                        }
                        case "method": {
                            logException.setMethodName(XMLLoggerParser.readCharacters(reader));
                            break block0;
                        }
                        case "line": {
                            logException.setLineNumber(XMLLoggerParser.readInt(reader));
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!EXCEPTION_FRAME_NODE_NAME.equals(reader.getLocalName())) break;
                    return logException;
                }
            }
        }
        return logException;
    }

    private static boolean readBoolean(XMLStreamReader reader) throws XMLStreamException {
        String characters = XMLLoggerParser.readCharacters(reader);
        try {
            return Boolean.valueOf(characters);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLStreamException("Invalid boolean " + characters);
        }
    }

    private static long readLong(XMLStreamReader reader) throws XMLStreamException {
        String characters = XMLLoggerParser.readCharacters(reader);
        try {
            return Long.valueOf(characters);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLStreamException("Invalid long " + characters);
        }
    }

    private static int readInt(XMLStreamReader reader) throws XMLStreamException {
        String characters = XMLLoggerParser.readCharacters(reader);
        try {
            return Integer.valueOf(characters);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLStreamException("Invalid integer " + characters);
        }
    }

    private static String readCharacters(XMLStreamReader reader) throws XMLStreamException {
        StringBuilder result = new StringBuilder();
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 4: 
                case 12: {
                    result.append(reader.getText());
                    break;
                }
                case 2: {
                    return result.toString();
                }
            }
        }
        return result.toString();
    }
}

