/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class TestSuiteLogRecord
extends AbstractLogRecord {
    private static final String TEST_CASE_REMAINING_RETRY_COUNT = "remainingRetryCount";
    private String devicePlatform;
    private String logFolder;
    private Map<String, String> runData;
    private String testSuiteCollectionId;
    private Map<String, String> buildData;
    private boolean isCompleted;

    public TestSuiteLogRecord(String name, String logFolder) {
        super(name);
        this.logFolder = logFolder;
        this.runData = new HashMap<String, String>();
        this.buildData = new HashMap<String, String>();
        this.setType("TEST_SUITE");
    }

    public void setStatus(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getBrowser() {
        if (this.getRunData().containsKey("browser")) {
            if (this.getRunData().containsKey("remoteOS")) {
                return String.valueOf(this.getRunData().get("remoteOS")) + " - " + this.getRunData().get("browser");
            }
            return this.getRunData().get("browser");
        }
        return "";
    }

    public String getTestCloudPlatform() {
        Map<String, Object> inputDesiredCaps = RunConfiguration.getDriverPreferencesProperties("Remote");
        String space = " ";
        String hyphen = " - ";
        String platformName = (String)inputDesiredCaps.get("platformName");
        String platformVersion = (String)inputDesiredCaps.get("platformVersion");
        String deviceName = (String)inputDesiredCaps.get("deviceName");
        if (this.getRunData().containsKey("browser")) {
            String browser = this.getRunData().get("browser").split(" ")[0];
            return String.valueOf(platformName) + space + platformVersion + hyphen + deviceName + hyphen + browser;
        }
        return "";
    }

    public String getLogFolder() {
        return this.logFolder;
    }

    public int getTotalTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(null);
    }

    public int getTotalPassedTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.PASSED);
    }

    public int getTotalFailedTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.FAILED);
    }

    public int getTotalErrorTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.ERROR);
    }

    public int getTotalIncompleteTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.INCOMPLETE);
    }

    public int getTotalSkippedTestCases() {
        return this.getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue.SKIPPED);
    }

    public TestStatus.TestStatusValue getSummaryStatus() {
        if (this.getTotalIncompleteTestCases() > 0) {
            return TestStatus.TestStatusValue.INCOMPLETE;
        }
        if (this.getTotalErrorTestCases() > 0) {
            return TestStatus.TestStatusValue.ERROR;
        }
        if (this.getTotalFailedTestCases() > 0) {
            return TestStatus.TestStatusValue.FAILED;
        }
        if (this.getTotalSkippedTestCases() == this.getTotalTestCases()) {
            return TestStatus.TestStatusValue.SKIPPED;
        }
        return TestStatus.TestStatusValue.PASSED;
    }

    public ILogRecord[] filterFinalTestCasesResult() {
        ILogRecord[] childLogRecords = this.getChildRecords();
        ArrayList<ILogRecord> filterChildLogRecords = new ArrayList<ILogRecord>();
        int i = 0;
        while (i < childLogRecords.length) {
            int remainingRetryCount;
            TestCaseLogRecord testCaseLog;
            Map<String, String> testCaseProperties;
            ILogRecord childLogRecord = childLogRecords[i];
            if (this.isFailedOrErrorTestCase(childLogRecord) && (testCaseProperties = (testCaseLog = (TestCaseLogRecord)childLogRecord).getProperties()) != null && testCaseProperties.containsKey(TEST_CASE_REMAINING_RETRY_COUNT) && (remainingRetryCount = Integer.parseInt(testCaseProperties.get(TEST_CASE_REMAINING_RETRY_COUNT))) > 0) {
                if (i == childLogRecords.length - 1) {
                    filterChildLogRecords.add(childLogRecord);
                }
            } else {
                filterChildLogRecords.add(childLogRecord);
            }
            ++i;
        }
        return filterChildLogRecords.toArray(new ILogRecord[filterChildLogRecords.size()]);
    }

    private boolean isFailedOrErrorTestCase(ILogRecord logRecord) {
        if (!(logRecord instanceof TestCaseLogRecord)) {
            return false;
        }
        switch (logRecord.getStatus().getStatusValue()) {
            case FAILED: 
            case ERROR: {
                return true;
            }
        }
        return false;
    }

    private int getTotalTestCasesWithTestStatusValue(TestStatus.TestStatusValue testStatusValue) {
        ILogRecord[] childLogRecords = this.filterFinalTestCasesResult();
        int total = 0;
        ILogRecord[] iLogRecordArray = childLogRecords;
        int n = childLogRecords.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord childLogRecord = iLogRecordArray[n2];
            if (childLogRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLog = (TestCaseLogRecord)childLogRecord;
                if (testStatusValue == null || testCaseLog.getStatus().statusValue == testStatusValue) {
                    ++total;
                }
            }
            ++n2;
        }
        return total;
    }

    public String getDeviceName() {
        return this.getRunData().containsKey("deviceName") ? this.getRunData().get("deviceName") : this.getValueFromDesiredCaps("deviceName");
    }

    public String getDeviceId() {
        return this.getRunData().containsKey("deviceId") ? this.getRunData().get("deviceId") : "";
    }

    public String getDevicePlatform() {
        if (StringUtils.isBlank((CharSequence)this.devicePlatform)) {
            String platform = this.getValueFromDesiredCaps("platform");
            return (String)StringUtils.defaultIfEmpty((CharSequence)platform, (CharSequence)this.devicePlatform);
        }
        return this.devicePlatform;
    }

    private String getValueFromDesiredCaps(String key) {
        if (this.getRunData().containsKey("desiredCapabilities")) {
            String json = this.getRunData().get("desiredCapabilities");
            try {
                Map desiredCaps = (Map)new ObjectMapper().readValue(json, HashMap.class);
                return (String)desiredCaps.get(key);
            }
            catch (JsonProcessingException jsonProcessingException) {
                return "";
            }
        }
        return "";
    }

    public void setDevicePlatform(String devicePlatform) {
        this.devicePlatform = devicePlatform;
    }

    public String getOs() {
        return this.getRunData().containsKey("os") ? this.getRunData().get("os") : "";
    }

    public String getHostName() {
        return this.getRunData().containsKey("hostName") ? this.getRunData().get("hostName") : "";
    }

    public String getAppVersion() {
        return this.getRunData().containsKey("katalonVersion") ? this.getRunData().get("katalonVersion") : "";
    }

    public String getQtestBuildNumber() {
        return this.getBuildData().containsKey("qTestBuildNumber") ? this.getBuildData().get("qTestBuildNumber") : "";
    }

    public String getQtestBuildURL() {
        return this.getBuildData().containsKey("qTestBuildURL") ? this.getBuildData().get("qTestBuildURL") : "";
    }

    public String getAzurebBuildDefinitionId() {
        if (this.getBuildData().containsKey("adoDefinitionId")) {
            return this.getBuildData().get("adoDefinitionId");
        }
        if (this.getBuildData().containsKey("adoDefinitionID")) {
            return this.getBuildData().get("adoDefinitionID");
        }
        if (this.getBuildData().containsKey("adoBuildDefId")) {
            return this.getBuildData().get("adoBuildDefId");
        }
        if (this.getBuildData().containsKey("adoBuildDefID")) {
            return this.getBuildData().get("adoBuildDefID");
        }
        return "";
    }

    public String getAzurebReleaseDefinitionId() {
        if (this.getBuildData().containsKey("adoReleaseDefId")) {
            return this.getBuildData().get("adoReleaseDefId");
        }
        if (this.getBuildData().containsKey("adoReleaseDefID")) {
            return this.getBuildData().get("adoReleaseDefID");
        }
        return "";
    }

    public Map<String, String> getRunData() {
        return this.runData;
    }

    public void addRunData(Map<String, String> runData) {
        this.runData.putAll(runData);
    }

    public Map<String, String> getBuildData() {
        return this.buildData;
    }

    public void addBuildData(Map<String, String> buildData) {
        this.buildData.putAll(buildData);
    }

    public <T extends ILogRecord> int getChildIndex(T child) {
        return Arrays.asList(this.getChildRecords()).indexOf(child);
    }

    public List<String> getLogFiles() {
        ArrayList<String> logFiles = new ArrayList<String>();
        String[] stringArray = new File(this.getLogFolder()).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childFile = stringArray[n2];
            if (FilenameUtils.getExtension((String)childFile).equals("log")) {
                logFiles.add(childFile);
            }
            ++n2;
        }
        return logFiles;
    }

    @Override
    public String getSystemOutMsg() {
        return this.getJUnitMessage();
    }

    @Override
    public String getSystemErrorMsg() {
        TestStatus status = this.getStatus();
        String stackTrace = status.getStackTrace();
        if (status.getStatusValue().isError()) {
            return String.valueOf(this.getJUnitMessage()) + stackTrace;
        }
        return stackTrace;
    }

    public String getTestSuiteCollectionId() {
        return this.testSuiteCollectionId;
    }

    public void setTestSuiteCollectionId(String testSuiteCollectionId) {
        this.testSuiteCollectionId = testSuiteCollectionId;
    }

    public TestCaseLogRecord getLastTestCaseLogRecord() {
        return this.getChildRecords().length > 0 ? (TestCaseLogRecord)this.getChildRecords()[this.getChildRecords().length - 1] : null;
    }
}

