/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.google.common.base.Optional;
import com.kms.katalon.core.annotation.SetUp;
import com.kms.katalon.core.annotation.SetupTestCase;
import com.kms.katalon.core.annotation.TearDown;
import com.kms.katalon.core.annotation.TearDownTestCase;
import com.kms.katalon.core.common.CommonExecutor;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.CoreMessageConstants;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.context.internal.InternalTestSuiteContext;
import com.kms.katalon.core.context.internal.VideoRecorderService;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.main.AnnotatedMethodCollector;
import com.kms.katalon.core.main.RetrySettings;
import com.kms.katalon.core.main.RetrySettingsImpl;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseExecutor;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.util.internal.JsonUtil;
import groovy.lang.Binding;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.ast.MethodNode;

public class TestSuiteExecutor
extends CommonExecutor {
    public static final String IS_RERUN_IMMEDIATELY = "rerunTestFailImmediately";
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private final String testSuiteId;
    private final ScriptEngine scriptEngine;
    private InternalTestSuiteContext testSuiteContext;
    private ExecutionEventManager eventManger;
    private ScriptCache scriptCache;
    private Map<String, String> suiteProperties;
    private int failedThreshold;
    private static final Set<String> TEST_SUITE_ANNOTATION_METHODS = new HashSet<String>();

    static {
        TEST_SUITE_ANNOTATION_METHODS.add(SetUp.class.getName());
        TEST_SUITE_ANNOTATION_METHODS.add(TearDown.class.getName());
        TEST_SUITE_ANNOTATION_METHODS.add(SetupTestCase.class.getName());
        TEST_SUITE_ANNOTATION_METHODS.add(TearDownTestCase.class.getName());
    }

    public TestSuiteExecutor(String testSuiteId, ScriptEngine scriptEngine, ExecutionEventManager eventManger) {
        this.testSuiteId = testSuiteId;
        this.scriptEngine = scriptEngine;
        this.eventManger = eventManger;
        this.testSuiteContext = new InternalTestSuiteContext();
        this.testSuiteContext.setTestSuiteId(testSuiteId);
        this.failedThreshold = -1;
        VideoRecorderService videoRecorderService = new VideoRecorderService(RunConfiguration.getReportFolder(), RunConfiguration.getRecorderSetting());
        eventManger.addListenerEventHandle(videoRecorderService);
    }

    private RetrySettings setUpRetrySettingsForTestCase() {
        if (!Boolean.parseBoolean(this.suiteProperties.get(IS_RERUN_IMMEDIATELY))) {
            return null;
        }
        RetrySettingsImpl retrySettings = new RetrySettingsImpl();
        retrySettings.setCurrentRetryCount(0);
        int retryCount = Integer.parseInt(this.suiteProperties.get("retryCount"));
        retrySettings.setRemainingRetryCount(retryCount);
        return retrySettings;
    }

    public void execute(Map<String, String> suiteProperties, File testCaseBindingFile) {
        this.suiteProperties = suiteProperties;
        this.eventManger.publicEvent(ExecutionListenerEvent.BEFORE_TEST_EXECUTION, new Object[0]);
        this.logger.startSuite(this.testSuiteId, suiteProperties);
        this.eventManger.publicEvent(ExecutionListenerEvent.BEFORE_TEST_SUITE, new Object[]{this.testSuiteContext});
        this.accessTestSuiteMainPhase(suiteProperties, testCaseBindingFile);
        this.setStatusTestSuiteContext(this.testSuiteContext);
        this.executeListenerAfterTestSuite();
        this.cleanDriver();
        this.logger.endSuite(this.testSuiteId, Collections.emptyMap());
        this.eventManger.publicEvent(ExecutionListenerEvent.AFTER_TEST_EXECUTION, new Object[0]);
    }

    private void executeListenerAfterTestSuite() {
        this.eventManger.publicEvent(ExecutionListenerEvent.AFTER_TEST_SUITE, new Object[]{this.testSuiteContext});
    }

    private void accessTestSuiteMainPhase(Map<String, String> suiteProperties, File testCaseBindingFile) {
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        try {
            this.scriptCache = new ScriptCache(this.testSuiteId);
        }
        catch (IOException e) {
            errorCollector.addError(e);
            return;
        }
        this.invokeTestSuiteMethod(SetUp.class.getName(), "setup action", false);
        if (errorCollector.containsErrors()) {
            return;
        }
        try {
            this.failedThreshold = RunConfiguration.getFailedTestThreshold();
            List bindings = FileUtils.readLines((File)testCaseBindingFile, (String)"UTF-8");
            int i = 0;
            while (i < bindings.size()) {
                TestCaseBinding testCaseBinding = JsonUtil.fromJson((String)bindings.get(i), TestCaseBinding.class);
                this.accessTestCaseMainPhaseLoop(this.scriptEngine, testCaseBinding);
                if (RunConfiguration.getRunningMode() == RunningMode.CONSOLE && this.reachFailedThreshold()) {
                    this.logger.logInfo(MessageFormat.format(CoreMessageConstants.MSG_REACH_THRESHOLD, this.failedThreshold));
                    break;
                }
                this.accessTestCaseMainPhase(i, testCaseBinding);
                ++i;
            }
        }
        catch (IOException e) {
            errorCollector.addError(e);
        }
        this.invokeTestSuiteMethod(TearDown.class.getName(), "tear down", true);
    }

    protected boolean reachFailedThreshold() {
        return this.failedThreshold == 0;
    }

    protected void updateFailedThreshold() {
        if (this.failedThreshold > 0) {
            --this.failedThreshold;
        }
    }

    @Override
    public TestCaseExecutor accessTestCaseMainPhaseBody(TestCaseBinding tcBinding, InternalTestCaseContext testCaseContext) {
        HashMap<String, Object> bindedValues = new HashMap<String, Object>((Map)Optional.fromNullable(tcBinding.getBindedValues()).or(new HashMap()));
        this.eventManger.publicEvent(ExecutionListenerEvent.BEFORE_TEST_DATA_BIND_INTO_TEST_CASE, new Object[]{this.testSuiteContext, testCaseContext, bindedValues});
        tcBinding.setBindedValues(bindedValues);
        TestCaseExecutor testCaseExecutor = new TestCaseExecutor(tcBinding, this.scriptEngine, this.eventManger, testCaseContext);
        testCaseExecutor.setTestSuiteExecutor(this);
        testCaseExecutor.setRetrySettings(this.setUpRetrySettingsForTestCase());
        return testCaseExecutor;
    }

    public void invokeEachTestCaseMethod(String methodName, String actionType, boolean ignoredIfFailed) {
        this.invokeTestSuiteMethod(methodName, actionType, ignoredIfFailed);
    }

    private void invokeTestSuiteMethod(String annotatedMethodName, String actionType, boolean ignoredIfFailed) {
        if (!this.scriptCache.hasScriptContent()) {
            return;
        }
        try {
            List<MethodNode> annotatedMethods = this.scriptCache.getMethodNodes(annotatedMethodName);
            if (annotatedMethods.isEmpty()) {
                return;
            }
            this.scriptEngine.changeConfigForExecutingScript();
            annotatedMethods.forEach(methodNode -> this.runMethod(methodNode.getName(), actionType, ignoredIfFailed));
        }
        catch (IOException e) {
            if (!ignoredIfFailed) {
                ErrorCollector.getCollector().addError(e);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    private void runMethod(String methodName, String actionType, boolean ignoredIfFailed) {
        Stack<KeywordLogger.KeywordStackElement> keywordStack = new Stack<KeywordLogger.KeywordStackElement>();
        HashMap<String, String> startKeywordAttributeMap = new HashMap<String, String>();
        startKeywordAttributeMap.put("isIgnoredIfFailed", String.valueOf(ignoredIfFailed));
        this.logger.startKeyword(methodName, actionType, startKeywordAttributeMap, keywordStack);
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        List<Throwable> oldErrors = errorCollector.getCoppiedErrors();
        try {
            errorCollector.clearErrors();
            this.scriptEngine.runScriptMethodAsRawText(this.scriptCache.scriptContent, this.scriptCache.className, methodName, new Binding());
            this.endAllUnfinishedKeywords(keywordStack);
        }
        catch (Throwable e) {
            errorCollector.getErrors().add(e);
        }
        boolean isKeyword = true;
        if (errorCollector.containsErrors()) {
            this.endAllUnfinishedKeywords(keywordStack);
            Throwable firstError = errorCollector.getFirstError();
            String errorMessage = firstError.getMessage();
            if (ignoredIfFailed) {
                this.logger.logWarning(errorMessage, null, firstError, isKeyword);
            } else {
                oldErrors.add(errorCollector.getFirstError());
                this.logger.logError(errorMessage, null, firstError, isKeyword);
            }
        } else {
            this.logger.logPassed(MessageFormat.format(StringConstants.MAIN_LOG_PASSED_METHOD_COMPLETED, methodName), Collections.emptyMap(), isKeyword);
        }
        errorCollector.clearErrors();
        errorCollector.getErrors().addAll(oldErrors);
        this.logger.endKeyword(methodName, Collections.emptyMap(), keywordStack);
    }

    private void endAllUnfinishedKeywords(Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        while (!keywordStack.isEmpty()) {
            KeywordLogger.KeywordStackElement keywordStackElement = keywordStack.pop();
            this.logger.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
        }
    }

    private class ScriptCache {
        private File scriptFile;
        private AnnotatedMethodCollector annotatedMethodCollector;
        private String className;
        private String scriptContent;

        private ScriptCache(String testSuiteId) throws IOException {
            this.scriptFile = this.getTestSuiteScriptFile(testSuiteId);
            if (this.scriptFile != null && this.scriptFile.exists()) {
                this.scriptContent = FileUtils.readFileToString((File)this.scriptFile, (String)"UTF-8");
                this.className = this.scriptFile.toURI().toURL().toExternalForm();
                this.annotatedMethodCollector = new AnnotatedMethodCollector(TEST_SUITE_ANNOTATION_METHODS);
            }
        }

        public List<MethodNode> getMethodNodes(String annotatedMethodName) throws IOException {
            Map<String, List<MethodNode>> methodNodeCollection = this.annotatedMethodCollector.getMethodNodes(this.scriptContent);
            if (!methodNodeCollection.containsKey(annotatedMethodName)) {
                return Collections.emptyList();
            }
            return methodNodeCollection.get(annotatedMethodName);
        }

        public boolean hasScriptContent() {
            return this.scriptFile != null && this.scriptFile.exists();
        }

        private File getTestSuiteScriptFile(String testSuiteId) {
            return new File(RunConfiguration.getProjectDir(), String.valueOf(testSuiteId) + ".groovy");
        }
    }
}

