/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.network;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.util.internal.ProxyUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class HttpClientProxyBuilder {
    private static final String TLS = "TLS";
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    protected static final boolean HOST_NAME_VERIFY_VALUE = true;
    private static PoolingHttpClientConnectionManager connectionManager;
    private final HttpClientBuilder clientBuilder;

    static {
        try {
            SSLContext sc = SSLContext.getInstance(HttpClientProxyBuilder.getProtocol());
            sc.init(HttpClientProxyBuilder.getKeyManagers(), HttpClientProxyBuilder.getTrustManagers(), null);
            Registry reg = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sc, HttpClientProxyBuilder.getHostnameVerifier())).build();
            connectionManager = new PoolingHttpClientConnectionManager(reg);
        }
        catch (Exception exception) {
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        connectionManager.setValidateAfterInactivity(1);
        connectionManager.setMaxTotal(2000);
        connectionManager.setDefaultMaxPerRoute(500);
    }

    public HttpClientProxyBuilder(HttpClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public HttpClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public static HttpClientProxyBuilder create(ProxyInformation proxyInfo) throws URISyntaxException, IOException, GeneralSecurityException {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        clientBuilder.setConnectionManagerShared(true);
        SSLContext sc = SSLContext.getInstance(HttpClientProxyBuilder.getProtocol());
        sc.init(HttpClientProxyBuilder.getKeyManagers(), HttpClientProxyBuilder.getTrustManagers(), null);
        clientBuilder.setSSLContext(sc);
        HttpClientProxyBuilder.configureProxy(clientBuilder, proxyInfo);
        clientBuilder.setSSLHostnameVerifier(HttpClientProxyBuilder.getHostnameVerifier());
        clientBuilder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                Args.notNull((Object)response, (String)"HTTP response");
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    try {
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return 1L;
            }
        });
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).build();
        clientBuilder.setDefaultRequestConfig(config);
        return new HttpClientProxyBuilder(clientBuilder);
    }

    public static HttpClientProxyBuilder create(ProxyInformation proxyInfo, String url) throws URISyntaxException, IOException, GeneralSecurityException {
        boolean useProxy;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        clientBuilder.setConnectionManagerShared(true);
        SSLContext sc = SSLContext.getInstance(HttpClientProxyBuilder.getProtocol());
        sc.init(HttpClientProxyBuilder.getKeyManagers(), HttpClientProxyBuilder.getTrustManagers(), null);
        clientBuilder.setSSLContext(sc);
        boolean bl = useProxy = proxyInfo != null && !ProxyOption.NO_PROXY.name().equals(proxyInfo.getProxyOption());
        if (useProxy) {
            HttpClientProxyBuilder.configureProxy(clientBuilder, proxyInfo);
        }
        clientBuilder.setSSLHostnameVerifier(HttpClientProxyBuilder.getHostnameVerifier());
        clientBuilder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                Args.notNull((Object)response, (String)"HTTP response");
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    try {
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return 1L;
            }
        });
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).build();
        clientBuilder.setDefaultRequestConfig(config);
        return new HttpClientProxyBuilder(clientBuilder);
    }

    public static void configureProxy(HttpClientBuilder httpClientBuilder, ProxyInformation proxyInformation) {
        if (proxyInformation == null) {
            return;
        }
        if (ProxyOption.valueOf(proxyInformation.getProxyOption()).equals((Object)ProxyOption.NO_PROXY)) {
            return;
        }
        final boolean isUseSystemProxy = ProxyOption.valueOf(proxyInformation.getProxyOption()).equals((Object)ProxyOption.USE_SYSTEM);
        BasicCredentialsProvider credentialsProvider = null;
        HttpHost httpProxy = null;
        if (!isUseSystemProxy) {
            httpProxy = new HttpHost(proxyInformation.getProxyServerAddress(), proxyInformation.getProxyServerPort());
            credentialsProvider = new BasicCredentialsProvider();
            String username = proxyInformation.getUsername();
            String password = proxyInformation.getPassword();
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                credentialsProvider.setCredentials(new AuthScope(httpProxy), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        final HttpHost finalHttpProxy = httpProxy;
        httpClientBuilder.setRoutePlanner(new HttpRoutePlanner(){

            public HttpRoute determineRoute(HttpHost arg0, HttpRequest arg1, HttpContext arg2) throws HttpException {
                if (isUseSystemProxy) {
                    return new SystemDefaultRoutePlanner(ProxyUtil.getAutoProxySelector()).determineRoute(arg0, arg1, arg2);
                }
                return new DefaultProxyRoutePlanner(finalHttpProxy).determineRoute(arg0, arg1, arg2);
            }
        }).setDefaultCredentialsProvider(credentialsProvider);
    }

    private static TrustManager[] getTrustManagers() throws IOException {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                HttpClientProxyBuilder.validateCertificate(certs, authType);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                HttpClientProxyBuilder.validateCertificate(certs, authType);
            }
        }};
    }

    private static boolean validateCertificate(X509Certificate[] certs, String authType) {
        return certs != null && authType != null;
    }

    private static KeyManager[] getKeyManagers() throws GeneralSecurityException, IOException {
        return new KeyManager[0];
    }

    private static HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
    }

    private static String getProtocol() {
        return TLS;
    }
}

