/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.JsModel;
import com.kms.katalon.core.reporting.JsModelProperty;
import com.kms.katalon.core.reporting.JsTestModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsSuiteModel
extends JsModel {
    private List<ILogRecord> fFilteredTestCases;
    private List<String> listStrings;
    private TestSuiteLogRecord suiteLog;
    private JsModel metaData;
    private JsModel subSuite;
    private List<JsTestModel> tests;
    private JsModel status;
    private JsModel suiteKeyword;
    private JsModel sum;

    public JsSuiteModel(TestSuiteLogRecord suiteLog, List<String> listStrings) {
        this.suiteLog = suiteLog;
        this.listStrings = listStrings;
        this.fFilteredTestCases = Arrays.asList(suiteLog.filterFinalTestCasesResult());
    }

    public JsSuiteModel(TestSuiteLogRecord suiteLog, List<String> listStrings, List<ILogRecord> filteredTestCases) {
        this.suiteLog = suiteLog;
        this.listStrings = listStrings;
        this.fFilteredTestCases = filteredTestCases;
    }

    private void init() {
        if (this.listStrings.isEmpty()) {
            this.listStrings.add("\"*\"");
        }
        this.props.add(new JsModelProperty("Name", this.suiteLog.getName(), this.listStrings));
        this.props.add(new JsModelProperty("Source", this.suiteLog.getSource().replace("\\", "\\\\"), this.listStrings));
        this.props.add(new JsModelProperty("Relative Source", this.suiteLog.getSource().replace("\\", "\\\\"), this.listStrings));
        this.props.add(new JsModelProperty("doc", "0", null));
        this.metaData = new JsModel();
        int[] totalFailsErrorsIncompletes = this.initStatus();
        this.subSuite = new JsModel();
        this.tests = new ArrayList<JsTestModel>();
        ILogRecord[] iLogRecordArray = this.suiteLog.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord testLog = iLogRecordArray[n2];
            if (testLog instanceof TestCaseLogRecord && this.fFilteredTestCases.contains(testLog)) {
                this.tests.add(new JsTestModel((TestCaseLogRecord)testLog, this.listStrings));
            }
            ++n2;
        }
        this.suiteKeyword = new JsModel();
        this.initSummary(totalFailsErrorsIncompletes);
    }

    private int[] initStatus() {
        this.status = new JsModel();
        TestStatus.TestStatusValue suiteStat = TestStatus.TestStatusValue.PASSED;
        long suiteStartTime = this.suiteLog.getStartTime();
        long suiteEndTime = this.suiteLog.getLastTestCaseLogRecord() != null ? this.suiteLog.getLastTestCaseLogRecord().getEndTime() : this.suiteLog.getEndTime();
        long elapsedTime = suiteEndTime - suiteStartTime;
        String lastErrMsg = "";
        int totalFail = 0;
        int totalErr = 0;
        int totalInComplete = 0;
        int totalSkipped = 0;
        ILogRecord[] iLogRecordArray = this.suiteLog.filterFinalTestCasesResult();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord testLogEntity = iLogRecordArray[n2];
            if (testLogEntity instanceof TestCaseLogRecord) {
                TestStatus testStatus = testLogEntity.getStatus();
                if (testStatus != null && testStatus.getStatusValue() == TestStatus.TestStatusValue.FAILED) {
                    suiteStat = TestStatus.TestStatusValue.FAILED;
                    lastErrMsg = testLogEntity.getMessage();
                    ++totalFail;
                } else if (testStatus != null && testStatus.getStatusValue() == TestStatus.TestStatusValue.ERROR) {
                    suiteStat = TestStatus.TestStatusValue.ERROR;
                    lastErrMsg = testLogEntity.getMessage();
                    ++totalErr;
                } else if (testStatus != null && testStatus.getStatusValue() == TestStatus.TestStatusValue.INCOMPLETE) {
                    suiteStat = TestStatus.TestStatusValue.INCOMPLETE;
                    lastErrMsg = testLogEntity.getMessage();
                    ++totalInComplete;
                } else if (testStatus != null && testStatus.getStatusValue() == TestStatus.TestStatusValue.SKIPPED) {
                    lastErrMsg = testLogEntity.getMessage();
                    ++totalSkipped;
                }
            }
            ++n2;
        }
        if (totalSkipped == this.suiteLog.getChildRecords().length) {
            suiteStat = TestStatus.TestStatusValue.SKIPPED;
        }
        String statValue = String.valueOf(suiteStat.ordinal());
        this.status.props.add(new JsModelProperty("status", statValue, null));
        this.status.props.add(new JsModelProperty("suiteStartTime", String.valueOf(suiteStartTime), null));
        this.status.props.add(new JsModelProperty("elapsedTime", String.valueOf(elapsedTime), null));
        if (suiteStat == TestStatus.TestStatusValue.FAILED || suiteStat == TestStatus.TestStatusValue.ERROR) {
            this.status.props.add(lastErrMsg.equals("") ? new JsModelProperty("errMessage", "0", null) : new JsModelProperty("errMessage", lastErrMsg, this.listStrings));
        }
        this.suiteLog.getStatus().setStatusValue(suiteStat);
        return new int[]{totalFail, totalErr, totalInComplete, totalSkipped};
    }

    private void initSummary(int[] totalFailsErrorsIncompletes) {
        int totalChildCount = 0;
        ILogRecord[] finalResultsChildLogRecords = this.suiteLog.filterFinalTestCasesResult();
        int index = 0;
        while (index < finalResultsChildLogRecords.length) {
            if (finalResultsChildLogRecords[index] instanceof TestCaseLogRecord) {
                ++totalChildCount;
            }
            ++index;
        }
        this.sum = new JsModel();
        this.sum.props.add(new JsModelProperty("total", String.valueOf(totalChildCount), null));
        this.sum.props.add(new JsModelProperty("passes", String.valueOf(totalChildCount - (totalFailsErrorsIncompletes[0] + totalFailsErrorsIncompletes[1] + totalFailsErrorsIncompletes[2] + totalFailsErrorsIncompletes[3])), null));
        this.sum.props.add(new JsModelProperty("fails", String.valueOf(totalFailsErrorsIncompletes[0]), null));
        this.sum.props.add(new JsModelProperty("errors", String.valueOf(totalFailsErrorsIncompletes[1]), null));
        this.sum.props.add(new JsModelProperty("incompletes", String.valueOf(totalFailsErrorsIncompletes[2]), null));
        this.sum.props.add(new JsModelProperty("skipped", String.valueOf(totalFailsErrorsIncompletes[3]), null));
    }

    @Override
    public StringBuilder toArrayString() {
        this.init();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (JsModelProperty prop : this.props) {
            sb.append(prop.getPropertyValue());
            sb.append(",");
        }
        sb.append((CharSequence)this.metaData.toArrayString());
        sb.append(",");
        sb.append((CharSequence)this.status.toArrayString());
        sb.append(",");
        sb.append((CharSequence)this.subSuite.toArrayString());
        sb.append(",");
        sb.append("[");
        int i = 0;
        while (i < this.tests.size()) {
            sb.append((CharSequence)this.tests.get(i).toArrayString());
            if (i < this.tests.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        sb.append(",");
        sb.append((CharSequence)this.suiteKeyword.toArrayString());
        sb.append(",");
        sb.append((CharSequence)this.sum.toArrayString());
        sb.append("]");
        return sb;
    }
}

