/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting;

import com.kms.katalon.core.logging.TestSuiteXMLLogParser;
import com.kms.katalon.core.logging.XMLLoggerParser;
import com.kms.katalon.core.logging.XMLParserException;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.JUnitError;
import com.kms.katalon.core.reporting.JUnitFailure;
import com.kms.katalon.core.reporting.JUnitProperties;
import com.kms.katalon.core.reporting.JUnitProperty;
import com.kms.katalon.core.reporting.JUnitReportObjectFactory;
import com.kms.katalon.core.reporting.JUnitTestCase;
import com.kms.katalon.core.reporting.JUnitTestSuite;
import com.kms.katalon.core.reporting.JUnitTestSuites;
import com.kms.katalon.core.reporting.JsSuiteModel;
import com.kms.katalon.core.reporting.template.ResourceLoader;
import com.kms.katalon.core.testdata.reader.CsvWriter;
import com.kms.katalon.core.util.internal.DateUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public class ReportUtil {
    public static final String JUNIT_REPORT_FILE_NAME = "JUnit_Report.xml";

    private static void appendReportConstantValues(List<String> constantValues, StringBuilder stringBuilder) {
        for (String value : constantValues) {
            stringBuilder.append(value);
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
    }

    private static StringBuilder generateVars(List<String> strings, TestSuiteLogRecord suiteLogEntity, StringBuilder model) throws IOException {
        StringBuilder sb = new StringBuilder();
        List lines = IOUtils.readLines((InputStream)ResourceLoader.class.getResourceAsStream("html_vars.txt"));
        for (String line : lines) {
            if (line.equals("//JavaScript Suite model for Reporting")) {
                sb.append((CharSequence)model);
                continue;
            }
            if (line.equals("//JavaScript Strings constant for Reporting")) {
                ReportUtil.appendReportConstantValues(strings, sb);
                continue;
            }
            if (line.equals("//JavaScript Test Execution Environment Info")) {
                StringBuilder envInfoSb = new StringBuilder();
                envInfoSb.append("{");
                envInfoSb.append(String.format("\"host\" : \"%s\", ", suiteLogEntity.getHostName()));
                envInfoSb.append(String.format("\"os\" : \"%s\", ", suiteLogEntity.getOs()));
                envInfoSb.append(String.format("\"katalonVersion\" : \"%s\", ", suiteLogEntity.getAppVersion()));
                if (suiteLogEntity.getBrowser() != null && !suiteLogEntity.getBrowser().equals("")) {
                    if (suiteLogEntity.getRunData().containsKey("browser")) {
                        envInfoSb.append(String.format("\"browser\" : \"%s\",", suiteLogEntity.getRunData().get("browser")));
                    } else {
                        envInfoSb.append(String.format("\"browser\" : \"%s\",", suiteLogEntity.getBrowser()));
                    }
                }
                if (suiteLogEntity.getDeviceName() != null && !suiteLogEntity.getDeviceName().equals("")) {
                    envInfoSb.append(String.format("\"deviceName\" : \"%s\",", suiteLogEntity.getDeviceName()));
                }
                if (suiteLogEntity.getDeviceName() != null && !suiteLogEntity.getDeviceName().equals("")) {
                    envInfoSb.append(String.format("\"devicePlatform\" : \"%s\",", suiteLogEntity.getDevicePlatform()));
                }
                envInfoSb.append("\"\" : \"\"");
                envInfoSb.append("}");
                sb.append((CharSequence)envInfoSb);
                continue;
            }
            sb.append(line);
            sb.append("\n");
        }
        return sb;
    }

    public static String getOs() {
        return String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("sun.arch.data.model") + "bit";
    }

    public static String getHostName() {
        String hostName = "Unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        return hostName;
    }

    private static void collectInfoLines(ILogRecord logRecord, List<ILogRecord> rmvLogs) {
        if (logRecord instanceof MessageLogRecord && (logRecord.getStatus().getStatusValue() == TestStatus.TestStatusValue.INCOMPLETE || logRecord.getStatus().getStatusValue() == TestStatus.TestStatusValue.INFO)) {
            rmvLogs.add(logRecord);
        }
        ILogRecord[] iLogRecordArray = logRecord.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord childLogRecord = iLogRecordArray[n2];
            ReportUtil.collectInfoLines(childLogRecord, rmvLogs);
            ++n2;
        }
    }

    public static void writeLogRecordToFiles(String logFolder) throws Exception {
        TestSuiteLogRecord testSuiteLogRecord = ReportUtil.generate(logFolder);
        if (testSuiteLogRecord != null) {
            ReportUtil.writeLogRecordToFiles(testSuiteLogRecord, new File(logFolder));
        }
    }

    public static void writeLogRecordToCSVFile(TestSuiteLogRecord suiteLogEntity, File destFile, List<ILogRecord> filteredTestCases) throws IOException {
        ReportUtil.writeLogRecordToCSVFile(suiteLogEntity, destFile, filteredTestCases, true);
    }

    public static void writeLogRecordToCSVFile(TestSuiteLogRecord suiteLogEntity, File destFile, List<ILogRecord> filteredTestCases, boolean stepsIncluded) throws IOException {
        CsvWriter.writeCsvReport(suiteLogEntity, destFile, filteredTestCases, stepsIncluded);
    }

    public static void writeLogRecordToFiles(TestSuiteLogRecord suiteLogEntity, File logFolder) throws Exception {
        ReportUtil.writeHtmlReport(suiteLogEntity, logFolder);
        ReportUtil.writeCSVReport(suiteLogEntity, logFolder);
        ReportUtil.writeSimpleHTMLReport(suiteLogEntity, logFolder);
        ReportUtil.writeJUnitReport(suiteLogEntity, logFolder);
    }

    public static void writeLogRecordToJUnitFile(String logFolder) throws Exception {
        TestSuiteLogRecord testSuiteLogRecord = ReportUtil.generate(logFolder);
        if (testSuiteLogRecord != null) {
            ReportUtil.writeJUnitReport(testSuiteLogRecord, new File(logFolder));
        }
    }

    public static JUnitTestSuite generateJUnitTestSuite(TestSuiteLogRecord suiteLogEntity) {
        JUnitReportObjectFactory factory = new JUnitReportObjectFactory();
        String testSuiteName = suiteLogEntity.getName();
        String totalTests = String.valueOf(suiteLogEntity.getTotalTestCases());
        String totalError = String.valueOf(suiteLogEntity.getTotalErrorTestCases());
        String totalFailure = String.valueOf(suiteLogEntity.getTotalFailedTestCases());
        String totalSkipped = String.valueOf(suiteLogEntity.getTotalSkippedTestCases());
        TestCaseLogRecord lastTestCaseLogRecord = suiteLogEntity.getLastTestCaseLogRecord();
        String duration = String.valueOf((float)((lastTestCaseLogRecord != null ? lastTestCaseLogRecord.getEndTime() : suiteLogEntity.getEndTime()) - suiteLogEntity.getStartTime()) / 1000.0f);
        JUnitProperties properties = factory.createProperties();
        List<JUnitProperty> propertyList = properties.getProperty();
        propertyList.add(new JUnitProperty("deviceName", suiteLogEntity.getDeviceName()));
        propertyList.add(new JUnitProperty("devicePlatform", suiteLogEntity.getDevicePlatform()));
        propertyList.add(new JUnitProperty("logFolder", StringEscapeUtils.escapeJava((String)suiteLogEntity.getLogFolder())));
        propertyList.add(new JUnitProperty("logFiles", factory.sanitizeReportLogs(suiteLogEntity)));
        propertyList.add(new JUnitProperty("attachments", factory.sanitizeReportAttachments(suiteLogEntity)));
        suiteLogEntity.getRunData().forEach((name, value) -> {
            boolean bl = propertyList.add(new JUnitProperty((String)name, (String)value));
        });
        JUnitTestSuite ts = factory.createTestSuite();
        ts.setProperties(properties);
        ts.setId(suiteLogEntity.getId());
        ts.setName(testSuiteName);
        ts.setHostname(suiteLogEntity.getHostName());
        ts.setTime(duration);
        ts.setTimestamp(DateUtil.getISOLocalDateTimeFormatted(suiteLogEntity.getStartTime()));
        ts.setSystemOut(suiteLogEntity.getSystemOutMsg().trim());
        ts.setSystemErr(suiteLogEntity.getSystemErrorMsg().trim());
        ts.setTests(totalTests);
        ts.setErrors(totalError);
        ts.setFailures(totalFailure);
        ts.setSkipped(totalSkipped);
        Arrays.asList(suiteLogEntity.filterFinalTestCasesResult()).stream().forEach(item -> {
            JUnitTestCase tc = factory.createTestCase();
            String time = String.valueOf((float)(item.getEndTime() - item.getStartTime()) / 1000.0f);
            tc.setClassname(item.getId());
            tc.setName(item.getName());
            tc.setTime(time);
            TestStatus status = item.getStatus();
            TestStatus.TestStatusValue statusValue = status.getStatusValue();
            String statusName = statusValue.name();
            String message = StringUtils.removeStart((String)item.getMessage(), (String)(String.valueOf(item.getName()) + " " + statusName + " because (of) "));
            tc.setStatus(statusName);
            if (TestStatus.TestStatusValue.ERROR == statusValue) {
                JUnitError error = factory.createError();
                error.setType(statusName);
                error.setMessage(message);
                tc.getError().add(error);
            }
            if (TestStatus.TestStatusValue.FAILED == statusValue) {
                JUnitFailure failure = factory.createFailure();
                failure.setType(statusName);
                failure.setMessage(message);
                tc.getFailure().add(failure);
            }
            tc.getSystemOut().add(item.getSystemOutMsg().trim());
            tc.getSystemErr().add(item.getSystemErrorMsg().trim());
            ts.getTestcase().add(tc);
        });
        return ts;
    }

    public static void writeJUnitReport(TestSuiteCollectionLogRecord suiteCollectionLogRecord, File logFolder) throws JAXBException, IOException {
        JUnitReportObjectFactory factory = new JUnitReportObjectFactory();
        ArrayList<JUnitTestSuite> tsList = new ArrayList<JUnitTestSuite>();
        for (TestSuiteLogRecord suiteLogEntity : suiteCollectionLogRecord.getTestSuiteRecords()) {
            JUnitTestSuite ts = ReportUtil.generateJUnitTestSuite(suiteLogEntity);
            tsList.add(ts);
        }
        String testSuiteCollectionName = suiteCollectionLogRecord.getName();
        String testSuiteCollectionTotalTests = suiteCollectionLogRecord.getTotalTestCases();
        String testSuiteCollectiontotalError = suiteCollectionLogRecord.getTotalErrorTestCases();
        String testSuiteCollectionTotalFailure = suiteCollectionLogRecord.getTotalFailedTestCases();
        String testSuiteCollectionDuration = String.valueOf((float)(suiteCollectionLogRecord.getEndTime() - suiteCollectionLogRecord.getStartTime()) / 1000.0f);
        JUnitTestSuites tss = factory.createTestSuites();
        tss.setErrors(testSuiteCollectiontotalError);
        tss.setFailures(testSuiteCollectionTotalFailure);
        tss.setTests(testSuiteCollectionTotalTests);
        tss.setTime(testSuiteCollectionDuration);
        tss.setName(testSuiteCollectionName);
        tss.getTestsuite().addAll(tsList);
        JAXBContext context = ReportUtil.createJAXBContext();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)tss, new File(logFolder, JUNIT_REPORT_FILE_NAME));
    }

    public static void writeJUnitReport(TestSuiteLogRecord suiteLogEntity, File logFolder) throws JAXBException, IOException {
        JUnitReportObjectFactory factory = new JUnitReportObjectFactory();
        JUnitTestSuite ts = ReportUtil.generateJUnitTestSuite(suiteLogEntity);
        JUnitTestSuites tss = factory.createTestSuites();
        tss.setErrors(ts.getErrors());
        tss.setFailures(ts.getFailures());
        tss.setTests(ts.getTests());
        tss.setTime(ts.getTime());
        tss.setName(ts.getName());
        tss.getTestsuite().add(ts);
        JAXBContext context = ReportUtil.createJAXBContext();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)tss, new File(logFolder, JUNIT_REPORT_FILE_NAME));
    }

    private static JAXBContext createJAXBContext() throws JAXBException {
        JAXBContext context = JAXBContextFactory.createContext((Class[])new Class[]{JUnitError.class, JUnitFailure.class, JUnitProperties.class, JUnitProperty.class, JUnitTestCase.class, JUnitTestSuites.class, JUnitTestSuite.class}, new HashMap());
        return context;
    }

    public static File writeTSCollectionHTMLReport(String reportTitle, String tsReportsJson, File destDir, boolean isAutoGenerate) throws IOException, URISyntaxException {
        StringBuilder htmlSb = new StringBuilder();
        ReportUtil.readFileToStringBuilder("html_collection_index_template.txt", htmlSb);
        String template = htmlSb.toString();
        template = StringUtils.replace((String)template, (String)"REPORT_TITLE", (String)reportTitle);
        template = StringUtils.replace((String)template, (String)"TEST_SUITE_REPORT_LIST", (String)tsReportsJson);
        File indexFile = null;
        indexFile = isAutoGenerate ? new File(destDir, "HTML_Report.html") : new File(destDir, "index.html");
        FileUtils.writeStringToFile((File)indexFile, (String)template, (String)"UTF-8");
        if (!isAutoGenerate) {
            htmlSb = new StringBuilder();
            ReportUtil.readFileToStringBuilder("html_collection_frame_template.txt", htmlSb);
            template = htmlSb.toString();
            template = StringUtils.replace((String)template, (String)"REPORT_TITLE", (String)reportTitle);
            template = StringUtils.replace((String)template, (String)"TEST_SUITE_REPORT_LIST", (String)tsReportsJson);
            FileUtils.writeStringToFile((File)new File(destDir, "index-frame-view.html"), (String)template, (String)"UTF-8");
        }
        return indexFile;
    }

    public static void writeHtmlReport(TestSuiteLogRecord suiteLogEntity, File logFolder) throws IOException, URISyntaxException {
        StringBuilder htmlSb = ReportUtil.prepareHtmlContent(suiteLogEntity);
        FileUtils.writeStringToFile((File)new File(logFolder, String.valueOf(logFolder.getName()) + ".html"), (String)htmlSb.toString(), (String)"UTF-8");
    }

    private static StringBuilder prepareHtmlContent(TestSuiteLogRecord suiteLogEntity) throws IOException, URISyntaxException {
        ArrayList<String> strings = new ArrayList<String>();
        JsSuiteModel jsSuiteModel = new JsSuiteModel(suiteLogEntity, strings);
        StringBuilder sbModel = jsSuiteModel.toArrayString();
        StringBuilder htmlSb = new StringBuilder();
        ReportUtil.readFileToStringBuilder("html_template.txt", htmlSb);
        htmlSb.append((CharSequence)ReportUtil.generateVars(strings, suiteLogEntity, sbModel));
        ReportUtil.readFileToStringBuilder("html_content.txt", htmlSb);
        return htmlSb;
    }

    public static void writeHtmlReportAppendHashCodeToName(TestSuiteLogRecord suiteLogEntity, File logFolder, int reportDirLocationHashCode) throws IOException, URISyntaxException {
        StringBuilder htmlSb = ReportUtil.prepareHtmlContent(suiteLogEntity);
        FileUtils.writeStringToFile((File)new File(logFolder, String.valueOf(logFolder.getName()) + reportDirLocationHashCode + ".html"), (String)htmlSb.toString(), (String)"UTF-8");
    }

    public static void writeExecutionUUIDToFile(String UUID, File logFolder) throws IOException, URISyntaxException {
        FileUtils.writeStringToFile((File)new File(logFolder, "execution.uuid"), (String)UUID, (String)"UTF-8");
    }

    private static String getTestSuiteCollectionId(File logFolder) throws IOException {
        File idFile = ReportUtil.getOrCreateTestSuiteCollectionIdFile(logFolder);
        return FileUtils.readFileToString((File)idFile, (String)"UTF-8");
    }

    public static void writeTestSuiteCollectionIdToFile(String testSuiteCollectionId, File logFolder) throws IOException {
        File idFile = ReportUtil.getOrCreateTestSuiteCollectionIdFile(logFolder);
        FileUtils.writeStringToFile((File)idFile, (String)testSuiteCollectionId, (String)"UTF-8");
    }

    private static File getOrCreateTestSuiteCollectionIdFile(File logFolder) throws IOException {
        File idFile = new File(logFolder, "tsc_id.txt");
        if (!idFile.exists()) {
            idFile.createNewFile();
        }
        return idFile;
    }

    public static void writeCSVReport(TestSuiteLogRecord suiteLogEntity, File logFolder) throws IOException {
        CsvWriter.writeCsvReport(suiteLogEntity, new File(logFolder, String.valueOf(logFolder.getName()) + ".csv"), Arrays.asList(suiteLogEntity.getChildRecords()));
    }

    public static void writeSimpleHTMLReport(TestSuiteLogRecord suiteLogEntity, File logFolder) throws IOException, URISyntaxException {
        ArrayList<ILogRecord> infoLogs = new ArrayList<ILogRecord>();
        ReportUtil.collectInfoLines(suiteLogEntity, infoLogs);
        for (ILogRecord infoLog : infoLogs) {
            infoLog.getParentLogRecord().removeChildRecord(infoLog);
        }
        LinkedList<String> simpleStrings = new LinkedList<String>();
        JsSuiteModel simpleJsSuiteModel = new JsSuiteModel(suiteLogEntity, simpleStrings);
        StringBuilder simpleSbModel = simpleJsSuiteModel.toArrayString();
        StringBuilder simpleHtmlSb = new StringBuilder();
        ReportUtil.readFileToStringBuilder("html_template.txt", simpleHtmlSb);
        simpleHtmlSb.append((CharSequence)ReportUtil.generateVars(simpleStrings, suiteLogEntity, simpleSbModel));
        ReportUtil.readFileToStringBuilder("html_content.txt", simpleHtmlSb);
        FileUtils.writeStringToFile((File)new File(logFolder, "Report.html"), (String)simpleHtmlSb.toString(), (String)"UTF-8");
    }

    public static void writeLogRecordToHTMLFile(TestSuiteLogRecord suiteLogEntity, File destFile, List<ILogRecord> filteredTestCases) throws IOException, URISyntaxException {
        LinkedList<String> strings = new LinkedList<String>();
        JsSuiteModel jsSuiteModel = new JsSuiteModel(suiteLogEntity, strings);
        StringBuilder sbModel = jsSuiteModel.toArrayString();
        StringBuilder htmlSb = new StringBuilder();
        ReportUtil.readFileToStringBuilder("html_template.txt", htmlSb);
        htmlSb.append((CharSequence)ReportUtil.generateVars(strings, suiteLogEntity, sbModel));
        ReportUtil.readFileToStringBuilder("html_content.txt", htmlSb);
        ArrayList<ILogRecord> infoLogs = new ArrayList<ILogRecord>();
        ReportUtil.collectInfoLines(suiteLogEntity, infoLogs);
        for (ILogRecord infoLog : infoLogs) {
            infoLog.getParentLogRecord().removeChildRecord(infoLog);
        }
        strings = new LinkedList();
        jsSuiteModel = new JsSuiteModel(suiteLogEntity, strings, filteredTestCases);
        sbModel = jsSuiteModel.toArrayString();
        htmlSb = new StringBuilder();
        ReportUtil.readFileToStringBuilder("html_template.txt", htmlSb);
        htmlSb.append((CharSequence)ReportUtil.generateVars(strings, suiteLogEntity, sbModel));
        ReportUtil.readFileToStringBuilder("html_content.txt", htmlSb);
        FileUtils.writeStringToFile((File)destFile, (String)htmlSb.toString(), (String)"UTF-8");
    }

    public static List<XmlLogRecord> getAllLogRecords(String logFolder) throws XMLParserException, IOException, XMLStreamException {
        return XMLLoggerParser.readFromLogFolder(logFolder);
    }

    public static TestSuiteLogRecord generate(String logFolder, IProgressMonitor progressMonitor) throws XMLParserException, IOException, XMLStreamException {
        TestSuiteLogRecord suiteLogRecord = new TestSuiteXMLLogParser().readTestSuiteLogFromXMLFiles(logFolder, progressMonitor);
        String testSuiteCollectionId = ReportUtil.getTestSuiteCollectionId(new File(logFolder));
        if (StringUtils.isNotBlank((String)testSuiteCollectionId) && suiteLogRecord != null) {
            suiteLogRecord.setTestSuiteCollectionId(testSuiteCollectionId);
        }
        return suiteLogRecord;
    }

    public static TestSuiteLogRecord generate(String logFolder) throws XMLParserException, IOException, XMLStreamException {
        return ReportUtil.generate(logFolder, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void readFileToStringBuilder(String fileName, StringBuilder sb) throws IOException, URISyntaxException {
        String path = ResourceLoader.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.endsWith(fileName)) continue;
                StringBuilderWriter sbWriter = new StringBuilderWriter(new StringBuilder());
                IOUtils.copy((InputStream)jar.getInputStream(jarEntry), (Writer)sbWriter);
                sbWriter.flush();
                sbWriter.close();
                sb.append((CharSequence)sbWriter.getBuilder());
                break;
            }
            jar.close();
        } else {
            InputStream is = (InputStream)ResourceLoader.class.getResource(fileName).getContent();
            sb.append(IOUtils.toString((InputStream)is, (String)"UTF-8"));
        }
    }
}

