/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.setting;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;

public class LinkedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private final HashSet<Object> keys = new LinkedHashSet<Object>();
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public LinkedProperties() {
    }

    public LinkedProperties(Properties properties) {
        for (Object prop : properties.keySet()) {
            this.put(prop, properties.get(prop));
        }
    }

    public Iterable<Object> orderedKeys() {
        return Collections.list(this.keys());
    }

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(this.keys);
    }

    @Override
    public Object put(Object key, Object value) {
        this.keys.add(key);
        return super.put(key, value);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    @Override
    public Object remove(Object key) {
        this.keys.remove(key);
        return super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Writer writer, String comments) throws IOException {
        boolean checkProp;
        BufferedWriter bw;
        block9: {
            bw = new BufferedWriter(writer);
            if (comments != null) {
                LinkedProperties.writeComments(bw, comments);
            }
            checkProp = false;
            try {
                if (System.getProperty("project.properties").equals("true")) {
                    checkProp = true;
                }
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) break block9;
                this.logger.logError(ExceptionsUtil.getStackTraceForThrowable(e), null, e);
            }
        }
        if (checkProp) {
            bw.write("#" + new Date().toString());
            bw.newLine();
        }
        LinkedProperties linkedProperties = this;
        synchronized (linkedProperties) {
            Enumeration<Object> e = this.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)this.get(key);
                key = this.customSaveConvert(key, true, true);
                val = this.customSaveConvert(val, false, true);
                bw.write(String.valueOf(key) + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        bw.write("#");
        int len = comments.length();
        int current = 0;
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        while (current < len) {
            char c = comments.charAt(current);
            if (c > '\u00ff' || c == '\n' || c == '\r') {
                if (last != current) {
                    bw.write(comments.substring(last, current));
                }
                if (c > '\u00ff') {
                    uu[2] = LinkedProperties.toHex(c >> 12 & 0xF);
                    uu[3] = LinkedProperties.toHex(c >> 8 & 0xF);
                    uu[4] = LinkedProperties.toHex(c >> 4 & 0xF);
                    uu[5] = LinkedProperties.toHex(c & 0xF);
                    bw.write(new String(uu));
                } else {
                    bw.newLine();
                    if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                        ++current;
                    }
                    if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                        bw.write("#");
                    }
                }
                last = current + 1;
            }
            ++current;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private String customSaveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(LinkedProperties.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(LinkedProperties.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(LinkedProperties.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(LinkedProperties.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

